/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ConstructBeaconTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("construct_beacon");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("level"));
        return new TriggerInstance(pEntityPredicate, minmaxbounds$ints);
    }

    public void trigger(ServerPlayer pPlayer, int pLevel) {
        this.trigger(pPlayer, p_148028_ -> p_148028_.matches(pLevel));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints level;

        public TriggerInstance(EntityPredicate.Composite pPlayer, MinMaxBounds.Ints pLevel) {
            super(ID, pPlayer);
            this.level = pLevel;
        }

        public static TriggerInstance constructedBeacon() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, MinMaxBounds.Ints.ANY);
        }

        public static TriggerInstance constructedBeacon(MinMaxBounds.Ints pLevel) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pLevel);
        }

        public boolean matches(int pLevel) {
            return this.level.matches(pLevel);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("level", this.level.serializeToJson());
            return jsonobject;
        }
    }
}

