/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3;

public class DamageSourcePredicate {
    public static final DamageSourcePredicate ANY = Builder.damageType().build();
    @Nullable
    private final Boolean isProjectile;
    @Nullable
    private final Boolean isExplosion;
    @Nullable
    private final Boolean bypassesArmor;
    @Nullable
    private final Boolean bypassesInvulnerability;
    @Nullable
    private final Boolean bypassesMagic;
    @Nullable
    private final Boolean isFire;
    @Nullable
    private final Boolean isMagic;
    @Nullable
    private final Boolean isLightning;
    private final EntityPredicate directEntity;
    private final EntityPredicate sourceEntity;

    public DamageSourcePredicate(@Nullable Boolean pIsProjectile, @Nullable Boolean pIsExplosion, @Nullable Boolean pBypassesArmor, @Nullable Boolean pBypassesInvulnerability, @Nullable Boolean pBypassesMagic, @Nullable Boolean pIsFire, @Nullable Boolean pIsMagic, @Nullable Boolean pIsLightning, EntityPredicate pDirectEntity, EntityPredicate pSourceEntity) {
        this.isProjectile = pIsProjectile;
        this.isExplosion = pIsExplosion;
        this.bypassesArmor = pBypassesArmor;
        this.bypassesInvulnerability = pBypassesInvulnerability;
        this.bypassesMagic = pBypassesMagic;
        this.isFire = pIsFire;
        this.isMagic = pIsMagic;
        this.isLightning = pIsLightning;
        this.directEntity = pDirectEntity;
        this.sourceEntity = pSourceEntity;
    }

    public boolean matches(ServerPlayer pPlayer, DamageSource pSource) {
        return this.matches(pPlayer.getLevel(), pPlayer.position(), pSource);
    }

    public boolean matches(ServerLevel pLevel, Vec3 pPosition, DamageSource pSource) {
        if (this == ANY) {
            return true;
        }
        if (this.isProjectile != null && this.isProjectile.booleanValue() != pSource.isProjectile()) {
            return false;
        }
        if (this.isExplosion != null && this.isExplosion.booleanValue() != pSource.isExplosion()) {
            return false;
        }
        if (this.bypassesArmor != null && this.bypassesArmor.booleanValue() != pSource.isBypassArmor()) {
            return false;
        }
        if (this.bypassesInvulnerability != null && this.bypassesInvulnerability.booleanValue() != pSource.isBypassInvul()) {
            return false;
        }
        if (this.bypassesMagic != null && this.bypassesMagic.booleanValue() != pSource.isBypassMagic()) {
            return false;
        }
        if (this.isFire != null && this.isFire.booleanValue() != pSource.isFire()) {
            return false;
        }
        if (this.isMagic != null && this.isMagic.booleanValue() != pSource.isMagic()) {
            return false;
        }
        if (this.isLightning != null && this.isLightning != (pSource == DamageSource.LIGHTNING_BOLT)) {
            return false;
        }
        if (!this.directEntity.matches(pLevel, pPosition, pSource.getDirectEntity())) {
            return false;
        }
        return this.sourceEntity.matches(pLevel, pPosition, pSource.getEntity());
    }

    public static DamageSourcePredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "damage type");
            Boolean obool = DamageSourcePredicate.getOptionalBoolean(jsonobject, "is_projectile");
            Boolean obool1 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "is_explosion");
            Boolean obool2 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "bypasses_armor");
            Boolean obool3 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "bypasses_invulnerability");
            Boolean obool4 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "bypasses_magic");
            Boolean obool5 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "is_fire");
            Boolean obool6 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "is_magic");
            Boolean obool7 = DamageSourcePredicate.getOptionalBoolean(jsonobject, "is_lightning");
            EntityPredicate entitypredicate = EntityPredicate.fromJson(jsonobject.get("direct_entity"));
            EntityPredicate entitypredicate1 = EntityPredicate.fromJson(jsonobject.get("source_entity"));
            return new DamageSourcePredicate(obool, obool1, obool2, obool3, obool4, obool5, obool6, obool7, entitypredicate, entitypredicate1);
        }
        return ANY;
    }

    @Nullable
    private static Boolean getOptionalBoolean(JsonObject pJson, String pProperty) {
        return pJson.has(pProperty) ? Boolean.valueOf(GsonHelper.getAsBoolean(pJson, pProperty)) : null;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        this.addOptionally(jsonobject, "is_projectile", this.isProjectile);
        this.addOptionally(jsonobject, "is_explosion", this.isExplosion);
        this.addOptionally(jsonobject, "bypasses_armor", this.bypassesArmor);
        this.addOptionally(jsonobject, "bypasses_invulnerability", this.bypassesInvulnerability);
        this.addOptionally(jsonobject, "bypasses_magic", this.bypassesMagic);
        this.addOptionally(jsonobject, "is_fire", this.isFire);
        this.addOptionally(jsonobject, "is_magic", this.isMagic);
        this.addOptionally(jsonobject, "is_lightning", this.isLightning);
        jsonobject.add("direct_entity", this.directEntity.serializeToJson());
        jsonobject.add("source_entity", this.sourceEntity.serializeToJson());
        return jsonobject;
    }

    private void addOptionally(JsonObject pJson, String pProperty, @Nullable Boolean pValue) {
        if (pValue != null) {
            pJson.addProperty(pProperty, pValue);
        }
    }

    public static class Builder {
        @Nullable
        private Boolean isProjectile;
        @Nullable
        private Boolean isExplosion;
        @Nullable
        private Boolean bypassesArmor;
        @Nullable
        private Boolean bypassesInvulnerability;
        @Nullable
        private Boolean bypassesMagic;
        @Nullable
        private Boolean isFire;
        @Nullable
        private Boolean isMagic;
        @Nullable
        private Boolean isLightning;
        private EntityPredicate directEntity = EntityPredicate.ANY;
        private EntityPredicate sourceEntity = EntityPredicate.ANY;

        public static Builder damageType() {
            return new Builder();
        }

        public Builder isProjectile(Boolean pIsProjectile) {
            this.isProjectile = pIsProjectile;
            return this;
        }

        public Builder isExplosion(Boolean pIsExplosion) {
            this.isExplosion = pIsExplosion;
            return this;
        }

        public Builder bypassesArmor(Boolean pBypassesArmor) {
            this.bypassesArmor = pBypassesArmor;
            return this;
        }

        public Builder bypassesInvulnerability(Boolean pBypassesInvulnerability) {
            this.bypassesInvulnerability = pBypassesInvulnerability;
            return this;
        }

        public Builder bypassesMagic(Boolean pBypassesMagic) {
            this.bypassesMagic = pBypassesMagic;
            return this;
        }

        public Builder isFire(Boolean pIsFire) {
            this.isFire = pIsFire;
            return this;
        }

        public Builder isMagic(Boolean pIsMagic) {
            this.isMagic = pIsMagic;
            return this;
        }

        public Builder isLightning(Boolean pIsLightning) {
            this.isLightning = pIsLightning;
            return this;
        }

        public Builder direct(EntityPredicate pDirectEntity) {
            this.directEntity = pDirectEntity;
            return this;
        }

        public Builder direct(EntityPredicate.Builder pDirectEntity) {
            this.directEntity = pDirectEntity.build();
            return this;
        }

        public Builder source(EntityPredicate pSourceEntity) {
            this.sourceEntity = pSourceEntity;
            return this;
        }

        public Builder source(EntityPredicate.Builder pSourceEntity) {
            this.sourceEntity = pSourceEntity.build();
            return this;
        }

        public DamageSourcePredicate build() {
            return new DamageSourcePredicate(this.isProjectile, this.isExplosion, this.bypassesArmor, this.bypassesInvulnerability, this.bypassesMagic, this.isFire, this.isMagic, this.isLightning, this.directEntity, this.sourceEntity);
        }
    }
}

