/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class DeserializationContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation id;
    private final PredicateManager predicateManager;
    private final Gson predicateGson = Deserializers.createConditionSerializer().create();

    public DeserializationContext(ResourceLocation pId, PredicateManager pPredicateManager) {
        this.id = pId;
        this.predicateManager = pPredicateManager;
    }

    public final LootItemCondition[] deserializeConditions(JsonArray p_25875_, String p_25876_, LootContextParamSet p_25877_) {
        LootItemCondition[] alootitemcondition = (LootItemCondition[])this.predicateGson.fromJson((JsonElement)p_25875_, LootItemCondition[].class);
        ValidationContext validationcontext = new ValidationContext(p_25877_, this.predicateManager::get, p_25883_ -> null);
        LootItemCondition[] lootItemConditionArray = alootitemcondition;
        int n = alootitemcondition.length;
        int n2 = 0;
        while (n2 < n) {
            LootItemCondition lootitemcondition = lootItemConditionArray[n2];
            lootitemcondition.validate(validationcontext);
            validationcontext.getProblems().forEach((p_25880_, p_25881_) -> LOGGER.warn("Found validation problem in advancement trigger {}/{}: {}", new Object[]{p_25876_, p_25880_, p_25881_}));
            ++n2;
        }
        return alootitemcondition;
    }

    public ResourceLocation getAdvancementId() {
        return this.id;
    }
}

