/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class EffectsChangedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("effects_changed");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        MobEffectsPredicate mobeffectspredicate = MobEffectsPredicate.fromJson(pJson.get("effects"));
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pJson, "source", pConditionsParser);
        return new TriggerInstance(pEntityPredicate, mobeffectspredicate, entitypredicate$composite);
    }

    public void trigger(ServerPlayer pPlayer, @Nullable Entity pSource) {
        LootContext lootcontext = pSource != null ? EntityPredicate.createContext(pPlayer, pSource) : null;
        this.trigger(pPlayer, (T p_149268_) -> p_149268_.matches(pPlayer, lootcontext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MobEffectsPredicate effects;
        private final EntityPredicate.Composite source;

        public TriggerInstance(EntityPredicate.Composite pPlayer, MobEffectsPredicate pEffects, EntityPredicate.Composite pSource) {
            super(ID, pPlayer);
            this.effects = pEffects;
            this.source = pSource;
        }

        public static TriggerInstance hasEffects(MobEffectsPredicate pEffects) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pEffects, EntityPredicate.Composite.ANY);
        }

        public static TriggerInstance gotEffectsFrom(EntityPredicate pSource) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, MobEffectsPredicate.ANY, EntityPredicate.Composite.wrap(pSource));
        }

        public boolean matches(ServerPlayer pPlayer, @Nullable LootContext pLootContext) {
            if (!this.effects.matches(pPlayer)) {
                return false;
            }
            return this.source == EntityPredicate.Composite.ANY || pLootContext != null && this.source.matches(pLootContext);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("effects", this.effects.serializeToJson());
            jsonobject.add("source", this.source.toJson(pConditions));
            return jsonobject;
        }
    }
}

