/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class EnchantedItemTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("enchanted_item");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("item"));
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("levels"));
        return new TriggerInstance(pEntityPredicate, itempredicate, minmaxbounds$ints);
    }

    public void trigger(ServerPlayer pPlayer, ItemStack pItem, int pLevelsSpent) {
        this.trigger(pPlayer, p_27675_ -> p_27675_.matches(pItem, pLevelsSpent));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final MinMaxBounds.Ints levels;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ItemPredicate pItem, MinMaxBounds.Ints pLevels) {
            super(ID, pPlayer);
            this.item = pItem;
            this.levels = pLevels;
        }

        public static TriggerInstance enchantedItem() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, ItemPredicate.ANY, MinMaxBounds.Ints.ANY);
        }

        public boolean matches(ItemStack pItem, int pLevels) {
            if (!this.item.matches(pItem)) {
                return false;
            }
            return this.levels.matches(pLevels);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("item", this.item.serializeToJson());
            jsonobject.add("levels", this.levels.serializeToJson());
            return jsonobject;
        }
    }
}

