/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;

public class EntityHurtPlayerTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("entity_hurt_player");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        DamagePredicate damagepredicate = DamagePredicate.fromJson(pJson.get("damage"));
        return new TriggerInstance(pEntityPredicate, damagepredicate);
    }

    public void trigger(ServerPlayer pPlayer, DamageSource pSource, float pDealtDamage, float pTakenDamage, boolean pBlocked) {
        this.trigger(pPlayer, p_35186_ -> p_35186_.matches(pPlayer, pSource, pDealtDamage, pTakenDamage, pBlocked));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final DamagePredicate damage;

        public TriggerInstance(EntityPredicate.Composite pPlayer, DamagePredicate pDamage) {
            super(ID, pPlayer);
            this.damage = pDamage;
        }

        public static TriggerInstance entityHurtPlayer() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, DamagePredicate.ANY);
        }

        public static TriggerInstance entityHurtPlayer(DamagePredicate pDamageConditionBuilder) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pDamageConditionBuilder);
        }

        public static TriggerInstance entityHurtPlayer(DamagePredicate.Builder pDamageConditionBuilder) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pDamageConditionBuilder.build());
        }

        public boolean matches(ServerPlayer pPlayer, DamageSource pSource, float pDealtDamage, float pTakenDamage, boolean pBlocked) {
            return this.damage.matches(pPlayer, pSource, pDealtDamage, pTakenDamage, pBlocked);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("damage", this.damage.serializeToJson());
            return jsonobject;
        }
    }
}

