/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FishingRodHookedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("fishing_rod_hooked");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("rod"));
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pJson, "entity", pConditionsParser);
        ItemPredicate itempredicate1 = ItemPredicate.fromJson(pJson.get("item"));
        return new TriggerInstance(pEntityPredicate, itempredicate, entitypredicate$composite, itempredicate1);
    }

    public void trigger(ServerPlayer pPlayer, ItemStack pRod, FishingHook pEntity, Collection<ItemStack> pStacks) {
        LootContext lootcontext = EntityPredicate.createContext(pPlayer, pEntity.getHookedIn() != null ? pEntity.getHookedIn() : pEntity);
        this.trigger(pPlayer, p_40425_ -> p_40425_.matches(pRod, lootcontext, pStacks));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate rod;
        private final EntityPredicate.Composite entity;
        private final ItemPredicate item;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ItemPredicate pRod, EntityPredicate.Composite pEntity, ItemPredicate pItem) {
            super(ID, pPlayer);
            this.rod = pRod;
            this.entity = pEntity;
            this.item = pItem;
        }

        public static TriggerInstance fishedItem(ItemPredicate pRod, EntityPredicate pBobber, ItemPredicate pItem) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pRod, EntityPredicate.Composite.wrap(pBobber), pItem);
        }

        public boolean matches(ItemStack pRod, LootContext pContext, Collection<ItemStack> pStacks) {
            if (!this.rod.matches(pRod)) {
                return false;
            }
            if (!this.entity.matches(pContext)) {
                return false;
            }
            if (this.item != ItemPredicate.ANY) {
                ItemEntity itementity;
                boolean flag = false;
                Entity entity = pContext.getParamOrNull(LootContextParams.THIS_ENTITY);
                if (entity instanceof ItemEntity && this.item.matches((itementity = (ItemEntity)entity).getItem())) {
                    flag = true;
                }
                for (ItemStack itemstack : pStacks) {
                    if (!this.item.matches(itemstack)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("rod", this.rod.serializeToJson());
            jsonobject.add("entity", this.entity.toJson(pConditions));
            jsonobject.add("item", this.item.serializeToJson());
            return jsonobject;
        }
    }
}

