/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FluidPredicate {
    public static final FluidPredicate ANY = new FluidPredicate(null, null, StatePropertiesPredicate.ANY);
    @Nullable
    private final TagKey<Fluid> tag;
    @Nullable
    private final Fluid fluid;
    private final StatePropertiesPredicate properties;

    public FluidPredicate(@Nullable TagKey<Fluid> pTag, @Nullable Fluid pFluid, StatePropertiesPredicate pProperties) {
        this.tag = pTag;
        this.fluid = pFluid;
        this.properties = pProperties;
    }

    public boolean matches(ServerLevel pLevel, BlockPos pPos) {
        if (this == ANY) {
            return true;
        }
        if (!pLevel.isLoaded(pPos)) {
            return false;
        }
        FluidState fluidstate = pLevel.getFluidState(pPos);
        if (this.tag != null && !fluidstate.is(this.tag)) {
            return false;
        }
        if (this.fluid != null && !fluidstate.is(this.fluid)) {
            return false;
        }
        return this.properties.matches(fluidstate);
    }

    public static FluidPredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "fluid");
            Fluid fluid = null;
            if (jsonobject.has("fluid")) {
                ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(jsonobject, "fluid"));
                fluid = Registry.FLUID.get(resourcelocation);
            }
            TagKey<Fluid> tagkey = null;
            if (jsonobject.has("tag")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.getAsString(jsonobject, "tag"));
                tagkey = TagKey.create(Registry.FLUID_REGISTRY, resourcelocation1);
            }
            StatePropertiesPredicate statepropertiespredicate = StatePropertiesPredicate.fromJson(jsonobject.get("state"));
            return new FluidPredicate(tagkey, fluid, statepropertiespredicate);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (this.fluid != null) {
            jsonobject.addProperty("fluid", Registry.FLUID.getKey(this.fluid).toString());
        }
        if (this.tag != null) {
            jsonobject.addProperty("tag", this.tag.location().toString());
        }
        jsonobject.add("state", this.properties.serializeToJson());
        return jsonobject;
    }

    public static class Builder {
        @Nullable
        private Fluid fluid;
        @Nullable
        private TagKey<Fluid> fluids;
        private StatePropertiesPredicate properties = StatePropertiesPredicate.ANY;

        private Builder() {
        }

        public static Builder fluid() {
            return new Builder();
        }

        public Builder of(Fluid pFluids) {
            this.fluid = pFluids;
            return this;
        }

        public Builder of(TagKey<Fluid> pFluids) {
            this.fluids = pFluids;
            return this;
        }

        public Builder setProperties(StatePropertiesPredicate pProperties) {
            this.properties = pProperties;
            return this;
        }

        public FluidPredicate build() {
            return new FluidPredicate(this.fluids, this.fluid, this.properties);
        }
    }
}

