/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryChangeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("inventory_changed");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "slots", new JsonObject());
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(jsonobject.get("occupied"));
        MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.fromJson(jsonobject.get("full"));
        MinMaxBounds.Ints minmaxbounds$ints2 = MinMaxBounds.Ints.fromJson(jsonobject.get("empty"));
        ItemPredicate[] aitempredicate = ItemPredicate.fromJsonArray(pJson.get("items"));
        return new TriggerInstance(pEntityPredicate, minmaxbounds$ints, minmaxbounds$ints1, minmaxbounds$ints2, aitempredicate);
    }

    public void trigger(ServerPlayer pPlayer, Inventory pInventory, ItemStack pStack) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        while (l < pInventory.getContainerSize()) {
            ItemStack itemstack = pInventory.getItem(l);
            if (itemstack.isEmpty()) {
                ++j;
            } else {
                ++k;
                if (itemstack.getCount() >= itemstack.getMaxStackSize()) {
                    ++i;
                }
            }
            ++l;
        }
        this.trigger(pPlayer, pInventory, pStack, i, j, k);
    }

    private void trigger(ServerPlayer pPlayer, Inventory pInventory, ItemStack pStack, int pFull, int pEmpty, int pOccupied) {
        this.trigger(pPlayer, p_43166_ -> p_43166_.matches(pInventory, pStack, pFull, pEmpty, pOccupied));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints slotsOccupied;
        private final MinMaxBounds.Ints slotsFull;
        private final MinMaxBounds.Ints slotsEmpty;
        private final ItemPredicate[] predicates;

        public TriggerInstance(EntityPredicate.Composite pPlayer, MinMaxBounds.Ints pSlotsOccupied, MinMaxBounds.Ints pSlotsFull, MinMaxBounds.Ints pSlotsEmpty, ItemPredicate[] pPredicates) {
            super(ID, pPlayer);
            this.slotsOccupied = pSlotsOccupied;
            this.slotsFull = pSlotsFull;
            this.slotsEmpty = pSlotsEmpty;
            this.predicates = pPredicates;
        }

        public static TriggerInstance a(ItemPredicate ... p_43198_) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, p_43198_);
        }

        public static TriggerInstance a(ItemLike ... p_43200_) {
            ItemPredicate[] aitempredicate = new ItemPredicate[p_43200_.length];
            int i = 0;
            while (i < p_43200_.length) {
                aitempredicate[i] = new ItemPredicate(null, (Set<Item>)ImmutableSet.of((Object)p_43200_[i].asItem()), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, EnchantmentPredicate.NONE, EnchantmentPredicate.NONE, null, NbtPredicate.ANY);
                ++i;
            }
            return TriggerInstance.a(aitempredicate);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            if (!(this.slotsOccupied.isAny() && this.slotsFull.isAny() && this.slotsEmpty.isAny())) {
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.add("occupied", this.slotsOccupied.serializeToJson());
                jsonobject1.add("full", this.slotsFull.serializeToJson());
                jsonobject1.add("empty", this.slotsEmpty.serializeToJson());
                jsonobject.add("slots", (JsonElement)jsonobject1);
            }
            if (this.predicates.length > 0) {
                JsonArray jsonarray = new JsonArray();
                ItemPredicate[] itemPredicateArray = this.predicates;
                int n = this.predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemPredicate itempredicate = itemPredicateArray[n2];
                    jsonarray.add(itempredicate.serializeToJson());
                    ++n2;
                }
                jsonobject.add("items", (JsonElement)jsonarray);
            }
            return jsonobject;
        }

        public boolean matches(Inventory pInventory, ItemStack pStack, int pFull, int pEmpty, int pOccupied) {
            if (!this.slotsFull.matches(pFull)) {
                return false;
            }
            if (!this.slotsEmpty.matches(pEmpty)) {
                return false;
            }
            if (!this.slotsOccupied.matches(pOccupied)) {
                return false;
            }
            int i = this.predicates.length;
            if (i == 0) {
                return true;
            }
            if (i != 1) {
                ObjectArrayList list = new ObjectArrayList((Object[])this.predicates);
                int j = pInventory.getContainerSize();
                int k = 0;
                while (k < j) {
                    if (list.isEmpty()) {
                        return true;
                    }
                    ItemStack itemstack = pInventory.getItem(k);
                    if (!itemstack.isEmpty()) {
                        list.removeIf(p_43194_ -> p_43194_.matches(itemstack));
                    }
                    ++k;
                }
                return list.isEmpty();
            }
            return !pStack.isEmpty() && this.predicates[0].matches(pStack);
        }
    }
}

