/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ItemDurabilityTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("item_durability_changed");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("item"));
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("durability"));
        MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.fromJson(pJson.get("delta"));
        return new TriggerInstance(pEntityPredicate, itempredicate, minmaxbounds$ints, minmaxbounds$ints1);
    }

    public void trigger(ServerPlayer pPlayer, ItemStack pItem, int pNewDurability) {
        this.trigger(pPlayer, p_43676_ -> p_43676_.matches(pItem, pNewDurability));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final MinMaxBounds.Ints durability;
        private final MinMaxBounds.Ints delta;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ItemPredicate pItem, MinMaxBounds.Ints pDurability, MinMaxBounds.Ints pDelta) {
            super(ID, pPlayer);
            this.item = pItem;
            this.durability = pDurability;
            this.delta = pDelta;
        }

        public static TriggerInstance changedDurability(ItemPredicate pItem, MinMaxBounds.Ints pDurability) {
            return TriggerInstance.changedDurability(EntityPredicate.Composite.ANY, pItem, pDurability);
        }

        public static TriggerInstance changedDurability(EntityPredicate.Composite pPlayer, ItemPredicate pItem, MinMaxBounds.Ints pDurability) {
            return new TriggerInstance(pPlayer, pItem, pDurability, MinMaxBounds.Ints.ANY);
        }

        public boolean matches(ItemStack pItem, int pDurability) {
            if (!this.item.matches(pItem)) {
                return false;
            }
            if (!this.durability.matches(pItem.getMaxDamage() - pDurability)) {
                return false;
            }
            return this.delta.matches(pItem.getDamageValue() - pDurability);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("item", this.item.serializeToJson());
            jsonobject.add("durability", this.durability.serializeToJson());
            jsonobject.add("delta", this.delta.serializeToJson());
            return jsonobject;
        }
    }
}

