/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class ItemPickedUpByEntityTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("thrown_item_picked_up_by_entity");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    protected TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("item"));
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pJson, "entity", pConditionsParser);
        return new TriggerInstance(pEntityPredicate, itempredicate, entitypredicate$composite);
    }

    public void trigger(ServerPlayer pPlayer, ItemStack pStack, Entity pEntity) {
        LootContext lootcontext = EntityPredicate.createContext(pPlayer, pEntity);
        this.trigger(pPlayer, p_44371_ -> p_44371_.matches(pPlayer, pStack, lootcontext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final EntityPredicate.Composite entity;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ItemPredicate pItem, EntityPredicate.Composite pEntity) {
            super(ID, pPlayer);
            this.item = pItem;
            this.entity = pEntity;
        }

        public static TriggerInstance itemPickedUpByEntity(EntityPredicate.Composite pPlayer, ItemPredicate.Builder pItem, EntityPredicate.Composite pEntity) {
            return new TriggerInstance(pPlayer, pItem.build(), pEntity);
        }

        public boolean matches(ServerPlayer pPlayer, ItemStack pStack, LootContext pContext) {
            if (!this.item.matches(pStack)) {
                return false;
            }
            return this.entity.matches(pContext);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("item", this.item.serializeToJson());
            jsonobject.add("entity", this.entity.toJson(pConditions));
            return jsonobject;
        }
    }
}

