/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ItemPredicate {
    public static final ItemPredicate ANY = new ItemPredicate();
    @Nullable
    private final TagKey<Item> tag;
    @Nullable
    private final Set<Item> items;
    private final MinMaxBounds.Ints count;
    private final MinMaxBounds.Ints durability;
    private final EnchantmentPredicate[] enchantments;
    private final EnchantmentPredicate[] storedEnchantments;
    @Nullable
    private final Potion potion;
    private final NbtPredicate nbt;

    public ItemPredicate() {
        this.tag = null;
        this.items = null;
        this.potion = null;
        this.count = MinMaxBounds.Ints.ANY;
        this.durability = MinMaxBounds.Ints.ANY;
        this.enchantments = EnchantmentPredicate.NONE;
        this.storedEnchantments = EnchantmentPredicate.NONE;
        this.nbt = NbtPredicate.ANY;
    }

    public ItemPredicate(@Nullable TagKey<Item> pTag, @Nullable Set<Item> pItems, MinMaxBounds.Ints pCount, MinMaxBounds.Ints pDurability, EnchantmentPredicate[] pEnchantments, EnchantmentPredicate[] pStoredEnchantments, @Nullable Potion pPotion, NbtPredicate pNbt) {
        this.tag = pTag;
        this.items = pItems;
        this.count = pCount;
        this.durability = pDurability;
        this.enchantments = pEnchantments;
        this.storedEnchantments = pStoredEnchantments;
        this.potion = pPotion;
        this.nbt = pNbt;
    }

    public boolean matches(ItemStack pItem) {
        int n;
        int n2;
        EnchantmentPredicate[] enchantmentPredicateArray;
        if (this == ANY) {
            return true;
        }
        if (this.tag != null && !pItem.is(this.tag)) {
            return false;
        }
        if (this.items != null && !this.items.contains(pItem.getItem())) {
            return false;
        }
        if (!this.count.matches(pItem.getCount())) {
            return false;
        }
        if (!this.durability.isAny() && !pItem.isDamageableItem()) {
            return false;
        }
        if (!this.durability.matches(pItem.getMaxDamage() - pItem.getDamageValue())) {
            return false;
        }
        if (!this.nbt.matches(pItem)) {
            return false;
        }
        if (this.enchantments.length > 0) {
            Map<Enchantment, Integer> map = EnchantmentHelper.deserializeEnchantments(pItem.getEnchantmentTags());
            enchantmentPredicateArray = this.enchantments;
            n2 = this.enchantments.length;
            n = 0;
            while (n < n2) {
                EnchantmentPredicate enchantmentpredicate = enchantmentPredicateArray[n];
                if (!enchantmentpredicate.containedIn(map)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.storedEnchantments.length > 0) {
            Map<Enchantment, Integer> map1 = EnchantmentHelper.deserializeEnchantments(EnchantedBookItem.getEnchantments(pItem));
            enchantmentPredicateArray = this.storedEnchantments;
            n2 = this.storedEnchantments.length;
            n = 0;
            while (n < n2) {
                EnchantmentPredicate enchantmentpredicate1 = enchantmentPredicateArray[n];
                if (!enchantmentpredicate1.containedIn(map1)) {
                    return false;
                }
                ++n;
            }
        }
        Potion potion = PotionUtils.getPotion(pItem);
        return this.potion == null || this.potion == potion;
    }

    public static ItemPredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "item");
            MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(jsonobject.get("count"));
            MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.fromJson(jsonobject.get("durability"));
            if (jsonobject.has("data")) {
                throw new JsonParseException("Disallowed data tag found");
            }
            NbtPredicate nbtpredicate = NbtPredicate.fromJson(jsonobject.get("nbt"));
            ImmutableSet set = null;
            JsonArray jsonarray = GsonHelper.getAsJsonArray(jsonobject, "items", null);
            if (jsonarray != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (JsonElement jsonelement : jsonarray) {
                    ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.convertToString(jsonelement, "item"));
                    builder.add((Object)Registry.ITEM.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown item id '" + resourcelocation + "'")));
                }
                set = builder.build();
            }
            TagKey<Item> tagkey = null;
            if (jsonobject.has("tag")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.getAsString(jsonobject, "tag"));
                tagkey = TagKey.create(Registry.ITEM_REGISTRY, resourcelocation1);
            }
            Potion potion = null;
            if (jsonobject.has("potion")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(GsonHelper.getAsString(jsonobject, "potion"));
                potion = Registry.POTION.getOptional(resourcelocation2).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + resourcelocation2 + "'"));
            }
            EnchantmentPredicate[] aenchantmentpredicate = EnchantmentPredicate.fromJsonArray(jsonobject.get("enchantments"));
            EnchantmentPredicate[] aenchantmentpredicate1 = EnchantmentPredicate.fromJsonArray(jsonobject.get("stored_enchantments"));
            return new ItemPredicate(tagkey, (Set<Item>)set, minmaxbounds$ints, minmaxbounds$ints1, aenchantmentpredicate, aenchantmentpredicate1, potion, nbtpredicate);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        int n;
        EnchantmentPredicate[] enchantmentPredicateArray;
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (this.items != null) {
            JsonArray jsonarray = new JsonArray();
            for (Item item : this.items) {
                jsonarray.add(Registry.ITEM.getKey(item).toString());
            }
            jsonobject.add("items", (JsonElement)jsonarray);
        }
        if (this.tag != null) {
            jsonobject.addProperty("tag", this.tag.location().toString());
        }
        jsonobject.add("count", this.count.serializeToJson());
        jsonobject.add("durability", this.durability.serializeToJson());
        jsonobject.add("nbt", this.nbt.serializeToJson());
        if (this.enchantments.length > 0) {
            JsonArray jsonarray1 = new JsonArray();
            enchantmentPredicateArray = this.enchantments;
            n = this.enchantments.length;
            int n2 = 0;
            while (n2 < n) {
                EnchantmentPredicate enchantmentpredicate = enchantmentPredicateArray[n2];
                jsonarray1.add(enchantmentpredicate.serializeToJson());
                ++n2;
            }
            jsonobject.add("enchantments", (JsonElement)jsonarray1);
        }
        if (this.storedEnchantments.length > 0) {
            JsonArray jsonarray2 = new JsonArray();
            enchantmentPredicateArray = this.storedEnchantments;
            n = this.storedEnchantments.length;
            int n3 = 0;
            while (n3 < n) {
                EnchantmentPredicate enchantmentpredicate1 = enchantmentPredicateArray[n3];
                jsonarray2.add(enchantmentpredicate1.serializeToJson());
                ++n3;
            }
            jsonobject.add("stored_enchantments", (JsonElement)jsonarray2);
        }
        if (this.potion != null) {
            jsonobject.addProperty("potion", Registry.POTION.getKey(this.potion).toString());
        }
        return jsonobject;
    }

    public static ItemPredicate[] fromJsonArray(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonArray jsonarray = GsonHelper.convertToJsonArray(pJson, "items");
            ItemPredicate[] aitempredicate = new ItemPredicate[jsonarray.size()];
            int i = 0;
            while (i < aitempredicate.length) {
                aitempredicate[i] = ItemPredicate.fromJson(jsonarray.get(i));
                ++i;
            }
            return aitempredicate;
        }
        return new ItemPredicate[0];
    }

    public static class Builder {
        private final List<EnchantmentPredicate> enchantments = Lists.newArrayList();
        private final List<EnchantmentPredicate> storedEnchantments = Lists.newArrayList();
        @Nullable
        private Set<Item> items;
        @Nullable
        private TagKey<Item> tag;
        private MinMaxBounds.Ints count = MinMaxBounds.Ints.ANY;
        private MinMaxBounds.Ints durability = MinMaxBounds.Ints.ANY;
        @Nullable
        private Potion potion;
        private NbtPredicate nbt = NbtPredicate.ANY;

        private Builder() {
        }

        public static Builder item() {
            return new Builder();
        }

        public Builder a(ItemLike ... p_151446_) {
            this.items = (Set)Stream.of(p_151446_).map(ItemLike::asItem).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public Builder of(TagKey<Item> pTag) {
            this.tag = pTag;
            return this;
        }

        public Builder withCount(MinMaxBounds.Ints pCount) {
            this.count = pCount;
            return this;
        }

        public Builder hasDurability(MinMaxBounds.Ints pDurability) {
            this.durability = pDurability;
            return this;
        }

        public Builder isPotion(Potion pPotion) {
            this.potion = pPotion;
            return this;
        }

        public Builder hasNbt(CompoundTag pNbt) {
            this.nbt = new NbtPredicate(pNbt);
            return this;
        }

        public Builder hasEnchantment(EnchantmentPredicate pEnchantment) {
            this.enchantments.add(pEnchantment);
            return this;
        }

        public Builder hasStoredEnchantment(EnchantmentPredicate pStoredEnchantment) {
            this.storedEnchantments.add(pStoredEnchantment);
            return this;
        }

        public ItemPredicate build() {
            return new ItemPredicate(this.tag, this.items, this.count, this.durability, this.enchantments.toArray(EnchantmentPredicate.NONE), this.storedEnchantments.toArray(EnchantmentPredicate.NONE), this.potion, this.nbt);
        }
    }
}

