/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class KilledByCrossbowTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("killed_by_crossbow");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        EntityPredicate.Composite[] aentitypredicate$composite = EntityPredicate.Composite.fromJsonArray(pJson, "victims", pConditionsParser);
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("unique_entity_types"));
        return new TriggerInstance(pEntityPredicate, aentitypredicate$composite, minmaxbounds$ints);
    }

    @Override
    public void trigger(ServerPlayer pPlayer, Collection<Entity> pEntities) {
        ArrayList list = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        for (Entity entity : pEntities) {
            set.add(entity.getType());
            list.add(EntityPredicate.createContext(pPlayer, entity));
        }
        this.trigger(pPlayer, (T p_46881_) -> p_46881_.matches(list, set.size()));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite[] victims;
        private final MinMaxBounds.Ints uniqueEntityTypes;

        public TriggerInstance(EntityPredicate.Composite pPlayer, EntityPredicate.Composite[] pVictims, MinMaxBounds.Ints pUniqueEntityTypes) {
            super(ID, pPlayer);
            this.victims = pVictims;
            this.uniqueEntityTypes = pUniqueEntityTypes;
        }

        public static TriggerInstance a(EntityPredicate.Builder ... p_46901_) {
            EntityPredicate.Composite[] aentitypredicate$composite = new EntityPredicate.Composite[p_46901_.length];
            int i = 0;
            while (i < p_46901_.length) {
                EntityPredicate.Builder entitypredicate$builder = p_46901_[i];
                aentitypredicate$composite[i] = EntityPredicate.Composite.wrap(entitypredicate$builder.build());
                ++i;
            }
            return new TriggerInstance(EntityPredicate.Composite.ANY, aentitypredicate$composite, MinMaxBounds.Ints.ANY);
        }

        public static TriggerInstance crossbowKilled(MinMaxBounds.Ints pBounds) {
            EntityPredicate.Composite[] aentitypredicate$composite = new EntityPredicate.Composite[]{};
            return new TriggerInstance(EntityPredicate.Composite.ANY, aentitypredicate$composite, pBounds);
        }

        public boolean matches(Collection<LootContext> pContexts, int pBounds) {
            if (this.victims.length > 0) {
                ArrayList list = Lists.newArrayList(pContexts);
                EntityPredicate.Composite[] compositeArray = this.victims;
                int n = this.victims.length;
                int n2 = 0;
                while (n2 < n) {
                    EntityPredicate.Composite entitypredicate$composite = compositeArray[n2];
                    boolean flag = false;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        LootContext lootcontext = (LootContext)iterator.next();
                        if (!entitypredicate$composite.matches(lootcontext)) continue;
                        iterator.remove();
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        return false;
                    }
                    ++n2;
                }
            }
            return this.uniqueEntityTypes.matches(pBounds);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("victims", EntityPredicate.Composite.a(this.victims, pConditions));
            jsonobject.add("unique_entity_types", this.uniqueEntityTypes.serializeToJson());
            return jsonobject;
        }
    }
}

