/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class KilledTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    final ResourceLocation id;

    public KilledTrigger(ResourceLocation pId) {
        this.id = pId;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        return new TriggerInstance(this.id, pEntityPredicate, EntityPredicate.Composite.fromJson(pJson, "entity", pConditionsParser), DamageSourcePredicate.fromJson(pJson.get("killing_blow")));
    }

    public void trigger(ServerPlayer pPlayer, Entity pEntity, DamageSource pSource) {
        LootContext lootcontext = EntityPredicate.createContext(pPlayer, pEntity);
        this.trigger(pPlayer, p_48112_ -> p_48112_.matches(pPlayer, lootcontext, pSource));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite entityPredicate;
        private final DamageSourcePredicate killingBlow;

        public TriggerInstance(ResourceLocation pCriterion, EntityPredicate.Composite pPlayer, EntityPredicate.Composite pEntityPredicate, DamageSourcePredicate pKillingBlow) {
            super(pCriterion, pPlayer);
            this.entityPredicate = pEntityPredicate;
            this.killingBlow = pKillingBlow;
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate pEntityPredicateBuilder) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate.Builder pEntityPredicateBuilder) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder.build()), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance playerKilledEntity() {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, DamageSourcePredicate.ANY);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate pEntityPredicateBuilder, DamageSourcePredicate pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder), pKillingBlowBuilder);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate.Builder pEntityPredicateBuilder, DamageSourcePredicate pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder.build()), pKillingBlowBuilder);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate pEntityPredicateBuilder, DamageSourcePredicate.Builder pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder), pKillingBlowBuilder.build());
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate.Builder pEntityPredicateBuilder, DamageSourcePredicate.Builder pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder.build()), pKillingBlowBuilder.build());
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate pEntityPredicateBuilder) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate.Builder pEntityPredicateBuilder) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder.build()), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer() {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate pEntityPredicateBuilder, DamageSourcePredicate pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder), pKillingBlowBuilder);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate.Builder pEntityPredicateBuilder, DamageSourcePredicate pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder.build()), pKillingBlowBuilder);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate pEntityPredicateBuilder, DamageSourcePredicate.Builder pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder), pKillingBlowBuilder.build());
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate.Builder pEntityPredicateBuilder, DamageSourcePredicate.Builder pKillingBlowBuilder) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, EntityPredicate.Composite.ANY, EntityPredicate.Composite.wrap(pEntityPredicateBuilder.build()), pKillingBlowBuilder.build());
        }

        public boolean matches(ServerPlayer pPlayer, LootContext pContext, DamageSource pSource) {
            return !this.killingBlow.matches(pPlayer, pSource) ? false : this.entityPredicate.matches(pContext);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("entity", this.entityPredicate.toJson(pConditions));
            jsonobject.add("killing_blow", this.killingBlow.serializeToJson());
            return jsonobject;
        }
    }
}

