/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class LevitationTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("levitation");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        DistancePredicate distancepredicate = DistancePredicate.fromJson(pJson.get("distance"));
        MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("duration"));
        return new TriggerInstance(pEntityPredicate, distancepredicate, minmaxbounds$ints);
    }

    public void trigger(ServerPlayer pPlayer, Vec3 pStartPos, int pDuration) {
        this.trigger(pPlayer, p_49124_ -> p_49124_.matches(pPlayer, pStartPos, pDuration));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final DistancePredicate distance;
        private final MinMaxBounds.Ints duration;

        public TriggerInstance(EntityPredicate.Composite pPlayer, DistancePredicate pDistance, MinMaxBounds.Ints pDuration) {
            super(ID, pPlayer);
            this.distance = pDistance;
            this.duration = pDuration;
        }

        public static TriggerInstance levitated(DistancePredicate pDistance) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pDistance, MinMaxBounds.Ints.ANY);
        }

        public boolean matches(ServerPlayer pPlayer, Vec3 pStartPos, int pDuration) {
            if (!this.distance.matches(pStartPos.x, pStartPos.y, pStartPos.z, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ())) {
                return false;
            }
            return this.duration.matches(pDuration);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("distance", this.distance.serializeToJson());
            jsonobject.add("duration", this.duration.serializeToJson());
            return jsonobject;
        }
    }
}

