/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.phys.Vec3;

public class LighthingBoltPredicate {
    public static final LighthingBoltPredicate ANY = new LighthingBoltPredicate(MinMaxBounds.Ints.ANY, EntityPredicate.ANY);
    private static final String BLOCKS_SET_ON_FIRE_KEY = "blocks_set_on_fire";
    private static final String ENTITY_STRUCK_KEY = "entity_struck";
    private final MinMaxBounds.Ints blocksSetOnFire;
    private final EntityPredicate entityStruck;

    private LighthingBoltPredicate(MinMaxBounds.Ints pBlocksSetOnFire, EntityPredicate pEntityStruck) {
        this.blocksSetOnFire = pBlocksSetOnFire;
        this.entityStruck = pEntityStruck;
    }

    public static LighthingBoltPredicate blockSetOnFire(MinMaxBounds.Ints pBlocksSetOnFire) {
        return new LighthingBoltPredicate(pBlocksSetOnFire, EntityPredicate.ANY);
    }

    public static LighthingBoltPredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "lightning");
            return new LighthingBoltPredicate(MinMaxBounds.Ints.fromJson(jsonobject.get(BLOCKS_SET_ON_FIRE_KEY)), EntityPredicate.fromJson(jsonobject.get(ENTITY_STRUCK_KEY)));
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.add(BLOCKS_SET_ON_FIRE_KEY, this.blocksSetOnFire.serializeToJson());
        jsonobject.add(ENTITY_STRUCK_KEY, this.entityStruck.serializeToJson());
        return jsonobject;
    }

    public boolean matches(Entity p_153247_, ServerLevel p_153248_, @Nullable Vec3 p_153249_) {
        if (this == ANY) {
            return true;
        }
        if (!(p_153247_ instanceof LightningBolt)) {
            return false;
        }
        LightningBolt lightningbolt = (LightningBolt)p_153247_;
        return this.blocksSetOnFire.matches(lightningbolt.getBlocksSetOnFire()) && (this.entityStruck == EntityPredicate.ANY || lightningbolt.getHitEntities().anyMatch(p_153245_ -> this.entityStruck.matches(p_153248_, p_153249_, (Entity)p_153245_)));
    }
}

