/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.slf4j.Logger;

public class LocationPredicate {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LocationPredicate ANY = new LocationPredicate(MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, null, null, null, null, LightPredicate.ANY, BlockPredicate.ANY, FluidPredicate.ANY);
    private final MinMaxBounds.Doubles x;
    private final MinMaxBounds.Doubles y;
    private final MinMaxBounds.Doubles z;
    @Nullable
    private final ResourceKey<Biome> biome;
    @Nullable
    private final ResourceKey<ConfiguredStructureFeature<?, ?>> feature;
    @Nullable
    private final ResourceKey<Level> dimension;
    @Nullable
    private final Boolean smokey;
    private final LightPredicate light;
    private final BlockPredicate block;
    private final FluidPredicate fluid;

    public LocationPredicate(MinMaxBounds.Doubles pX, MinMaxBounds.Doubles pY, MinMaxBounds.Doubles pZ, @Nullable ResourceKey<Biome> pBiome, @Nullable ResourceKey<ConfiguredStructureFeature<?, ?>> pFeature, @Nullable ResourceKey<Level> pDimension, @Nullable Boolean pSmokey, LightPredicate pLight, BlockPredicate pBlock, FluidPredicate pFluid) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.biome = pBiome;
        this.feature = pFeature;
        this.dimension = pDimension;
        this.smokey = pSmokey;
        this.light = pLight;
        this.block = pBlock;
        this.fluid = pFluid;
    }

    public static LocationPredicate inBiome(ResourceKey<Biome> pBiome) {
        return new LocationPredicate(MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, pBiome, null, null, null, LightPredicate.ANY, BlockPredicate.ANY, FluidPredicate.ANY);
    }

    public static LocationPredicate inDimension(ResourceKey<Level> pDimension) {
        return new LocationPredicate(MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, null, null, pDimension, null, LightPredicate.ANY, BlockPredicate.ANY, FluidPredicate.ANY);
    }

    public static LocationPredicate inFeature(ResourceKey<ConfiguredStructureFeature<?, ?>> pFeature) {
        return new LocationPredicate(MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, MinMaxBounds.Doubles.ANY, null, pFeature, null, null, LightPredicate.ANY, BlockPredicate.ANY, FluidPredicate.ANY);
    }

    public static LocationPredicate atYLocation(MinMaxBounds.Doubles p_187443_) {
        return new LocationPredicate(MinMaxBounds.Doubles.ANY, p_187443_, MinMaxBounds.Doubles.ANY, null, null, null, null, LightPredicate.ANY, BlockPredicate.ANY, FluidPredicate.ANY);
    }

    public boolean matches(ServerLevel pLevel, double pX, double p_52620_, double pY) {
        if (!this.x.matches(pX)) {
            return false;
        }
        if (!this.y.matches(p_52620_)) {
            return false;
        }
        if (!this.z.matches(pY)) {
            return false;
        }
        if (this.dimension != null && this.dimension != pLevel.dimension()) {
            return false;
        }
        BlockPos blockpos = new BlockPos(pX, p_52620_, pY);
        boolean flag = pLevel.isLoaded(blockpos);
        if (this.biome == null || flag && pLevel.getBiome(blockpos).is(this.biome)) {
            if (this.feature == null || flag && pLevel.structureFeatureManager().getStructureWithPieceAt(blockpos, this.feature).isValid()) {
                if (this.smokey == null || flag && this.smokey == CampfireBlock.isSmokeyPos(pLevel, blockpos)) {
                    if (!this.light.matches(pLevel, blockpos)) {
                        return false;
                    }
                    if (!this.block.matches(pLevel, blockpos)) {
                        return false;
                    }
                    return this.fluid.matches(pLevel, blockpos);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (!(this.x.isAny() && this.y.isAny() && this.z.isAny())) {
            JsonObject jsonobject1 = new JsonObject();
            jsonobject1.add("x", this.x.serializeToJson());
            jsonobject1.add("y", this.y.serializeToJson());
            jsonobject1.add("z", this.z.serializeToJson());
            jsonobject.add("position", (JsonElement)jsonobject1);
        }
        if (this.dimension != null) {
            Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.dimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_52633_ -> jsonobject.add("dimension", p_52633_));
        }
        if (this.feature != null) {
            jsonobject.addProperty("feature", this.feature.location().toString());
        }
        if (this.biome != null) {
            jsonobject.addProperty("biome", this.biome.location().toString());
        }
        if (this.smokey != null) {
            jsonobject.addProperty("smokey", this.smokey);
        }
        jsonobject.add("light", this.light.serializeToJson());
        jsonobject.add("block", this.block.serializeToJson());
        jsonobject.add("fluid", this.fluid.serializeToJson());
        return jsonobject;
    }

    public static LocationPredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            ResourceKey resourcekey;
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "location");
            JsonObject jsonobject1 = GsonHelper.getAsJsonObject(jsonobject, "position", new JsonObject());
            MinMaxBounds.Doubles minmaxbounds$doubles = MinMaxBounds.Doubles.fromJson(jsonobject1.get("x"));
            MinMaxBounds.Doubles minmaxbounds$doubles1 = MinMaxBounds.Doubles.fromJson(jsonobject1.get("y"));
            MinMaxBounds.Doubles minmaxbounds$doubles2 = MinMaxBounds.Doubles.fromJson(jsonobject1.get("z"));
            ResourceKey resourceKey = jsonobject.has("dimension") ? (ResourceKey)ResourceLocation.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonobject.get("dimension")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(p_52637_ -> ResourceKey.create(Registry.DIMENSION_REGISTRY, p_52637_)).orElse(null) : (resourcekey = null);
            ResourceKey resourcekey1 = jsonobject.has("feature") ? (ResourceKey)ResourceLocation.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonobject.get("feature")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(p_207927_ -> ResourceKey.create(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, p_207927_)).orElse(null) : null;
            ResourceKey<Biome> resourcekey2 = null;
            if (jsonobject.has("biome")) {
                ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(jsonobject, "biome"));
                resourcekey2 = ResourceKey.create(Registry.BIOME_REGISTRY, resourcelocation);
            }
            Boolean obool = jsonobject.has("smokey") ? Boolean.valueOf(jsonobject.get("smokey").getAsBoolean()) : null;
            LightPredicate lightpredicate = LightPredicate.fromJson(jsonobject.get("light"));
            BlockPredicate blockpredicate = BlockPredicate.fromJson(jsonobject.get("block"));
            FluidPredicate fluidpredicate = FluidPredicate.fromJson(jsonobject.get("fluid"));
            return new LocationPredicate(minmaxbounds$doubles, minmaxbounds$doubles1, minmaxbounds$doubles2, resourcekey2, resourcekey1, resourcekey, obool, lightpredicate, blockpredicate, fluidpredicate);
        }
        return ANY;
    }

    public static class Builder {
        private MinMaxBounds.Doubles x = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles y = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles z = MinMaxBounds.Doubles.ANY;
        @Nullable
        private ResourceKey<Biome> biome;
        @Nullable
        private ResourceKey<ConfiguredStructureFeature<?, ?>> feature;
        @Nullable
        private ResourceKey<Level> dimension;
        @Nullable
        private Boolean smokey;
        private LightPredicate light = LightPredicate.ANY;
        private BlockPredicate block = BlockPredicate.ANY;
        private FluidPredicate fluid = FluidPredicate.ANY;

        public static Builder location() {
            return new Builder();
        }

        public Builder setX(MinMaxBounds.Doubles pX) {
            this.x = pX;
            return this;
        }

        public Builder setY(MinMaxBounds.Doubles pY) {
            this.y = pY;
            return this;
        }

        public Builder setZ(MinMaxBounds.Doubles pZ) {
            this.z = pZ;
            return this;
        }

        public Builder setBiome(@Nullable ResourceKey<Biome> pBiome) {
            this.biome = pBiome;
            return this;
        }

        public Builder setFeature(@Nullable ResourceKey<ConfiguredStructureFeature<?, ?>> pFeature) {
            this.feature = pFeature;
            return this;
        }

        public Builder setDimension(@Nullable ResourceKey<Level> pDimension) {
            this.dimension = pDimension;
            return this;
        }

        public Builder setLight(LightPredicate pLight) {
            this.light = pLight;
            return this;
        }

        public Builder setBlock(BlockPredicate pBlock) {
            this.block = pBlock;
            return this;
        }

        public Builder setFluid(FluidPredicate pFluid) {
            this.fluid = pFluid;
            return this;
        }

        public Builder setSmokey(Boolean pSmokey) {
            this.smokey = pSmokey;
            return this;
        }

        public LocationPredicate build() {
            return new LocationPredicate(this.x, this.y, this.z, this.biome, this.feature, this.dimension, this.smokey, this.light, this.block, this.fluid);
        }
    }
}

