/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class LocationTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    final ResourceLocation id;

    public LocationTrigger(ResourceLocation pId) {
        this.id = pId;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "location", pJson);
        LocationPredicate locationpredicate = LocationPredicate.fromJson((JsonElement)jsonobject);
        return new TriggerInstance(this.id, pEntityPredicate, locationpredicate);
    }

    public void trigger(ServerPlayer pPlayer) {
        this.trigger(pPlayer, p_53649_ -> p_53649_.matches(pPlayer.getLevel(), pPlayer.getX(), pPlayer.getY(), pPlayer.getZ()));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final LocationPredicate location;

        public TriggerInstance(ResourceLocation pCriterion, EntityPredicate.Composite pPlayer, LocationPredicate pLocation) {
            super(pCriterion, pPlayer);
            this.location = pLocation;
        }

        public static TriggerInstance located(LocationPredicate pEntityPredicate) {
            return new TriggerInstance(CriteriaTriggers.LOCATION.id, EntityPredicate.Composite.ANY, pEntityPredicate);
        }

        public static TriggerInstance located(EntityPredicate pEntityPredicate) {
            return new TriggerInstance(CriteriaTriggers.LOCATION.id, EntityPredicate.Composite.wrap(pEntityPredicate), LocationPredicate.ANY);
        }

        public static TriggerInstance sleptInBed() {
            return new TriggerInstance(CriteriaTriggers.SLEPT_IN_BED.id, EntityPredicate.Composite.ANY, LocationPredicate.ANY);
        }

        public static TriggerInstance raidWon() {
            return new TriggerInstance(CriteriaTriggers.RAID_WIN.id, EntityPredicate.Composite.ANY, LocationPredicate.ANY);
        }

        public static TriggerInstance walkOnBlockWithEquipment(Block pBlock, Item pItem) {
            return TriggerInstance.located(EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().feet(ItemPredicate.Builder.item().a(pItem).build()).build()).steppingOn(LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().a(pBlock).build()).build()).build());
        }

        public boolean matches(ServerLevel pLevel, double pX, double p_53668_, double pY) {
            return this.location.matches(pLevel, pX, p_53668_, pY);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("location", this.location.serializeToJson());
            return jsonobject;
        }
    }
}

