/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class LootTableTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("player_generates_container_loot");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    protected TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(pJson, "loot_table"));
        return new TriggerInstance(pEntityPredicate, resourcelocation);
    }

    public void trigger(ServerPlayer pPlayer, ResourceLocation pLootTable) {
        this.trigger(pPlayer, (T p_54606_) -> p_54606_.matches(pLootTable));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ResourceLocation lootTable;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ResourceLocation pLootTable) {
            super(ID, pPlayer);
            this.lootTable = pLootTable;
        }

        public static TriggerInstance lootTableUsed(ResourceLocation pLootTable) {
            return new TriggerInstance(EntityPredicate.Composite.ANY, pLootTable);
        }

        public boolean matches(ResourceLocation pLootTable) {
            return this.lootTable.equals(pLootTable);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.addProperty("loot_table", this.lootTable.toString());
            return jsonobject;
        }
    }
}

