/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;

public abstract class MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.range.swapped"));
    @Nullable
    protected final T min;
    @Nullable
    protected final T max;

    protected MinMaxBounds(@Nullable T pMin, @Nullable T pMax) {
        this.min = pMin;
        this.max = pMax;
    }

    @Nullable
    public T getMin() {
        return this.min;
    }

    @Nullable
    public T getMax() {
        return this.max;
    }

    public boolean isAny() {
        return this.min == null && this.max == null;
    }

    public JsonElement serializeToJson() {
        if (this.isAny()) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.min.equals(this.max)) {
            return new JsonPrimitive(this.min);
        }
        JsonObject jsonobject = new JsonObject();
        if (this.min != null) {
            jsonobject.addProperty("min", this.min);
        }
        if (this.max != null) {
            jsonobject.addProperty("max", this.max);
        }
        return jsonobject;
    }

    protected static <T extends Number, R extends MinMaxBounds<T>> R fromJson(@Nullable JsonElement pJson, R pDefaultValue, BiFunction<JsonElement, String, T> pValueFactory, BoundsFactory<T, R> pBoundedFactory) {
        if (pJson != null && !pJson.isJsonNull()) {
            if (GsonHelper.isNumberValue(pJson)) {
                Number t2 = (Number)pValueFactory.apply(pJson, "value");
                return pBoundedFactory.create(t2, t2);
            }
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "value");
            Number t = jsonobject.has("min") ? (Number)((Number)pValueFactory.apply(jsonobject.get("min"), "min")) : (Number)null;
            Number t1 = jsonobject.has("max") ? (Number)((Number)pValueFactory.apply(jsonobject.get("max"), "max")) : (Number)null;
            return pBoundedFactory.create(t, t1);
        }
        return pDefaultValue;
    }

    protected static <T extends Number, R extends MinMaxBounds<T>> R fromReader(StringReader pReader, BoundsFromReaderFactory<T, R> pBoundedFactory, Function<String, T> pValueFactory, Supplier<DynamicCommandExceptionType> pCommandExceptionSupplier, Function<T, T> pFormatter) throws CommandSyntaxException {
        if (!pReader.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)pReader);
        }
        int i = pReader.getCursor();
        try {
            Number t1;
            Number t = (Number)MinMaxBounds.optionallyFormat(MinMaxBounds.readNumber(pReader, pValueFactory, pCommandExceptionSupplier), pFormatter);
            if (pReader.canRead(2) && pReader.peek() == '.' && pReader.peek(1) == '.') {
                pReader.skip();
                pReader.skip();
                t1 = (Number)MinMaxBounds.optionallyFormat(MinMaxBounds.readNumber(pReader, pValueFactory, pCommandExceptionSupplier), pFormatter);
                if (t == null && t1 == null) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)pReader);
                }
            } else {
                t1 = t;
            }
            if (t == null && t1 == null) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)pReader);
            }
            return pBoundedFactory.create(pReader, t, t1);
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            pReader.setCursor(i);
            throw new CommandSyntaxException(commandsyntaxexception.getType(), commandsyntaxexception.getRawMessage(), commandsyntaxexception.getInput(), i);
        }
    }

    @Nullable
    private static <T extends Number> T readNumber(StringReader pReader, Function<String, T> pStringToValueFunction, Supplier<DynamicCommandExceptionType> pCommandExceptionSupplier) throws CommandSyntaxException {
        int i = pReader.getCursor();
        while (pReader.canRead() && MinMaxBounds.isAllowedInputChat(pReader)) {
            pReader.skip();
        }
        String s = pReader.getString().substring(i, pReader.getCursor());
        if (s.isEmpty()) {
            return null;
        }
        try {
            return (T)((Number)pStringToValueFunction.apply(s));
        }
        catch (NumberFormatException numberformatexception) {
            throw pCommandExceptionSupplier.get().createWithContext((ImmutableStringReader)pReader, (Object)s);
        }
    }

    private static boolean isAllowedInputChat(StringReader pReader) {
        char c0 = pReader.peek();
        if ((c0 < '0' || c0 > '9') && c0 != '-') {
            if (c0 != '.') {
                return false;
            }
            return !pReader.canRead(2) || pReader.peek(1) != '.';
        }
        return true;
    }

    @Nullable
    private static <T> T optionallyFormat(@Nullable T pValue, Function<T, T> pFormatter) {
        return pValue == null ? null : (T)pFormatter.apply(pValue);
    }

    @FunctionalInterface
    protected static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(@Nullable T var1, @Nullable T var2);
    }

    @FunctionalInterface
    protected static interface BoundsFromReaderFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, @Nullable T var2, @Nullable T var3) throws CommandSyntaxException;
    }

    public static class Doubles
    extends MinMaxBounds<Double> {
        public static final Doubles ANY = new Doubles(null, null);
        @Nullable
        private final Double minSq;
        @Nullable
        private final Double maxSq;

        private static Doubles create(StringReader p_154796_, @Nullable Double p_154797_, @Nullable Double p_154798_) throws CommandSyntaxException {
            if (p_154797_ != null && p_154798_ != null && p_154797_ > p_154798_) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)p_154796_);
            }
            return new Doubles(p_154797_, p_154798_);
        }

        @Nullable
        private static Double squareOpt(@Nullable Double pValue) {
            return pValue == null ? null : Double.valueOf(pValue * pValue);
        }

        private Doubles(@Nullable Double p_154784_, @Nullable Double p_154785_) {
            super(p_154784_, p_154785_);
            this.minSq = Doubles.squareOpt(p_154784_);
            this.maxSq = Doubles.squareOpt(p_154785_);
        }

        public static Doubles exactly(double pValue) {
            return new Doubles(pValue, pValue);
        }

        public static Doubles between(double pMin, double p_154790_) {
            return new Doubles(pMin, p_154790_);
        }

        public static Doubles atLeast(double pMin) {
            return new Doubles(pMin, null);
        }

        public static Doubles atMost(double pMax) {
            return new Doubles(null, pMax);
        }

        public boolean matches(double pValue) {
            if (this.min != null && (Double)this.min > pValue) {
                return false;
            }
            return this.max == null || !((Double)this.max < pValue);
        }

        public boolean matchesSqr(double pValue) {
            if (this.minSq != null && this.minSq > pValue) {
                return false;
            }
            return this.maxSq == null || !(this.maxSq < pValue);
        }

        public static Doubles fromJson(@Nullable JsonElement pJson) {
            return Doubles.fromJson(pJson, ANY, GsonHelper::convertToDouble, Doubles::new);
        }

        public static Doubles fromReader(StringReader pReader) throws CommandSyntaxException {
            return Doubles.fromReader(pReader, p_154807_ -> p_154807_);
        }

        public static Doubles fromReader(StringReader pReader, Function<Double, Double> pFormatter) throws CommandSyntaxException {
            return Doubles.fromReader(pReader, Doubles::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), pFormatter);
        }
    }

    public static class Ints
    extends MinMaxBounds<Integer> {
        public static final Ints ANY = new Ints(null, null);
        @Nullable
        private final Long minSq;
        @Nullable
        private final Long maxSq;

        private static Ints create(StringReader p_55378_, @Nullable Integer p_55379_, @Nullable Integer p_55380_) throws CommandSyntaxException {
            if (p_55379_ != null && p_55380_ != null && p_55379_ > p_55380_) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)p_55378_);
            }
            return new Ints(p_55379_, p_55380_);
        }

        @Nullable
        private static Long squareOpt(@Nullable Integer pValue) {
            return pValue == null ? null : Long.valueOf(pValue.longValue() * pValue.longValue());
        }

        private Ints(@Nullable Integer p_55369_, @Nullable Integer p_55370_) {
            super(p_55369_, p_55370_);
            this.minSq = Ints.squareOpt(p_55369_);
            this.maxSq = Ints.squareOpt(p_55370_);
        }

        public static Ints exactly(int pValue) {
            return new Ints(pValue, pValue);
        }

        public static Ints between(int pMin, int pMax) {
            return new Ints(pMin, pMax);
        }

        public static Ints atLeast(int pMin) {
            return new Ints(pMin, null);
        }

        public static Ints atMost(int pMax) {
            return new Ints(null, pMax);
        }

        public boolean matches(int pValue) {
            if (this.min != null && (Integer)this.min > pValue) {
                return false;
            }
            return this.max == null || (Integer)this.max >= pValue;
        }

        public boolean matchesSqr(long pValue) {
            if (this.minSq != null && this.minSq > pValue) {
                return false;
            }
            return this.maxSq == null || this.maxSq >= pValue;
        }

        public static Ints fromJson(@Nullable JsonElement pJson) {
            return Ints.fromJson(pJson, ANY, GsonHelper::convertToInt, Ints::new);
        }

        public static Ints fromReader(StringReader pReader) throws CommandSyntaxException {
            return Ints.fromReader(pReader, p_55389_ -> p_55389_);
        }

        public static Ints fromReader(StringReader pReader, Function<Integer, Integer> pValueFunction) throws CommandSyntaxException {
            return Ints.fromReader(pReader, Ints::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), pValueFunction);
        }
    }
}

