/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MobEffectsPredicate {
    public static final MobEffectsPredicate ANY = new MobEffectsPredicate(Collections.emptyMap());
    private final Map<MobEffect, MobEffectInstancePredicate> effects;

    public MobEffectsPredicate(Map<MobEffect, MobEffectInstancePredicate> pEffects) {
        this.effects = pEffects;
    }

    public static MobEffectsPredicate effects() {
        return new MobEffectsPredicate(Maps.newLinkedHashMap());
    }

    public MobEffectsPredicate and(MobEffect pEffect) {
        this.effects.put(pEffect, new MobEffectInstancePredicate());
        return this;
    }

    public MobEffectsPredicate and(MobEffect pEffect, MobEffectInstancePredicate pPredicate) {
        this.effects.put(pEffect, pPredicate);
        return this;
    }

    public boolean matches(Entity pEffects) {
        if (this == ANY) {
            return true;
        }
        return pEffects instanceof LivingEntity ? this.matches(((LivingEntity)pEffects).getActiveEffectsMap()) : false;
    }

    public boolean matches(LivingEntity pEffects) {
        return this == ANY ? true : this.matches(pEffects.getActiveEffectsMap());
    }

    public boolean matches(Map<MobEffect, MobEffectInstance> pEffects) {
        if (this == ANY) {
            return true;
        }
        for (Map.Entry<MobEffect, MobEffectInstancePredicate> entry : this.effects.entrySet()) {
            MobEffectInstance mobeffectinstance = pEffects.get(entry.getKey());
            if (entry.getValue().matches(mobeffectinstance)) continue;
            return false;
        }
        return true;
    }

    public static MobEffectsPredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "effects");
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry entry : jsonobject.entrySet()) {
                ResourceLocation resourcelocation = new ResourceLocation((String)entry.getKey());
                MobEffect mobeffect = Registry.MOB_EFFECT.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown effect '" + resourcelocation + "'"));
                MobEffectInstancePredicate mobeffectspredicate$mobeffectinstancepredicate = MobEffectInstancePredicate.fromJson(GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), (String)entry.getKey()));
                map.put(mobeffect, mobeffectspredicate$mobeffectinstancepredicate);
            }
            return new MobEffectsPredicate(map);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry<MobEffect, MobEffectInstancePredicate> entry : this.effects.entrySet()) {
            jsonobject.add(Registry.MOB_EFFECT.getKey(entry.getKey()).toString(), entry.getValue().serializeToJson());
        }
        return jsonobject;
    }

    public static class MobEffectInstancePredicate {
        private final MinMaxBounds.Ints amplifier;
        private final MinMaxBounds.Ints duration;
        @Nullable
        private final Boolean ambient;
        @Nullable
        private final Boolean visible;

        public MobEffectInstancePredicate(MinMaxBounds.Ints pAmplifier, MinMaxBounds.Ints pDuration, @Nullable Boolean pAmbient, @Nullable Boolean pVisible) {
            this.amplifier = pAmplifier;
            this.duration = pDuration;
            this.ambient = pAmbient;
            this.visible = pVisible;
        }

        public MobEffectInstancePredicate() {
            this(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, null, null);
        }

        public boolean matches(@Nullable MobEffectInstance pEffect) {
            if (pEffect == null) {
                return false;
            }
            if (!this.amplifier.matches(pEffect.getAmplifier())) {
                return false;
            }
            if (!this.duration.matches(pEffect.getDuration())) {
                return false;
            }
            if (this.ambient != null && this.ambient.booleanValue() != pEffect.isAmbient()) {
                return false;
            }
            return this.visible == null || this.visible.booleanValue() == pEffect.isVisible();
        }

        public JsonElement serializeToJson() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("amplifier", this.amplifier.serializeToJson());
            jsonobject.add("duration", this.duration.serializeToJson());
            jsonobject.addProperty("ambient", this.ambient);
            jsonobject.addProperty("visible", this.visible);
            return jsonobject;
        }

        public static MobEffectInstancePredicate fromJson(JsonObject pJson) {
            MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(pJson.get("amplifier"));
            MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.fromJson(pJson.get("duration"));
            Boolean obool = pJson.has("ambient") ? Boolean.valueOf(GsonHelper.getAsBoolean(pJson, "ambient")) : null;
            Boolean obool1 = pJson.has("visible") ? Boolean.valueOf(GsonHelper.getAsBoolean(pJson, "visible")) : null;
            return new MobEffectInstancePredicate(minmaxbounds$ints, minmaxbounds$ints1, obool, obool1);
        }
    }
}

