/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class PlayerInteractTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("player_interacted_with_entity");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    protected TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("item"));
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pJson, "entity", pConditionsParser);
        return new TriggerInstance(pEntityPredicate, itempredicate, entitypredicate$composite);
    }

    public void trigger(ServerPlayer pPlayer, ItemStack pItem, Entity pEntity) {
        LootContext lootcontext = EntityPredicate.createContext(pPlayer, pEntity);
        this.trigger(pPlayer, p_61501_ -> p_61501_.matches(pItem, lootcontext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final EntityPredicate.Composite entity;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ItemPredicate pItem, EntityPredicate.Composite pEntity) {
            super(ID, pPlayer);
            this.item = pItem;
            this.entity = pEntity;
        }

        public static TriggerInstance itemUsedOnEntity(EntityPredicate.Composite pPlayer, ItemPredicate.Builder pItem, EntityPredicate.Composite pEntity) {
            return new TriggerInstance(pPlayer, pItem.build(), pEntity);
        }

        public boolean matches(ItemStack pItem, LootContext pLootContext) {
            return !this.item.matches(pItem) ? false : this.entity.matches(pLootContext);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("item", this.item.serializeToJson());
            jsonobject.add("entity", this.entity.toJson(pConditions));
            return jsonobject;
        }
    }
}

