/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;

public class RecipeUnlockedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("recipe_unlocked");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(pJson, "recipe"));
        return new TriggerInstance(pEntityPredicate, resourcelocation);
    }

    @Override
    public void trigger(ServerPlayer pPlayer, Recipe<?> pRecipe) {
        ((SimpleCriterionTrigger)this).trigger(pPlayer, (T p_63723_) -> p_63723_.matches(pRecipe));
    }

    public static TriggerInstance unlocked(ResourceLocation pRecipe) {
        return new TriggerInstance(EntityPredicate.Composite.ANY, pRecipe);
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ResourceLocation recipe;

        public TriggerInstance(EntityPredicate.Composite pPlayer, ResourceLocation pRecipe) {
            super(ID, pPlayer);
            this.recipe = pRecipe;
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.addProperty("recipe", this.recipe.toString());
            return jsonobject;
        }

        public boolean matches(Recipe<?> pRecipe) {
            return this.recipe.equals(pRecipe.getId());
        }
    }
}

