/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;

public abstract class SimpleCriterionTrigger<T extends AbstractCriterionTriggerInstance>
implements CriterionTrigger<T> {
    private final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<T>>> players = Maps.newIdentityHashMap();

    @Override
    public final void addPlayerListener(PlayerAdvancements pPlayerAdvancements, CriterionTrigger.Listener<T> pListener) {
        this.players.computeIfAbsent(pPlayerAdvancements, p_66252_ -> Sets.newHashSet()).add(pListener);
    }

    @Override
    public final void removePlayerListener(PlayerAdvancements pPlayerAdvancements, CriterionTrigger.Listener<T> pListener) {
        Set<CriterionTrigger.Listener<T>> set = this.players.get(pPlayerAdvancements);
        if (set != null) {
            set.remove(pListener);
            if (set.isEmpty()) {
                this.players.remove(pPlayerAdvancements);
            }
        }
    }

    @Override
    public final void removePlayerListeners(PlayerAdvancements pPlayerAdvancements) {
        this.players.remove(pPlayerAdvancements);
    }

    protected abstract T createInstance(JsonObject var1, EntityPredicate.Composite var2, DeserializationContext var3);

    @Override
    public final T createInstance(JsonObject pObject, DeserializationContext pConditions) {
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pObject, "player", pConditions);
        return this.createInstance(pObject, entitypredicate$composite, pConditions);
    }

    protected void trigger(ServerPlayer pPlayer, Predicate<T> pTestTrigger) {
        PlayerAdvancements playeradvancements = pPlayer.getAdvancements();
        Set<CriterionTrigger.Listener<T>> set = this.players.get(playeradvancements);
        if (set != null && !set.isEmpty()) {
            LootContext lootcontext = EntityPredicate.createContext(pPlayer, pPlayer);
            List list = null;
            for (CriterionTrigger.Listener<T> listener : set) {
                AbstractCriterionTriggerInstance t = (AbstractCriterionTriggerInstance)listener.getTriggerInstance();
                if (!pTestTrigger.test(t) || !t.getPlayerPredicate().matches(lootcontext)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener<Object> listener1 : list) {
                    listener1.run(playeradvancements);
                }
            }
        }
    }
}

