/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class StatePropertiesPredicate {
    public static final StatePropertiesPredicate ANY = new StatePropertiesPredicate((List<PropertyMatcher>)ImmutableList.of());
    private final List<PropertyMatcher> properties;

    private static PropertyMatcher fromJson(String pName, JsonElement pJson) {
        if (pJson.isJsonPrimitive()) {
            String s2 = pJson.getAsString();
            return new ExactPropertyMatcher(pName, s2);
        }
        JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "value");
        String s = jsonobject.has("min") ? StatePropertiesPredicate.getStringOrNull(jsonobject.get("min")) : null;
        String s1 = jsonobject.has("max") ? StatePropertiesPredicate.getStringOrNull(jsonobject.get("max")) : null;
        return s != null && s.equals(s1) ? new ExactPropertyMatcher(pName, s) : new RangedPropertyMatcher(pName, s, s1);
    }

    @Nullable
    private static String getStringOrNull(JsonElement pJson) {
        return pJson.isJsonNull() ? null : pJson.getAsString();
    }

    StatePropertiesPredicate(List<PropertyMatcher> p_67662_) {
        this.properties = ImmutableList.copyOf(p_67662_);
    }

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> pProperties, S pTargetProperty) {
        for (PropertyMatcher statepropertiespredicate$propertymatcher : this.properties) {
            if (statepropertiespredicate$propertymatcher.match(pProperties, pTargetProperty)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState pState) {
        return this.matches(pState.getBlock().getStateDefinition(), pState);
    }

    public boolean matches(FluidState pState) {
        return this.matches(pState.getType().getStateDefinition(), pState);
    }

    public void checkState(StateDefinition<?, ?> pProperties, Consumer<String> pPropertyConsumer) {
        this.properties.forEach(p_67678_ -> p_67678_.checkState(pProperties, pPropertyConsumer));
    }

    public static StatePropertiesPredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "properties");
            ArrayList list = Lists.newArrayList();
            for (Map.Entry entry : jsonobject.entrySet()) {
                list.add(StatePropertiesPredicate.fromJson((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
            return new StatePropertiesPredicate(list);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (!this.properties.isEmpty()) {
            this.properties.forEach(p_67683_ -> jsonobject.add(p_67683_.getName(), p_67683_.toJson()));
        }
        return jsonobject;
    }

    public static class Builder {
        private final List<PropertyMatcher> matchers = Lists.newArrayList();

        private Builder() {
        }

        public static Builder properties() {
            return new Builder();
        }

        public Builder hasProperty(Property<?> pProperty, String pValue) {
            this.matchers.add(new ExactPropertyMatcher(pProperty.getName(), pValue));
            return this;
        }

        public Builder hasProperty(Property<Integer> pProperty, int pValue) {
            return this.hasProperty((Property)pProperty, (Comparable<T> & StringRepresentable)Integer.toString(pValue));
        }

        public Builder hasProperty(Property<Boolean> pProperty, boolean pValue) {
            return this.hasProperty((Property)pProperty, (Comparable<T> & StringRepresentable)Boolean.toString(pValue));
        }

        public <T extends Comparable<T> & StringRepresentable> Builder hasProperty(Property<T> pProperty, T pValue) {
            return this.hasProperty(pProperty, (T)((StringRepresentable)pValue).getSerializedName());
        }

        public StatePropertiesPredicate build() {
            return new StatePropertiesPredicate(this.matchers);
        }
    }

    static class ExactPropertyMatcher
    extends PropertyMatcher {
        private final String value;

        public ExactPropertyMatcher(String pName, String pValue) {
            super(pName);
            this.value = pValue;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(StateHolder<?, ?> pProperties, Property<T> pPropertyTarget) {
            Comparable t = pProperties.getValue(pPropertyTarget);
            Optional<T> optional = pPropertyTarget.getValue(this.value);
            return optional.isPresent() && t.compareTo((Comparable)((Comparable)optional.get())) == 0;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(this.value);
        }
    }

    static abstract class PropertyMatcher {
        private final String name;

        public PropertyMatcher(String pName) {
            this.name = pName;
        }

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> pProperties, S pPropertyToMatch) {
            Property<?> property = pProperties.getProperty(this.name);
            return property == null ? false : this.match(pPropertyToMatch, property);
        }

        protected abstract <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);

        public abstract JsonElement toJson();

        public String getName() {
            return this.name;
        }

        public void checkState(StateDefinition<?, ?> pProperties, Consumer<String> pPropertyConsumer) {
            Property<?> property = pProperties.getProperty(this.name);
            if (property == null) {
                pPropertyConsumer.accept(this.name);
            }
        }
    }

    static class RangedPropertyMatcher
    extends PropertyMatcher {
        @Nullable
        private final String minValue;
        @Nullable
        private final String maxValue;

        public RangedPropertyMatcher(String pName, @Nullable String pMinValue, @Nullable String pMaxValue) {
            super(pName);
            this.minValue = pMinValue;
            this.maxValue = pMaxValue;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(StateHolder<?, ?> pProperties, Property<T> pPropertyTarget) {
            Optional<T> optional1;
            Optional<T> optional;
            Comparable t = pProperties.getValue(pPropertyTarget);
            if (!(this.minValue == null || (optional = pPropertyTarget.getValue(this.minValue)).isPresent() && t.compareTo((Comparable)((Comparable)optional.get())) >= 0)) {
                return false;
            }
            return this.maxValue == null || (optional1 = pPropertyTarget.getValue(this.maxValue)).isPresent() && t.compareTo((Comparable)((Comparable)optional1.get())) <= 0;
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonobject = new JsonObject();
            if (this.minValue != null) {
                jsonobject.addProperty("min", this.minValue);
            }
            if (this.maxValue != null) {
                jsonobject.addProperty("max", this.maxValue);
            }
            return jsonobject;
        }
    }
}

