/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class TradeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("villager_trade");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        EntityPredicate.Composite entitypredicate$composite = EntityPredicate.Composite.fromJson(pJson, "villager", pConditionsParser);
        ItemPredicate itempredicate = ItemPredicate.fromJson(pJson.get("item"));
        return new TriggerInstance(pEntityPredicate, entitypredicate$composite, itempredicate);
    }

    public void trigger(ServerPlayer pPlayer, AbstractVillager pVillager, ItemStack pStack) {
        LootContext lootcontext = EntityPredicate.createContext(pPlayer, pVillager);
        this.trigger(pPlayer, p_70970_ -> p_70970_.matches(lootcontext, pStack));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite villager;
        private final ItemPredicate item;

        public TriggerInstance(EntityPredicate.Composite pPlayer, EntityPredicate.Composite pVillager, ItemPredicate pItem) {
            super(ID, pPlayer);
            this.villager = pVillager;
            this.item = pItem;
        }

        public static TriggerInstance tradedWithVillager() {
            return new TriggerInstance(EntityPredicate.Composite.ANY, EntityPredicate.Composite.ANY, ItemPredicate.ANY);
        }

        public static TriggerInstance tradedWithVillager(EntityPredicate.Builder p_191437_) {
            return new TriggerInstance(EntityPredicate.Composite.wrap(p_191437_.build()), EntityPredicate.Composite.ANY, ItemPredicate.ANY);
        }

        public boolean matches(LootContext pContext, ItemStack pStack) {
            if (!this.villager.matches(pContext)) {
                return false;
            }
            return this.item.matches(pStack);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext pConditions) {
            JsonObject jsonobject = super.serializeToJson(pConditions);
            jsonobject.add("item", this.item.serializeToJson());
            jsonobject.add("villager", this.villager.toJson(pConditions));
            return jsonobject;
        }
    }
}

