/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class UsedEnderEyeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("used_ender_eye");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject pJson, EntityPredicate.Composite pEntityPredicate, DeserializationContext pConditionsParser) {
        MinMaxBounds.Doubles minmaxbounds$doubles = MinMaxBounds.Doubles.fromJson(pJson.get("distance"));
        return new TriggerInstance(pEntityPredicate, minmaxbounds$doubles);
    }

    public void trigger(ServerPlayer pPlayer, BlockPos pPos) {
        double d0 = pPlayer.getX() - (double)pPos.getX();
        double d1 = pPlayer.getZ() - (double)pPos.getZ();
        double d2 = d0 * d0 + d1 * d1;
        this.trigger(pPlayer, (T p_73934_) -> p_73934_.matches(d2));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Doubles level;

        public TriggerInstance(EntityPredicate.Composite pPlayer, MinMaxBounds.Doubles pLevel) {
            super(ID, pPlayer);
            this.level = pLevel;
        }

        public boolean matches(double pDistanceSq) {
            return this.level.matchesSqr(pDistanceSq);
        }
    }
}

