/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;

public class WrappedMinMaxBounds {
    public static final WrappedMinMaxBounds ANY = new WrappedMinMaxBounds(null, null);
    public static final SimpleCommandExceptionType ERROR_INTS_ONLY = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.range.ints"));
    @Nullable
    private final Float min;
    @Nullable
    private final Float max;

    public WrappedMinMaxBounds(@Nullable Float pMin, @Nullable Float pMax) {
        this.min = pMin;
        this.max = pMax;
    }

    public static WrappedMinMaxBounds exactly(float pValue) {
        return new WrappedMinMaxBounds(Float.valueOf(pValue), Float.valueOf(pValue));
    }

    public static WrappedMinMaxBounds between(float pMin, float pMax) {
        return new WrappedMinMaxBounds(Float.valueOf(pMin), Float.valueOf(pMax));
    }

    public static WrappedMinMaxBounds atLeast(float pMin) {
        return new WrappedMinMaxBounds(Float.valueOf(pMin), null);
    }

    public static WrappedMinMaxBounds atMost(float pMax) {
        return new WrappedMinMaxBounds(null, Float.valueOf(pMax));
    }

    public boolean matches(float pValue) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && this.min.floatValue() > pValue && this.max.floatValue() < pValue) {
            return false;
        }
        if (this.min != null && this.min.floatValue() > pValue) {
            return false;
        }
        return this.max == null || !(this.max.floatValue() < pValue);
    }

    public boolean matchesSqr(double pValue) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && (double)(this.min.floatValue() * this.min.floatValue()) > pValue && (double)(this.max.floatValue() * this.max.floatValue()) < pValue) {
            return false;
        }
        if (this.min != null && (double)(this.min.floatValue() * this.min.floatValue()) > pValue) {
            return false;
        }
        return this.max == null || !((double)(this.max.floatValue() * this.max.floatValue()) < pValue);
    }

    @Nullable
    public Float getMin() {
        return this.min;
    }

    @Nullable
    public Float getMax() {
        return this.max;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.max != null && this.min.equals(this.max)) {
            return new JsonPrimitive((Number)this.min);
        }
        JsonObject jsonobject = new JsonObject();
        if (this.min != null) {
            jsonobject.addProperty("min", (Number)this.min);
        }
        if (this.max != null) {
            jsonobject.addProperty("max", (Number)this.min);
        }
        return jsonobject;
    }

    public static WrappedMinMaxBounds fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            if (GsonHelper.isNumberValue(pJson)) {
                float f2 = GsonHelper.convertToFloat(pJson, "value");
                return new WrappedMinMaxBounds(Float.valueOf(f2), Float.valueOf(f2));
            }
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "value");
            Float f = jsonobject.has("min") ? Float.valueOf(GsonHelper.getAsFloat(jsonobject, "min")) : null;
            Float f1 = jsonobject.has("max") ? Float.valueOf(GsonHelper.getAsFloat(jsonobject, "max")) : null;
            return new WrappedMinMaxBounds(f, f1);
        }
        return ANY;
    }

    public static WrappedMinMaxBounds fromReader(StringReader pReader, boolean pIsFloatingPoint) throws CommandSyntaxException {
        return WrappedMinMaxBounds.fromReader(pReader, pIsFloatingPoint, p_164413_ -> p_164413_);
    }

    public static WrappedMinMaxBounds fromReader(StringReader pReader, boolean pIsFloatingPoint, Function<Float, Float> pValueFactory) throws CommandSyntaxException {
        Float f1;
        if (!pReader.canRead()) {
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)pReader);
        }
        int i = pReader.getCursor();
        Float f = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(pReader, pIsFloatingPoint), pValueFactory);
        if (pReader.canRead(2) && pReader.peek() == '.' && pReader.peek(1) == '.') {
            pReader.skip();
            pReader.skip();
            f1 = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(pReader, pIsFloatingPoint), pValueFactory);
            if (f == null && f1 == null) {
                pReader.setCursor(i);
                throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)pReader);
            }
        } else {
            if (!pIsFloatingPoint && pReader.canRead() && pReader.peek() == '.') {
                pReader.setCursor(i);
                throw ERROR_INTS_ONLY.createWithContext((ImmutableStringReader)pReader);
            }
            f1 = f;
        }
        if (f == null && f1 == null) {
            pReader.setCursor(i);
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)pReader);
        }
        return new WrappedMinMaxBounds(f, f1);
    }

    @Nullable
    private static Float readNumber(StringReader pReader, boolean pIsFloatingPoint) throws CommandSyntaxException {
        int i = pReader.getCursor();
        while (pReader.canRead() && WrappedMinMaxBounds.isAllowedNumber(pReader, pIsFloatingPoint)) {
            pReader.skip();
        }
        String s = pReader.getString().substring(i, pReader.getCursor());
        if (s.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException numberformatexception) {
            if (pIsFloatingPoint) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)pReader, (Object)s);
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)pReader, (Object)s);
        }
    }

    private static boolean isAllowedNumber(StringReader pReader, boolean pIsFloatingPoint) {
        char c0 = pReader.peek();
        if ((c0 < '0' || c0 > '9') && c0 != '-') {
            if (pIsFloatingPoint && c0 == '.') {
                return !pReader.canRead(2) || pReader.peek(1) != '.';
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static Float optionallyFormat(@Nullable Float pValue, Function<Float, Float> pValueFactory) {
        return pValue == null ? null : pValueFactory.apply(pValue);
    }
}

