/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.optifine.reflect.Reflector;

public class Camera {
    private boolean initialized;
    private BlockGetter level;
    private Entity entity;
    private Vec3 position = Vec3.ZERO;
    private final BlockPos.MutableBlockPos blockPosition = new BlockPos.MutableBlockPos();
    private final Vector3f forwards = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);
    private float xRot;
    private float yRot;
    private final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private boolean detached;
    private float eyeHeight;
    private float eyeHeightOld;
    public static final float FOG_DISTANCE_SCALE = 0.083333336f;

    public void setup(BlockGetter pLevel, Entity pRenderViewEntity, boolean pThirdPerson, boolean pThirdPersonReverse, float pPartialTick) {
        this.initialized = true;
        this.level = pLevel;
        this.entity = pRenderViewEntity;
        this.detached = pThirdPerson;
        this.setRotation(pRenderViewEntity.getViewYRot(pPartialTick), pRenderViewEntity.getViewXRot(pPartialTick));
        this.setPosition(Mth.lerp((double)pPartialTick, pRenderViewEntity.xo, pRenderViewEntity.getX()), Mth.lerp((double)pPartialTick, pRenderViewEntity.yo, pRenderViewEntity.getY()) + (double)Mth.lerp(pPartialTick, this.eyeHeightOld, this.eyeHeight), Mth.lerp((double)pPartialTick, pRenderViewEntity.zo, pRenderViewEntity.getZ()));
        if (pThirdPerson) {
            if (pThirdPersonReverse) {
                this.setRotation(this.yRot + 180.0f, -this.xRot);
            }
            this.move(-this.getMaxZoom(4.0), 0.0, 0.0);
        } else if (pRenderViewEntity instanceof LivingEntity && ((LivingEntity)pRenderViewEntity).isSleeping()) {
            Direction direction = ((LivingEntity)pRenderViewEntity).getBedOrientation();
            this.setRotation(direction != null ? direction.toYRot() - 180.0f : 0.0f, 0.0f);
            this.move(0.0, 0.3, 0.0);
        }
    }

    public void tick() {
        if (this.entity != null) {
            this.eyeHeightOld = this.eyeHeight;
            this.eyeHeight += (this.entity.getEyeHeight() - this.eyeHeight) * 0.5f;
        }
    }

    private double getMaxZoom(double pStartingDistance) {
        int i = 0;
        while (i < 8) {
            double d0;
            Vec3 vec31;
            BlockHitResult hitresult;
            float f = (i & 1) * 2 - 1;
            float f1 = (i >> 1 & 1) * 2 - 1;
            float f2 = (i >> 2 & 1) * 2 - 1;
            Vec3 vec3 = this.position.add(f *= 0.1f, f1 *= 0.1f, f2 *= 0.1f);
            if (((HitResult)(hitresult = this.level.clip(new ClipContext(vec3, vec31 = new Vec3(this.position.x - (double)this.forwards.x() * pStartingDistance + (double)f + (double)f2, this.position.y - (double)this.forwards.y() * pStartingDistance + (double)f1, this.position.z - (double)this.forwards.z() * pStartingDistance + (double)f2), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.entity)))).getType() != HitResult.Type.MISS && (d0 = hitresult.getLocation().distanceTo(this.position)) < pStartingDistance) {
                pStartingDistance = d0;
            }
            ++i;
        }
        return pStartingDistance;
    }

    protected void move(double pDistanceOffset, double p_90570_, double pVerticalOffset) {
        double d0 = (double)this.forwards.x() * pDistanceOffset + (double)this.up.x() * p_90570_ + (double)this.left.x() * pVerticalOffset;
        double d1 = (double)this.forwards.y() * pDistanceOffset + (double)this.up.y() * p_90570_ + (double)this.left.y() * pVerticalOffset;
        double d2 = (double)this.forwards.z() * pDistanceOffset + (double)this.up.z() * p_90570_ + (double)this.left.z() * pVerticalOffset;
        this.setPosition(new Vec3(this.position.x + d0, this.position.y + d1, this.position.z + d2));
    }

    protected void setRotation(float pPitch, float pYaw) {
        this.xRot = pYaw;
        this.yRot = pPitch;
        this.rotation.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.rotation.mul(Vector3f.YP.rotationDegrees(-pPitch));
        this.rotation.mul(Vector3f.XP.rotationDegrees(pYaw));
        this.forwards.set(0.0f, 0.0f, 1.0f);
        this.forwards.transform(this.rotation);
        this.up.set(0.0f, 1.0f, 0.0f);
        this.up.transform(this.rotation);
        this.left.set(1.0f, 0.0f, 0.0f);
        this.left.transform(this.rotation);
    }

    protected void setPosition(double pX, double p_90586_, double pY) {
        this.setPosition(new Vec3(pX, p_90586_, pY));
    }

    protected void setPosition(Vec3 pPos) {
        this.position = pPos;
        this.blockPosition.set(pPos.x, pPos.y, pPos.z);
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public BlockPos getBlockPosition() {
        return this.blockPosition;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public Quaternion rotation() {
        return this.rotation;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public NearPlane getNearPlane() {
        Minecraft minecraft = Minecraft.getInstance();
        double d0 = (double)minecraft.getWindow().getWidth() / (double)minecraft.getWindow().getHeight();
        double d1 = Math.tan(minecraft.options.fov * 0.01745329238474369 / 2.0) * (double)0.05f;
        double d2 = d1 * d0;
        Vec3 vec3 = new Vec3(this.forwards).scale(0.05f);
        Vec3 vec31 = new Vec3(this.left).scale(d2);
        Vec3 vec32 = new Vec3(this.up).scale(d1);
        return new NearPlane(vec3, vec31, vec32);
    }

    public FogType getFluidInCamera() {
        if (!this.initialized) {
            return FogType.NONE;
        }
        FluidState fluidstate = this.level.getFluidState(this.blockPosition);
        if (fluidstate.is(FluidTags.WATER) && this.position.y < (double)((float)this.blockPosition.getY() + fluidstate.getHeight(this.level, this.blockPosition))) {
            return FogType.WATER;
        }
        NearPlane camera$nearplane = this.getNearPlane();
        for (Vec3 vec3 : Arrays.asList(camera$nearplane.forward, camera$nearplane.getTopLeft(), camera$nearplane.getTopRight(), camera$nearplane.getBottomLeft(), camera$nearplane.getBottomRight())) {
            Vec3 vec31 = this.position.add(vec3);
            BlockPos blockpos = new BlockPos(vec31);
            FluidState fluidstate1 = this.level.getFluidState(blockpos);
            if (fluidstate1.is(FluidTags.LAVA)) {
                if (!(vec31.y <= (double)(fluidstate1.getHeight(this.level, blockpos) + (float)blockpos.getY()))) continue;
                return FogType.LAVA;
            }
            BlockState blockstate = this.level.getBlockState(blockpos);
            if (!blockstate.is(Blocks.POWDER_SNOW)) continue;
            return FogType.POWDER_SNOW;
        }
        return FogType.NONE;
    }

    public BlockState getBlockState() {
        return !this.initialized ? Blocks.AIR.defaultBlockState() : this.level.getBlockState(this.blockPosition);
    }

    public void setAnglesInternal(float yaw, float pitch) {
        this.yRot = yaw;
        this.xRot = pitch;
    }

    public BlockState getBlockAtCamera() {
        if (!this.initialized) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState blockstate = this.level.getBlockState(this.blockPosition);
        if (Reflector.IForgeBlockState_getStateAtViewpoint.exists()) {
            blockstate = (BlockState)Reflector.call(blockstate, Reflector.IForgeBlockState_getStateAtViewpoint, this.level, this.blockPosition, this.position);
        }
        return blockstate;
    }

    public final Vector3f getLookVector() {
        return this.forwards;
    }

    public final Vector3f getUpVector() {
        return this.up;
    }

    public final Vector3f getLeftVector() {
        return this.left;
    }

    public void reset() {
        this.level = null;
        this.entity = null;
        this.initialized = false;
    }

    public static class NearPlane {
        final Vec3 forward;
        private final Vec3 left;
        private final Vec3 up;

        NearPlane(Vec3 pForward, Vec3 pLeft, Vec3 pUp) {
            this.forward = pForward;
            this.left = pLeft;
            this.up = pUp;
        }

        public Vec3 getTopLeft() {
            return this.forward.add(this.up).add(this.left);
        }

        public Vec3 getTopRight() {
            return this.forward.add(this.up).subtract(this.left);
        }

        public Vec3 getBottomLeft() {
            return this.forward.subtract(this.up).add(this.left);
        }

        public Vec3 getBottomRight() {
            return this.forward.subtract(this.up).subtract(this.left);
        }

        public Vec3 getPointOnPlane(float p_167696_, float p_167697_) {
            return this.forward.add(this.up.scale(p_167697_)).subtract(this.left.scale(p_167696_));
        }
    }
}

