/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.Registry;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.slf4j.Logger;

public class ClientRecipeBook
extends RecipeBook {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<RecipeBookCategories, List<RecipeCollection>> collectionsByTab = ImmutableMap.of();
    private List<RecipeCollection> allCollections = ImmutableList.of();

    public void setupCollections(Iterable<Recipe<?>> p_90626_) {
        Map<RecipeBookCategories, List<List<Recipe<?>>>> map = ClientRecipeBook.categorizeAndGroupRecipes(p_90626_);
        HashMap map1 = Maps.newHashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((p_90630_, p_90631_) -> map1.put(p_90630_, (List)p_90631_.stream().map(RecipeCollection::new).peek(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)).collect(ImmutableList.toImmutableList())));
        RecipeBookCategories.AGGREGATE_CATEGORIES.forEach((p_90637_, p_90638_) -> map1.put(p_90637_, (List)p_90638_.stream().flatMap(p_167706_ -> ((List)map1.getOrDefault(p_167706_, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.collectionsByTab = ImmutableMap.copyOf((Map)map1);
        this.allCollections = builder.build();
    }

    private static Map<RecipeBookCategories, List<List<Recipe<?>>>> categorizeAndGroupRecipes(Iterable<Recipe<?>> p_90643_) {
        HashMap map = Maps.newHashMap();
        HashBasedTable table = HashBasedTable.create();
        for (Recipe<?> recipe : p_90643_) {
            if (recipe.isSpecial() || recipe.isIncomplete()) continue;
            RecipeBookCategories recipebookcategories = ClientRecipeBook.getCategory(recipe);
            String s = recipe.getGroup();
            if (s.isEmpty()) {
                map.computeIfAbsent(recipebookcategories, p_90645_ -> Lists.newArrayList()).add(ImmutableList.of(recipe));
                continue;
            }
            List list = (List)table.get((Object)recipebookcategories, (Object)s);
            if (list == null) {
                list = Lists.newArrayList();
                table.put((Object)recipebookcategories, (Object)s, (Object)list);
                map.computeIfAbsent(recipebookcategories, p_90641_ -> Lists.newArrayList()).add(list);
            }
            list.add(recipe);
        }
        return map;
    }

    private static RecipeBookCategories getCategory(Recipe<?> pRecipe) {
        RecipeType<?> recipetype = pRecipe.getType();
        if (recipetype == RecipeType.CRAFTING) {
            ItemStack itemstack = pRecipe.getResultItem();
            CreativeModeTab creativemodetab = itemstack.getItem().getItemCategory();
            if (creativemodetab == CreativeModeTab.TAB_BUILDING_BLOCKS) {
                return RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
            }
            if (creativemodetab != CreativeModeTab.TAB_TOOLS && creativemodetab != CreativeModeTab.TAB_COMBAT) {
                return creativemodetab == CreativeModeTab.TAB_REDSTONE ? RecipeBookCategories.CRAFTING_REDSTONE : RecipeBookCategories.CRAFTING_MISC;
            }
            return RecipeBookCategories.CRAFTING_EQUIPMENT;
        }
        if (recipetype == RecipeType.SMELTING) {
            if (pRecipe.getResultItem().getItem().isEdible()) {
                return RecipeBookCategories.FURNACE_FOOD;
            }
            return pRecipe.getResultItem().getItem() instanceof BlockItem ? RecipeBookCategories.FURNACE_BLOCKS : RecipeBookCategories.FURNACE_MISC;
        }
        if (recipetype == RecipeType.BLASTING) {
            return pRecipe.getResultItem().getItem() instanceof BlockItem ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
        }
        if (recipetype == RecipeType.SMOKING) {
            return RecipeBookCategories.SMOKER_FOOD;
        }
        if (recipetype == RecipeType.STONECUTTING) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (recipetype == RecipeType.CAMPFIRE_COOKING) {
            return RecipeBookCategories.CAMPFIRE;
        }
        if (recipetype == RecipeType.SMITHING) {
            return RecipeBookCategories.SMITHING;
        }
        LOGGER.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> Registry.RECIPE_TYPE.getKey(pRecipe.getType())), LogUtils.defer(pRecipe::getId));
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeCollection> getCollections() {
        return this.allCollections;
    }

    public List<RecipeCollection> getCollection(RecipeBookCategories pCategories) {
        return this.collectionsByTab.getOrDefault((Object)pCategories, Collections.emptyList());
    }
}

