/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class FullscreenResolutionProgressOption
extends ProgressOption {
    private static final double CURRENT_MODE = -1.0;

    public FullscreenResolutionProgressOption(Window pWindow) {
        this(pWindow, pWindow.findBestMonitor());
    }

    private FullscreenResolutionProgressOption(Window pWindow, @Nullable Monitor pMonitor) {
        super("options.fullscreen.resolution", -1.0, pMonitor != null ? (double)(pMonitor.getModeCount() - 1) : -1.0, 1.0f, (Options p_90724_) -> {
            if (pMonitor == null) {
                return -1.0;
            }
            Optional<VideoMode> optional = pWindow.getPreferredFullscreenVideoMode();
            return optional.map(p_167802_ -> pMonitor.getVideoModeIndex((VideoMode)p_167802_)).orElse(-1.0);
        }, (Options p_90728_, Double p_90729_) -> {
            if (pMonitor != null) {
                if (p_90729_ == -1.0) {
                    pWindow.setPreferredFullscreenVideoMode(Optional.empty());
                } else {
                    pWindow.setPreferredFullscreenVideoMode(Optional.of(pMonitor.getMode(p_90729_.intValue())));
                }
            }
        }, (Options p_90732_, ProgressOption p_90733_) -> {
            if (pMonitor == null) {
                return new TranslatableComponent("options.fullscreen.unavailable");
            }
            double d0 = p_90733_.get((Options)p_90732_);
            return d0 == -1.0 ? p_90733_.genericValueLabel(new TranslatableComponent("options.fullscreen.current")) : p_90733_.genericValueLabel(new TextComponent(pMonitor.getMode((int)d0).toString()));
        });
    }
}

