/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GlDebug;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Matrix4f;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import hu.dominikhun250.diamondclient.DiscordRPCHandler;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.AmbientOcclusionStatus;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.ClientTelemetryManager;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Game;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.PeriodicNotificationManager;
import net.minecraft.client.ResourceLoadStateTracker;
import net.minecraft.client.Screenshot;
import net.minecraft.client.Timer;
import net.minecraft.client.User;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DatapackLoadFailureScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.OutOfMemoryScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.profiling.ClientMetricsSamplersProvider;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.LegacyPackResourcesAdapter;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.PackResourcesAdapterV4;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.client.searchtree.ReloadableIdSearchTree;
import net.minecraft.client.searchtree.ReloadableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ProcessorChunkProgressListener;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FileZipper;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.ContinuousProfiler;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.io.FileUtils;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

public class Minecraft
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler {
    private static Minecraft instance;
    private static final Logger LOGGER;
    public static final boolean ON_OSX;
    private static final int MAX_TICKS_PER_UPDATE = 10;
    public static final ResourceLocation DEFAULT_FONT;
    public static final ResourceLocation UNIFORM_FONT;
    public static final ResourceLocation ALT_FONT;
    private static final ResourceLocation REGIONAL_COMPLIANCIES;
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INITIAL_TASK;
    private static final Component SOCIAL_INTERACTIONS_NOT_AVAILABLE;
    public static final String UPDATE_DRIVERS_ADVICE = "Please make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).";
    private final File resourcePackDirectory;
    private final PropertyMap profileProperties;
    private final TextureManager textureManager;
    private final DataFixer fixerUpper;
    private final VirtualScreen virtualScreen;
    private final Window window;
    private final Timer timer = new Timer(20.0f, 0L);
    private final RenderBuffers renderBuffers;
    public final LevelRenderer levelRenderer;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemRenderer itemRenderer;
    private final ItemInHandRenderer itemInHandRenderer;
    public final ParticleEngine particleEngine;
    private final SearchRegistry searchRegistry = new SearchRegistry();
    private final User user;
    public final Font font;
    public final GameRenderer gameRenderer;
    public final DebugRenderer debugRenderer;
    private final AtomicReference<StoringChunkProgressListener> progressListener = new AtomicReference();
    public final Gui gui;
    public final Options options;
    private final HotbarManager hotbarManager;
    public final MouseHandler mouseHandler;
    public final KeyboardHandler keyboardHandler;
    public final File gameDirectory;
    private final String launchedVersion;
    private final String versionType;
    private final Proxy proxy;
    private final LevelStorageSource levelSource;
    public final FrameTimer frameTimer = new FrameTimer();
    private final boolean is64bit;
    private final boolean demo;
    private final boolean allowsMultiplayer;
    private final boolean allowsChat;
    private final ReloadableResourceManager resourceManager;
    private final ClientPackSource clientPackSource;
    private final PackRepository resourcePackRepository;
    private final LanguageManager languageManager;
    private final BlockColors blockColors;
    private final ItemColors itemColors;
    private final RenderTarget mainRenderTarget;
    private final SoundManager soundManager;
    private final MusicManager musicManager;
    private final FontManager fontManager;
    private final SplashManager splashManager;
    private final GpuWarnlistManager gpuWarnlistManager;
    private final PeriodicNotificationManager regionalCompliancies = new PeriodicNotificationManager(REGIONAL_COMPLIANCIES, (Object2BooleanFunction<String>)((Object2BooleanFunction)Minecraft::countryEqualsISO3));
    private final MinecraftSessionService minecraftSessionService;
    private final UserApiService userApiService;
    private final SkinManager skinManager;
    private final ModelManager modelManager;
    private final BlockRenderDispatcher blockRenderer;
    private final PaintingTextureManager paintingTextures;
    private final MobEffectTextureManager mobEffectTextures;
    private final ToastComponent toast;
    private final Game game = new Game(this);
    private final Tutorial tutorial;
    private final PlayerSocialManager playerSocialManager;
    private final EntityModelSet entityModels;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final UUID deviceSessionId = UUID.randomUUID();
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Nullable
    public ClientLevel level;
    @Nullable
    public LocalPlayer player;
    @Nullable
    private IntegratedServer singleplayerServer;
    @Nullable
    private ServerData currentServer;
    @Nullable
    private Connection pendingConnection;
    private boolean isLocalServer;
    @Nullable
    public Entity cameraEntity;
    @Nullable
    public Entity crosshairPickEntity;
    @Nullable
    public HitResult hitResult;
    private int rightClickDelay;
    protected int missTime;
    private volatile boolean pause;
    private float pausePartialTick;
    private long lastNanoTime = Util.getNanos();
    private long lastTime;
    private int frames;
    public boolean noRender;
    @Nullable
    public Screen screen;
    @Nullable
    private Overlay overlay;
    private boolean connectedToRealms;
    private Thread gameThread;
    private volatile boolean running = true;
    @Nullable
    private Supplier<CrashReport> delayedCrash;
    private static int fps;
    public String fpsString = "";
    public boolean wireframe;
    public boolean chunkPath;
    public boolean chunkVisibility;
    public boolean smartCull = true;
    private boolean windowActive;
    private final Queue<Runnable> progressTasks = Queues.newConcurrentLinkedQueue();
    @Nullable
    private CompletableFuture<Void> pendingReload;
    @Nullable
    private TutorialToast socialInteractionsToast;
    private ProfilerFiller profiler = InactiveProfiler.INSTANCE;
    private int fpsPieRenderTicks;
    private final ContinuousProfiler fpsPieProfiler = new ContinuousProfiler(Util.timeSource, () -> this.fpsPieRenderTicks);
    @Nullable
    private ProfileResults fpsPieResults;
    private MetricsRecorder metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    private final ResourceLoadStateTracker reloadStateTracker = new ResourceLoadStateTracker();
    private String debugPath = "root";

    static {
        LOGGER = LogUtils.getLogger();
        ON_OSX = Util.getPlatform() == Util.OS.OSX;
        DEFAULT_FONT = new ResourceLocation("default");
        UNIFORM_FONT = new ResourceLocation("uniform");
        ALT_FONT = new ResourceLocation("alt");
        REGIONAL_COMPLIANCIES = new ResourceLocation("regional_compliancies.json");
        RESOURCE_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
        SOCIAL_INTERACTIONS_NOT_AVAILABLE = new TranslatableComponent("multiplayer.socialInteractions.not_available");
    }

    public Minecraft(GameConfig pGameConfig) {
        super("Client");
        int i;
        String s;
        instance = this;
        this.gameDirectory = pGameConfig.location.gameDirectory;
        File file1 = pGameConfig.location.assetDirectory;
        this.resourcePackDirectory = pGameConfig.location.resourcePackDirectory;
        this.launchedVersion = pGameConfig.game.launchVersion;
        this.versionType = pGameConfig.game.versionType;
        this.profileProperties = pGameConfig.user.profileProperties;
        this.clientPackSource = new ClientPackSource(new File(this.gameDirectory, "server-resource-packs"), pGameConfig.location.getAssetIndex());
        this.resourcePackRepository = new PackRepository(Minecraft::createClientPackAdapter, this.clientPackSource, new FolderRepositorySource(this.resourcePackDirectory, PackSource.DEFAULT));
        this.proxy = pGameConfig.user.proxy;
        YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.proxy);
        this.minecraftSessionService = yggdrasilauthenticationservice.createMinecraftSessionService();
        this.userApiService = this.createUserApiService(yggdrasilauthenticationservice, pGameConfig);
        this.user = pGameConfig.user.user;
        LOGGER.info("Setting user: {}", (Object)this.user.getName());
        LOGGER.debug("(Session ID is {})", (Object)this.user.getSessionId());
        this.demo = pGameConfig.game.demo;
        this.allowsMultiplayer = !pGameConfig.game.disableMultiplayer;
        this.allowsChat = !pGameConfig.game.disableChat;
        this.is64bit = Minecraft.checkIs64Bit();
        this.singleplayerServer = null;
        if (this.allowsMultiplayer() && pGameConfig.server.hostname != null) {
            s = pGameConfig.server.hostname;
            i = pGameConfig.server.port;
        } else {
            s = null;
            i = 0;
        }
        KeybindComponent.setKeyResolver(KeyMapping::createNameSupplier);
        this.fixerUpper = DataFixers.getDataFixer();
        this.toast = new ToastComponent(this);
        this.gameThread = Thread.currentThread();
        this.options = new Options(this, this.gameDirectory);
        this.tutorial = new Tutorial(this, this.options);
        this.hotbarManager = new HotbarManager(this.gameDirectory, this.fixerUpper);
        LOGGER.info("Backend library: {}", (Object)RenderSystem.getBackendDescription());
        DisplayData displaydata = this.options.overrideHeight > 0 && this.options.overrideWidth > 0 ? new DisplayData(this.options.overrideWidth, this.options.overrideHeight, pGameConfig.display.fullscreenWidth, pGameConfig.display.fullscreenHeight, pGameConfig.display.isFullscreen) : pGameConfig.display;
        Util.timeSource = RenderSystem.initBackendSystem();
        this.virtualScreen = new VirtualScreen(this);
        this.window = this.virtualScreen.newWindow(displaydata, this.options.fullscreenVideoModeString, this.createTitle());
        this.setWindowActive(true);
        if (!ON_OSX) {
            try {
                InputStream inputstream = this.getClientPackSource().getVanillaPack().getResource(PackType.CLIENT_RESOURCES, new ResourceLocation("minecraft", "icons/custom_icon_16x16.png"));
                InputStream inputstream1 = this.getClientPackSource().getVanillaPack().getResource(PackType.CLIENT_RESOURCES, new ResourceLocation("minecraft", "icons/custom_icon_32x32.png"));
                this.window.setIcon(inputstream, inputstream1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't set icon", (Throwable)ioexception);
            }
        }
        this.window.setFramerateLimit(this.options.framerateLimit);
        this.mouseHandler = new MouseHandler(this);
        this.mouseHandler.setup(this.window.getWindow());
        this.keyboardHandler = new KeyboardHandler(this);
        this.keyboardHandler.setup(this.window.getWindow());
        RenderSystem.initRenderer(this.options.glDebugVerbosity, false);
        this.mainRenderTarget = new MainTarget(this.window.getWidth(), this.window.getHeight());
        this.mainRenderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.mainRenderTarget.clear(ON_OSX);
        this.resourceManager = new ReloadableResourceManager(PackType.CLIENT_RESOURCES);
        this.resourcePackRepository.reload();
        this.options.loadSelectedResourcePacks(this.resourcePackRepository);
        this.languageManager = new LanguageManager(this.options.languageCode);
        this.resourceManager.registerReloadListener(this.languageManager);
        this.textureManager = new TextureManager(this.resourceManager);
        this.resourceManager.registerReloadListener(this.textureManager);
        this.skinManager = new SkinManager(this.textureManager, new File(file1, "skins"), this.minecraftSessionService);
        this.levelSource = new LevelStorageSource(this.gameDirectory.toPath().resolve("saves"), this.gameDirectory.toPath().resolve("backups"), this.fixerUpper);
        this.soundManager = new SoundManager(this.resourceManager, this.options);
        this.resourceManager.registerReloadListener(this.soundManager);
        this.splashManager = new SplashManager(this.user);
        this.resourceManager.registerReloadListener(this.splashManager);
        this.musicManager = new MusicManager(this);
        this.fontManager = new FontManager(this.textureManager);
        this.font = this.fontManager.createFont();
        this.resourceManager.registerReloadListener(this.fontManager.getReloadListener());
        this.selectMainFont(this.isEnforceUnicode());
        this.resourceManager.registerReloadListener(new GrassColorReloadListener());
        this.resourceManager.registerReloadListener(new FoliageColorReloadListener());
        this.window.setErrorSection("Startup");
        RenderSystem.setupDefaultState(0, 0, this.window.getWidth(), this.window.getHeight());
        this.window.setErrorSection("Post startup");
        this.blockColors = BlockColors.createDefault();
        this.itemColors = ItemColors.createDefault(this.blockColors);
        this.modelManager = new ModelManager(this.textureManager, this.blockColors, this.options.mipmapLevels);
        this.resourceManager.registerReloadListener(this.modelManager);
        this.entityModels = new EntityModelSet();
        this.resourceManager.registerReloadListener(this.entityModels);
        this.blockEntityRenderDispatcher = new BlockEntityRenderDispatcher(this.font, this.entityModels, this::getBlockRenderer);
        this.resourceManager.registerReloadListener(this.blockEntityRenderDispatcher);
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(this.blockEntityRenderDispatcher, this.entityModels);
        this.resourceManager.registerReloadListener(blockentitywithoutlevelrenderer);
        this.itemRenderer = new ItemRenderer(this.textureManager, this.modelManager, this.itemColors, blockentitywithoutlevelrenderer);
        this.entityRenderDispatcher = new EntityRenderDispatcher(this.textureManager, this.itemRenderer, this.font, this.options, this.entityModels);
        this.resourceManager.registerReloadListener(this.entityRenderDispatcher);
        this.itemInHandRenderer = new ItemInHandRenderer(this);
        this.resourceManager.registerReloadListener(this.itemRenderer);
        this.renderBuffers = new RenderBuffers();
        this.gameRenderer = new GameRenderer(this, this.resourceManager, this.renderBuffers);
        this.resourceManager.registerReloadListener(this.gameRenderer);
        this.playerSocialManager = new PlayerSocialManager(this, this.userApiService);
        this.blockRenderer = new BlockRenderDispatcher(this.modelManager.getBlockModelShaper(), blockentitywithoutlevelrenderer, this.blockColors);
        this.resourceManager.registerReloadListener(this.blockRenderer);
        this.levelRenderer = new LevelRenderer(this, this.renderBuffers);
        this.resourceManager.registerReloadListener(this.levelRenderer);
        this.createSearchTrees();
        this.resourceManager.registerReloadListener(this.searchRegistry);
        this.particleEngine = new ParticleEngine(this.level, this.textureManager);
        this.resourceManager.registerReloadListener(this.particleEngine);
        this.paintingTextures = new PaintingTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.paintingTextures);
        this.mobEffectTextures = new MobEffectTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.mobEffectTextures);
        this.gpuWarnlistManager = new GpuWarnlistManager();
        this.resourceManager.registerReloadListener(this.gpuWarnlistManager);
        this.resourceManager.registerReloadListener(this.regionalCompliancies);
        this.gui = new Gui(this);
        this.debugRenderer = new DebugRenderer(this);
        RenderSystem.setErrorCallback(this::onFullscreenError);
        if (this.mainRenderTarget.width == this.window.getWidth() && this.mainRenderTarget.height == this.window.getHeight()) {
            if (this.options.fullscreen && !this.window.isFullscreen()) {
                this.window.toggleFullScreen();
                this.options.fullscreen = this.window.isFullscreen();
            }
        } else {
            StringBuilder stringbuilder = new StringBuilder("Recovering from unsupported resolution (" + this.window.getWidth() + "x" + this.window.getHeight() + ").\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).");
            if (GlDebug.isDebugEnabled()) {
                stringbuilder.append("\n\nReported GL debug messages:\n").append(String.join((CharSequence)"\n", GlDebug.getLastOpenGlDebugMessages()));
            }
            this.window.setWindowed(this.mainRenderTarget.width, this.mainRenderTarget.height);
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)stringbuilder.toString(), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        }
        this.window.updateVsync(this.options.enableVsync);
        this.window.updateRawMouseInput(this.options.rawMouseInput);
        this.window.setDefaultErrorCallback();
        this.resizeDisplay();
        this.gameRenderer.preloadUiShader(this.getClientPackSource().getVanillaPack());
        LoadingOverlay.registerTextures(this);
        List<PackResources> list = this.resourcePackRepository.openAllSelected();
        this.reloadStateTracker.startReload(ResourceLoadStateTracker.ReloadReason.INITIAL, list);
        this.setOverlay(new LoadingOverlay(this, this.resourceManager.createReload(Util.backgroundExecutor(), this, RESOURCE_RELOAD_INITIAL_TASK, list), p_210745_ -> Util.ifElse(p_210745_, this::rollbackResourcePacks, () -> {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                this.selfTest();
            }
            this.reloadStateTracker.finishReload();
        }), false));
        if (s != null) {
            ConnectScreen.startConnecting(new TitleScreen(), this, new ServerAddress(s, i), null);
        } else {
            this.setScreen(new TitleScreen(true));
        }
    }

    private static boolean countryEqualsISO3(Object p_210783_) {
        try {
            return Locale.getDefault().getISO3Country().equals(p_210783_);
        }
        catch (MissingResourceException missingresourceexception) {
            return false;
        }
    }

    public void updateTitle() {
        this.window.setTitle("DiamondClient | 1.18.2");
    }

    private String createTitle() {
        DiscordRPCHandler.updatePresence("Made by: Dominikhun250", "Minecraft 1.18.2");
        StringBuilder stringbuilder = new StringBuilder("Minecraft");
        if (Minecraft.checkModStatus().shouldReportAsModified()) {
            stringbuilder.append("*");
        }
        stringbuilder.append(" ");
        stringbuilder.append(SharedConstants.getCurrentVersion().getName());
        ClientPacketListener clientpacketlistener = this.getConnection();
        if (clientpacketlistener != null && clientpacketlistener.getConnection().isConnected()) {
            stringbuilder.append(" - ");
            if (this.singleplayerServer != null && !this.singleplayerServer.isPublished()) {
                stringbuilder.append(I18n.a("title.singleplayer", new Object[0]));
            } else if (this.isConnectedToRealms()) {
                stringbuilder.append(I18n.a("title.multiplayer.realms", new Object[0]));
            } else if (!(this.singleplayerServer != null || this.currentServer != null && this.currentServer.isLan())) {
                stringbuilder.append(I18n.a("title.multiplayer.other", new Object[0]));
            } else {
                stringbuilder.append(I18n.a("title.multiplayer.lan", new Object[0]));
            }
        }
        return stringbuilder.toString();
    }

    private UserApiService createUserApiService(YggdrasilAuthenticationService p_193586_, GameConfig p_193587_) {
        try {
            return p_193586_.createUserApiService(p_193587_.user.user.getAccessToken());
        }
        catch (AuthenticationException authenticationexception) {
            LOGGER.error("Failed to verify authentication", (Throwable)authenticationexception);
            return UserApiService.OFFLINE;
        }
    }

    public static ModCheck checkModStatus() {
        return ModCheck.identify("DiamondClient", ClientBrandRetriever::getClientModName, "Client", Minecraft.class);
    }

    private void rollbackResourcePacks(Throwable p_91240_) {
        if (this.resourcePackRepository.getSelectedIds().size() > 1) {
            this.clearResourcePacksOnError(p_91240_, null);
        } else {
            Util.throwAsRuntime(p_91240_);
        }
    }

    public void clearResourcePacksOnError(Throwable pThrowable, @Nullable Component pErrorMessage) {
        LOGGER.info("Caught error loading resourcepacks, removing all selected resourcepacks", pThrowable);
        this.reloadStateTracker.startRecovery(pThrowable);
        this.resourcePackRepository.setSelected(Collections.emptyList());
        this.options.resourcePacks.clear();
        this.options.incompatibleResourcePacks.clear();
        this.options.save();
        this.reloadResourcePacks(true).thenRun(() -> {
            ToastComponent toastcomponent = this.getToasts();
            SystemToast.addOrUpdate(toastcomponent, SystemToast.SystemToastIds.PACK_LOAD_FAILURE, new TranslatableComponent("resourcePack.load_fail"), pErrorMessage);
        });
    }

    public void run() {
        DiscordRPCHandler.start();
        this.gameThread = Thread.currentThread();
        if (Runtime.getRuntime().availableProcessors() > 4) {
            this.gameThread.setPriority(10);
        }
        try {
            boolean flag = false;
            while (this.running) {
                if (this.delayedCrash != null) {
                    Minecraft.crash(this.delayedCrash.get());
                    return;
                }
                try {
                    SingleTickProfiler singletickprofiler = SingleTickProfiler.createTickProfiler("Renderer");
                    boolean flag1 = this.shouldRenderFpsPie();
                    this.profiler = this.constructProfiler(flag1, singletickprofiler);
                    this.profiler.startTick();
                    this.metricsRecorder.startTick();
                    this.runTick(!flag);
                    this.metricsRecorder.endTick();
                    this.profiler.endTick();
                    this.finishProfilers(flag1, singletickprofiler);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    if (flag) {
                        throw outofmemoryerror;
                    }
                    this.emergencySave();
                    this.setScreen(new OutOfMemoryScreen());
                    System.gc();
                    LOGGER.error(LogUtils.FATAL_MARKER, "Out of memory", (Throwable)outofmemoryerror);
                    flag = true;
                }
            }
        }
        catch (ReportedException reportedexception) {
            this.fillReport(reportedexception.getReport());
            this.emergencySave();
            LOGGER.error(LogUtils.FATAL_MARKER, "Reported exception thrown!", (Throwable)reportedexception);
            Minecraft.crash(reportedexception.getReport());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = this.fillReport(new CrashReport("Unexpected error", throwable));
            LOGGER.error(LogUtils.FATAL_MARKER, "Unreported exception thrown!", throwable);
            this.emergencySave();
            Minecraft.crash(crashreport);
        }
    }

    void selectMainFont(boolean pForced) {
        this.fontManager.setRenames((Map<ResourceLocation, ResourceLocation>)(pForced ? ImmutableMap.of((Object)DEFAULT_FONT, (Object)UNIFORM_FONT) : ImmutableMap.of()));
    }

    private void createSearchTrees() {
        ReloadableSearchTree<ItemStack> reloadablesearchtree = new ReloadableSearchTree<ItemStack>(p_210797_ -> p_210797_.getTooltipLines(null, TooltipFlag.Default.NORMAL).stream().map(p_210807_ -> ChatFormatting.stripFormatting(p_210807_.getString()).trim()).filter(p_210809_ -> !p_210809_.isEmpty()), p_91317_ -> Stream.of(Registry.ITEM.getKey(p_91317_.getItem())));
        ReloadableIdSearchTree<ItemStack> reloadableidsearchtree = new ReloadableIdSearchTree<ItemStack>(p_91121_ -> p_91121_.getTags().map(TagKey::location));
        NonNullList<ItemStack> nonnulllist = NonNullList.create();
        for (Item item : Registry.ITEM) {
            item.fillItemCategory(CreativeModeTab.TAB_SEARCH, nonnulllist);
        }
        nonnulllist.forEach(p_210707_ -> {
            reloadablesearchtree.add((ItemStack)p_210707_);
            reloadableidsearchtree.add((ItemStack)p_210707_);
        });
        ReloadableSearchTree<RecipeCollection> reloadablesearchtree1 = new ReloadableSearchTree<RecipeCollection>(p_210778_ -> p_210778_.getRecipes().stream().flatMap(p_210776_ -> p_210776_.getResultItem().getTooltipLines(null, TooltipFlag.Default.NORMAL).stream()).map(p_210803_ -> ChatFormatting.stripFormatting(p_210803_.getString()).trim()).filter(p_210805_ -> !p_210805_.isEmpty()), p_210701_ -> p_210701_.getRecipes().stream().map(p_210681_ -> Registry.ITEM.getKey(p_210681_.getResultItem().getItem())));
        this.searchRegistry.register(SearchRegistry.CREATIVE_NAMES, reloadablesearchtree);
        this.searchRegistry.register(SearchRegistry.CREATIVE_TAGS, reloadableidsearchtree);
        this.searchRegistry.register(SearchRegistry.RECIPE_COLLECTIONS, reloadablesearchtree1);
    }

    private void onFullscreenError(int p_91114_, long p_91115_) {
        this.options.enableVsync = false;
        this.options.save();
    }

    private static boolean checkIs64Bit() {
        String[] astring;
        String[] stringArray = astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
        int n = astring.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String s1 = System.getProperty(s);
            if (s1 != null && s1.contains("64")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public RenderTarget getMainRenderTarget() {
        return this.mainRenderTarget;
    }

    public String getLaunchedVersion() {
        return this.launchedVersion;
    }

    public String getVersionType() {
        return "DiamondClient";
    }

    public void delayCrash(Supplier<CrashReport> p_199936_) {
        this.delayedCrash = p_199936_;
    }

    public static void crash(CrashReport pReport) {
        File file1 = new File(Minecraft.getInstance().gameDirectory, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.realStdoutPrintln(pReport.getFriendlyReport());
        if (pReport.getSaveFile() != null) {
            Bootstrap.realStdoutPrintln("#@!@# Game crashed! Crash report saved to: #@!@# " + pReport.getSaveFile());
            System.exit(-1);
        } else if (pReport.saveToFile(file2)) {
            Bootstrap.realStdoutPrintln("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            System.exit(-1);
        } else {
            Bootstrap.realStdoutPrintln("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean isEnforceUnicode() {
        return this.options.forceUnicodeFont;
    }

    public CompletableFuture<Void> reloadResourcePacks() {
        return this.reloadResourcePacks(false);
    }

    private CompletableFuture<Void> reloadResourcePacks(boolean p_168020_) {
        if (this.pendingReload != null) {
            return this.pendingReload;
        }
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        if (!p_168020_ && this.overlay instanceof LoadingOverlay) {
            this.pendingReload = completablefuture;
            return completablefuture;
        }
        this.resourcePackRepository.reload();
        List<PackResources> list = this.resourcePackRepository.openAllSelected();
        if (!p_168020_) {
            this.reloadStateTracker.startReload(ResourceLoadStateTracker.ReloadReason.MANUAL, list);
        }
        this.setOverlay(new LoadingOverlay(this, this.resourceManager.createReload(Util.backgroundExecutor(), this, RESOURCE_RELOAD_INITIAL_TASK, list), p_210750_ -> Util.ifElse(p_210750_, this::rollbackResourcePacks, () -> {
            this.levelRenderer.allChanged();
            this.reloadStateTracker.finishReload();
            completablefuture.complete(null);
        }), true));
        return completablefuture;
    }

    private void selfTest() {
        boolean flag = false;
        BlockModelShaper blockmodelshaper = this.getBlockRenderer().getBlockModelShaper();
        BakedModel bakedmodel = blockmodelshaper.getModelManager().getMissingModel();
        for (Block block : Registry.BLOCK) {
            for (Object blockstate : block.getStateDefinition().getPossibleStates()) {
                Object bakedmodel1;
                if (((BlockBehaviour.BlockStateBase)blockstate).getRenderShape() != RenderShape.MODEL || (bakedmodel1 = blockmodelshaper.getBlockModel((BlockState)blockstate)) != bakedmodel) continue;
                LOGGER.debug("Missing model for: {}", blockstate);
                flag = true;
            }
        }
        TextureAtlasSprite textureatlassprite1 = bakedmodel.getParticleIcon();
        for (Block block1 : Registry.BLOCK) {
            for (BlockState blockstate1 : block1.getStateDefinition().getPossibleStates()) {
                TextureAtlasSprite textureatlassprite = blockmodelshaper.getParticleIcon(blockstate1);
                if (blockstate1.isAir() || textureatlassprite != textureatlassprite1) continue;
                LOGGER.debug("Missing particle icon for: {}", (Object)blockstate1);
                flag = true;
            }
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.create();
        for (Item item : Registry.ITEM) {
            nonnulllist.clear();
            item.fillItemCategory(CreativeModeTab.TAB_SEARCH, nonnulllist);
            for (ItemStack itemstack : nonnulllist) {
                String s = itemstack.getDescriptionId();
                String s1 = new TranslatableComponent(s).getString();
                if (!s1.toLowerCase(Locale.ROOT).equals(item.getDescriptionId())) continue;
                LOGGER.debug("Missing translation for: {} {} {}", new Object[]{itemstack, s, itemstack.getItem()});
            }
        }
        flag |= MenuScreens.selfTest();
        if (flag |= EntityRenderers.validateRegistrations()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public LevelStorageSource getLevelSource() {
        return this.levelSource;
    }

    private void openChatScreen(String pDefaultText) {
        ChatStatus minecraft$chatstatus = this.getChatStatus();
        if (!minecraft$chatstatus.isChatAllowed(this.isLocalServer())) {
            this.gui.setOverlayMessage(minecraft$chatstatus.getMessage(), false);
        } else {
            this.setScreen(new ChatScreen(pDefaultText));
        }
    }

    public void setScreen(@Nullable Screen pGuiScreen) {
        if (SharedConstants.IS_RUNNING_IN_IDE && Thread.currentThread() != this.gameThread) {
            LOGGER.error("setScreen called from non-game thread");
        }
        if (this.screen != null) {
            this.screen.removed();
        }
        if (pGuiScreen == null && this.level == null) {
            pGuiScreen = new TitleScreen();
        } else if (pGuiScreen == null && this.player.isDeadOrDying()) {
            if (this.player.shouldShowDeathScreen()) {
                pGuiScreen = new DeathScreen(null, this.level.getLevelData().isHardcore());
            } else {
                this.player.respawn();
            }
        }
        this.screen = pGuiScreen;
        BufferUploader.reset();
        if (pGuiScreen != null) {
            this.mouseHandler.releaseMouse();
            KeyMapping.releaseAll();
            pGuiScreen.init(this, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight());
            this.noRender = false;
        } else {
            this.soundManager.resume();
            this.mouseHandler.grabMouse();
        }
        this.updateTitle();
    }

    public void setOverlay(@Nullable Overlay pLoadingGui) {
        this.overlay = pLoadingGui;
    }

    public void destroy() {
        try {
            LOGGER.info("Stopping!");
            try {
                NarratorChatListener.INSTANCE.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.level != null) {
                    this.level.disconnect();
                }
                this.clearLevel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.screen != null) {
                this.screen.removed();
            }
            this.close();
        }
        finally {
            Util.timeSource = System::nanoTime;
            if (this.delayedCrash == null) {
                System.exit(0);
            }
        }
    }

    @Override
    public void close() {
        try {
            try {
                this.regionalCompliancies.close();
                this.modelManager.close();
                this.fontManager.close();
                this.gameRenderer.close();
                this.levelRenderer.close();
                this.soundManager.destroy();
                this.resourcePackRepository.close();
                this.particleEngine.close();
                this.mobEffectTextures.close();
                this.paintingTextures.close();
                this.textureManager.close();
                this.resourceManager.close();
                Util.shutdownExecutors();
            }
            catch (Throwable throwable) {
                LOGGER.error("Shutdown failure!", throwable);
                throw throwable;
            }
        }
        finally {
            this.virtualScreen.close();
            this.window.close();
        }
    }

    private void runTick(boolean pRenderLevel) {
        boolean flag;
        Runnable runnable;
        this.window.setErrorSection("Pre render");
        long i = Util.getNanos();
        if (this.window.shouldClose()) {
            this.stop();
        }
        if (this.pendingReload != null && !(this.overlay instanceof LoadingOverlay)) {
            CompletableFuture<Void> completablefuture = this.pendingReload;
            this.pendingReload = null;
            this.reloadResourcePacks().thenRun(() -> completablefuture.complete(null));
        }
        while ((runnable = this.progressTasks.poll()) != null) {
            runnable.run();
        }
        if (pRenderLevel) {
            int j = this.timer.advanceTime(Util.getMillis());
            this.profiler.push("scheduledExecutables");
            this.runAllTasks();
            this.profiler.pop();
            this.profiler.push("tick");
            int k = 0;
            while (k < Math.min(10, j)) {
                this.profiler.incrementCounter("clientTick");
                this.tick();
                ++k;
            }
            this.profiler.pop();
        }
        this.mouseHandler.turnPlayer();
        this.window.setErrorSection("Render");
        this.profiler.push("sound");
        this.soundManager.updateSource(this.gameRenderer.getMainCamera());
        this.profiler.pop();
        this.profiler.push("render");
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.pushPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear(16640, ON_OSX);
        this.mainRenderTarget.bindWrite(true);
        FogRenderer.setupNoFog();
        this.profiler.push("display");
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        this.profiler.pop();
        if (!this.noRender) {
            this.profiler.popPush("gameRenderer");
            this.gameRenderer.render(this.pause ? this.pausePartialTick : this.timer.partialTick, i, pRenderLevel);
            this.profiler.popPush("toasts");
            this.toast.render(new PoseStack());
            this.profiler.pop();
        }
        if (this.fpsPieResults != null) {
            this.profiler.push("fpsPie");
            this.renderFpsMeter(new PoseStack(), this.fpsPieResults);
            this.profiler.pop();
        }
        this.profiler.push("blit");
        this.mainRenderTarget.unbindWrite();
        posestack.popPose();
        posestack.pushPose();
        RenderSystem.applyModelViewMatrix();
        this.mainRenderTarget.blitToScreen(this.window.getWidth(), this.window.getHeight());
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
        this.profiler.popPush("updateDisplay");
        this.window.updateDisplay();
        int i1 = this.getFramerateLimit();
        if ((double)i1 < Option.FRAMERATE_LIMIT.getMaxValue()) {
            RenderSystem.limitDisplayFPS(i1);
        }
        this.profiler.popPush("yield");
        Thread.yield();
        this.profiler.pop();
        this.window.setErrorSection("Post render");
        ++this.frames;
        boolean bl = flag = this.hasSingleplayerServer() && (this.screen != null && this.screen.isPauseScreen() || this.overlay != null && this.overlay.isPauseScreen()) && !this.singleplayerServer.isPublished();
        if (this.pause != flag) {
            if (this.pause) {
                this.pausePartialTick = this.timer.partialTick;
            } else {
                this.timer.partialTick = this.pausePartialTick;
            }
            this.pause = flag;
        }
        long l = Util.getNanos();
        this.frameTimer.logFrameDuration(l - this.lastNanoTime);
        this.lastNanoTime = l;
        this.profiler.push("fpsUpdate");
        while (Util.getMillis() >= this.lastTime + 1000L) {
            fps = this.frames;
            this.fpsString = String.format("%d fps T: %s%s%s%s B: %d", new Object[]{fps, (double)this.options.framerateLimit == Option.FRAMERATE_LIMIT.getMaxValue() ? "inf" : Integer.valueOf(this.options.framerateLimit), this.options.enableVsync ? " vsync" : "", this.options.graphicsMode, this.options.renderClouds == CloudStatus.OFF ? "" : (this.options.renderClouds == CloudStatus.FAST ? " fast-clouds" : " fancy-clouds"), this.options.biomeBlendRadius});
            this.lastTime += 1000L;
            this.frames = 0;
        }
        this.profiler.pop();
    }

    private boolean shouldRenderFpsPie() {
        return this.options.renderDebug && this.options.renderDebugCharts && !this.options.hideGui;
    }

    private ProfilerFiller constructProfiler(boolean p_167971_, @Nullable SingleTickProfiler p_167972_) {
        ProfilerFiller profilerfiller;
        if (!p_167971_) {
            this.fpsPieProfiler.disable();
            if (!this.metricsRecorder.isRecording() && p_167972_ == null) {
                return InactiveProfiler.INSTANCE;
            }
        }
        if (p_167971_) {
            if (!this.fpsPieProfiler.isEnabled()) {
                this.fpsPieRenderTicks = 0;
                this.fpsPieProfiler.enable();
            }
            ++this.fpsPieRenderTicks;
            profilerfiller = this.fpsPieProfiler.getFiller();
        } else {
            profilerfiller = InactiveProfiler.INSTANCE;
        }
        if (this.metricsRecorder.isRecording()) {
            profilerfiller = ProfilerFiller.tee(profilerfiller, this.metricsRecorder.getProfiler());
        }
        return SingleTickProfiler.decorateFiller(profilerfiller, p_167972_);
    }

    private void finishProfilers(boolean p_91339_, @Nullable SingleTickProfiler p_91340_) {
        if (p_91340_ != null) {
            p_91340_.endTick();
        }
        this.fpsPieResults = p_91339_ ? this.fpsPieProfiler.getResults() : null;
        this.profiler = this.fpsPieProfiler.getFiller();
    }

    @Override
    public void resizeDisplay() {
        int i = this.window.calculateScale(this.options.guiScale, this.isEnforceUnicode());
        this.window.setGuiScale(i);
        if (this.screen != null) {
            this.screen.resize(this, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight());
        }
        RenderTarget rendertarget = this.getMainRenderTarget();
        rendertarget.resize(this.window.getWidth(), this.window.getHeight(), ON_OSX);
        this.gameRenderer.resize(this.window.getWidth(), this.window.getHeight());
        this.mouseHandler.setIgnoreFirstMove();
    }

    @Override
    public void cursorEntered() {
        this.mouseHandler.cursorEntered();
    }

    private int getFramerateLimit() {
        return this.level != null || this.screen == null && this.overlay == null ? this.window.getFramerateLimit() : 60;
    }

    public void emergencySave() {
        try {
            MemoryReserve.release();
            this.levelRenderer.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.isLocalServer && this.singleplayerServer != null) {
                this.singleplayerServer.halt(true);
            }
            this.clearLevel(new GenericDirtMessageScreen(new TranslatableComponent("menu.savingLevel")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    public boolean debugClientMetricsStart(Consumer<TranslatableComponent> p_167947_) {
        Consumer<Path> consumer3;
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsStop();
            return false;
        }
        Consumer<ProfileResults> consumer = p_210788_ -> {
            int i = p_210788_.getTickDuration();
            double d0 = (double)p_210788_.getNanoDuration() / (double)TimeUtil.NANOSECONDS_PER_SECOND;
            this.execute(() -> p_167947_.accept(new TranslatableComponent("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", d0), i, String.format(Locale.ROOT, "%.2f", (double)i / d0))));
        };
        Consumer<Path> consumer1 = p_210791_ -> {
            MutableComponent component = new TextComponent(p_210791_.toString()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_210743_ -> p_210743_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, p_210791_.toFile().getParent())));
            this.execute(() -> p_167947_.accept(new TranslatableComponent("debug.profiling.stop", component)));
        };
        SystemReport systemreport = Minecraft.fillSystemReport(new SystemReport(), this, this.languageManager, this.launchedVersion, this.options);
        Consumer<List> consumer2 = p_210677_ -> {
            Path path = this.archiveProfilingReport(systemreport, (List<Path>)p_210677_);
            consumer1.accept(path);
        };
        if (this.singleplayerServer == null) {
            consumer3 = p_210760_ -> consumer2.accept((List)ImmutableList.of((Object)p_210760_));
        } else {
            this.singleplayerServer.fillSystemReport(systemreport);
            CompletableFuture completablefuture = new CompletableFuture();
            CompletableFuture completablefuture1 = new CompletableFuture();
            CompletableFuture.allOf(completablefuture, completablefuture1).thenRunAsync(() -> consumer2.accept((List)ImmutableList.of((Object)((Path)completablefuture.join()), (Object)((Path)completablefuture1.join()))), Util.ioPool());
            this.singleplayerServer.startRecordingMetrics(p_210679_ -> {}, completablefuture1::complete);
            consumer3 = completablefuture::complete;
        }
        this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ClientMetricsSamplersProvider(Util.timeSource, this.levelRenderer), Util.timeSource, Util.ioPool(), new MetricsPersister("client"), p_210757_ -> {
            this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
            consumer.accept((ProfileResults)p_210757_);
        }, consumer3);
        return true;
    }

    private void debugClientMetricsStop() {
        this.metricsRecorder.end();
        if (this.singleplayerServer != null) {
            this.singleplayerServer.finishRecordingMetrics();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Path archiveProfilingReport(SystemReport p_167857_, List<Path> p_167858_) {
        s = this.isLocalServer() != false ? this.getSingleplayerServer().getWorldData().getLevelName() : this.getCurrentServer().name;
        try {
            s1 = String.format("%s-%s-%s", new Object[]{new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()), s, SharedConstants.getCurrentVersion().getId()});
            s2 = FileUtil.findAvailableName(MetricsPersister.PROFILING_RESULTS_DIR, s1, ".zip");
            path = MetricsPersister.PROFILING_RESULTS_DIR.resolve(s2);
        }
        catch (IOException ioexception1) {
            throw new UncheckedIOException(ioexception1);
        }
        try {
            filezipper = new FileZipper(path);
            try {
                filezipper.add(Paths.get("system.txt", new String[0]), p_167857_.toLineSeparatedString());
                filezipper.add(Paths.get("client", new String[0]).resolve(this.options.getFile().getName()), this.options.dumpOptionsForReport());
                p_167858_.forEach((Consumer<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(java.nio.file.Path ), (Ljava/nio/file/Path;)V)((FileZipper)filezipper));
            }
            catch (Throwable throwable1) {
                try {
                    filezipper.close();
                }
                catch (Throwable throwable) {
                    throwable1.addSuppressed(throwable);
                }
                throw throwable1;
            }
            filezipper.close();
        }
        finally {
            ** for (path1 : p_167858_)
        }
lbl-1000:
        // 1 sources

        {
            try {
                FileUtils.forceDelete((File)path1.toFile());
            }
            catch (IOException ioexception) {
                Minecraft.LOGGER.warn("Failed to delete temporary profiling result {}", (Object)path1, (Object)ioexception);
            }
            continue;
        }
lbl36:
        // 1 sources

        return path;
    }

    public void debugFpsMeterKeyPress(int pKeyCount) {
        List<ResultField> list;
        if (this.fpsPieResults != null && !(list = this.fpsPieResults.getTimes(this.debugPath)).isEmpty()) {
            ResultField resultfield = list.remove(0);
            if (pKeyCount == 0) {
                int i;
                if (!resultfield.name.isEmpty() && (i = this.debugPath.lastIndexOf(30)) >= 0) {
                    this.debugPath = this.debugPath.substring(0, i);
                }
            } else if (--pKeyCount < list.size() && !"unspecified".equals(list.get((int)pKeyCount).name)) {
                if (!this.debugPath.isEmpty()) {
                    this.debugPath = String.valueOf(this.debugPath) + "\u001e";
                }
                this.debugPath = String.valueOf(this.debugPath) + list.get((int)pKeyCount).name;
            }
        }
    }

    private void renderFpsMeter(PoseStack pPoseStack, ProfileResults pProfilerResult) {
        List<ResultField> list = pProfilerResult.getTimes(this.debugPath);
        ResultField resultfield = list.remove(0);
        RenderSystem.clear(256, ON_OSX);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix4f = Matrix4f.orthographic(0.0f, this.window.getWidth(), 0.0f, this.window.getHeight(), 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix(matrix4f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.setIdentity();
        posestack.translate(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.lineWidth(1.0f);
        RenderSystem.disableTexture();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        int i = 160;
        int j = this.window.getWidth() - 160 - 10;
        int k = this.window.getHeight() - 320;
        RenderSystem.enableBlend();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.vertex((float)j - 176.0f, (float)k - 96.0f - 16.0f, 0.0).color(200, 0, 0, 0).endVertex();
        bufferbuilder.vertex((float)j - 176.0f, k + 320, 0.0).color(200, 0, 0, 0).endVertex();
        bufferbuilder.vertex((float)j + 176.0f, k + 320, 0.0).color(200, 0, 0, 0).endVertex();
        bufferbuilder.vertex((float)j + 176.0f, (float)k - 96.0f - 16.0f, 0.0).color(200, 0, 0, 0).endVertex();
        tesselator.end();
        RenderSystem.disableBlend();
        double d0 = 0.0;
        for (ResultField resultfield1 : list) {
            int l = Mth.floor(resultfield1.percentage / 4.0) + 1;
            bufferbuilder.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            int i1 = resultfield1.getColor();
            int j1 = i1 >> 16 & 0xFF;
            int k1 = i1 >> 8 & 0xFF;
            int l1 = i1 & 0xFF;
            bufferbuilder.vertex(j, k, 0.0).color(j1, k1, l1, 255).endVertex();
            int i2 = l;
            while (i2 >= 0) {
                float f = (float)((d0 + resultfield1.percentage * (double)i2 / (double)l) * 6.2831854820251465 / 100.0);
                float f1 = Mth.sin(f) * 160.0f;
                float f2 = Mth.cos(f) * 160.0f * 0.5f;
                bufferbuilder.vertex((float)j + f1, (float)k - f2, 0.0).color(j1, k1, l1, 255).endVertex();
                --i2;
            }
            tesselator.end();
            bufferbuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            int l2 = l;
            while (l2 >= 0) {
                float f3 = (float)((d0 + resultfield1.percentage * (double)l2 / (double)l) * 6.2831854820251465 / 100.0);
                float f4 = Mth.sin(f3) * 160.0f;
                float f5 = Mth.cos(f3) * 160.0f * 0.5f;
                if (!(f5 > 0.0f)) {
                    bufferbuilder.vertex((float)j + f4, (float)k - f5, 0.0).color(j1 >> 1, k1 >> 1, l1 >> 1, 255).endVertex();
                    bufferbuilder.vertex((float)j + f4, (float)k - f5 + 10.0f, 0.0).color(j1 >> 1, k1 >> 1, l1 >> 1, 255).endVertex();
                }
                --l2;
            }
            tesselator.end();
            d0 += resultfield1.percentage;
        }
        DecimalFormat decimalformat = new DecimalFormat("##0.00");
        decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        RenderSystem.enableTexture();
        String s = ProfileResults.demanglePath(resultfield.name);
        String s1 = "";
        if (!"unspecified".equals(s)) {
            s1 = String.valueOf(s1) + "[0] ";
        }
        s1 = s.isEmpty() ? String.valueOf(s1) + "ROOT " : String.valueOf(s1) + s + " ";
        int k2 = 0xFFFFFF;
        this.font.drawShadow(pPoseStack, s1, (float)(j - 160), (float)(k - 80 - 16), 0xFFFFFF);
        s1 = String.valueOf(decimalformat.format(resultfield.globalPercentage)) + "%";
        this.font.drawShadow(pPoseStack, s1, (float)(j + 160 - this.font.width(s1)), (float)(k - 80 - 16), 0xFFFFFF);
        int j2 = 0;
        while (j2 < list.size()) {
            ResultField resultfield2 = list.get(j2);
            StringBuilder stringbuilder = new StringBuilder();
            if ("unspecified".equals(resultfield2.name)) {
                stringbuilder.append("[?] ");
            } else {
                stringbuilder.append("[").append(j2 + 1).append("] ");
            }
            String s2 = stringbuilder.append(resultfield2.name).toString();
            this.font.drawShadow(pPoseStack, s2, (float)(j - 160), (float)(k + 80 + j2 * 8 + 20), resultfield2.getColor());
            s2 = String.valueOf(decimalformat.format(resultfield2.percentage)) + "%";
            this.font.drawShadow(pPoseStack, s2, (float)(j + 160 - 50 - this.font.width(s2)), (float)(k + 80 + j2 * 8 + 20), resultfield2.getColor());
            s2 = String.valueOf(decimalformat.format(resultfield2.globalPercentage)) + "%";
            this.font.drawShadow(pPoseStack, s2, (float)(j + 160 - this.font.width(s2)), (float)(k + 80 + j2 * 8 + 20), resultfield2.getColor());
            ++j2;
        }
    }

    public void stop() {
        DiscordRPCHandler.shutdown();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void pauseGame(boolean pPauseOnly) {
        if (this.screen == null) {
            boolean flag;
            boolean bl = flag = this.hasSingleplayerServer() && !this.singleplayerServer.isPublished();
            if (flag) {
                this.setScreen(new PauseScreen(!pPauseOnly));
                this.soundManager.pause();
            } else {
                this.setScreen(new PauseScreen(true));
            }
        }
    }

    private void continueAttack(boolean pLeftClick) {
        if (!pLeftClick) {
            this.missTime = 0;
        }
        if (this.missTime <= 0 && !this.player.isUsingItem()) {
            if (pLeftClick && this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK) {
                Direction direction;
                BlockHitResult blockhitresult = (BlockHitResult)this.hitResult;
                BlockPos blockpos = blockhitresult.getBlockPos();
                if (!this.level.getBlockState(blockpos).isAir() && this.gameMode.continueDestroyBlock(blockpos, direction = blockhitresult.getDirection())) {
                    this.particleEngine.crack(blockpos, direction);
                    this.player.swing(InteractionHand.MAIN_HAND);
                }
            } else {
                this.gameMode.stopDestroyBlock();
            }
        }
    }

    private boolean startAttack() {
        if (this.missTime > 0) {
            return false;
        }
        if (this.hitResult == null) {
            LOGGER.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.gameMode.hasMissTime()) {
                this.missTime = 10;
            }
            return false;
        }
        if (this.player.isHandsBusy()) {
            return false;
        }
        boolean flag = false;
        switch (this.hitResult.getType()) {
            case ENTITY: {
                this.gameMode.attack(this.player, ((EntityHitResult)this.hitResult).getEntity());
                break;
            }
            case BLOCK: {
                BlockHitResult blockhitresult = (BlockHitResult)this.hitResult;
                BlockPos blockpos = blockhitresult.getBlockPos();
                if (!this.level.getBlockState(blockpos).isAir()) {
                    this.gameMode.startDestroyBlock(blockpos, blockhitresult.getDirection());
                    if (!this.level.getBlockState(blockpos).isAir()) break;
                    flag = true;
                    break;
                }
            }
            case MISS: {
                if (this.gameMode.hasMissTime()) {
                    this.missTime = 10;
                }
                this.player.resetAttackStrengthTicker();
            }
        }
        this.player.swing(InteractionHand.MAIN_HAND);
        return flag;
    }

    private void startUseItem() {
        if (!this.gameMode.isDestroying()) {
            this.rightClickDelay = 4;
            if (!this.player.isHandsBusy()) {
                if (this.hitResult == null) {
                    LOGGER.warn("Null returned as 'hitResult', this shouldn't happen!");
                }
                InteractionHand[] interactionHandArray = InteractionHand.values();
                int n = interactionHandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InteractionResult interactionresult2;
                    InteractionHand interactionhand = interactionHandArray[n2];
                    ItemStack itemstack = this.player.getItemInHand(interactionhand);
                    if (this.hitResult != null) {
                        switch (this.hitResult.getType()) {
                            case ENTITY: {
                                EntityHitResult entityhitresult = (EntityHitResult)this.hitResult;
                                Entity entity = entityhitresult.getEntity();
                                if (!this.level.getWorldBorder().isWithinBounds(entity.blockPosition())) {
                                    return;
                                }
                                InteractionResult interactionresult = this.gameMode.interactAt(this.player, entity, entityhitresult, interactionhand);
                                if (!interactionresult.consumesAction()) {
                                    interactionresult = this.gameMode.interact(this.player, entity, interactionhand);
                                }
                                if (!interactionresult.consumesAction()) break;
                                if (interactionresult.shouldSwing()) {
                                    this.player.swing(interactionhand);
                                }
                                return;
                            }
                            case BLOCK: {
                                BlockHitResult blockhitresult = (BlockHitResult)this.hitResult;
                                int i = itemstack.getCount();
                                InteractionResult interactionresult1 = this.gameMode.useItemOn(this.player, this.level, interactionhand, blockhitresult);
                                if (interactionresult1.consumesAction()) {
                                    if (interactionresult1.shouldSwing()) {
                                        this.player.swing(interactionhand);
                                        if (!itemstack.isEmpty() && (itemstack.getCount() != i || this.gameMode.hasInfiniteItems())) {
                                            this.gameRenderer.itemInHandRenderer.itemUsed(interactionhand);
                                        }
                                    }
                                    return;
                                }
                                if (interactionresult1 != InteractionResult.FAIL) break;
                                return;
                            }
                        }
                    }
                    if (!itemstack.isEmpty() && (interactionresult2 = this.gameMode.useItem(this.player, this.level, interactionhand)).consumesAction()) {
                        if (interactionresult2.shouldSwing()) {
                            this.player.swing(interactionhand);
                        }
                        this.gameRenderer.itemInHandRenderer.itemUsed(interactionhand);
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    public MusicManager getMusicManager() {
        return this.musicManager;
    }

    public void tick() {
        if (this.rightClickDelay > 0) {
            --this.rightClickDelay;
        }
        this.profiler.push("gui");
        this.gui.tick(this.pause);
        this.profiler.pop();
        this.gameRenderer.pick(1.0f);
        this.tutorial.onLookAt(this.level, this.hitResult);
        this.profiler.push("gameMode");
        if (!this.pause && this.level != null) {
            this.gameMode.tick();
        }
        this.profiler.popPush("textures");
        if (this.level != null) {
            this.textureManager.tick();
        }
        if (this.screen == null && this.player != null) {
            if (this.player.isDeadOrDying() && !(this.screen instanceof DeathScreen)) {
                this.setScreen(null);
            } else if (this.player.isSleeping() && this.level != null) {
                this.setScreen(new InBedChatScreen());
            }
        } else {
            Screen $$4 = this.screen;
            if ($$4 instanceof InBedChatScreen) {
                InBedChatScreen inbedchatscreen = (InBedChatScreen)$$4;
                if (!this.player.isSleeping()) {
                    inbedchatscreen.onPlayerWokeUp();
                }
            }
        }
        if (this.screen != null) {
            this.missTime = 10000;
        }
        if (this.screen != null) {
            Screen.wrapScreenError(() -> this.screen.tick(), "Ticking screen", this.screen.getClass().getCanonicalName());
        }
        if (!this.options.renderDebug) {
            this.gui.clearCache();
        }
        if (this.overlay == null && (this.screen == null || this.screen.passEvents)) {
            this.profiler.popPush("Keybindings");
            this.handleKeybinds();
            if (this.missTime > 0) {
                --this.missTime;
            }
        }
        if (this.level != null) {
            this.profiler.popPush("gameRenderer");
            if (!this.pause) {
                this.gameRenderer.tick();
            }
            this.profiler.popPush("levelRenderer");
            if (!this.pause) {
                this.levelRenderer.tick();
            }
            this.profiler.popPush("level");
            if (!this.pause) {
                if (this.level.getSkyFlashTime() > 0) {
                    this.level.setSkyFlashTime(this.level.getSkyFlashTime() - 1);
                }
                this.level.tickEntities();
            }
        } else if (this.gameRenderer.currentEffect() != null) {
            this.gameRenderer.shutdownEffect();
        }
        if (!this.pause) {
            this.musicManager.tick();
        }
        this.soundManager.tick(this.pause);
        if (this.level != null) {
            if (!this.pause) {
                if (!this.options.joinedFirstServer && this.isMultiplayerServer()) {
                    TranslatableComponent component = new TranslatableComponent("tutorial.socialInteractions.title");
                    TranslatableComponent component1 = new TranslatableComponent("tutorial.socialInteractions.description", Tutorial.key("socialInteractions"));
                    this.socialInteractionsToast = new TutorialToast(TutorialToast.Icons.SOCIAL_INTERACTIONS, component, component1, true);
                    this.tutorial.addTimedToast(this.socialInteractionsToast, 160);
                    this.options.joinedFirstServer = true;
                    this.options.save();
                }
                this.tutorial.tick();
                try {
                    this.level.tick(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception in world tick");
                    if (this.level == null) {
                        CrashReportCategory crashreportcategory = crashreport.addCategory("Affected level");
                        crashreportcategory.setDetail("Problem", "Level is null!");
                    } else {
                        this.level.fillReportDetails(crashreport);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            this.profiler.popPush("animateTick");
            if (!this.pause && this.level != null) {
                this.level.animateTick(this.player.getBlockX(), this.player.getBlockY(), this.player.getBlockZ());
            }
            this.profiler.popPush("particles");
            if (!this.pause) {
                this.particleEngine.tick();
            }
        } else if (this.pendingConnection != null) {
            this.profiler.popPush("pendingConnection");
            this.pendingConnection.tick();
        }
        this.profiler.popPush("keyboard");
        this.keyboardHandler.tick();
        this.profiler.pop();
    }

    private boolean isMultiplayerServer() {
        return !this.isLocalServer || this.singleplayerServer != null && this.singleplayerServer.isPublished();
    }

    /*
     * Unable to fully structure code
     */
    private void handleKeybinds() {
        block27: {
            while (this.options.keyTogglePerspective.consumeClick()) {
                cameratype = this.options.getCameraType();
                this.options.setCameraType(this.options.getCameraType().cycle());
                if (cameratype.isFirstPerson() != this.options.getCameraType().isFirstPerson()) {
                    this.gameRenderer.checkEntityPostEffect(this.options.getCameraType().isFirstPerson() != false ? this.getCameraEntity() : null);
                }
                this.levelRenderer.needsUpdate();
            }
            while (this.options.keySmoothCamera.consumeClick()) {
                v0 = this.options.smoothCamera = this.options.smoothCamera == false;
            }
            i = 0;
            while (i < 9) {
                flag = this.options.keySaveHotbarActivator.isDown();
                flag1 = this.options.keyLoadHotbarActivator.isDown();
                if (this.options.keyHotbarSlots[i].consumeClick()) {
                    if (this.player.isSpectator()) {
                        this.gui.getSpectatorGui().onHotbarSelected(i);
                    } else if (!this.player.isCreative() || this.screen != null || !flag1 && !flag) {
                        this.player.getInventory().selected = i;
                    } else {
                        CreativeModeInventoryScreen.handleHotbarLoadOrSave(this, i, flag1, flag);
                    }
                }
                ++i;
            }
            while (this.options.keySocialInteractions.consumeClick()) {
                if (!this.isMultiplayerServer()) {
                    this.player.displayClientMessage(Minecraft.SOCIAL_INTERACTIONS_NOT_AVAILABLE, true);
                    NarratorChatListener.INSTANCE.sayNow(Minecraft.SOCIAL_INTERACTIONS_NOT_AVAILABLE);
                    continue;
                }
                if (this.socialInteractionsToast != null) {
                    this.tutorial.removeTimedToast(this.socialInteractionsToast);
                    this.socialInteractionsToast = null;
                }
                this.setScreen(new SocialInteractionsScreen());
            }
            while (this.options.keyInventory.consumeClick()) {
                if (this.gameMode.isServerControlledInventory()) {
                    this.player.sendOpenInventory();
                    continue;
                }
                this.tutorial.onOpenInventory();
                this.setScreen(new InventoryScreen(this.player));
            }
            while (this.options.keyAdvancements.consumeClick()) {
                this.setScreen(new AdvancementsScreen(this.player.connection.getAdvancements()));
            }
            while (this.options.keySwapOffhand.consumeClick()) {
                if (this.player.isSpectator()) continue;
                this.getConnection().send(new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
            }
            while (this.options.keyDrop.consumeClick()) {
                if (this.player.isSpectator() || !this.player.drop(Screen.hasControlDown())) continue;
                this.player.swing(InteractionHand.MAIN_HAND);
            }
            while (this.options.keyChat.consumeClick()) {
                this.openChatScreen("");
            }
            if (this.screen == null && this.overlay == null && this.options.keyCommand.consumeClick()) {
                this.openChatScreen("/");
            }
            flag2 = false;
            if (!this.player.isUsingItem()) ** GOTO lbl70
            if (!this.options.keyUse.isDown()) {
                this.gameMode.releaseUsingItem(this.player);
            }
            while (this.options.keyAttack.consumeClick()) {
            }
            while (this.options.keyUse.consumeClick()) {
            }
            while (this.options.keyPickItem.consumeClick()) {
            }
            break block27;
lbl-1000:
            // 1 sources

            {
                flag2 |= this.startAttack();
lbl70:
                // 2 sources

                ** while (this.options.keyAttack.consumeClick())
            }
lbl71:
            // 2 sources

            while (this.options.keyUse.consumeClick()) {
                this.startUseItem();
            }
            while (this.options.keyPickItem.consumeClick()) {
                this.pickBlock();
            }
        }
        if (this.options.keyUse.isDown() && this.rightClickDelay == 0 && !this.player.isUsingItem()) {
            this.startUseItem();
        }
        this.continueAttack(this.screen == null && flag2 == false && this.options.keyAttack.isDown() != false && this.mouseHandler.isMouseGrabbed() != false);
    }

    public ClientTelemetryManager createTelemetryManager() {
        return new ClientTelemetryManager(this, this.userApiService, this.user.getXuid(), this.user.getClientId(), this.deviceSessionId);
    }

    public void loadLevel(String pLevelName) {
        this.doLoadLevel(pLevelName, WorldStem.DataPackConfigSupplier::loadFromWorld, WorldStem.WorldDataSupplier::loadFromWorld, false, ExperimentalDialogType.BACKUP);
    }

    public void createLevel(String pLevelName, LevelSettings pLevelSettings, RegistryAccess pDynamicRegistries, WorldGenSettings pDimensionGeneratorSettings) {
        this.doLoadLevel(pLevelName, p_210684_ -> pLevelSettings::getDataPackConfig, p_210718_ -> (p_210712_, p_210713_) -> {
            RegistryAccess.Writable registryaccess$writable = RegistryAccess.builtinCopy();
            RegistryOps dynamicops = RegistryOps.create(JsonOps.INSTANCE, pDynamicRegistries);
            RegistryOps dynamicops1 = RegistryOps.createAndLoad(JsonOps.INSTANCE, registryaccess$writable, p_210712_);
            DataResult dataresult = WorldGenSettings.CODEC.encodeStart(dynamicops, (Object)pDimensionGeneratorSettings).setLifecycle(Lifecycle.stable()).flatMap(p_210687_ -> WorldGenSettings.CODEC.parse(dynamicops1, p_210687_));
            WorldGenSettings worldgensettings = (WorldGenSettings)dataresult.getOrThrow(false, Util.prefix("Error reading worldgen settings after loading data packs: ", arg_0 -> ((Logger)LOGGER).error(arg_0)));
            return Pair.of((Object)new PrimaryLevelData(pLevelSettings, worldgensettings, dataresult.lifecycle()), (Object)registryaccess$writable.freeze());
        }, false, ExperimentalDialogType.CREATE);
    }

    /*
     * Unable to fully structure code
     */
    private void doLoadLevel(String p_205206_, Function<LevelStorageSource.LevelStorageAccess, WorldStem.DataPackConfigSupplier> p_205207_, Function<LevelStorageSource.LevelStorageAccess, WorldStem.WorldDataSupplier> p_205208_, boolean p_205209_, ExperimentalDialogType p_205210_) {
        block15: {
            block14: {
                try {
                    levelstoragesource$levelstorageaccess = this.levelSource.createAccess(p_205206_);
                }
                catch (IOException ioexception2) {
                    Minecraft.LOGGER.warn("Failed to read level {} data", (Object)p_205206_, (Object)ioexception2);
                    SystemToast.onWorldAccessFailure(this, p_205206_);
                    this.setScreen(null);
                    return;
                }
                packrepository = Minecraft.createPackRepository(levelstoragesource$levelstorageaccess);
                try {
                    worldstem = this.makeWorldStem(packrepository, p_205209_, p_205207_.apply(levelstoragesource$levelstorageaccess), p_205208_.apply(levelstoragesource$levelstorageaccess));
                }
                catch (Exception exception) {
                    Minecraft.LOGGER.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
                    this.setScreen(new DatapackLoadFailureScreen((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$53(java.lang.String java.util.function.Function java.util.function.Function net.minecraft.client.Minecraft$ExperimentalDialogType ), ()V)((Minecraft)this, (String)p_205206_, p_205207_, p_205208_, (ExperimentalDialogType)p_205210_)));
                    try {
                        packrepository.close();
                        levelstoragesource$levelstorageaccess.close();
                    }
                    catch (IOException ioexception) {
                        Minecraft.LOGGER.warn("Failed to unlock access to level {}", (Object)p_205206_, (Object)ioexception);
                    }
                    return;
                }
                worlddata = worldstem.worldData();
                flag = worlddata.worldGenSettings().isOldCustomizedWorld();
                v0 = flag1 = worlddata.worldGenSettingsLifecycle() != Lifecycle.stable();
                if (p_205210_ != ExperimentalDialogType.NONE && (flag || flag1)) break block14;
                this.clearLevel();
                this.progressListener.set(null);
                try {
                    registryaccess$frozen = worldstem.registryAccess();
                    levelstoragesource$levelstorageaccess.saveDataTag(registryaccess$frozen, worlddata);
                    worldstem.updateGlobals();
                    yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.proxy);
                    minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
                    gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
                    gameprofilecache = new GameProfileCache(gameprofilerepository, new File(this.gameDirectory, MinecraftServer.USERID_CACHE_FILE.getName()));
                    gameprofilecache.setExecutor(this);
                    SkullBlockEntity.setup(gameprofilecache, minecraftsessionservice, this);
                    GameProfileCache.setUsesAuthentication(false);
                    this.singleplayerServer = MinecraftServer.spin((Function<Thread, IntegratedServer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$54(net.minecraft.world.level.storage.LevelStorageSource$LevelStorageAccess net.minecraft.server.packs.repository.PackRepository net.minecraft.server.WorldStem com.mojang.authlib.minecraft.MinecraftSessionService com.mojang.authlib.GameProfileRepository net.minecraft.server.players.GameProfileCache java.lang.Thread ), (Ljava/lang/Thread;)Lnet/minecraft/client/server/IntegratedServer;)((Minecraft)this, (LevelStorageSource.LevelStorageAccess)levelstoragesource$levelstorageaccess, (PackRepository)packrepository, (WorldStem)worldstem, (MinecraftSessionService)minecraftsessionservice, (GameProfileRepository)gameprofilerepository, (GameProfileCache)gameprofilecache));
                    this.isLocalServer = true;
                    if (true) ** GOTO lbl53
                }
                catch (Throwable throwable) {
                    crashreport = CrashReport.forThrowable(throwable, "Starting integrated server");
                    crashreportcategory = crashreport.addCategory("Starting integrated server");
                    crashreportcategory.setDetail("Level ID", p_205206_);
                    crashreportcategory.setDetail("Level Name", worlddata.getLevelName());
                    throw new ReportedException(crashreport);
                }
                do {
                    Thread.yield();
lbl53:
                    // 2 sources

                } while (this.progressListener.get() == null);
                levelloadingscreen = new LevelLoadingScreen(this.progressListener.get());
                this.setScreen(levelloadingscreen);
                this.profiler.push("waitForServer");
                while (!this.singleplayerServer.isReady()) {
                    levelloadingscreen.tick();
                    this.runTick(false);
                    try {
                        Thread.sleep(16L);
                    }
                    catch (InterruptedException crashreport) {
                        // empty catch block
                    }
                    if (this.delayedCrash == null) continue;
                    Minecraft.crash(this.delayedCrash.get());
                    return;
                }
                this.profiler.pop();
                socketaddress = this.singleplayerServer.getConnection().startMemoryChannel();
                connection = Connection.connectToLocalServer(socketaddress);
                connection.setListener(new ClientHandshakePacketListenerImpl(connection, this, null, (Consumer<Component>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$57(net.minecraft.network.chat.Component ), (Lnet/minecraft/network/chat/Component;)V)()));
                connection.send(new ClientIntentionPacket(socketaddress.toString(), 0, ConnectionProtocol.LOGIN));
                connection.send(new ServerboundHelloPacket(this.getUser().getGameProfile()));
                this.pendingConnection = connection;
                break block15;
            }
            this.displayExperimentalConfirmationDialog(p_205210_, p_205206_, flag, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$58(java.lang.String java.util.function.Function java.util.function.Function boolean ), ()V)((Minecraft)this, (String)p_205206_, p_205207_, p_205208_, (boolean)p_205209_));
            worldstem.close();
            try {
                packrepository.close();
                levelstoragesource$levelstorageaccess.close();
            }
            catch (IOException ioexception1) {
                Minecraft.LOGGER.warn("Failed to unlock access to level {}", (Object)p_205206_, (Object)ioexception1);
            }
        }
    }

    private void displayExperimentalConfirmationDialog(ExperimentalDialogType pSelectionType, String pLevelName, boolean pCustomized, Runnable pRunnable) {
        if (pSelectionType == ExperimentalDialogType.BACKUP) {
            TranslatableComponent component1;
            TranslatableComponent component;
            if (pCustomized) {
                component = new TranslatableComponent("selectWorld.backupQuestion.customized");
                component1 = new TranslatableComponent("selectWorld.backupWarning.customized");
            } else {
                component = new TranslatableComponent("selectWorld.backupQuestion.experimental");
                component1 = new TranslatableComponent("selectWorld.backupWarning.experimental");
            }
            this.setScreen(new BackupConfirmScreen(null, (p_210729_, p_210730_) -> {
                if (p_210729_) {
                    EditWorldScreen.makeBackupAndShowToast(this.levelSource, pLevelName);
                }
                pRunnable.run();
            }, component, component1, false));
        } else {
            this.setScreen(new ConfirmScreen(p_210725_ -> {
                if (p_210725_) {
                    pRunnable.run();
                } else {
                    this.setScreen(null);
                    try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.levelSource.createAccess(pLevelName);){
                        levelstoragesource$levelstorageaccess.deleteLevel();
                    }
                    catch (IOException ioexception) {
                        SystemToast.onWorldDeleteFailure(this, pLevelName);
                        LOGGER.error("Failed to delete world {}", (Object)pLevelName, (Object)ioexception);
                    }
                }
            }, new TranslatableComponent("selectWorld.backupQuestion.experimental"), new TranslatableComponent("selectWorld.backupWarning.experimental"), CommonComponents.GUI_PROCEED, CommonComponents.GUI_CANCEL));
        }
    }

    public WorldStem makeWorldStem(LevelStorageSource.LevelStorageAccess p_205153_, boolean p_205154_) throws ExecutionException, InterruptedException {
        PackRepository packrepository = Minecraft.createPackRepository(p_205153_);
        return this.makeWorldStem(packrepository, p_205154_, WorldStem.DataPackConfigSupplier.loadFromWorld(p_205153_), WorldStem.WorldDataSupplier.loadFromWorld(p_205153_));
    }

    public WorldStem makeWorldStem(PackRepository p_205126_, boolean p_205127_, WorldStem.DataPackConfigSupplier p_205128_, WorldStem.WorldDataSupplier p_205129_) throws InterruptedException, ExecutionException {
        try {
            WorldStem.InitConfig worldstem$initconfig = new WorldStem.InitConfig(p_205126_, Commands.CommandSelection.INTEGRATED, 2, p_205127_);
            CompletableFuture<WorldStem> completablefuture = WorldStem.load(worldstem$initconfig, p_205128_, p_205129_, Util.backgroundExecutor(), this);
            this.managedBlock(completablefuture::isDone);
            return completablefuture.get();
        }
        catch (InterruptedException | ExecutionException interruptedexception) {
            p_205126_.close();
            throw interruptedexception;
        }
    }

    private static PackRepository createPackRepository(LevelStorageSource.LevelStorageAccess p_205143_) {
        return new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource(p_205143_.getLevelPath(LevelResource.DATAPACK_DIR).toFile(), PackSource.WORLD));
    }

    public void setLevel(ClientLevel pLevelClient) {
        ProgressScreen progressscreen = new ProgressScreen(true);
        progressscreen.progressStartNoAbort(new TranslatableComponent("connect.joining"));
        this.updateScreenAndTick(progressscreen);
        this.level = pLevelClient;
        this.updateLevelInEngines(pLevelClient);
        if (!this.isLocalServer) {
            YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(this.proxy);
            MinecraftSessionService minecraftsessionservice = authenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = authenticationservice.createProfileRepository();
            GameProfileCache gameprofilecache = new GameProfileCache(gameprofilerepository, new File(this.gameDirectory, MinecraftServer.USERID_CACHE_FILE.getName()));
            gameprofilecache.setExecutor(this);
            SkullBlockEntity.setup(gameprofilecache, minecraftsessionservice, this);
            GameProfileCache.setUsesAuthentication(false);
        }
    }

    public void clearLevel() {
        this.clearLevel(new ProgressScreen(true));
    }

    public void clearLevel(Screen pScreen) {
        ClientPacketListener clientpacketlistener = this.getConnection();
        if (clientpacketlistener != null) {
            this.dropAllTasks();
            clientpacketlistener.cleanup();
        }
        this.playerSocialManager.stopOnlineMode();
        IntegratedServer integratedserver = this.singleplayerServer;
        this.singleplayerServer = null;
        this.gameRenderer.resetData();
        this.gameMode = null;
        NarratorChatListener.INSTANCE.clear();
        this.updateScreenAndTick(pScreen);
        if (this.level != null) {
            if (integratedserver != null) {
                this.profiler.push("waitForServer");
                while (!integratedserver.isShutdown()) {
                    this.runTick(false);
                }
                this.profiler.pop();
            }
            this.clientPackSource.clearServerPack();
            this.gui.onDisconnected();
            this.currentServer = null;
            this.isLocalServer = false;
            this.game.onLeaveGameSession();
        }
        this.level = null;
        this.updateLevelInEngines(null);
        this.player = null;
        SkullBlockEntity.clear();
    }

    private void updateScreenAndTick(Screen pScreen) {
        this.profiler.push("forcedTick");
        this.soundManager.stop();
        this.cameraEntity = null;
        this.pendingConnection = null;
        this.setScreen(pScreen);
        this.runTick(false);
        this.profiler.pop();
    }

    public void forceSetScreen(Screen pScreen) {
        this.profiler.push("forcedTick");
        this.setScreen(pScreen);
        this.runTick(false);
        this.profiler.pop();
    }

    private void updateLevelInEngines(@Nullable ClientLevel pLevel) {
        this.levelRenderer.setLevel(pLevel);
        this.particleEngine.setLevel(pLevel);
        this.blockEntityRenderDispatcher.setLevel(pLevel);
        this.updateTitle();
    }

    public boolean allowsMultiplayer() {
        return this.allowsMultiplayer && this.userApiService.properties().flag(UserApiService.UserFlag.SERVERS_ALLOWED);
    }

    public boolean allowsRealms() {
        return this.userApiService.properties().flag(UserApiService.UserFlag.REALMS_ALLOWED);
    }

    public boolean isBlocked(UUID pPlayerUUID) {
        if (this.getChatStatus().isChatAllowed(false)) {
            return this.playerSocialManager.shouldHideMessageFrom(pPlayerUUID);
        }
        return (this.player == null || !pPlayerUUID.equals(this.player.getUUID())) && !pPlayerUUID.equals(Util.NIL_UUID);
    }

    public ChatStatus getChatStatus() {
        if (this.options.chatVisibility == ChatVisiblity.HIDDEN) {
            return ChatStatus.DISABLED_BY_OPTIONS;
        }
        if (!this.allowsChat) {
            return ChatStatus.DISABLED_BY_LAUNCHER;
        }
        return !this.userApiService.properties().flag(UserApiService.UserFlag.CHAT_ALLOWED) ? ChatStatus.DISABLED_BY_PROFILE : ChatStatus.ENABLED;
    }

    public final boolean isDemo() {
        return this.demo;
    }

    @Nullable
    public ClientPacketListener getConnection() {
        return this.player == null ? null : this.player.connection;
    }

    public static boolean renderNames() {
        return !Minecraft.instance.options.hideGui;
    }

    public static boolean useFancyGraphics() {
        return Minecraft.instance.options.graphicsMode.getId() >= GraphicsStatus.FANCY.getId();
    }

    public static boolean useShaderTransparency() {
        return !Minecraft.instance.gameRenderer.isPanoramicMode() && Minecraft.instance.options.graphicsMode.getId() >= GraphicsStatus.FABULOUS.getId();
    }

    public static boolean useAmbientOcclusion() {
        return Minecraft.instance.options.ambientOcclusion != AmbientOcclusionStatus.OFF;
    }

    private void pickBlock() {
        if (this.hitResult != null && this.hitResult.getType() != HitResult.Type.MISS) {
            ItemStack itemstack;
            boolean flag = this.player.getAbilities().instabuild;
            BlockEntity blockentity = null;
            HitResult.Type hitresult$type = this.hitResult.getType();
            if (hitresult$type == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)this.hitResult).getBlockPos();
                BlockState blockstate = this.level.getBlockState(blockpos);
                if (blockstate.isAir()) {
                    return;
                }
                Block block = blockstate.getBlock();
                itemstack = block.getCloneItemStack(this.level, blockpos, blockstate);
                if (itemstack.isEmpty()) {
                    return;
                }
                if (flag && Screen.hasControlDown() && blockstate.hasBlockEntity()) {
                    blockentity = this.level.getBlockEntity(blockpos);
                }
            } else {
                if (hitresult$type != HitResult.Type.ENTITY || !flag) {
                    return;
                }
                Entity entity = ((EntityHitResult)this.hitResult).getEntity();
                itemstack = entity.getPickResult();
                if (itemstack == null) {
                    return;
                }
            }
            if (itemstack.isEmpty()) {
                String s = "";
                if (hitresult$type == HitResult.Type.BLOCK) {
                    s = Registry.BLOCK.getKey(this.level.getBlockState(((BlockHitResult)this.hitResult).getBlockPos()).getBlock()).toString();
                } else if (hitresult$type == HitResult.Type.ENTITY) {
                    s = Registry.ENTITY_TYPE.getKey(((EntityHitResult)this.hitResult).getEntity().getType()).toString();
                }
                LOGGER.warn("Picking on: [{}] {} gave null item", (Object)hitresult$type, (Object)s);
            } else {
                Inventory inventory = this.player.getInventory();
                if (blockentity != null) {
                    this.addCustomNbtData(itemstack, blockentity);
                }
                int i = inventory.findSlotMatchingItem(itemstack);
                if (flag) {
                    inventory.setPickedItem(itemstack);
                    this.gameMode.handleCreativeModeItemAdd(this.player.getItemInHand(InteractionHand.MAIN_HAND), 36 + inventory.selected);
                } else if (i != -1) {
                    if (Inventory.isHotbarSlot(i)) {
                        inventory.selected = i;
                    } else {
                        this.gameMode.handlePickItem(i);
                    }
                }
            }
        }
    }

    private ItemStack addCustomNbtData(ItemStack pStack, BlockEntity pTe) {
        CompoundTag compoundtag = pTe.saveWithFullMetadata();
        if (pStack.getItem() instanceof PlayerHeadItem && compoundtag.contains("SkullOwner")) {
            CompoundTag compoundtag2 = compoundtag.getCompound("SkullOwner");
            pStack.getOrCreateTag().put("SkullOwner", compoundtag2);
            return pStack;
        }
        BlockItem.setBlockEntityData(pStack, pTe.getType(), compoundtag);
        CompoundTag compoundtag1 = new CompoundTag();
        ListTag listtag = new ListTag();
        listtag.add(StringTag.valueOf("\"(+NBT)\""));
        compoundtag1.put("Lore", listtag);
        pStack.addTagElement("display", compoundtag1);
        return pStack;
    }

    public CrashReport fillReport(CrashReport pTheCrash) {
        SystemReport systemreport = pTheCrash.getSystemReport();
        Minecraft.fillSystemReport(systemreport, this, this.languageManager, this.launchedVersion, this.options);
        if (this.level != null) {
            this.level.fillReportDetails(pTheCrash);
        }
        if (this.singleplayerServer != null) {
            this.singleplayerServer.fillSystemReport(systemreport);
        }
        this.reloadStateTracker.fillCrashReport(pTheCrash);
        return pTheCrash;
    }

    public static void fillReport(@Nullable Minecraft pMinecraft, @Nullable LanguageManager pLanguageManager, String pLaunchVersion, @Nullable Options pOptions, CrashReport pReport) {
        SystemReport systemreport = pReport.getSystemReport();
        Minecraft.fillSystemReport(systemreport, pMinecraft, pLanguageManager, pLaunchVersion, pOptions);
    }

    private static SystemReport fillSystemReport(SystemReport pReport, @Nullable Minecraft pMinecraft, @Nullable LanguageManager pLanguageManager, String pLaunchVersion, Options pOptions) {
        pReport.setDetail("Launched Version", () -> pLaunchVersion);
        pReport.setDetail("Backend library", RenderSystem::getBackendDescription);
        pReport.setDetail("Backend API", RenderSystem::getApiDescription);
        pReport.setDetail("Window size", () -> pMinecraft != null ? String.valueOf(minecraft.window.getWidth()) + "x" + minecraft.window.getHeight() : "<not initialized>");
        pReport.setDetail("GL Caps", RenderSystem::getCapsString);
        pReport.setDetail("GL debug messages", () -> GlDebug.isDebugEnabled() ? String.join((CharSequence)"\n", GlDebug.getLastOpenGlDebugMessages()) : "<disabled>");
        pReport.setDetail("Using VBOs", () -> "Yes");
        pReport.setDetail("Is Modded", () -> Minecraft.checkModStatus().fullDescription());
        pReport.setDetail("Type", "Client (map_client.txt)");
        if (pOptions != null) {
            String s;
            if (instance != null && (s = instance.getGpuWarnlistManager().getAllWarnings()) != null) {
                pReport.setDetail("GPU Warnings", s);
            }
            pReport.setDetail("Graphics mode", pOptions.graphicsMode.toString());
            pReport.setDetail("Resource Packs", () -> {
                StringBuilder stringbuilder = new StringBuilder();
                for (String s1 : options.resourcePacks) {
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(s1);
                    if (!options.incompatibleResourcePacks.contains(s1)) continue;
                    stringbuilder.append(" (incompatible)");
                }
                return stringbuilder.toString();
            });
        }
        if (pLanguageManager != null) {
            pReport.setDetail("Current Language", () -> pLanguageManager.getSelected().toString());
        }
        pReport.setDetail("CPU", GlUtil::getCpuInfo);
        return pReport;
    }

    public static Minecraft getInstance() {
        return instance;
    }

    public CompletableFuture<Void> delayTextureReload() {
        return this.submit(() -> this.reloadResourcePacks()).thenCompose(p_210747_ -> p_210747_);
    }

    public void setCurrentServer(@Nullable ServerData pCurrentServer) {
        this.currentServer = pCurrentServer;
    }

    @Nullable
    public ServerData getCurrentServer() {
        return this.currentServer;
    }

    public boolean isLocalServer() {
        return this.isLocalServer;
    }

    public boolean hasSingleplayerServer() {
        return this.isLocalServer && this.singleplayerServer != null;
    }

    @Nullable
    public IntegratedServer getSingleplayerServer() {
        return this.singleplayerServer;
    }

    public User getUser() {
        return this.user;
    }

    public PropertyMap getProfileProperties() {
        if (this.profileProperties.isEmpty()) {
            GameProfile gameprofile = this.getMinecraftSessionService().fillProfileProperties(this.user.getGameProfile(), false);
            this.profileProperties.putAll((Multimap)gameprofile.getProperties());
        }
        return this.profileProperties;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public TextureManager getTextureManager() {
        return this.textureManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public PackRepository getResourcePackRepository() {
        return this.resourcePackRepository;
    }

    public ClientPackSource getClientPackSource() {
        return this.clientPackSource;
    }

    public File getResourcePackDirectory() {
        return this.resourcePackDirectory;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public Function<ResourceLocation, TextureAtlasSprite> getTextureAtlas(ResourceLocation pLocation) {
        return this.modelManager.getAtlas(pLocation)::getSprite;
    }

    public boolean is64Bit() {
        return this.is64bit;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public GpuWarnlistManager getGpuWarnlistManager() {
        return this.gpuWarnlistManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public Music getSituationalMusic() {
        if (this.screen instanceof WinScreen) {
            return Musics.CREDITS;
        }
        if (this.player != null) {
            if (this.player.level.dimension() == Level.END) {
                return this.gui.getBossOverlay().shouldPlayMusic() ? Musics.END_BOSS : Musics.END;
            }
            Holder<Biome> holder = this.player.level.getBiome(this.player.blockPosition());
            Biome.BiomeCategory biome$biomecategory = Biome.getBiomeCategory(holder);
            if (!this.musicManager.isPlayingMusic(Musics.UNDER_WATER) && (!this.player.isUnderWater() || biome$biomecategory != Biome.BiomeCategory.OCEAN && biome$biomecategory != Biome.BiomeCategory.RIVER)) {
                return this.player.level.dimension() != Level.NETHER && this.player.getAbilities().instabuild && this.player.getAbilities().mayfly ? Musics.CREATIVE : holder.value().getBackgroundMusic().orElse(Musics.GAME);
            }
            return Musics.UNDER_WATER;
        }
        return Musics.MENU;
    }

    public MinecraftSessionService getMinecraftSessionService() {
        return this.minecraftSessionService;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    @Nullable
    public Entity getCameraEntity() {
        return this.cameraEntity;
    }

    public void setCameraEntity(Entity pViewingEntity) {
        this.cameraEntity = pViewingEntity;
        this.gameRenderer.checkEntityPostEffect(pViewingEntity);
    }

    public boolean shouldEntityAppearGlowing(Entity pEntity) {
        return pEntity.isCurrentlyGlowing() || this.player != null && this.player.isSpectator() && this.options.keySpectatorOutlines.isDown() && pEntity.getType() == EntityType.PLAYER;
    }

    @Override
    protected Thread getRunningThread() {
        return this.gameThread;
    }

    @Override
    protected Runnable wrapRunnable(Runnable pRunnable) {
        return pRunnable;
    }

    @Override
    protected boolean shouldRun(Runnable pRunnable) {
        return true;
    }

    public BlockRenderDispatcher getBlockRenderer() {
        return this.blockRenderer;
    }

    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return this.entityRenderDispatcher;
    }

    public BlockEntityRenderDispatcher getBlockEntityRenderDispatcher() {
        return this.blockEntityRenderDispatcher;
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public ItemInHandRenderer getItemInHandRenderer() {
        return this.itemInHandRenderer;
    }

    public <T> MutableSearchTree<T> getSearchTree(SearchRegistry.Key<T> pKey) {
        return this.searchRegistry.getTree(pKey);
    }

    public FrameTimer getFrameTimer() {
        return this.frameTimer;
    }

    public boolean isConnectedToRealms() {
        return this.connectedToRealms;
    }

    public void setConnectedToRealms(boolean pIsConnected) {
        this.connectedToRealms = pIsConnected;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public float getFrameTime() {
        return this.timer.partialTick;
    }

    public float getDeltaFrameTime() {
        return this.timer.tickDelta;
    }

    public BlockColors getBlockColors() {
        return this.blockColors;
    }

    public boolean showOnlyReducedInfo() {
        return this.player != null && this.player.isReducedDebugInfo() || this.options.reducedDebugInfo;
    }

    public ToastComponent getToasts() {
        return this.toast;
    }

    public Tutorial getTutorial() {
        return this.tutorial;
    }

    public boolean isWindowActive() {
        return this.windowActive;
    }

    public HotbarManager getHotbarManager() {
        return this.hotbarManager;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public PaintingTextureManager getPaintingTextures() {
        return this.paintingTextures;
    }

    public MobEffectTextureManager getMobEffectTextures() {
        return this.mobEffectTextures;
    }

    @Override
    public void setWindowActive(boolean pFocused) {
        this.windowActive = pFocused;
    }

    public Component grabPanoramixScreenshot(File p_167900_, int p_167901_, int p_167902_) {
        TranslatableComponent translatablecomponent;
        int i = this.window.getWidth();
        int j = this.window.getHeight();
        TextureTarget rendertarget = new TextureTarget(p_167901_, p_167902_, true, ON_OSX);
        float f = this.player.getXRot();
        float f1 = this.player.getYRot();
        float f2 = this.player.xRotO;
        float f3 = this.player.yRotO;
        this.gameRenderer.setRenderBlockOutline(false);
        try {
            this.gameRenderer.setPanoramicMode(true);
            this.levelRenderer.graphicsChanged();
            this.window.setWidth(p_167901_);
            this.window.setHeight(p_167902_);
            int k = 0;
            while (k < 6) {
                switch (k) {
                    case 0: {
                        this.player.setYRot(f1);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 1: {
                        this.player.setYRot((f1 + 90.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 2: {
                        this.player.setYRot((f1 + 180.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 3: {
                        this.player.setYRot((f1 - 90.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 4: {
                        this.player.setYRot(f1);
                        this.player.setXRot(-90.0f);
                        break;
                    }
                    default: {
                        this.player.setYRot(f1);
                        this.player.setXRot(90.0f);
                    }
                }
                this.player.yRotO = this.player.getYRot();
                this.player.xRotO = this.player.getXRot();
                rendertarget.bindWrite(true);
                this.gameRenderer.renderLevel(1.0f, 0L, new PoseStack());
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.grab(p_167900_, "panorama_" + k + ".png", rendertarget, p_210769_ -> {});
                ++k;
            }
            MutableComponent component = new TextComponent(p_167900_.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_210781_ -> p_210781_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, p_167900_.getAbsolutePath())));
            TranslatableComponent translatableComponent = new TranslatableComponent("screenshot.success", component);
            return translatableComponent;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save image", (Throwable)exception);
            translatablecomponent = new TranslatableComponent("screenshot.failure", exception.getMessage());
        }
        finally {
            this.player.setXRot(f);
            this.player.setYRot(f1);
            this.player.xRotO = f2;
            this.player.yRotO = f3;
            this.gameRenderer.setRenderBlockOutline(true);
            this.window.setWidth(i);
            this.window.setHeight(j);
            rendertarget.destroyBuffers();
            this.gameRenderer.setPanoramicMode(false);
            this.levelRenderer.graphicsChanged();
            this.getMainRenderTarget().bindWrite(true);
        }
        return translatablecomponent;
    }

    private Component grabHugeScreenshot(File p_167904_, int p_167905_, int p_167906_, int p_167907_, int p_167908_) {
        try {
            ByteBuffer bytebuffer = GlUtil.allocateMemory(p_167905_ * p_167906_ * 3);
            Screenshot screenshot = new Screenshot(p_167904_, p_167907_, p_167908_, p_167906_);
            float f = (float)p_167907_ / (float)p_167905_;
            float f1 = (float)p_167908_ / (float)p_167906_;
            float f2 = f > f1 ? f : f1;
            int i = (p_167908_ - 1) / p_167906_ * p_167906_;
            while (i >= 0) {
                int j = 0;
                while (j < p_167907_) {
                    RenderSystem.setShaderTexture(0, TextureAtlas.LOCATION_BLOCKS);
                    float f3 = (float)(p_167907_ - p_167905_) / 2.0f * 2.0f - (float)(j * 2);
                    float f4 = (float)(p_167908_ - p_167906_) / 2.0f * 2.0f - (float)(i * 2);
                    this.gameRenderer.renderZoomed(f2, f3 /= (float)p_167905_, f4 /= (float)p_167906_);
                    bytebuffer.clear();
                    RenderSystem.pixelStore(3333, 1);
                    RenderSystem.pixelStore(3317, 1);
                    RenderSystem.readPixels(0, 0, p_167905_, p_167906_, 32992, 5121, bytebuffer);
                    screenshot.addRegion(bytebuffer, j, i, p_167905_, p_167906_);
                    j += p_167905_;
                }
                screenshot.saveRow();
                i -= p_167906_;
            }
            File file1 = screenshot.close();
            GlUtil.freeMemory(bytebuffer);
            MutableComponent component = new TextComponent(file1.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_210721_ -> p_210721_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file1.getAbsolutePath())));
            return new TranslatableComponent("screenshot.success", component);
        }
        catch (Exception exception) {
            LOGGER.warn("Couldn't save screenshot", (Throwable)exception);
            return new TranslatableComponent("screenshot.failure", exception.getMessage());
        }
    }

    public ProfilerFiller getProfiler() {
        return this.profiler;
    }

    public Game getGame() {
        return this.game;
    }

    @Nullable
    public StoringChunkProgressListener getProgressListener() {
        return this.progressListener.get();
    }

    public SplashManager getSplashManager() {
        return this.splashManager;
    }

    @Nullable
    public Overlay getOverlay() {
        return this.overlay;
    }

    public PlayerSocialManager getPlayerSocialManager() {
        return this.playerSocialManager;
    }

    public boolean renderOnThread() {
        return false;
    }

    public Window getWindow() {
        return this.window;
    }

    public RenderBuffers renderBuffers() {
        return this.renderBuffers;
    }

    private static Pack createClientPackAdapter(String p_167934_, Component p_167935_, boolean p_167936_, Supplier<PackResources> p_167937_, PackMetadataSection p_167938_, Pack.Position p_167939_, PackSource p_167940_) {
        int i = p_167938_.getPackFormat();
        Supplier<PackResources> supplier = p_167937_;
        if (i <= 3) {
            supplier = Minecraft.adaptV3(p_167937_);
        }
        if (i <= 4) {
            supplier = Minecraft.adaptV4(supplier);
        }
        return new Pack(p_167934_, p_167935_, p_167936_, supplier, p_167938_, PackType.CLIENT_RESOURCES, p_167939_, p_167940_);
    }

    private static Supplier<PackResources> adaptV3(Supplier<PackResources> pResourcePackSupplier) {
        return () -> new LegacyPackResourcesAdapter((PackResources)pResourcePackSupplier.get(), LegacyPackResourcesAdapter.V3);
    }

    private static Supplier<PackResources> adaptV4(Supplier<PackResources> pResourcePackSupplier) {
        return () -> new PackResourcesAdapterV4((PackResources)pResourcePackSupplier.get());
    }

    public void updateMaxMipLevel(int pMipMapLevel) {
        this.modelManager.updateMaxMipLevel(pMipMapLevel);
    }

    public EntityModelSet getEntityModels() {
        return this.entityModels;
    }

    public boolean isTextFilteringEnabled() {
        return this.userApiService.properties().flag(UserApiService.UserFlag.PROFANITY_FILTER_ENABLED);
    }

    public void prepareForMultiplayer() {
        this.playerSocialManager.startOnlineMode();
    }

    private /* synthetic */ void lambda$53(String string, Function function, Function function2, ExperimentalDialogType experimentalDialogType) {
        this.doLoadLevel(string, function, function2, true, experimentalDialogType);
    }

    private /* synthetic */ IntegratedServer lambda$54(LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, WorldStem worldStem, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, GameProfileCache gameProfileCache, Thread p_210695_) {
        return new IntegratedServer(p_210695_, this, levelStorageAccess, packRepository, worldStem, minecraftSessionService, gameProfileRepository, gameProfileCache, p_210795_ -> {
            StoringChunkProgressListener storingchunkprogresslistener = new StoringChunkProgressListener(p_210795_ + 0);
            this.progressListener.set(storingchunkprogresslistener);
            return ProcessorChunkProgressListener.createStarted(storingchunkprogresslistener, this.progressTasks::add);
        });
    }

    private static /* synthetic */ void lambda$57(Component p_210793_) {
    }

    private /* synthetic */ void lambda$58(String string, Function function, Function function2, boolean bl) {
        this.doLoadLevel(string, function, function2, bl, ExperimentalDialogType.NONE);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ChatStatus {
        ENABLED(TextComponent.EMPTY){

            @Override
            public boolean isChatAllowed(boolean p_168045_) {
                return true;
            }
        }
        ,
        DISABLED_BY_OPTIONS(new TranslatableComponent("chat.disabled.options").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168051_) {
                return false;
            }
        }
        ,
        DISABLED_BY_LAUNCHER(new TranslatableComponent("chat.disabled.launcher").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168057_) {
                return p_168057_;
            }
        }
        ,
        DISABLED_BY_PROFILE(new TranslatableComponent("chat.disabled.profile").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168063_) {
                return p_168063_;
            }
        };

        private final Component message;

        private ChatStatus(Component p_168033_) {
            this.message = p_168033_;
        }

        public Component getMessage() {
            return this.message;
        }

        public abstract boolean isChatAllowed(boolean var1);
    }

    static enum ExperimentalDialogType {
        NONE,
        CREATE,
        BACKUP;

    }
}

