/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.AmbientOcclusionStatus;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CameraType;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.Option;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomSky;
import net.optifine.DynamicLights;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.config.FloatOptions;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import net.optifine.util.FontUtils;
import net.optifine.util.KeyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class Options {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final TypeToken<List<String>> RESOURCE_PACK_TYPE = new TypeToken<List<String>>(){};
    public static final int RENDER_DISTANCE_TINY = 2;
    public static final int RENDER_DISTANCE_SHORT = 4;
    public static final int RENDER_DISTANCE_NORMAL = 8;
    public static final int RENDER_DISTANCE_FAR = 12;
    public static final int RENDER_DISTANCE_REALLY_FAR = 16;
    public static final int RENDER_DISTANCE_EXTREME = 32;
    private static final Splitter OPTION_SPLITTER = Splitter.on((char)':').limit(2);
    private static final float DEFAULT_VOLUME = 1.0f;
    public static final String DEFAULT_SOUND_DEVICE = "";
    public boolean darkMojangStudiosBackground;
    public boolean hideLightningFlashes;
    public double sensitivity = 0.5;
    public int renderDistance;
    public int simulationDistance;
    private int serverRenderDistance = 0;
    public float entityDistanceScaling = 1.0f;
    public int framerateLimit = 120;
    public CloudStatus renderClouds = CloudStatus.FANCY;
    public GraphicsStatus graphicsMode = GraphicsStatus.FANCY;
    public AmbientOcclusionStatus ambientOcclusion = AmbientOcclusionStatus.MAX;
    public PrioritizeChunkUpdates prioritizeChunkUpdates = PrioritizeChunkUpdates.NONE;
    public List<String> resourcePacks = Lists.newArrayList();
    public List<String> incompatibleResourcePacks = Lists.newArrayList();
    public ChatVisiblity chatVisibility = ChatVisiblity.FULL;
    public double chatOpacity = 1.0;
    public double chatLineSpacing;
    public double textBackgroundOpacity = 0.5;
    @Nullable
    public String fullscreenVideoModeString;
    public boolean hideServerAddress;
    public boolean advancedItemTooltips;
    public boolean pauseOnLostFocus = true;
    private final Set<PlayerModelPart> modelParts = EnumSet.allOf(PlayerModelPart.class);
    public HumanoidArm mainHand = HumanoidArm.RIGHT;
    public int overrideWidth;
    public int overrideHeight;
    public boolean heldItemTooltips = true;
    public double chatScale = 1.0;
    public double chatWidth = 1.0;
    public double chatHeightUnfocused = 0.44366195797920227;
    public double chatHeightFocused = 1.0;
    public double chatDelay;
    public int mipmapLevels = 4;
    private final Object2FloatMap<SoundSource> sourceVolumes = (Object2FloatMap)Util.make(new Object2FloatOpenHashMap(), mapIn -> mapIn.defaultReturnValue(1.0f));
    public boolean useNativeTransport = true;
    public AttackIndicatorStatus attackIndicator = AttackIndicatorStatus.CROSSHAIR;
    public TutorialSteps tutorialStep = TutorialSteps.MOVEMENT;
    public boolean joinedFirstServer = false;
    public boolean hideBundleTutorial = false;
    public int biomeBlendRadius = 2;
    public double mouseWheelSensitivity = 1.0;
    public boolean rawMouseInput = true;
    public int glDebugVerbosity = 1;
    public boolean autoJump = true;
    public boolean autoSuggestions = true;
    public boolean chatColors = true;
    public boolean chatLinks = true;
    public boolean chatLinksPrompt = true;
    public boolean enableVsync = true;
    public boolean entityShadows = true;
    public boolean forceUnicodeFont;
    public boolean invertYMouse;
    public boolean discreteMouseScroll;
    public boolean realmsNotifications = true;
    public boolean allowServerListing = true;
    public boolean reducedDebugInfo;
    public boolean showSubtitles;
    public boolean backgroundForChatOnly = true;
    public boolean touchscreen;
    public boolean fullscreen;
    public boolean bobView = true;
    public boolean toggleCrouch;
    public boolean toggleSprint;
    public boolean skipMultiplayerWarning;
    public boolean skipRealms32bitWarning;
    public boolean hideMatchedNames = true;
    public boolean showAutosaveIndicator = true;
    public final KeyMapping keyUp = new KeyMapping("key.forward", 87, "key.categories.movement");
    public final KeyMapping keyLeft = new KeyMapping("key.left", 65, "key.categories.movement");
    public final KeyMapping keyDown = new KeyMapping("key.back", 83, "key.categories.movement");
    public final KeyMapping keyRight = new KeyMapping("key.right", 68, "key.categories.movement");
    public final KeyMapping keyJump = new KeyMapping("key.jump", 32, "key.categories.movement");
    public final KeyMapping keyShift = new ToggleKeyMapping("key.sneak", 340, "key.categories.movement", () -> this.toggleCrouch);
    public final KeyMapping keySprint = new ToggleKeyMapping("key.sprint", 341, "key.categories.movement", () -> this.toggleSprint);
    public final KeyMapping keyInventory = new KeyMapping("key.inventory", 69, "key.categories.inventory");
    public final KeyMapping keySwapOffhand = new KeyMapping("key.swapOffhand", 70, "key.categories.inventory");
    public final KeyMapping keyDrop = new KeyMapping("key.drop", 81, "key.categories.inventory");
    public final KeyMapping keyUse = new KeyMapping("key.use", InputConstants.Type.MOUSE, 1, "key.categories.gameplay");
    public final KeyMapping keyAttack = new KeyMapping("key.attack", InputConstants.Type.MOUSE, 0, "key.categories.gameplay");
    public final KeyMapping keyPickItem = new KeyMapping("key.pickItem", InputConstants.Type.MOUSE, 2, "key.categories.gameplay");
    public final KeyMapping keyChat = new KeyMapping("key.chat", 84, "key.categories.multiplayer");
    public final KeyMapping keyPlayerList = new KeyMapping("key.playerlist", 258, "key.categories.multiplayer");
    public final KeyMapping keyCommand = new KeyMapping("key.command", 47, "key.categories.multiplayer");
    public final KeyMapping keySocialInteractions = new KeyMapping("key.socialInteractions", 80, "key.categories.multiplayer");
    public final KeyMapping keyScreenshot = new KeyMapping("key.screenshot", 291, "key.categories.misc");
    public final KeyMapping keyTogglePerspective = new KeyMapping("key.togglePerspective", 294, "key.categories.misc");
    public final KeyMapping keySmoothCamera = new KeyMapping("key.smoothCamera", InputConstants.bv.getValue(), "key.categories.misc");
    public final KeyMapping keyFullscreen = new KeyMapping("key.fullscreen", 300, "key.categories.misc");
    public final KeyMapping keySpectatorOutlines = new KeyMapping("key.spectatorOutlines", InputConstants.bv.getValue(), "key.categories.misc");
    public final KeyMapping keyAdvancements = new KeyMapping("key.advancements", 76, "key.categories.misc");
    public final KeyMapping[] keyHotbarSlots = new KeyMapping[]{new KeyMapping("key.hotbar.1", 49, "key.categories.inventory"), new KeyMapping("key.hotbar.2", 50, "key.categories.inventory"), new KeyMapping("key.hotbar.3", 51, "key.categories.inventory"), new KeyMapping("key.hotbar.4", 52, "key.categories.inventory"), new KeyMapping("key.hotbar.5", 53, "key.categories.inventory"), new KeyMapping("key.hotbar.6", 54, "key.categories.inventory"), new KeyMapping("key.hotbar.7", 55, "key.categories.inventory"), new KeyMapping("key.hotbar.8", 56, "key.categories.inventory"), new KeyMapping("key.hotbar.9", 57, "key.categories.inventory")};
    public final KeyMapping keySaveHotbarActivator = new KeyMapping("key.saveToolbarActivator", 67, "key.categories.creative");
    public final KeyMapping keyLoadHotbarActivator = new KeyMapping("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyMapping[] keyMappings = (KeyMapping[])ArrayUtils.addAll((Object[])new KeyMapping[]{this.keyAttack, this.keyUse, this.keyUp, this.keyLeft, this.keyDown, this.keyRight, this.keyJump, this.keyShift, this.keySprint, this.keyDrop, this.keyInventory, this.keyChat, this.keyPlayerList, this.keyPickItem, this.keyCommand, this.keySocialInteractions, this.keyScreenshot, this.keyTogglePerspective, this.keySmoothCamera, this.keyFullscreen, this.keySpectatorOutlines, this.keySwapOffhand, this.keySaveHotbarActivator, this.keyLoadHotbarActivator, this.keyAdvancements}, (Object[])this.keyHotbarSlots);
    protected Minecraft minecraft;
    private final File optionsFile;
    public Difficulty difficulty = Difficulty.NORMAL;
    public boolean hideGui;
    private CameraType cameraType = CameraType.FIRST_PERSON;
    public boolean renderDebug;
    public boolean renderDebugCharts;
    public boolean renderFpsChart;
    public String lastMpIp = "";
    public boolean smoothCamera;
    public double fov = 70.0;
    public float screenEffectScale = 1.0f;
    public float fovEffectScale = 1.0f;
    public double gamma;
    public int guiScale;
    public ParticleStatus particles = ParticleStatus.ALL;
    public NarratorStatus narratorStatus = NarratorStatus.OFF;
    public String languageCode = "en_us";
    public String soundDevice = "";
    public boolean syncWrites;
    public int ofFogType = 1;
    public float ofFogStart = 0.8f;
    public int ofMipmapType = 0;
    public boolean ofOcclusionFancy = false;
    public boolean ofSmoothFps = false;
    public boolean ofSmoothWorld = Config.isSingleProcessor();
    public boolean ofLazyChunkLoading = Config.isSingleProcessor();
    public boolean ofRenderRegions = false;
    public boolean ofSmartAnimations = false;
    public double ofAoLevel = 1.0;
    public int ofAaLevel = 0;
    public int ofAfLevel = 1;
    public int ofClouds = 0;
    public double ofCloudsHeight = 0.0;
    public int ofTrees = 0;
    public int ofRain = 0;
    public int ofBetterGrass = 3;
    public int ofAutoSaveTicks = 4000;
    public boolean ofLagometer = false;
    public boolean ofProfiler = false;
    public boolean ofShowFps = false;
    public boolean ofWeather = true;
    public boolean ofSky = true;
    public boolean ofStars = true;
    public boolean ofSunMoon = true;
    public int ofVignette = 0;
    public int ofChunkUpdates = 1;
    public boolean ofChunkUpdatesDynamic = false;
    public int ofTime = 0;
    public boolean ofBetterSnow = false;
    public boolean ofSwampColors = true;
    public boolean ofRandomEntities = true;
    public boolean ofCustomFonts = true;
    public boolean ofCustomColors = true;
    public boolean ofCustomSky = true;
    public boolean ofShowCapes = true;
    public int ofConnectedTextures = 2;
    public boolean ofCustomItems = true;
    public boolean ofNaturalTextures = false;
    public boolean ofEmissiveTextures = true;
    public boolean ofFastMath = false;
    public boolean ofFastRender = false;
    public boolean ofDynamicFov = true;
    public boolean ofAlternateBlocks = true;
    public int ofDynamicLights = 3;
    public boolean ofCustomEntityModels = true;
    public boolean ofCustomGuis = true;
    public boolean ofShowGlErrors = true;
    public int ofScreenshotSize = 1;
    public int ofChatBackground = 0;
    public boolean ofChatShadow = true;
    public int ofTelemetry = 0;
    public int ofAnimatedWater = 0;
    public int ofAnimatedLava = 0;
    public boolean ofAnimatedFire = true;
    public boolean ofAnimatedPortal = true;
    public boolean ofAnimatedRedstone = true;
    public boolean ofAnimatedExplosion = true;
    public boolean ofAnimatedFlame = true;
    public boolean ofAnimatedSmoke = true;
    public boolean ofVoidParticles = true;
    public boolean ofWaterParticles = true;
    public boolean ofRainSplash = true;
    public boolean ofPortalParticles = true;
    public boolean ofPotionParticles = true;
    public boolean ofFireworkParticles = true;
    public boolean ofDrippingWaterLava = true;
    public boolean ofAnimatedTerrain = true;
    public boolean ofAnimatedTextures = true;
    public static final int DEFAULT = 0;
    public static final int FAST = 1;
    public static final int FANCY = 2;
    public static final int OFF = 3;
    public static final int SMART = 4;
    public static final int COMPACT = 5;
    public static final int ANIM_ON = 0;
    public static final int ANIM_GENERATED = 1;
    public static final int ANIM_OFF = 2;
    public static final String DEFAULT_STR = "Default";
    public static final double CHAT_WIDTH_SCALE = 4.0571431;
    private static final int[] OF_TREES_VALUES;
    private static final int[] OF_DYNAMIC_LIGHTS;
    private static final String[] KEYS_DYNAMIC_LIGHTS;
    public static final int TELEM_ON = 0;
    public static final int TELEM_ANON = 1;
    public static final int TELEM_OFF = 2;
    private static final int[] OF_TELEMETRY;
    private static final String[] KEYS_TELEMETRY;
    public KeyMapping ofKeyBindZoom;
    private File optionsFileOF;
    private boolean loadOptions;
    private boolean saveOptions;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 2;
        OF_TREES_VALUES = nArray;
        OF_DYNAMIC_LIGHTS = new int[]{3, 1, 2};
        KEYS_DYNAMIC_LIGHTS = new String[]{"options.off", "options.graphics.fast", "options.graphics.fancy"};
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        OF_TELEMETRY = nArray2;
        KEYS_TELEMETRY = new String[]{"options.on", "of.general.anonymous", "options.off"};
    }

    public Options(Minecraft pMinecraft, File pGameDirectory) {
        this.setForgeKeybindProperties();
        this.minecraft = pMinecraft;
        this.optionsFile = new File(pGameDirectory, "options.txt");
        if (pMinecraft.is64Bit() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            Option.RENDER_DISTANCE.setMaxValue(32.0f);
            Option.SIMULATION_DISTANCE.setMaxValue(32.0f);
            long i = 1000000L;
            if (Runtime.getRuntime().maxMemory() >= 1500L * i) {
                Option.RENDER_DISTANCE.setMaxValue(48.0f);
            }
            if (Runtime.getRuntime().maxMemory() >= 2500L * i) {
                Option.RENDER_DISTANCE.setMaxValue(64.0f);
            }
        } else {
            Option.RENDER_DISTANCE.setMaxValue(16.0f);
            Option.SIMULATION_DISTANCE.setMaxValue(16.0f);
        }
        this.renderDistance = pMinecraft.is64Bit() ? 12 : 8;
        this.simulationDistance = pMinecraft.is64Bit() ? 12 : 8;
        this.gamma = 0.5;
        this.syncWrites = Util.getPlatform() == Util.OS.WINDOWS;
        this.optionsFileOF = new File(pGameDirectory, "optionsof.txt");
        this.framerateLimit = (int)Option.FRAMERATE_LIMIT.getMaxValue();
        this.ofKeyBindZoom = new KeyMapping("of.key.zoom", 67, "key.categories.misc");
        this.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])this.keyMappings, (Object)this.ofKeyBindZoom);
        KeyUtils.fixKeyConflicts(this.keyMappings, new KeyMapping[]{this.ofKeyBindZoom});
        this.renderDistance = 8;
        this.load();
        Config.initGameSettings(this);
    }

    public float getBackgroundOpacity(float pOpacity) {
        return this.backgroundForChatOnly ? pOpacity : (float)this.textBackgroundOpacity;
    }

    public int getBackgroundColor(float pOpacity) {
        return (int)(this.getBackgroundOpacity(pOpacity) * 255.0f) << 24 & 0xFF000000;
    }

    public int getBackgroundColor(int pOpacity) {
        return this.backgroundForChatOnly ? pOpacity : (int)(this.textBackgroundOpacity * 255.0) << 24 & 0xFF000000;
    }

    public void setKey(KeyMapping pKeyBinding, InputConstants.Key pInput) {
        pKeyBinding.setKey(pInput);
        this.save();
    }

    private void processOptions(FieldAccess p_168428_) {
        this.autoJump = p_168428_.process("autoJump", this.autoJump);
        this.autoSuggestions = p_168428_.process("autoSuggestions", this.autoSuggestions);
        this.chatColors = p_168428_.process("chatColors", this.chatColors);
        this.chatLinks = p_168428_.process("chatLinks", this.chatLinks);
        this.chatLinksPrompt = p_168428_.process("chatLinksPrompt", this.chatLinksPrompt);
        this.enableVsync = p_168428_.process("enableVsync", this.enableVsync);
        if (this.loadOptions) {
            if (this.enableVsync) {
                this.framerateLimit = (int)Option.FRAMERATE_LIMIT.getMaxValue();
            }
            this.updateVSync();
        }
        this.entityShadows = p_168428_.process("entityShadows", this.entityShadows);
        this.forceUnicodeFont = p_168428_.process("forceUnicodeFont", this.forceUnicodeFont);
        this.discreteMouseScroll = p_168428_.process("discrete_mouse_scroll", this.discreteMouseScroll);
        this.invertYMouse = p_168428_.process("invertYMouse", this.invertYMouse);
        this.realmsNotifications = p_168428_.process("realmsNotifications", this.realmsNotifications);
        this.reducedDebugInfo = p_168428_.process("reducedDebugInfo", this.reducedDebugInfo);
        this.showSubtitles = p_168428_.process("showSubtitles", this.showSubtitles);
        this.touchscreen = p_168428_.process("touchscreen", this.touchscreen);
        this.fullscreen = p_168428_.process("fullscreen", this.fullscreen);
        this.bobView = p_168428_.process("bobView", this.bobView);
        this.toggleCrouch = p_168428_.process("toggleCrouch", this.toggleCrouch);
        this.toggleSprint = p_168428_.process("toggleSprint", this.toggleSprint);
        this.darkMojangStudiosBackground = p_168428_.process("darkMojangStudiosBackground", this.darkMojangStudiosBackground);
        this.hideLightningFlashes = p_168428_.process("hideLightningFlashes", this.hideLightningFlashes);
        this.sensitivity = p_168428_.process("mouseSensitivity", this.sensitivity);
        this.fov = p_168428_.process("fov", (this.fov - 70.0) / 40.0) * 40.0 + 70.0;
        this.screenEffectScale = p_168428_.process("screenEffectScale", this.screenEffectScale);
        this.fovEffectScale = p_168428_.process("fovEffectScale", this.fovEffectScale);
        this.gamma = p_168428_.process("gamma", this.gamma);
        this.renderDistance = (int)Mth.clamp((double)p_168428_.process("renderDistance", this.renderDistance), Option.RENDER_DISTANCE.getMinValue(), Option.RENDER_DISTANCE.getMaxValue());
        this.simulationDistance = (int)Mth.clamp((double)p_168428_.process("simulationDistance", this.simulationDistance), Option.SIMULATION_DISTANCE.getMinValue(), Option.SIMULATION_DISTANCE.getMaxValue());
        this.entityDistanceScaling = p_168428_.process("entityDistanceScaling", this.entityDistanceScaling);
        this.guiScale = p_168428_.process("guiScale", this.guiScale);
        this.particles = p_168428_.process("particles", this.particles, ParticleStatus::byId, ParticleStatus::getId);
        this.framerateLimit = p_168428_.process("maxFps", this.framerateLimit);
        if (this.loadOptions) {
            if (this.enableVsync) {
                this.framerateLimit = (int)Option.FRAMERATE_LIMIT.getMaxValue();
            }
            if (this.framerateLimit <= 0) {
                this.framerateLimit = (int)Option.FRAMERATE_LIMIT.getMaxValue();
            }
        }
        this.difficulty = p_168428_.process("difficulty", this.difficulty, Difficulty::byId, Difficulty::getId);
        this.graphicsMode = p_168428_.process("graphicsMode", this.graphicsMode, GraphicsStatus::byId, GraphicsStatus::getId);
        if (this.loadOptions) {
            this.updateRenderClouds();
        }
        this.ambientOcclusion = p_168428_.process("ao", this.ambientOcclusion, Options::readAmbientOcclusion, aoIn -> Integer.toString(aoIn.getId()));
        this.prioritizeChunkUpdates = p_168428_.process("prioritizeChunkUpdates", this.prioritizeChunkUpdates, PrioritizeChunkUpdates::byId, PrioritizeChunkUpdates::getId);
        this.biomeBlendRadius = p_168428_.process("biomeBlendRadius", this.biomeBlendRadius);
        this.renderClouds = p_168428_.process("renderClouds", this.renderClouds, Options::readCloudStatus, Options::writeCloudStatus);
        this.resourcePacks = p_168428_.process("resourcePacks", this.resourcePacks, Options::readPackList, arg_0 -> ((Gson)GSON).toJson(arg_0));
        this.incompatibleResourcePacks = p_168428_.process("incompatibleResourcePacks", this.incompatibleResourcePacks, Options::readPackList, arg_0 -> ((Gson)GSON).toJson(arg_0));
        this.lastMpIp = p_168428_.process("lastServer", this.lastMpIp);
        this.languageCode = p_168428_.process("lang", this.languageCode);
        this.soundDevice = p_168428_.process("soundDevice", this.soundDevice);
        this.chatVisibility = p_168428_.process("chatVisibility", this.chatVisibility, ChatVisiblity::byId, ChatVisiblity::getId);
        this.chatOpacity = p_168428_.process("chatOpacity", this.chatOpacity);
        this.chatLineSpacing = p_168428_.process("chatLineSpacing", this.chatLineSpacing);
        this.textBackgroundOpacity = p_168428_.process("textBackgroundOpacity", this.textBackgroundOpacity);
        this.backgroundForChatOnly = p_168428_.process("backgroundForChatOnly", this.backgroundForChatOnly);
        this.hideServerAddress = p_168428_.process("hideServerAddress", this.hideServerAddress);
        this.advancedItemTooltips = p_168428_.process("advancedItemTooltips", this.advancedItemTooltips);
        this.pauseOnLostFocus = p_168428_.process("pauseOnLostFocus", this.pauseOnLostFocus);
        this.overrideWidth = p_168428_.process("overrideWidth", this.overrideWidth);
        this.overrideHeight = p_168428_.process("overrideHeight", this.overrideHeight);
        this.heldItemTooltips = p_168428_.process("heldItemTooltips", this.heldItemTooltips);
        this.chatHeightFocused = p_168428_.process("chatHeightFocused", this.chatHeightFocused);
        this.chatDelay = p_168428_.process("chatDelay", this.chatDelay);
        this.chatHeightUnfocused = p_168428_.process("chatHeightUnfocused", this.chatHeightUnfocused);
        this.chatScale = p_168428_.process("chatScale", this.chatScale);
        this.chatWidth = p_168428_.process("chatWidth", this.chatWidth);
        this.mipmapLevels = p_168428_.process("mipmapLevels", this.mipmapLevels);
        this.useNativeTransport = p_168428_.process("useNativeTransport", this.useNativeTransport);
        this.mainHand = p_168428_.process("mainHand", this.mainHand, Options::readMainHand, Options::writeMainHand);
        this.attackIndicator = p_168428_.process("attackIndicator", this.attackIndicator, AttackIndicatorStatus::byId, AttackIndicatorStatus::getId);
        this.narratorStatus = p_168428_.process("narrator", this.narratorStatus, NarratorStatus::byId, NarratorStatus::getId);
        this.tutorialStep = p_168428_.process("tutorialStep", this.tutorialStep, TutorialSteps::getByName, TutorialSteps::getName);
        this.mouseWheelSensitivity = p_168428_.process("mouseWheelSensitivity", this.mouseWheelSensitivity);
        this.rawMouseInput = p_168428_.process("rawMouseInput", this.rawMouseInput);
        this.glDebugVerbosity = p_168428_.process("glDebugVerbosity", this.glDebugVerbosity);
        this.skipMultiplayerWarning = p_168428_.process("skipMultiplayerWarning", this.skipMultiplayerWarning);
        this.skipRealms32bitWarning = p_168428_.process("skipRealms32bitWarning", this.skipRealms32bitWarning);
        this.hideMatchedNames = p_168428_.process("hideMatchedNames", this.hideMatchedNames);
        this.joinedFirstServer = p_168428_.process("joinedFirstServer", this.joinedFirstServer);
        this.hideBundleTutorial = p_168428_.process("hideBundleTutorial", this.hideBundleTutorial);
        this.syncWrites = p_168428_.process("syncChunkWrites", this.syncWrites);
        this.showAutosaveIndicator = p_168428_.process("showAutosaveIndicator", this.showAutosaveIndicator);
        this.allowServerListing = p_168428_.process("allowServerListing", this.allowServerListing);
        Object[] objectArray = this.keyMappings;
        int n = this.keyMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String s1;
            KeyMapping keymapping = objectArray[n2];
            String s = keymapping.saveString();
            if (Reflector.ForgeKeyBinding_getKeyModifier.exists()) {
                Object object = Reflector.call(keymapping, Reflector.ForgeKeyBinding_getKeyModifier, new Object[0]);
                Object object1 = Reflector.getFieldValue(Reflector.KeyModifier_NONE);
                s = String.valueOf(keymapping.saveString()) + (object != object1 ? ":" + object : DEFAULT_SOUND_DEVICE);
            }
            if (!s.equals(s1 = p_168428_.process("key_" + keymapping.getName(), s))) {
                if (Reflector.KeyModifier_valueFromString.exists()) {
                    if (s1.indexOf(58) != -1) {
                        String[] astring = s1.split(":");
                        Object object2 = Reflector.call(Reflector.KeyModifier_valueFromString, astring[1]);
                        Reflector.call(keymapping, Reflector.ForgeKeyBinding_setKeyModifierAndCode, object2, InputConstants.getKey(astring[0]));
                    } else {
                        Object object3 = Reflector.getFieldValue(Reflector.KeyModifier_NONE);
                        Reflector.call(keymapping, Reflector.ForgeKeyBinding_setKeyModifierAndCode, object3, InputConstants.getKey(s1));
                    }
                } else {
                    keymapping.setKey(InputConstants.getKey(s1));
                }
            }
            ++n2;
        }
        objectArray = SoundSource.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            KeyMapping soundsource = objectArray[n2];
            this.sourceVolumes.computeFloat((Object)soundsource, (sourceIn, levelIn) -> Float.valueOf(p_168428_.process("soundCategory_" + sourceIn.getName(), levelIn != null ? levelIn.floatValue() : 1.0f)));
            ++n2;
        }
        objectArray = PlayerModelPart.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            KeyMapping playermodelpart = objectArray[n2];
            boolean flag = this.modelParts.contains(playermodelpart);
            boolean flag1 = p_168428_.process("modelPart_" + ((PlayerModelPart)((Object)playermodelpart)).getId(), flag);
            if (flag1 != flag) {
                this.setModelPart((PlayerModelPart)((Object)playermodelpart), flag1);
            }
            ++n2;
        }
    }

    public void load() {
        this.loadOptions = true;
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            this.sourceVolumes.clear();
            CompoundTag compoundtag = new CompoundTag();
            try (BufferedReader bufferedreader = Files.newReader((File)this.optionsFile, (Charset)Charsets.UTF_8);){
                bufferedreader.lines().forEach(lineIn -> {
                    try {
                        Iterator iterator = OPTION_SPLITTER.split((CharSequence)lineIn).iterator();
                        compoundtag.putString((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception11) {
                        LOGGER.warn("Skipping bad option: {}", lineIn);
                    }
                });
            }
            CompoundTag compoundtag1 = this.dataFix(compoundtag);
            if (!compoundtag1.contains("graphicsMode") && compoundtag1.contains("fancyGraphics")) {
                this.graphicsMode = Options.isTrue(compoundtag1.getString("fancyGraphics")) ? GraphicsStatus.FANCY : GraphicsStatus.FAST;
            }
            this.processOptions(new FieldAccess(){

                @Nullable
                private String getValueOrNull(String p_168459_) {
                    return compoundtag1.contains(p_168459_) ? compoundtag1.getString(p_168459_) : null;
                }

                @Override
                public int process(String p_168467_, int p_168468_) {
                    String s = this.getValueOrNull(p_168467_);
                    if (s != null) {
                        try {
                            return Integer.parseInt(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            LOGGER.warn("Invalid integer value for option {} = {}", new Object[]{p_168467_, s, numberformatexception});
                        }
                    }
                    return p_168468_;
                }

                @Override
                public boolean process(String p_168483_, boolean p_168484_) {
                    String s = this.getValueOrNull(p_168483_);
                    return s != null ? Options.isTrue(s) : p_168484_;
                }

                @Override
                public String process(String p_168480_, String p_168481_) {
                    return (String)MoreObjects.firstNonNull((Object)this.getValueOrNull(p_168480_), (Object)p_168481_);
                }

                @Override
                public double process(String p_168461_, double p_168462_) {
                    String s = this.getValueOrNull(p_168461_);
                    if (s != null) {
                        if (Options.isTrue(s)) {
                            return 1.0;
                        }
                        if (Options.isFalse(s)) {
                            return 0.0;
                        }
                        try {
                            return Double.parseDouble(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            LOGGER.warn("Invalid floating point value for option {} = {}", new Object[]{p_168461_, s, numberformatexception});
                        }
                    }
                    return p_168462_;
                }

                @Override
                public float process(String p_168464_, float p_168465_) {
                    String s = this.getValueOrNull(p_168464_);
                    if (s != null) {
                        if (Options.isTrue(s)) {
                            return 1.0f;
                        }
                        if (Options.isFalse(s)) {
                            return 0.0f;
                        }
                        try {
                            return Float.parseFloat(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            LOGGER.warn("Invalid floating point value for option {} = {}", new Object[]{p_168464_, s, numberformatexception});
                        }
                    }
                    return p_168465_;
                }

                @Override
                public <T> T process(String p_168470_, T p_168471_, Function<String, T> p_168472_, Function<T, String> p_168473_) {
                    String s = this.getValueOrNull(p_168470_);
                    return s == null ? p_168471_ : p_168472_.apply(s);
                }

                @Override
                public <T> T process(String p_168475_, T p_168476_, IntFunction<T> p_168477_, ToIntFunction<T> p_168478_) {
                    String s = this.getValueOrNull(p_168475_);
                    if (s != null) {
                        try {
                            return p_168477_.apply(Integer.parseInt(s));
                        }
                        catch (Exception exception1) {
                            LOGGER.warn("Invalid integer value for option {} = {}", new Object[]{p_168475_, s, exception1});
                        }
                    }
                    return p_168476_;
                }
            });
            if (compoundtag1.contains("fullscreenResolution")) {
                this.fullscreenVideoModeString = compoundtag1.getString("fullscreenResolution");
            }
            if (this.minecraft.getWindow() != null) {
                this.minecraft.getWindow().setFramerateLimit(this.framerateLimit);
            }
            KeyMapping.resetMapping();
        }
        catch (Exception exception1) {
            LOGGER.error("Failed to load options", (Throwable)exception1);
        }
        this.loadOptions = false;
        this.loadOfOptions();
    }

    static boolean isTrue(String pValue) {
        return "true".equals(pValue);
    }

    static boolean isFalse(String pValue) {
        return "false".equals(pValue);
    }

    private CompoundTag dataFix(CompoundTag pNbt) {
        int i = 0;
        try {
            i = Integer.parseInt(pNbt.getString("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NbtUtils.update(this.minecraft.getFixerUpper(), DataFixTypes.OPTIONS, pNbt, i);
    }

    public void save() {
        this.saveOptions = true;
        if (!Reflector.ClientModLoader_isLoading.exists() || !Reflector.callBoolean(Reflector.ClientModLoader_isLoading, new Object[0])) {
            try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFile), StandardCharsets.UTF_8));){
                printwriter.println("version:" + SharedConstants.getCurrentVersion().getWorldVersion());
                this.processOptions(new FieldAccess(){

                    public void writePrefix(String p_168491_) {
                        printwriter.print(p_168491_);
                        printwriter.print(':');
                    }

                    @Override
                    public int process(String p_168499_, int p_168500_) {
                        this.writePrefix(p_168499_);
                        printwriter.println(p_168500_);
                        return p_168500_;
                    }

                    @Override
                    public boolean process(String p_168515_, boolean p_168516_) {
                        this.writePrefix(p_168515_);
                        printwriter.println(p_168516_);
                        return p_168516_;
                    }

                    @Override
                    public String process(String p_168512_, String p_168513_) {
                        this.writePrefix(p_168512_);
                        printwriter.println(p_168513_);
                        return p_168513_;
                    }

                    @Override
                    public double process(String p_168493_, double p_168494_) {
                        this.writePrefix(p_168493_);
                        printwriter.println(p_168494_);
                        return p_168494_;
                    }

                    @Override
                    public float process(String p_168496_, float p_168497_) {
                        this.writePrefix(p_168496_);
                        printwriter.println(p_168497_);
                        return p_168497_;
                    }

                    @Override
                    public <T> T process(String p_168502_, T p_168503_, Function<String, T> p_168504_, Function<T, String> p_168505_) {
                        this.writePrefix(p_168502_);
                        printwriter.println(p_168505_.apply(p_168503_));
                        return p_168503_;
                    }

                    @Override
                    public <T> T process(String p_168507_, T p_168508_, IntFunction<T> p_168509_, ToIntFunction<T> p_168510_) {
                        this.writePrefix(p_168507_);
                        printwriter.println(p_168510_.applyAsInt(p_168508_));
                        return p_168508_;
                    }
                });
                if (this.minecraft.getWindow().getPreferredFullscreenVideoMode().isPresent()) {
                    printwriter.println("fullscreenResolution:" + this.minecraft.getWindow().getPreferredFullscreenVideoMode().get().write());
                }
            }
            catch (Exception exception1) {
                LOGGER.error("Failed to save options", (Throwable)exception1);
            }
            this.saveOptions = false;
            this.saveOfOptions();
            this.broadcastOptions();
        }
    }

    public float getSoundSourceVolume(SoundSource pCategory) {
        return this.sourceVolumes.getFloat((Object)pCategory);
    }

    public void setSoundCategoryVolume(SoundSource pCategory, float pVolume) {
        this.sourceVolumes.put((Object)pCategory, pVolume);
        this.minecraft.getSoundManager().updateSourceVolume(pCategory, pVolume);
    }

    public void broadcastOptions() {
        if (this.minecraft.player != null) {
            int i = 0;
            for (PlayerModelPart playermodelpart : this.modelParts) {
                i |= playermodelpart.getMask();
            }
            this.minecraft.player.connection.send(new ServerboundClientInformationPacket(this.languageCode, this.renderDistance, this.chatVisibility, this.chatColors, i, this.mainHand, this.minecraft.isTextFilteringEnabled(), this.allowServerListing));
        }
    }

    private void setModelPart(PlayerModelPart pModelPart, boolean pEnable) {
        if (pEnable) {
            this.modelParts.add(pModelPart);
        } else {
            this.modelParts.remove((Object)pModelPart);
        }
    }

    public boolean isModelPartEnabled(PlayerModelPart pPlayerModelPart) {
        return this.modelParts.contains((Object)pPlayerModelPart);
    }

    public void toggleModelPart(PlayerModelPart pPlayerModelPart, boolean pEnable) {
        this.setModelPart(pPlayerModelPart, pEnable);
        this.broadcastOptions();
    }

    public CloudStatus getCloudsType() {
        return this.getEffectiveRenderDistance() >= 4 ? this.renderClouds : CloudStatus.OFF;
    }

    public boolean useNativeTransport() {
        return this.useNativeTransport;
    }

    public void setOptionFloatValueOF(Option option, double val) {
        if (option == Option.CLOUD_HEIGHT) {
            this.ofCloudsHeight = val;
        }
        if (option == Option.AO_LEVEL) {
            this.ofAoLevel = val;
            this.minecraft.levelRenderer.allChanged();
        }
        if (option == Option.AA_LEVEL) {
            int i = (int)val;
            if (i > 0 && Config.isShaders()) {
                Config.showGuiMessage(Lang.get("of.message.aa.shaders1"), Lang.get("of.message.aa.shaders2"));
                return;
            }
            if (i > 0 && Config.isGraphicsFabulous()) {
                Config.showGuiMessage(Lang.get("of.message.aa.gf1"), Lang.get("of.message.aa.gf2"));
                return;
            }
            this.ofAaLevel = i;
            this.ofAaLevel = Config.limit(this.ofAaLevel, 0, 16);
        }
        if (option == Option.AF_LEVEL) {
            int j;
            this.ofAfLevel = j = (int)val;
            this.ofAfLevel = Config.limit(this.ofAfLevel, 1, 16);
            this.minecraft.delayTextureReload();
            Shaders.uninit();
        }
        if (option == Option.MIPMAP_TYPE) {
            int k = (int)val;
            this.ofMipmapType = Config.limit(k, 0, 3);
            this.updateMipmaps();
        }
    }

    public double getOptionFloatValueOF(Option settingOption) {
        if (settingOption == Option.CLOUD_HEIGHT) {
            return this.ofCloudsHeight;
        }
        if (settingOption == Option.AO_LEVEL) {
            return this.ofAoLevel;
        }
        if (settingOption == Option.AA_LEVEL) {
            return this.ofAaLevel;
        }
        if (settingOption == Option.AF_LEVEL) {
            return this.ofAfLevel;
        }
        if (settingOption == Option.MIPMAP_TYPE) {
            return this.ofMipmapType;
        }
        if (settingOption == Option.FRAMERATE_LIMIT) {
            return (double)this.framerateLimit == Option.FRAMERATE_LIMIT.getMaxValue() && this.enableVsync ? 0.0 : (double)this.framerateLimit;
        }
        return 3.4028234663852886E38;
    }

    public void setOptionValueOF(Option par1EnumOptions, int par2) {
        if (par1EnumOptions == Option.FOG_FANCY) {
            switch (this.ofFogType) {
                case 2: {
                    this.ofFogType = 3;
                    break;
                }
                default: {
                    this.ofFogType = 2;
                }
            }
        }
        if (par1EnumOptions == Option.FOG_START) {
            this.ofFogStart += 0.2f;
            if (this.ofFogStart > 0.81f) {
                this.ofFogStart = 0.2f;
            }
        }
        if (par1EnumOptions == Option.SMOOTH_FPS) {
            boolean bl = this.ofSmoothFps = !this.ofSmoothFps;
        }
        if (par1EnumOptions == Option.SMOOTH_WORLD) {
            this.ofSmoothWorld = !this.ofSmoothWorld;
            Config.updateThreadPriorities();
        }
        if (par1EnumOptions == Option.CLOUDS) {
            ++this.ofClouds;
            if (this.ofClouds > 3) {
                this.ofClouds = 0;
            }
            this.updateRenderClouds();
        }
        if (par1EnumOptions == Option.TREES) {
            this.ofTrees = Options.nextValue(this.ofTrees, OF_TREES_VALUES);
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.RAIN) {
            ++this.ofRain;
            if (this.ofRain > 3) {
                this.ofRain = 0;
            }
        }
        if (par1EnumOptions == Option.ANIMATED_WATER) {
            ++this.ofAnimatedWater;
            if (this.ofAnimatedWater == 1) {
                ++this.ofAnimatedWater;
            }
            if (this.ofAnimatedWater > 2) {
                this.ofAnimatedWater = 0;
            }
        }
        if (par1EnumOptions == Option.ANIMATED_LAVA) {
            ++this.ofAnimatedLava;
            if (this.ofAnimatedLava == 1) {
                ++this.ofAnimatedLava;
            }
            if (this.ofAnimatedLava > 2) {
                this.ofAnimatedLava = 0;
            }
        }
        if (par1EnumOptions == Option.ANIMATED_FIRE) {
            boolean bl = this.ofAnimatedFire = !this.ofAnimatedFire;
        }
        if (par1EnumOptions == Option.ANIMATED_PORTAL) {
            boolean bl = this.ofAnimatedPortal = !this.ofAnimatedPortal;
        }
        if (par1EnumOptions == Option.ANIMATED_REDSTONE) {
            boolean bl = this.ofAnimatedRedstone = !this.ofAnimatedRedstone;
        }
        if (par1EnumOptions == Option.ANIMATED_EXPLOSION) {
            boolean bl = this.ofAnimatedExplosion = !this.ofAnimatedExplosion;
        }
        if (par1EnumOptions == Option.ANIMATED_FLAME) {
            boolean bl = this.ofAnimatedFlame = !this.ofAnimatedFlame;
        }
        if (par1EnumOptions == Option.ANIMATED_SMOKE) {
            boolean bl = this.ofAnimatedSmoke = !this.ofAnimatedSmoke;
        }
        if (par1EnumOptions == Option.VOID_PARTICLES) {
            boolean bl = this.ofVoidParticles = !this.ofVoidParticles;
        }
        if (par1EnumOptions == Option.WATER_PARTICLES) {
            boolean bl = this.ofWaterParticles = !this.ofWaterParticles;
        }
        if (par1EnumOptions == Option.PORTAL_PARTICLES) {
            boolean bl = this.ofPortalParticles = !this.ofPortalParticles;
        }
        if (par1EnumOptions == Option.POTION_PARTICLES) {
            boolean bl = this.ofPotionParticles = !this.ofPotionParticles;
        }
        if (par1EnumOptions == Option.FIREWORK_PARTICLES) {
            boolean bl = this.ofFireworkParticles = !this.ofFireworkParticles;
        }
        if (par1EnumOptions == Option.DRIPPING_WATER_LAVA) {
            boolean bl = this.ofDrippingWaterLava = !this.ofDrippingWaterLava;
        }
        if (par1EnumOptions == Option.ANIMATED_TERRAIN) {
            boolean bl = this.ofAnimatedTerrain = !this.ofAnimatedTerrain;
        }
        if (par1EnumOptions == Option.ANIMATED_TEXTURES) {
            boolean bl = this.ofAnimatedTextures = !this.ofAnimatedTextures;
        }
        if (par1EnumOptions == Option.RAIN_SPLASH) {
            boolean bl = this.ofRainSplash = !this.ofRainSplash;
        }
        if (par1EnumOptions == Option.LAGOMETER) {
            boolean bl = this.ofLagometer = !this.ofLagometer;
        }
        if (par1EnumOptions == Option.SHOW_FPS) {
            boolean bl = this.ofShowFps = !this.ofShowFps;
        }
        if (par1EnumOptions == Option.AUTOSAVE_TICKS) {
            int i = 900;
            this.ofAutoSaveTicks = Math.max(this.ofAutoSaveTicks / i * i, i);
            this.ofAutoSaveTicks *= 2;
            if (this.ofAutoSaveTicks > 32 * i) {
                this.ofAutoSaveTicks = i;
            }
        }
        if (par1EnumOptions == Option.BETTER_GRASS) {
            ++this.ofBetterGrass;
            if (this.ofBetterGrass > 3) {
                this.ofBetterGrass = 1;
            }
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.CONNECTED_TEXTURES) {
            ++this.ofConnectedTextures;
            if (this.ofConnectedTextures > 3) {
                this.ofConnectedTextures = 1;
            }
            if (this.ofConnectedTextures == 2) {
                this.minecraft.levelRenderer.allChanged();
            } else {
                this.minecraft.delayTextureReload();
            }
        }
        if (par1EnumOptions == Option.WEATHER) {
            boolean bl = this.ofWeather = !this.ofWeather;
        }
        if (par1EnumOptions == Option.SKY) {
            boolean bl = this.ofSky = !this.ofSky;
        }
        if (par1EnumOptions == Option.STARS) {
            boolean bl = this.ofStars = !this.ofStars;
        }
        if (par1EnumOptions == Option.SUN_MOON) {
            boolean bl = this.ofSunMoon = !this.ofSunMoon;
        }
        if (par1EnumOptions == Option.VIGNETTE) {
            ++this.ofVignette;
            if (this.ofVignette > 2) {
                this.ofVignette = 0;
            }
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES) {
            ++this.ofChunkUpdates;
            if (this.ofChunkUpdates > 5) {
                this.ofChunkUpdates = 1;
            }
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES_DYNAMIC) {
            boolean bl = this.ofChunkUpdatesDynamic = !this.ofChunkUpdatesDynamic;
        }
        if (par1EnumOptions == Option.TIME) {
            ++this.ofTime;
            if (this.ofTime > 2) {
                this.ofTime = 0;
            }
        }
        if (par1EnumOptions == Option.PROFILER) {
            boolean bl = this.ofProfiler = !this.ofProfiler;
        }
        if (par1EnumOptions == Option.BETTER_SNOW) {
            this.ofBetterSnow = !this.ofBetterSnow;
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.SWAMP_COLORS) {
            this.ofSwampColors = !this.ofSwampColors;
            CustomColors.updateUseDefaultGrassFoliageColors();
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.RANDOM_ENTITIES) {
            this.ofRandomEntities = !this.ofRandomEntities;
            RandomEntities.update();
        }
        if (par1EnumOptions == Option.CUSTOM_FONTS) {
            this.ofCustomFonts = !this.ofCustomFonts;
            FontUtils.reloadFonts();
        }
        if (par1EnumOptions == Option.CUSTOM_COLORS) {
            this.ofCustomColors = !this.ofCustomColors;
            CustomColors.update();
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.CUSTOM_ITEMS) {
            this.ofCustomItems = !this.ofCustomItems;
            this.minecraft.delayTextureReload();
        }
        if (par1EnumOptions == Option.CUSTOM_SKY) {
            this.ofCustomSky = !this.ofCustomSky;
            CustomSky.update();
        }
        if (par1EnumOptions == Option.SHOW_CAPES) {
            boolean bl = this.ofShowCapes = !this.ofShowCapes;
        }
        if (par1EnumOptions == Option.NATURAL_TEXTURES) {
            this.ofNaturalTextures = !this.ofNaturalTextures;
            NaturalTextures.update();
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.EMISSIVE_TEXTURES) {
            this.ofEmissiveTextures = !this.ofEmissiveTextures;
            this.minecraft.delayTextureReload();
        }
        if (par1EnumOptions == Option.FAST_MATH) {
            Mth.fastMath = this.ofFastMath = !this.ofFastMath;
        }
        if (par1EnumOptions == Option.FAST_RENDER) {
            boolean bl = this.ofFastRender = !this.ofFastRender;
        }
        if (par1EnumOptions == Option.LAZY_CHUNK_LOADING) {
            boolean bl = this.ofLazyChunkLoading = !this.ofLazyChunkLoading;
        }
        if (par1EnumOptions == Option.RENDER_REGIONS) {
            this.ofRenderRegions = !this.ofRenderRegions;
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.SMART_ANIMATIONS) {
            this.ofSmartAnimations = !this.ofSmartAnimations;
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.DYNAMIC_FOV) {
            boolean bl = this.ofDynamicFov = !this.ofDynamicFov;
        }
        if (par1EnumOptions == Option.ALTERNATE_BLOCKS) {
            this.ofAlternateBlocks = !this.ofAlternateBlocks;
            this.minecraft.levelRenderer.allChanged();
        }
        if (par1EnumOptions == Option.DYNAMIC_LIGHTS) {
            this.ofDynamicLights = Options.nextValue(this.ofDynamicLights, OF_DYNAMIC_LIGHTS);
            DynamicLights.removeLights(this.minecraft.levelRenderer);
        }
        if (par1EnumOptions == Option.SCREENSHOT_SIZE) {
            ++this.ofScreenshotSize;
            if (this.ofScreenshotSize > 4) {
                this.ofScreenshotSize = 1;
            }
        }
        if (par1EnumOptions == Option.CUSTOM_ENTITY_MODELS) {
            this.ofCustomEntityModels = !this.ofCustomEntityModels;
            this.minecraft.delayTextureReload();
        }
        if (par1EnumOptions == Option.CUSTOM_GUIS) {
            this.ofCustomGuis = !this.ofCustomGuis;
            CustomGuis.update();
        }
        if (par1EnumOptions == Option.SHOW_GL_ERRORS) {
            boolean bl = this.ofShowGlErrors = !this.ofShowGlErrors;
        }
        if (par1EnumOptions == Option.HELD_ITEM_TOOLTIPS) {
            boolean bl = this.heldItemTooltips = !this.heldItemTooltips;
        }
        if (par1EnumOptions == Option.ADVANCED_TOOLTIPS) {
            boolean bl = this.advancedItemTooltips = !this.advancedItemTooltips;
        }
        if (par1EnumOptions == Option.CHAT_BACKGROUND) {
            this.ofChatBackground = this.ofChatBackground == 0 ? 5 : (this.ofChatBackground == 5 ? 3 : 0);
        }
        if (par1EnumOptions == Option.CHAT_SHADOW) {
            boolean bl = this.ofChatShadow = !this.ofChatShadow;
        }
        if (par1EnumOptions == Option.TELEMETRY) {
            this.ofTelemetry = Options.nextValue(this.ofTelemetry, OF_TELEMETRY);
        }
    }

    public Component getKeyComponentOF(Option option) {
        String s = this.getKeyBindingOF(option);
        TextComponent component = new TextComponent(s);
        return component;
    }

    public String getKeyBindingOF(Option par1EnumOptions) {
        String s = String.valueOf(I18n.a(par1EnumOptions.getResourceKey(), new Object[0])) + ": ";
        if (s == null) {
            s = par1EnumOptions.getResourceKey();
        }
        if (par1EnumOptions == Option.RENDER_DISTANCE) {
            int j1 = (int)Option.RENDER_DISTANCE.get(this);
            String s2 = I18n.a("of.options.renderDistance.tiny", new Object[0]);
            int i = 2;
            if (j1 >= 4) {
                s2 = I18n.a("of.options.renderDistance.short", new Object[0]);
                i = 4;
            }
            if (j1 >= 8) {
                s2 = I18n.a("of.options.renderDistance.normal", new Object[0]);
                i = 8;
            }
            if (j1 >= 16) {
                s2 = I18n.a("of.options.renderDistance.far", new Object[0]);
                i = 16;
            }
            if (j1 >= 32) {
                s2 = Lang.get("of.options.renderDistance.extreme");
                i = 32;
            }
            if (j1 >= 48) {
                s2 = Lang.get("of.options.renderDistance.insane");
                i = 48;
            }
            if (j1 >= 64) {
                s2 = Lang.get("of.options.renderDistance.ludicrous");
                i = 64;
            }
            int j = this.renderDistance - i;
            String s1 = s2;
            if (j > 0) {
                s1 = String.valueOf(s2) + "+";
            }
            return String.valueOf(s) + j1 + " " + s1;
        }
        if (par1EnumOptions == Option.FOG_FANCY) {
            switch (this.ofFogType) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
                case 3: {
                    return String.valueOf(s) + Lang.getOff();
                }
            }
            return String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.FOG_START) {
            return String.valueOf(s) + this.ofFogStart;
        }
        if (par1EnumOptions == Option.MIPMAP_TYPE) {
            return FloatOptions.getText(par1EnumOptions, this.ofMipmapType);
        }
        if (par1EnumOptions == Option.SMOOTH_FPS) {
            return this.ofSmoothFps ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SMOOTH_WORLD) {
            return this.ofSmoothWorld ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CLOUDS) {
            switch (this.ofClouds) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
                case 3: {
                    return String.valueOf(s) + Lang.getOff();
                }
            }
            return String.valueOf(s) + Lang.getDefault();
        }
        if (par1EnumOptions == Option.TREES) {
            switch (this.ofTrees) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
                default: {
                    return String.valueOf(s) + Lang.getDefault();
                }
                case 4: 
            }
            return String.valueOf(s) + Lang.get("of.general.smart");
        }
        if (par1EnumOptions == Option.RAIN) {
            switch (this.ofRain) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
                case 3: {
                    return String.valueOf(s) + Lang.getOff();
                }
            }
            return String.valueOf(s) + Lang.getDefault();
        }
        if (par1EnumOptions == Option.ANIMATED_WATER) {
            switch (this.ofAnimatedWater) {
                case 1: {
                    return String.valueOf(s) + Lang.get("of.options.animation.dynamic");
                }
                case 2: {
                    return String.valueOf(s) + Lang.getOff();
                }
            }
            return String.valueOf(s) + Lang.getOn();
        }
        if (par1EnumOptions == Option.ANIMATED_LAVA) {
            switch (this.ofAnimatedLava) {
                case 1: {
                    return String.valueOf(s) + Lang.get("of.options.animation.dynamic");
                }
                case 2: {
                    return String.valueOf(s) + Lang.getOff();
                }
            }
            return String.valueOf(s) + Lang.getOn();
        }
        if (par1EnumOptions == Option.ANIMATED_FIRE) {
            return this.ofAnimatedFire ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_PORTAL) {
            return this.ofAnimatedPortal ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_REDSTONE) {
            return this.ofAnimatedRedstone ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_EXPLOSION) {
            return this.ofAnimatedExplosion ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_FLAME) {
            return this.ofAnimatedFlame ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_SMOKE) {
            return this.ofAnimatedSmoke ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.VOID_PARTICLES) {
            return this.ofVoidParticles ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.WATER_PARTICLES) {
            return this.ofWaterParticles ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.PORTAL_PARTICLES) {
            return this.ofPortalParticles ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.POTION_PARTICLES) {
            return this.ofPotionParticles ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.FIREWORK_PARTICLES) {
            return this.ofFireworkParticles ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.DRIPPING_WATER_LAVA) {
            return this.ofDrippingWaterLava ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_TERRAIN) {
            return this.ofAnimatedTerrain ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_TEXTURES) {
            return this.ofAnimatedTextures ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.RAIN_SPLASH) {
            return this.ofRainSplash ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.LAGOMETER) {
            return this.ofLagometer ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SHOW_FPS) {
            return this.ofShowFps ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.AUTOSAVE_TICKS) {
            int i1 = 900;
            if (this.ofAutoSaveTicks <= i1) {
                return String.valueOf(s) + Lang.get("of.options.save.45s");
            }
            if (this.ofAutoSaveTicks <= 2 * i1) {
                return String.valueOf(s) + Lang.get("of.options.save.90s");
            }
            if (this.ofAutoSaveTicks <= 4 * i1) {
                return String.valueOf(s) + Lang.get("of.options.save.3min");
            }
            if (this.ofAutoSaveTicks <= 8 * i1) {
                return String.valueOf(s) + Lang.get("of.options.save.6min");
            }
            return this.ofAutoSaveTicks <= 16 * i1 ? String.valueOf(s) + Lang.get("of.options.save.12min") : String.valueOf(s) + Lang.get("of.options.save.24min");
        }
        if (par1EnumOptions == Option.BETTER_GRASS) {
            switch (this.ofBetterGrass) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
            }
            return String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CONNECTED_TEXTURES) {
            switch (this.ofConnectedTextures) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
            }
            return String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.WEATHER) {
            return this.ofWeather ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SKY) {
            return this.ofSky ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.STARS) {
            return this.ofStars ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SUN_MOON) {
            return this.ofSunMoon ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.VIGNETTE) {
            switch (this.ofVignette) {
                case 1: {
                    return String.valueOf(s) + Lang.getFast();
                }
                case 2: {
                    return String.valueOf(s) + Lang.getFancy();
                }
            }
            return String.valueOf(s) + Lang.getDefault();
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES) {
            return String.valueOf(s) + this.ofChunkUpdates;
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES_DYNAMIC) {
            return this.ofChunkUpdatesDynamic ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.TIME) {
            if (this.ofTime == 1) {
                return String.valueOf(s) + Lang.get("of.options.time.dayOnly");
            }
            return this.ofTime == 2 ? String.valueOf(s) + Lang.get("of.options.time.nightOnly") : String.valueOf(s) + Lang.getDefault();
        }
        if (par1EnumOptions == Option.AA_LEVEL) {
            return FloatOptions.getText(par1EnumOptions, this.ofAaLevel);
        }
        if (par1EnumOptions == Option.AF_LEVEL) {
            return FloatOptions.getText(par1EnumOptions, this.ofAfLevel);
        }
        if (par1EnumOptions == Option.PROFILER) {
            return this.ofProfiler ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.BETTER_SNOW) {
            return this.ofBetterSnow ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SWAMP_COLORS) {
            return this.ofSwampColors ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.RANDOM_ENTITIES) {
            return this.ofRandomEntities ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_FONTS) {
            return this.ofCustomFonts ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_COLORS) {
            return this.ofCustomColors ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_SKY) {
            return this.ofCustomSky ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SHOW_CAPES) {
            return this.ofShowCapes ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_ITEMS) {
            return this.ofCustomItems ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.NATURAL_TEXTURES) {
            return this.ofNaturalTextures ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.EMISSIVE_TEXTURES) {
            return this.ofEmissiveTextures ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.FAST_MATH) {
            return this.ofFastMath ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.FAST_RENDER) {
            return this.ofFastRender ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.LAZY_CHUNK_LOADING) {
            return this.ofLazyChunkLoading ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.RENDER_REGIONS) {
            return this.ofRenderRegions ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SMART_ANIMATIONS) {
            return this.ofSmartAnimations ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.DYNAMIC_FOV) {
            return this.ofDynamicFov ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ALTERNATE_BLOCKS) {
            return this.ofAlternateBlocks ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.DYNAMIC_LIGHTS) {
            int l = Options.indexOf(this.ofDynamicLights, OF_DYNAMIC_LIGHTS);
            return String.valueOf(s) + Options.getTranslation(KEYS_DYNAMIC_LIGHTS, l);
        }
        if (par1EnumOptions == Option.SCREENSHOT_SIZE) {
            return this.ofScreenshotSize <= 1 ? String.valueOf(s) + Lang.getDefault() : String.valueOf(s) + this.ofScreenshotSize + "x";
        }
        if (par1EnumOptions == Option.CUSTOM_ENTITY_MODELS) {
            return this.ofCustomEntityModels ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_GUIS) {
            return this.ofCustomGuis ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.SHOW_GL_ERRORS) {
            return this.ofShowGlErrors ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.HELD_ITEM_TOOLTIPS) {
            return this.heldItemTooltips ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.ADVANCED_TOOLTIPS) {
            return this.advancedItemTooltips ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.FRAMERATE_LIMIT) {
            double d1 = Option.FRAMERATE_LIMIT.get(this);
            if (d1 == 0.0) {
                return String.valueOf(s) + Lang.get("of.options.framerateLimit.vsync");
            }
            return d1 == Option.FRAMERATE_LIMIT.getMaxValue() ? String.valueOf(s) + I18n.a("options.framerateLimit.max", new Object[0]) : String.valueOf(s) + (int)d1 + " fps";
        }
        if (par1EnumOptions == Option.CHAT_BACKGROUND) {
            if (this.ofChatBackground == 3) {
                return String.valueOf(s) + Lang.getOff();
            }
            return this.ofChatBackground == 5 ? String.valueOf(s) + Lang.get("of.general.compact") : String.valueOf(s) + Lang.getDefault();
        }
        if (par1EnumOptions == Option.CHAT_SHADOW) {
            return this.ofChatShadow ? String.valueOf(s) + Lang.getOn() : String.valueOf(s) + Lang.getOff();
        }
        if (par1EnumOptions == Option.TELEMETRY) {
            int k = Options.indexOf(this.ofTelemetry, OF_TELEMETRY);
            return String.valueOf(s) + Options.getTranslation(KEYS_TELEMETRY, k);
        }
        if (par1EnumOptions instanceof ProgressOption) {
            ProgressOption progressoption = (ProgressOption)par1EnumOptions;
            double d0 = progressoption.get(this);
            return d0 == 0.0 ? String.valueOf(s) + I18n.a("options.off", new Object[0]) : String.valueOf(s) + (int)(d0 * 100.0) + "%";
        }
        return null;
    }

    public void loadOfOptions() {
        try {
            File file1 = this.optionsFileOF;
            if (!file1.exists()) {
                file1 = this.optionsFile;
            }
            if (!file1.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file1), StandardCharsets.UTF_8));
            String s = DEFAULT_SOUND_DEVICE;
            while ((s = bufferedreader.readLine()) != null) {
                try {
                    String[] astring = s.split(":");
                    if (astring[0].equals("ofRenderDistanceChunks") && astring.length >= 2) {
                        this.renderDistance = Integer.valueOf(astring[1]);
                        this.renderDistance = Config.limit(this.renderDistance, 2, 1024);
                    }
                    if (astring[0].equals("ofFogType") && astring.length >= 2) {
                        this.ofFogType = Integer.valueOf(astring[1]);
                        this.ofFogType = Config.limit(this.ofFogType, 2, 3);
                    }
                    if (astring[0].equals("ofFogStart") && astring.length >= 2) {
                        this.ofFogStart = Float.valueOf(astring[1]).floatValue();
                        if (this.ofFogStart < 0.2f) {
                            this.ofFogStart = 0.2f;
                        }
                        if (this.ofFogStart > 0.81f) {
                            this.ofFogStart = 0.8f;
                        }
                    }
                    if (astring[0].equals("ofMipmapType") && astring.length >= 2) {
                        this.ofMipmapType = Integer.valueOf(astring[1]);
                        this.ofMipmapType = Config.limit(this.ofMipmapType, 0, 3);
                    }
                    if (astring[0].equals("ofOcclusionFancy") && astring.length >= 2) {
                        this.ofOcclusionFancy = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofSmoothFps") && astring.length >= 2) {
                        this.ofSmoothFps = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofSmoothWorld") && astring.length >= 2) {
                        this.ofSmoothWorld = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAoLevel") && astring.length >= 2) {
                        this.ofAoLevel = Float.valueOf(astring[1]).floatValue();
                        this.ofAoLevel = Config.limit(this.ofAoLevel, 0.0, 1.0);
                    }
                    if (astring[0].equals("ofClouds") && astring.length >= 2) {
                        this.ofClouds = Integer.valueOf(astring[1]);
                        this.ofClouds = Config.limit(this.ofClouds, 0, 3);
                        this.updateRenderClouds();
                    }
                    if (astring[0].equals("ofCloudsHeight") && astring.length >= 2) {
                        this.ofCloudsHeight = Float.valueOf(astring[1]).floatValue();
                        this.ofCloudsHeight = Config.limit(this.ofCloudsHeight, 0.0, 1.0);
                    }
                    if (astring[0].equals("ofTrees") && astring.length >= 2) {
                        this.ofTrees = Integer.valueOf(astring[1]);
                        this.ofTrees = Options.limit(this.ofTrees, OF_TREES_VALUES);
                    }
                    if (astring[0].equals("ofRain") && astring.length >= 2) {
                        this.ofRain = Integer.valueOf(astring[1]);
                        this.ofRain = Config.limit(this.ofRain, 0, 3);
                    }
                    if (astring[0].equals("ofAnimatedWater") && astring.length >= 2) {
                        this.ofAnimatedWater = Integer.valueOf(astring[1]);
                        this.ofAnimatedWater = Config.limit(this.ofAnimatedWater, 0, 2);
                    }
                    if (astring[0].equals("ofAnimatedLava") && astring.length >= 2) {
                        this.ofAnimatedLava = Integer.valueOf(astring[1]);
                        this.ofAnimatedLava = Config.limit(this.ofAnimatedLava, 0, 2);
                    }
                    if (astring[0].equals("ofAnimatedFire") && astring.length >= 2) {
                        this.ofAnimatedFire = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedPortal") && astring.length >= 2) {
                        this.ofAnimatedPortal = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedRedstone") && astring.length >= 2) {
                        this.ofAnimatedRedstone = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedExplosion") && astring.length >= 2) {
                        this.ofAnimatedExplosion = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedFlame") && astring.length >= 2) {
                        this.ofAnimatedFlame = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedSmoke") && astring.length >= 2) {
                        this.ofAnimatedSmoke = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofVoidParticles") && astring.length >= 2) {
                        this.ofVoidParticles = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofWaterParticles") && astring.length >= 2) {
                        this.ofWaterParticles = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofPortalParticles") && astring.length >= 2) {
                        this.ofPortalParticles = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofPotionParticles") && astring.length >= 2) {
                        this.ofPotionParticles = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofFireworkParticles") && astring.length >= 2) {
                        this.ofFireworkParticles = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofDrippingWaterLava") && astring.length >= 2) {
                        this.ofDrippingWaterLava = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedTerrain") && astring.length >= 2) {
                        this.ofAnimatedTerrain = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAnimatedTextures") && astring.length >= 2) {
                        this.ofAnimatedTextures = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofRainSplash") && astring.length >= 2) {
                        this.ofRainSplash = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofLagometer") && astring.length >= 2) {
                        this.ofLagometer = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofShowFps") && astring.length >= 2) {
                        this.ofShowFps = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAutoSaveTicks") && astring.length >= 2) {
                        this.ofAutoSaveTicks = Integer.valueOf(astring[1]);
                        this.ofAutoSaveTicks = Config.limit(this.ofAutoSaveTicks, 40, 40000);
                    }
                    if (astring[0].equals("ofBetterGrass") && astring.length >= 2) {
                        this.ofBetterGrass = Integer.valueOf(astring[1]);
                        this.ofBetterGrass = Config.limit(this.ofBetterGrass, 1, 3);
                    }
                    if (astring[0].equals("ofConnectedTextures") && astring.length >= 2) {
                        this.ofConnectedTextures = Integer.valueOf(astring[1]);
                        this.ofConnectedTextures = Config.limit(this.ofConnectedTextures, 1, 3);
                    }
                    if (astring[0].equals("ofWeather") && astring.length >= 2) {
                        this.ofWeather = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofSky") && astring.length >= 2) {
                        this.ofSky = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofStars") && astring.length >= 2) {
                        this.ofStars = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofSunMoon") && astring.length >= 2) {
                        this.ofSunMoon = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofVignette") && astring.length >= 2) {
                        this.ofVignette = Integer.valueOf(astring[1]);
                        this.ofVignette = Config.limit(this.ofVignette, 0, 2);
                    }
                    if (astring[0].equals("ofChunkUpdates") && astring.length >= 2) {
                        this.ofChunkUpdates = Integer.valueOf(astring[1]);
                        this.ofChunkUpdates = Config.limit(this.ofChunkUpdates, 1, 5);
                    }
                    if (astring[0].equals("ofChunkUpdatesDynamic") && astring.length >= 2) {
                        this.ofChunkUpdatesDynamic = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofTime") && astring.length >= 2) {
                        this.ofTime = Integer.valueOf(astring[1]);
                        this.ofTime = Config.limit(this.ofTime, 0, 2);
                    }
                    if (astring[0].equals("ofAaLevel") && astring.length >= 2) {
                        this.ofAaLevel = Integer.valueOf(astring[1]);
                        this.ofAaLevel = Config.limit(this.ofAaLevel, 0, 16);
                    }
                    if (astring[0].equals("ofAfLevel") && astring.length >= 2) {
                        this.ofAfLevel = Integer.valueOf(astring[1]);
                        this.ofAfLevel = Config.limit(this.ofAfLevel, 1, 16);
                    }
                    if (astring[0].equals("ofProfiler") && astring.length >= 2) {
                        this.ofProfiler = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofBetterSnow") && astring.length >= 2) {
                        this.ofBetterSnow = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofSwampColors") && astring.length >= 2) {
                        this.ofSwampColors = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofRandomEntities") && astring.length >= 2) {
                        this.ofRandomEntities = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofCustomFonts") && astring.length >= 2) {
                        this.ofCustomFonts = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofCustomColors") && astring.length >= 2) {
                        this.ofCustomColors = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofCustomItems") && astring.length >= 2) {
                        this.ofCustomItems = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofCustomSky") && astring.length >= 2) {
                        this.ofCustomSky = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofShowCapes") && astring.length >= 2) {
                        this.ofShowCapes = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofNaturalTextures") && astring.length >= 2) {
                        this.ofNaturalTextures = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofEmissiveTextures") && astring.length >= 2) {
                        this.ofEmissiveTextures = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofLazyChunkLoading") && astring.length >= 2) {
                        this.ofLazyChunkLoading = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofRenderRegions") && astring.length >= 2) {
                        this.ofRenderRegions = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofSmartAnimations") && astring.length >= 2) {
                        this.ofSmartAnimations = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofDynamicFov") && astring.length >= 2) {
                        this.ofDynamicFov = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofAlternateBlocks") && astring.length >= 2) {
                        this.ofAlternateBlocks = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofDynamicLights") && astring.length >= 2) {
                        this.ofDynamicLights = Integer.valueOf(astring[1]);
                        this.ofDynamicLights = Options.limit(this.ofDynamicLights, OF_DYNAMIC_LIGHTS);
                    }
                    if (astring[0].equals("ofScreenshotSize") && astring.length >= 2) {
                        this.ofScreenshotSize = Integer.valueOf(astring[1]);
                        this.ofScreenshotSize = Config.limit(this.ofScreenshotSize, 1, 4);
                    }
                    if (astring[0].equals("ofCustomEntityModels") && astring.length >= 2) {
                        this.ofCustomEntityModels = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofCustomGuis") && astring.length >= 2) {
                        this.ofCustomGuis = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofShowGlErrors") && astring.length >= 2) {
                        this.ofShowGlErrors = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofFastMath") && astring.length >= 2) {
                        Mth.fastMath = this.ofFastMath = Boolean.valueOf(astring[1]).booleanValue();
                    }
                    if (astring[0].equals("ofFastRender") && astring.length >= 2) {
                        this.ofFastRender = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofChatBackground") && astring.length >= 2) {
                        this.ofChatBackground = Integer.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofChatShadow") && astring.length >= 2) {
                        this.ofChatShadow = Boolean.valueOf(astring[1]);
                    }
                    if (astring[0].equals("ofTelemetry") && astring.length >= 2) {
                        this.ofTelemetry = Integer.valueOf(astring[1]);
                        this.ofTelemetry = Options.limit(this.ofTelemetry, OF_TELEMETRY);
                    }
                    if (!astring[0].equals("key_" + this.ofKeyBindZoom.getName())) continue;
                    this.ofKeyBindZoom.setKey(InputConstants.getKey(astring[1]));
                }
                catch (Exception exception1) {
                    Config.dbg("Skipping bad option: " + s);
                    exception1.printStackTrace();
                }
            }
            KeyUtils.fixKeyConflicts(this.keyMappings, new KeyMapping[]{this.ofKeyBindZoom});
            KeyMapping.resetMapping();
            bufferedreader.close();
        }
        catch (Exception exception11) {
            Config.warn("Failed to load options");
            exception11.printStackTrace();
        }
    }

    public void saveOfOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFileOF), StandardCharsets.UTF_8));
            printwriter.println("ofFogType:" + this.ofFogType);
            printwriter.println("ofFogStart:" + this.ofFogStart);
            printwriter.println("ofMipmapType:" + this.ofMipmapType);
            printwriter.println("ofOcclusionFancy:" + this.ofOcclusionFancy);
            printwriter.println("ofSmoothFps:" + this.ofSmoothFps);
            printwriter.println("ofSmoothWorld:" + this.ofSmoothWorld);
            printwriter.println("ofAoLevel:" + this.ofAoLevel);
            printwriter.println("ofClouds:" + this.ofClouds);
            printwriter.println("ofCloudsHeight:" + this.ofCloudsHeight);
            printwriter.println("ofTrees:" + this.ofTrees);
            printwriter.println("ofRain:" + this.ofRain);
            printwriter.println("ofAnimatedWater:" + this.ofAnimatedWater);
            printwriter.println("ofAnimatedLava:" + this.ofAnimatedLava);
            printwriter.println("ofAnimatedFire:" + this.ofAnimatedFire);
            printwriter.println("ofAnimatedPortal:" + this.ofAnimatedPortal);
            printwriter.println("ofAnimatedRedstone:" + this.ofAnimatedRedstone);
            printwriter.println("ofAnimatedExplosion:" + this.ofAnimatedExplosion);
            printwriter.println("ofAnimatedFlame:" + this.ofAnimatedFlame);
            printwriter.println("ofAnimatedSmoke:" + this.ofAnimatedSmoke);
            printwriter.println("ofVoidParticles:" + this.ofVoidParticles);
            printwriter.println("ofWaterParticles:" + this.ofWaterParticles);
            printwriter.println("ofPortalParticles:" + this.ofPortalParticles);
            printwriter.println("ofPotionParticles:" + this.ofPotionParticles);
            printwriter.println("ofFireworkParticles:" + this.ofFireworkParticles);
            printwriter.println("ofDrippingWaterLava:" + this.ofDrippingWaterLava);
            printwriter.println("ofAnimatedTerrain:" + this.ofAnimatedTerrain);
            printwriter.println("ofAnimatedTextures:" + this.ofAnimatedTextures);
            printwriter.println("ofRainSplash:" + this.ofRainSplash);
            printwriter.println("ofLagometer:" + this.ofLagometer);
            printwriter.println("ofShowFps:" + this.ofShowFps);
            printwriter.println("ofAutoSaveTicks:" + this.ofAutoSaveTicks);
            printwriter.println("ofBetterGrass:" + this.ofBetterGrass);
            printwriter.println("ofConnectedTextures:" + this.ofConnectedTextures);
            printwriter.println("ofWeather:" + this.ofWeather);
            printwriter.println("ofSky:" + this.ofSky);
            printwriter.println("ofStars:" + this.ofStars);
            printwriter.println("ofSunMoon:" + this.ofSunMoon);
            printwriter.println("ofVignette:" + this.ofVignette);
            printwriter.println("ofChunkUpdates:" + this.ofChunkUpdates);
            printwriter.println("ofChunkUpdatesDynamic:" + this.ofChunkUpdatesDynamic);
            printwriter.println("ofTime:" + this.ofTime);
            printwriter.println("ofAaLevel:" + this.ofAaLevel);
            printwriter.println("ofAfLevel:" + this.ofAfLevel);
            printwriter.println("ofProfiler:" + this.ofProfiler);
            printwriter.println("ofBetterSnow:" + this.ofBetterSnow);
            printwriter.println("ofSwampColors:" + this.ofSwampColors);
            printwriter.println("ofRandomEntities:" + this.ofRandomEntities);
            printwriter.println("ofCustomFonts:" + this.ofCustomFonts);
            printwriter.println("ofCustomColors:" + this.ofCustomColors);
            printwriter.println("ofCustomItems:" + this.ofCustomItems);
            printwriter.println("ofCustomSky:" + this.ofCustomSky);
            printwriter.println("ofShowCapes:" + this.ofShowCapes);
            printwriter.println("ofNaturalTextures:" + this.ofNaturalTextures);
            printwriter.println("ofEmissiveTextures:" + this.ofEmissiveTextures);
            printwriter.println("ofLazyChunkLoading:" + this.ofLazyChunkLoading);
            printwriter.println("ofRenderRegions:" + this.ofRenderRegions);
            printwriter.println("ofSmartAnimations:" + this.ofSmartAnimations);
            printwriter.println("ofDynamicFov:" + this.ofDynamicFov);
            printwriter.println("ofAlternateBlocks:" + this.ofAlternateBlocks);
            printwriter.println("ofDynamicLights:" + this.ofDynamicLights);
            printwriter.println("ofScreenshotSize:" + this.ofScreenshotSize);
            printwriter.println("ofCustomEntityModels:" + this.ofCustomEntityModels);
            printwriter.println("ofCustomGuis:" + this.ofCustomGuis);
            printwriter.println("ofShowGlErrors:" + this.ofShowGlErrors);
            printwriter.println("ofFastMath:" + this.ofFastMath);
            printwriter.println("ofFastRender:" + this.ofFastRender);
            printwriter.println("ofChatBackground:" + this.ofChatBackground);
            printwriter.println("ofChatShadow:" + this.ofChatShadow);
            printwriter.println("ofTelemetry:" + this.ofTelemetry);
            printwriter.println("key_" + this.ofKeyBindZoom.getName() + ":" + this.ofKeyBindZoom.saveString());
            printwriter.close();
        }
        catch (Exception exception1) {
            Config.warn("Failed to save options");
            exception1.printStackTrace();
        }
    }

    public void updateRenderClouds() {
        RenderTarget rendertarget;
        LevelRenderer levelrenderer;
        switch (this.ofClouds) {
            case 1: {
                this.renderClouds = CloudStatus.FAST;
                break;
            }
            case 2: {
                this.renderClouds = CloudStatus.FANCY;
                break;
            }
            case 3: {
                this.renderClouds = CloudStatus.OFF;
                break;
            }
            default: {
                this.renderClouds = this.graphicsMode != GraphicsStatus.FAST ? CloudStatus.FANCY : CloudStatus.FAST;
            }
        }
        if (this.graphicsMode == GraphicsStatus.FABULOUS && (levelrenderer = Minecraft.getInstance().levelRenderer) != null && (rendertarget = levelrenderer.getCloudsTarget()) != null) {
            rendertarget.clear(Minecraft.ON_OSX);
        }
    }

    public void resetSettings() {
        this.renderDistance = 8;
        this.simulationDistance = 8;
        this.entityDistanceScaling = 1.0f;
        this.bobView = true;
        this.framerateLimit = (int)Option.FRAMERATE_LIMIT.getMaxValue();
        this.enableVsync = false;
        this.updateVSync();
        this.mipmapLevels = 4;
        this.graphicsMode = GraphicsStatus.FANCY;
        this.ambientOcclusion = AmbientOcclusionStatus.MAX;
        this.renderClouds = CloudStatus.FANCY;
        this.fov = 70.0;
        this.gamma = 0.0;
        this.guiScale = 0;
        this.particles = ParticleStatus.ALL;
        this.heldItemTooltips = true;
        this.forceUnicodeFont = false;
        this.prioritizeChunkUpdates = PrioritizeChunkUpdates.NONE;
        this.ofFogType = 2;
        this.ofFogStart = 0.8f;
        this.ofMipmapType = 0;
        this.ofOcclusionFancy = false;
        this.ofSmartAnimations = false;
        this.ofSmoothFps = false;
        Config.updateAvailableProcessors();
        this.ofSmoothWorld = Config.isSingleProcessor();
        this.ofLazyChunkLoading = false;
        this.ofRenderRegions = false;
        this.ofFastMath = false;
        this.ofFastRender = false;
        this.ofDynamicFov = true;
        this.ofAlternateBlocks = true;
        this.ofDynamicLights = 3;
        this.ofScreenshotSize = 1;
        this.ofCustomEntityModels = true;
        this.ofCustomGuis = true;
        this.ofShowGlErrors = true;
        this.ofChatBackground = 0;
        this.ofChatShadow = true;
        this.ofTelemetry = 0;
        this.ofAoLevel = 1.0;
        this.ofAaLevel = 0;
        this.ofAfLevel = 1;
        this.ofClouds = 0;
        this.ofCloudsHeight = 0.0;
        this.ofTrees = 0;
        this.ofRain = 0;
        this.ofBetterGrass = 3;
        this.ofAutoSaveTicks = 4000;
        this.ofLagometer = false;
        this.ofShowFps = false;
        this.ofProfiler = false;
        this.ofWeather = true;
        this.ofSky = true;
        this.ofStars = true;
        this.ofSunMoon = true;
        this.ofVignette = 0;
        this.ofChunkUpdates = 1;
        this.ofChunkUpdatesDynamic = false;
        this.ofTime = 0;
        this.ofBetterSnow = false;
        this.ofSwampColors = true;
        this.ofRandomEntities = true;
        this.biomeBlendRadius = 2;
        this.ofCustomFonts = true;
        this.ofCustomColors = true;
        this.ofCustomItems = true;
        this.ofCustomSky = true;
        this.ofShowCapes = true;
        this.ofConnectedTextures = 2;
        this.ofNaturalTextures = false;
        this.ofEmissiveTextures = true;
        this.ofAnimatedWater = 0;
        this.ofAnimatedLava = 0;
        this.ofAnimatedFire = true;
        this.ofAnimatedPortal = true;
        this.ofAnimatedRedstone = true;
        this.ofAnimatedExplosion = true;
        this.ofAnimatedFlame = true;
        this.ofAnimatedSmoke = true;
        this.ofVoidParticles = true;
        this.ofWaterParticles = true;
        this.ofRainSplash = true;
        this.ofPortalParticles = true;
        this.ofPotionParticles = true;
        this.ofFireworkParticles = true;
        this.ofDrippingWaterLava = true;
        this.ofAnimatedTerrain = true;
        this.ofAnimatedTextures = true;
        Shaders.setShaderPack("OFF");
        Shaders.configAntialiasingLevel = 0;
        Shaders.uninit();
        Shaders.storeConfig();
        this.minecraft.delayTextureReload();
        this.save();
    }

    public void updateVSync() {
        if (this.minecraft.getWindow() != null) {
            this.minecraft.getWindow().updateVsync(this.enableVsync);
        }
    }

    public void updateMipmaps() {
        this.minecraft.updateMaxMipLevel(this.mipmapLevels);
        this.minecraft.delayTextureReload();
    }

    public void setAllAnimations(boolean flag) {
        int i;
        this.ofAnimatedWater = i = flag ? 0 : 2;
        this.ofAnimatedLava = i;
        this.ofAnimatedFire = flag;
        this.ofAnimatedPortal = flag;
        this.ofAnimatedRedstone = flag;
        this.ofAnimatedExplosion = flag;
        this.ofAnimatedFlame = flag;
        this.ofAnimatedSmoke = flag;
        this.ofVoidParticles = flag;
        this.ofWaterParticles = flag;
        this.ofRainSplash = flag;
        this.ofPortalParticles = flag;
        this.ofPotionParticles = flag;
        this.ofFireworkParticles = flag;
        this.particles = flag ? ParticleStatus.ALL : ParticleStatus.MINIMAL;
        this.ofDrippingWaterLava = flag;
        this.ofAnimatedTerrain = flag;
        this.ofAnimatedTextures = flag;
    }

    private static int nextValue(int val, int[] vals) {
        int i = Options.indexOf(val, vals);
        if (i < 0) {
            return vals[0];
        }
        if (++i >= vals.length) {
            i = 0;
        }
        return vals[i];
    }

    private static int limit(int val, int[] vals) {
        int i = Options.indexOf(val, vals);
        return i < 0 ? vals[0] : val;
    }

    private static int indexOf(int val, int[] vals) {
        int i = 0;
        while (i < vals.length) {
            if (vals[i] == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String getTranslation(String[] strArray, int index) {
        if (index < 0 || index >= strArray.length) {
            index = 0;
        }
        return I18n.a(strArray[index], new Object[0]);
    }

    private void setForgeKeybindProperties() {
        if (Reflector.KeyConflictContext_IN_GAME.exists() && Reflector.ForgeKeyBinding_setKeyConflictContext.exists()) {
            Object object = Reflector.getFieldValue(Reflector.KeyConflictContext_IN_GAME);
            Reflector.call(this.keyUp, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyLeft, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyDown, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyRight, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyJump, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyShift, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keySprint, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyAttack, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyChat, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyPlayerList, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyCommand, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keyTogglePerspective, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
            Reflector.call(this.keySmoothCamera, Reflector.ForgeKeyBinding_setKeyConflictContext, object);
        }
    }

    public void loadSelectedResourcePacks(PackRepository pResourcePackList) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Iterator<String> iterator = this.resourcePacks.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            Pack pack = pResourcePackList.getPack(s);
            if (pack == null && !s.startsWith("file/")) {
                pack = pResourcePackList.getPack("file/" + s);
            }
            if (pack == null) {
                LOGGER.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)s);
                iterator.remove();
                continue;
            }
            if (!pack.getCompatibility().isCompatible() && !this.incompatibleResourcePacks.contains(s)) {
                LOGGER.warn("Removed resource pack {} from options because it is no longer compatible", (Object)s);
                iterator.remove();
                continue;
            }
            if (pack.getCompatibility().isCompatible() && this.incompatibleResourcePacks.contains(s)) {
                LOGGER.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)s);
                this.incompatibleResourcePacks.remove(s);
                continue;
            }
            set.add(pack.getId());
        }
        pResourcePackList.setSelected(set);
    }

    public CameraType getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(CameraType pPointOfView) {
        this.cameraType = pPointOfView;
    }

    private static List<String> readPackList(String p_168443_) {
        ArrayList list = GsonHelper.fromJson(GSON, p_168443_, RESOURCE_PACK_TYPE);
        return list != null ? list : Lists.newArrayList();
    }

    /*
     * Exception decompiling
     */
    private static CloudStatus readCloudStatus(String p_168445_) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl27 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl27 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String writeCloudStatus(CloudStatus p_168426_) {
        switch (p_168426_) {
            case FANCY: {
                return "true";
            }
            case FAST: {
                return "fast";
            }
        }
        return "false";
    }

    private static AmbientOcclusionStatus readAmbientOcclusion(String p_168447_) {
        if (Options.isTrue(p_168447_)) {
            return AmbientOcclusionStatus.MAX;
        }
        return Options.isFalse(p_168447_) ? AmbientOcclusionStatus.OFF : AmbientOcclusionStatus.byId(Integer.parseInt(p_168447_));
    }

    private static HumanoidArm readMainHand(String p_168449_) {
        return "left".equals(p_168449_) ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    private static String writeMainHand(HumanoidArm p_168415_) {
        return p_168415_ == HumanoidArm.LEFT ? "left" : "right";
    }

    public File getFile() {
        return this.optionsFile;
    }

    public String dumpOptionsForReport() {
        ImmutableList immutablelist = ImmutableList.builder().add((Object)Pair.of((Object)"ao", (Object)String.valueOf((Object)this.ambientOcclusion))).add((Object)Pair.of((Object)"biomeBlendRadius", (Object)String.valueOf(this.biomeBlendRadius))).add((Object)Pair.of((Object)"enableVsync", (Object)String.valueOf(this.enableVsync))).add((Object)Pair.of((Object)"entityDistanceScaling", (Object)String.valueOf(this.entityDistanceScaling))).add((Object)Pair.of((Object)"entityShadows", (Object)String.valueOf(this.entityShadows))).add((Object)Pair.of((Object)"forceUnicodeFont", (Object)String.valueOf(this.forceUnicodeFont))).add((Object)Pair.of((Object)"fov", (Object)String.valueOf(this.fov))).add((Object)Pair.of((Object)"fovEffectScale", (Object)String.valueOf(this.fovEffectScale))).add((Object)Pair.of((Object)"prioritizeChunkUpdates", (Object)String.valueOf((Object)this.prioritizeChunkUpdates))).add((Object)Pair.of((Object)"fullscreen", (Object)String.valueOf(this.fullscreen))).add((Object)Pair.of((Object)"fullscreenResolution", (Object)String.valueOf(this.fullscreenVideoModeString))).add((Object)Pair.of((Object)"gamma", (Object)String.valueOf(this.gamma))).add((Object)Pair.of((Object)"glDebugVerbosity", (Object)String.valueOf(this.glDebugVerbosity))).add((Object)Pair.of((Object)"graphicsMode", (Object)String.valueOf((Object)this.graphicsMode))).add((Object)Pair.of((Object)"guiScale", (Object)String.valueOf(this.guiScale))).add((Object)Pair.of((Object)"maxFps", (Object)String.valueOf(this.framerateLimit))).add((Object)Pair.of((Object)"mipmapLevels", (Object)String.valueOf(this.mipmapLevels))).add((Object)Pair.of((Object)"narrator", (Object)String.valueOf((Object)this.narratorStatus))).add((Object)Pair.of((Object)"overrideHeight", (Object)String.valueOf(this.overrideHeight))).add((Object)Pair.of((Object)"overrideWidth", (Object)String.valueOf(this.overrideWidth))).add((Object)Pair.of((Object)"particles", (Object)String.valueOf((Object)this.particles))).add((Object)Pair.of((Object)"reducedDebugInfo", (Object)String.valueOf(this.reducedDebugInfo))).add((Object)Pair.of((Object)"renderClouds", (Object)String.valueOf((Object)this.renderClouds))).add((Object)Pair.of((Object)"renderDistance", (Object)String.valueOf(this.renderDistance))).add((Object)Pair.of((Object)"simulationDistance", (Object)String.valueOf(this.simulationDistance))).add((Object)Pair.of((Object)"resourcePacks", (Object)String.valueOf(this.resourcePacks))).add((Object)Pair.of((Object)"screenEffectScale", (Object)String.valueOf(this.screenEffectScale))).add((Object)Pair.of((Object)"syncChunkWrites", (Object)String.valueOf(this.syncWrites))).add((Object)Pair.of((Object)"useNativeTransport", (Object)String.valueOf(this.useNativeTransport))).add((Object)Pair.of((Object)"soundDevice", (Object)String.valueOf(this.soundDevice))).build();
        return immutablelist.stream().map(p_168421_0_ -> String.valueOf((String)p_168421_0_.getFirst()) + ": " + (String)p_168421_0_.getSecond()).collect(Collectors.joining(System.lineSeparator()));
    }

    public void setServerRenderDistance(int p_193771_) {
        this.serverRenderDistance = p_193771_;
    }

    public int getEffectiveRenderDistance() {
        return this.serverRenderDistance > 0 ? Math.min(this.renderDistance, this.serverRenderDistance) : this.renderDistance;
    }

    static interface FieldAccess {
        public int process(String var1, int var2);

        public boolean process(String var1, boolean var2);

        public String process(String var1, String var2);

        public double process(String var1, double var2);

        public float process(String var1, float var2);

        public <T> T process(String var1, T var2, Function<String, T> var3, Function<T, String> var4);

        public <T> T process(String var1, T var2, IntFunction<T> var3, ToIntFunction<T> var4);
    }
}

