/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.slf4j.Logger;

public class Screenshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private int rowHeight;
    private final DataOutputStream outputStream;
    private final byte[] bytes;
    private final int width;
    private final int height;
    private File file;

    public static void grab(File pGameDirectory, RenderTarget pBuffer, Consumer<Component> pMessageConsumer) {
        Screenshot.grab(pGameDirectory, null, pBuffer, pMessageConsumer);
    }

    public static void grab(File pGameDirectory, @Nullable String pScreenshotName, RenderTarget pBuffer, Consumer<Component> pMessageConsumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> Screenshot._grab(pGameDirectory, pScreenshotName, pBuffer, pMessageConsumer));
        } else {
            Screenshot._grab(pGameDirectory, pScreenshotName, pBuffer, pMessageConsumer);
        }
    }

    private static void _grab(File pGameDirectory, @Nullable String pScreenshotName, RenderTarget pBuffer, Consumer<Component> pMessageConsumer) {
        boolean flag;
        Minecraft minecraft = Config.getMinecraft();
        Window window = minecraft.getWindow();
        Options options = Config.getGameSettings();
        int i = window.getWidth();
        int j = window.getHeight();
        int k = options.guiScale;
        int l = window.calculateScale(minecraft.options.guiScale, minecraft.options.forceUnicodeFont);
        int i1 = Config.getScreenshotSize();
        boolean bl = flag = GLX.isUsingFBOs() && i1 > 1;
        if (flag) {
            options.guiScale = l * i1;
            try {
                window.resizeFramebuffer(i * i1, j * i1);
            }
            catch (Exception exception) {
                LOGGER.warn("Couldn't save screenshot", (Throwable)exception);
                pMessageConsumer.accept(new TranslatableComponent("screenshot.failure", exception.getMessage()));
            }
            GlStateManager.clear(16640);
            minecraft.getMainRenderTarget().bindWrite(true);
            GlStateManager._enableTexture();
            RenderSystem.getModelViewStack().pushPose();
            minecraft.gameRenderer.render(minecraft.getFrameTime(), System.nanoTime(), true);
            RenderSystem.getModelViewStack().popPose();
            RenderSystem.applyModelViewMatrix();
        }
        NativeImage nativeimage = Screenshot.takeScreenshot(pBuffer);
        if (flag) {
            minecraft.getMainRenderTarget().unbindWrite();
            Config.getGameSettings().guiScale = k;
            window.resizeFramebuffer(i, j);
        }
        File file1 = new File(pGameDirectory, "screenshots");
        file1.mkdir();
        File file2 = pScreenshotName == null ? Screenshot.getFile(file1) : new File(file1, pScreenshotName);
        Object object = null;
        if (Reflector.ForgeHooksClient_onScreenshot.exists()) {
            object = Reflector.call(Reflector.ForgeHooksClient_onScreenshot, nativeimage, file2);
            if (Reflector.callBoolean(object, Reflector.Event_isCanceled, new Object[0])) {
                Component component = (Component)Reflector.call(object, Reflector.ScreenshotEvent_getCancelMessage, new Object[0]);
                pMessageConsumer.accept(component);
                return;
            }
            file2 = (File)Reflector.call(object, Reflector.ScreenshotEvent_getScreenshotFile, new Object[0]);
        }
        File file3 = file2;
        Object object1 = object;
        Util.ioPool().execute(() -> {
            block6: {
                try {
                    try {
                        nativeimage.writeToFile(file3);
                        MutableComponent component1 = new TextComponent(file3.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_168606_1_ -> p_168606_1_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file3.getAbsolutePath())));
                        if (object1 != null && Reflector.call(object1, Reflector.ScreenshotEvent_getResultMessage, new Object[0]) != null) {
                            pMessageConsumer.accept((Component)Reflector.call(object1, Reflector.ScreenshotEvent_getResultMessage, new Object[0]));
                            break block6;
                        }
                        pMessageConsumer.accept(new TranslatableComponent("screenshot.success", component1));
                    }
                    catch (Exception exception1) {
                        LOGGER.warn("Couldn't save screenshot", (Throwable)exception1);
                        pMessageConsumer.accept(new TranslatableComponent("screenshot.failure", exception1.getMessage()));
                        nativeimage.close();
                    }
                }
                finally {
                    nativeimage.close();
                }
            }
        });
    }

    public static NativeImage takeScreenshot(RenderTarget pFramebuffer) {
        if (!GLX.isUsingFBOs()) {
            NativeImage nativeimage1 = new NativeImage(pFramebuffer.width, pFramebuffer.height, false);
            nativeimage1.downloadFromFramebuffer();
            nativeimage1.flipY();
            return nativeimage1;
        }
        int i = pFramebuffer.width;
        int j = pFramebuffer.height;
        NativeImage nativeimage = new NativeImage(i, j, false);
        RenderSystem.bindTexture(pFramebuffer.getColorTextureId());
        nativeimage.downloadTexture(0, true);
        nativeimage.flipY();
        return nativeimage;
    }

    private static File getFile(File pGameDirectory) {
        String s = DATE_FORMAT.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(pGameDirectory, String.valueOf(s) + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public Screenshot(File pGameDirectory, int pWidth, int pHeight, int pRowHeight) throws IOException {
        this.width = pWidth;
        this.height = pHeight;
        this.rowHeight = pRowHeight;
        File file1 = new File(pGameDirectory, "screenshots");
        file1.mkdir();
        String s = "huge_" + DATE_FORMAT.format(new Date());
        int i = 1;
        while ((this.file = new File(file1, String.valueOf(s) + (i == 1 ? "" : "_" + i) + ".tga")).exists()) {
            ++i;
        }
        byte[] abyte = new byte[18];
        abyte[2] = 2;
        abyte[12] = (byte)(pWidth % 256);
        abyte[13] = (byte)(pWidth / 256);
        abyte[14] = (byte)(pHeight % 256);
        abyte[15] = (byte)(pHeight / 256);
        abyte[16] = 24;
        this.bytes = new byte[pWidth * pRowHeight * 3];
        this.outputStream = new DataOutputStream(new FileOutputStream(this.file));
        this.outputStream.write(abyte);
    }

    public void addRegion(ByteBuffer p_168610_, int p_168611_, int p_168612_, int p_168613_, int p_168614_) {
        int i = p_168613_;
        int j = p_168614_;
        if (p_168613_ > this.width - p_168611_) {
            i = this.width - p_168611_;
        }
        if (p_168614_ > this.height - p_168612_) {
            j = this.height - p_168612_;
        }
        this.rowHeight = j;
        int k = 0;
        while (k < j) {
            p_168610_.position((p_168614_ - j) * p_168613_ * 3 + k * p_168613_ * 3);
            int l = (p_168611_ + k * this.width) * 3;
            p_168610_.get(this.bytes, l, i * 3);
            ++k;
        }
    }

    public void saveRow() throws IOException {
        this.outputStream.write(this.bytes, 0, this.width * 3 * this.rowHeight);
    }

    public File close() throws IOException {
        this.outputStream.close();
        return this.file;
    }
}

