/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.color.block;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;

public class BlockColors {
    private static final int DEFAULT = -1;
    private final IdMapper<BlockColor> blockColors = new IdMapper(32);
    private final Map<Block, Set<Property<?>>> coloringStates = Maps.newHashMap();

    public static BlockColors createDefault() {
        BlockColors blockcolors = new BlockColors();
        blockcolors.a((BlockState p_92646_, BlockAndTintGetter p_92647_, BlockPos p_92648_, int p_92649_) -> p_92647_ != null && p_92648_ != null ? BiomeColors.getAverageGrassColor(p_92647_, p_92646_.getValue(DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER ? p_92648_.below() : p_92648_) : -1, Blocks.LARGE_FERN, Blocks.TALL_GRASS);
        blockcolors.a(DoublePlantBlock.HALF, Blocks.LARGE_FERN, Blocks.TALL_GRASS);
        blockcolors.a((BlockState p_92641_, BlockAndTintGetter p_92642_, BlockPos p_92643_, int p_92644_) -> p_92642_ != null && p_92643_ != null ? BiomeColors.getAverageGrassColor(p_92642_, p_92643_) : GrassColor.get(0.5, 1.0), Blocks.GRASS_BLOCK, Blocks.FERN, Blocks.GRASS, Blocks.POTTED_FERN);
        blockcolors.a((BlockState p_92636_, BlockAndTintGetter p_92637_, BlockPos p_92638_, int p_92639_) -> FoliageColor.getEvergreenColor(), Blocks.SPRUCE_LEAVES);
        blockcolors.a((BlockState p_92631_, BlockAndTintGetter p_92632_, BlockPos p_92633_, int p_92634_) -> FoliageColor.getBirchColor(), Blocks.BIRCH_LEAVES);
        blockcolors.a((BlockState p_92626_, BlockAndTintGetter p_92627_, BlockPos p_92628_, int p_92629_) -> p_92627_ != null && p_92628_ != null ? BiomeColors.getAverageFoliageColor(p_92627_, p_92628_) : FoliageColor.getDefaultColor(), Blocks.OAK_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.VINE);
        blockcolors.a((BlockState p_92621_, BlockAndTintGetter p_92622_, BlockPos p_92623_, int p_92624_) -> p_92622_ != null && p_92623_ != null ? BiomeColors.getAverageWaterColor(p_92622_, p_92623_) : -1, Blocks.WATER, Blocks.BUBBLE_COLUMN, Blocks.WATER_CAULDRON);
        blockcolors.a((BlockState p_92616_, BlockAndTintGetter p_92617_, BlockPos p_92618_, int p_92619_) -> RedStoneWireBlock.getColorForPower(p_92616_.getValue(RedStoneWireBlock.POWER)), Blocks.REDSTONE_WIRE);
        blockcolors.a(RedStoneWireBlock.POWER, Blocks.REDSTONE_WIRE);
        blockcolors.a((BlockState p_92611_, BlockAndTintGetter p_92612_, BlockPos p_92613_, int p_92614_) -> p_92612_ != null && p_92613_ != null ? BiomeColors.getAverageGrassColor(p_92612_, p_92613_) : -1, Blocks.SUGAR_CANE);
        blockcolors.a((BlockState p_92606_, BlockAndTintGetter p_92607_, BlockPos p_92608_, int p_92609_) -> 14731036, Blocks.ATTACHED_MELON_STEM, Blocks.ATTACHED_PUMPKIN_STEM);
        blockcolors.a((BlockState p_92601_, BlockAndTintGetter p_92602_, BlockPos p_92603_, int p_92604_) -> {
            int i = p_92601_.getValue(StemBlock.AGE);
            int j = i * 32;
            int k = 255 - i * 8;
            int l = i * 4;
            return j << 16 | k << 8 | l;
        }, Blocks.MELON_STEM, Blocks.PUMPKIN_STEM);
        blockcolors.a(StemBlock.AGE, Blocks.MELON_STEM, Blocks.PUMPKIN_STEM);
        blockcolors.a((BlockState p_92596_, BlockAndTintGetter p_92597_, BlockPos p_92598_, int p_92599_) -> p_92597_ != null && p_92598_ != null ? 2129968 : 7455580, Blocks.LILY_PAD);
        return blockcolors;
    }

    public int getColor(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockColor blockcolor = this.blockColors.byId(Registry.BLOCK.getId(pState.getBlock()));
        if (blockcolor != null) {
            return blockcolor.getColor(pState, null, null, 0);
        }
        MaterialColor materialcolor = pState.getMapColor(pLevel, pPos);
        return materialcolor != null ? materialcolor.col : -1;
    }

    public int getColor(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
        BlockColor blockcolor = this.blockColors.byId(Registry.BLOCK.getId(pState.getBlock()));
        return blockcolor == null ? -1 : blockcolor.getColor(pState, pLevel, pPos, pTintIndex);
    }

    public void a(BlockColor p_92590_, Block ... p_92591_) {
        Block[] blockArray = p_92591_;
        int n = p_92591_.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            this.blockColors.addMapping(p_92590_, Registry.BLOCK.getId(block));
            ++n2;
        }
    }

    private void a(Set<Property<?>> p_92593_, Block ... p_92594_) {
        Block[] blockArray = p_92594_;
        int n = p_92594_.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            this.coloringStates.put(block, p_92593_);
            ++n2;
        }
    }

    private void a(Property<?> p_92587_, Block ... p_92588_) {
        this.a((Set<Property<?>>)ImmutableSet.of(p_92587_), p_92588_);
    }

    public Set<Property<?>> getColoringProperties(Block pBlock) {
        return (Set)this.coloringStates.getOrDefault(pBlock, (Set<Property<?>>)ImmutableSet.of());
    }
}

