/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.color.item;

import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ItemColors {
    private static final int DEFAULT = -1;
    private final IdMapper<ItemColor> itemColors = new IdMapper(32);

    public static ItemColors createDefault(BlockColors pColors) {
        ItemColors itemcolors = new ItemColors();
        itemcolors.a((p_92708_, p_92709_) -> p_92709_ > 0 ? -1 : ((DyeableLeatherItem)((Object)p_92708_.getItem())).getColor(p_92708_), Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS, Items.LEATHER_HORSE_ARMOR);
        itemcolors.a((p_92705_, p_92706_) -> GrassColor.get(0.5, 1.0), Blocks.TALL_GRASS, Blocks.LARGE_FERN);
        itemcolors.a((p_92702_, p_92703_) -> {
            int[] aint;
            if (p_92703_ != 1) {
                return -1;
            }
            CompoundTag compoundtag = p_92702_.getTagElement("Explosion");
            int[] nArray = aint = compoundtag != null && compoundtag.contains("Colors", 11) ? compoundtag.getIntArray("Colors") : null;
            if (aint != null && aint.length != 0) {
                if (aint.length == 1) {
                    return aint[0];
                }
                int i = 0;
                int j = 0;
                int k = 0;
                int[] nArray2 = aint;
                int n = aint.length;
                int n2 = 0;
                while (n2 < n) {
                    int l = nArray2[n2];
                    i += (l & 0xFF0000) >> 16;
                    j += (l & 0xFF00) >> 8;
                    k += (l & 0xFF) >> 0;
                    ++n2;
                }
                return (i /= aint.length) << 16 | (j /= aint.length) << 8 | (k /= aint.length);
            }
            return 0x8A8A8A;
        }, Items.FIREWORK_STAR);
        itemcolors.a((p_92699_, p_92700_) -> p_92700_ > 0 ? -1 : PotionUtils.getColor(p_92699_), Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION);
        for (SpawnEggItem spawneggitem : SpawnEggItem.eggs()) {
            itemcolors.a((p_92681_, p_92682_) -> spawneggitem.getColor(p_92682_), spawneggitem);
        }
        itemcolors.a((p_92687_, p_92688_) -> {
            BlockState blockstate = ((BlockItem)p_92687_.getItem()).getBlock().defaultBlockState();
            return pColors.getColor(blockstate, null, null, p_92688_);
        }, Blocks.GRASS_BLOCK, Blocks.GRASS, Blocks.FERN, Blocks.VINE, Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES, Blocks.BIRCH_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.LILY_PAD);
        itemcolors.a((p_92696_, p_92697_) -> p_92697_ == 0 ? PotionUtils.getColor(p_92696_) : -1, Items.TIPPED_ARROW);
        itemcolors.a((p_92693_, p_92694_) -> p_92694_ == 0 ? -1 : MapItem.getColor(p_92693_), Items.FILLED_MAP);
        return itemcolors;
    }

    public int getColor(ItemStack pStack, int pTintIndex) {
        ItemColor itemcolor = this.itemColors.byId(Registry.ITEM.getId(pStack.getItem()));
        return itemcolor == null ? -1 : itemcolor.getColor(pStack, pTintIndex);
    }

    public void a(ItemColor p_92690_, ItemLike ... p_92691_) {
        ItemLike[] itemLikeArray = p_92691_;
        int n = p_92691_.length;
        int n2 = 0;
        while (n2 < n) {
            ItemLike itemlike = itemLikeArray[n2];
            this.itemColors.addMapping(p_92690_, Item.getId(itemlike.asItem()));
            ++n2;
        }
    }
}

