/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import hu.dominikhun250.diamondclient.CPSCounter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.ChatListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.chat.OverlayChatListener;
import net.minecraft.client.gui.chat.StandardChatListener;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.gui.components.spectator.SpectatorGui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.client.EffectRenderer;
import net.minecraftforge.client.IItemRenderProperties;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomItems;
import net.optifine.TextureAnimations;
import net.optifine.reflect.Reflector;
import org.apache.commons.lang3.StringUtils;

public class Gui
extends GuiComponent {
    private static final ResourceLocation VIGNETTE_LOCATION = new ResourceLocation("textures/misc/vignette.png");
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    private static final ResourceLocation PUMPKIN_BLUR_LOCATION = new ResourceLocation("textures/misc/pumpkinblur.png");
    private static final ResourceLocation SPYGLASS_SCOPE_LOCATION = new ResourceLocation("textures/misc/spyglass_scope.png");
    private static final ResourceLocation POWDER_SNOW_OUTLINE_LOCATION = new ResourceLocation("textures/misc/powder_snow_outline.png");
    private static final Component DEMO_EXPIRED_TEXT = new TranslatableComponent("demo.demoExpired");
    private static final Component SAVING_TEXT = new TranslatableComponent("menu.savingLevel");
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final float MIN_CROSSHAIR_ATTACK_SPEED = 5.0f;
    private static final int NUM_HEARTS_PER_ROW = 10;
    private static final int LINE_HEIGHT = 10;
    private static final String SPACER = ": ";
    private static final float PORTAL_OVERLAY_ALPHA_MIN = 0.2f;
    private static final int HEART_SIZE = 9;
    private static final int HEART_SEPARATION = 8;
    private static final float AUTOSAVE_FADE_SPEED_FACTOR = 0.2f;
    private final Random random = new Random();
    private final Minecraft minecraft;
    private final ItemRenderer itemRenderer;
    private final ChatComponent chat;
    private int tickCount;
    @Nullable
    private Component overlayMessageString;
    private int overlayMessageTime;
    private boolean animateOverlayMessageColor;
    public float vignetteBrightness = 1.0f;
    private int toolHighlightTimer;
    private ItemStack lastToolHighlight = ItemStack.EMPTY;
    private final DebugScreenOverlay debugScreen;
    private final SubtitleOverlay subtitleOverlay;
    private final SpectatorGui spectatorGui;
    private final PlayerTabOverlay tabList;
    private final BossHealthOverlay bossOverlay;
    private int titleTime;
    @Nullable
    private Component title;
    @Nullable
    private Component subtitle;
    private int titleFadeInTime;
    private int titleStayTime;
    private int titleFadeOutTime;
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;
    private int screenWidth;
    private int screenHeight;
    private float autosaveIndicatorValue;
    private float lastAutosaveIndicatorValue;
    private final Map<ChatType, List<ChatListener>> chatListeners = Maps.newHashMap();
    private float scopeScale;

    public Gui(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
        this.itemRenderer = pMinecraft.getItemRenderer();
        this.debugScreen = new DebugScreenOverlay(pMinecraft);
        this.spectatorGui = new SpectatorGui(pMinecraft);
        this.chat = new ChatComponent(pMinecraft);
        this.tabList = new PlayerTabOverlay(pMinecraft, this);
        this.bossOverlay = new BossHealthOverlay(pMinecraft);
        this.subtitleOverlay = new SubtitleOverlay(pMinecraft);
        ChatType[] chatTypeArray = ChatType.values();
        int n = chatTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatType chattype = chatTypeArray[n2];
            this.chatListeners.put(chattype, Lists.newArrayList());
            ++n2;
        }
        NarratorChatListener chatlistener = NarratorChatListener.INSTANCE;
        this.chatListeners.get((Object)ChatType.CHAT).add(new StandardChatListener(pMinecraft));
        this.chatListeners.get((Object)ChatType.CHAT).add(chatlistener);
        this.chatListeners.get((Object)ChatType.SYSTEM).add(new StandardChatListener(pMinecraft));
        this.chatListeners.get((Object)ChatType.SYSTEM).add(chatlistener);
        this.chatListeners.get((Object)ChatType.GAME_INFO).add(new OverlayChatListener(pMinecraft));
        this.resetTitleTimes();
    }

    public void resetTitleTimes() {
        this.titleFadeInTime = 10;
        this.titleStayTime = 70;
        this.titleFadeOutTime = 20;
    }

    private String toRoman(int number) {
        if (number < 1) {
            return "";
        }
        if (number >= 1000) {
            return "M" + this.toRoman(number - 1000);
        }
        if (number >= 900) {
            return "CM" + this.toRoman(number - 900);
        }
        if (number >= 500) {
            return "D" + this.toRoman(number - 500);
        }
        if (number >= 400) {
            return "CD" + this.toRoman(number - 400);
        }
        if (number >= 100) {
            return "C" + this.toRoman(number - 100);
        }
        if (number >= 90) {
            return "XC" + this.toRoman(number - 90);
        }
        if (number >= 50) {
            return "L" + this.toRoman(number - 50);
        }
        if (number >= 40) {
            return "XL" + this.toRoman(number - 40);
        }
        if (number >= 10) {
            return "X" + this.toRoman(number - 10);
        }
        if (number >= 9) {
            return "IX" + this.toRoman(number - 9);
        }
        if (number >= 5) {
            return "V" + this.toRoman(number - 5);
        }
        if (number >= 4) {
            return "IV" + this.toRoman(number - 4);
        }
        if (number >= 1) {
            return "I" + this.toRoman(number - 1);
        }
        return "";
    }

    private String formatDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return String.format("%02d:%02d", minutes, seconds %= 60);
    }

    public void render(PoseStack pPoseStack, float pPartialTick) {
        float f2;
        PlayerInfo playerInfo;
        Object type;
        Collection<MobEffectInstance> effects;
        this.screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        this.screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        LocalPlayer player = this.minecraft.player;
        if (player != null && !this.minecraft.options.hideGui && !(effects = player.getActiveEffects()).isEmpty()) {
            int x = this.screenWidth - 70;
            int y = this.screenHeight - 30;
            MobEffectTextureManager textureManager = this.minecraft.getMobEffectTextures();
            Font font = this.minecraft.font;
            ArrayList<MobEffectInstance> effectList = new ArrayList<MobEffectInstance>(effects);
            int i = effectList.size() - 1;
            while (i >= 0) {
                MobEffectInstance effect = (MobEffectInstance)effectList.get(i);
                type = effect.getEffect();
                TextureAtlasSprite sprite = textureManager.get((MobEffect)type);
                int amplifier = effect.getAmplifier();
                int duration = effect.getDuration();
                RenderSystem.setShaderTexture(0, sprite.atlas().location());
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                Gui.blit(pPoseStack, x, y, this.getBlitOffset(), 18, 18, sprite);
                String level = this.toRoman(amplifier + 1);
                String time = this.formatDuration(duration);
                font.drawShadow(pPoseStack, String.valueOf(level) + SPACER + time, (float)(x + 20), (float)(y + 4), 0xFFFFFF);
                y -= 24;
                --i;
            }
        }
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int startX = 10;
        int startY = screenHeight / 2 - 30;
        ItemStack offhandItem = this.minecraft.player.getOffhandItem();
        if (!offhandItem.isEmpty()) {
            this.minecraft.getItemRenderer().renderGuiItem(offhandItem, startX, startY - 25);
            if (offhandItem.getMaxDamage() > 0) {
                int offhandDurability = (int)((float)(offhandItem.getMaxDamage() - offhandItem.getDamageValue()) / (float)offhandItem.getMaxDamage() * 100.0f);
                this.minecraft.font.drawShadow(pPoseStack, String.valueOf(offhandDurability) + "%", (float)(startX + 20), (float)(startY - 20), 0xFFFFFF);
            }
        }
        int i = 3;
        while (i >= 0) {
            ItemStack armorStack = this.minecraft.player.getInventory().armor.get(i);
            if (!armorStack.isEmpty()) {
                this.minecraft.getItemRenderer().renderGuiItem(armorStack, startX, startY + (3 - i) * 20);
                if (armorStack.getMaxDamage() > 0) {
                    int durability = (int)((float)(armorStack.getMaxDamage() - armorStack.getDamageValue()) / (float)armorStack.getMaxDamage() * 100.0f);
                    this.minecraft.font.drawShadow(pPoseStack, String.valueOf(durability) + "%", (float)(startX + 20), (float)(startY + 5 + (3 - i) * 20), 0xFFFFFF);
                }
            }
            --i;
        }
        ItemStack mainhandItem = this.minecraft.player.getMainHandItem();
        if (!mainhandItem.isEmpty()) {
            this.minecraft.getItemRenderer().renderGuiItem(mainhandItem, startX, startY + 85);
            if (mainhandItem.getMaxDamage() > 0) {
                int mainhandDurability = (int)((float)(mainhandItem.getMaxDamage() - mainhandItem.getDamageValue()) / (float)mainhandItem.getMaxDamage() * 100.0f);
                this.minecraft.font.drawShadow(pPoseStack, String.valueOf(mainhandDurability) + "%", (float)(startX + 20), (float)(startY + 90), 0xFFFFFF);
            }
        }
        int ping = 0;
        if (this.minecraft.player != null && this.minecraft.getConnection() != null && (playerInfo = this.minecraft.getConnection().getPlayerInfo(this.minecraft.player.getUUID())) != null) {
            ping = playerInfo.getLatency();
            type = "PING: " + ping + "ms";
        }
        ChatFormatting pingColor = ping <= 30 ? ChatFormatting.GREEN : (ping <= 70 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        int leftCPS = CPSCounter.getLeftCPS();
        int rightCPS = CPSCounter.getRightCPS();
        String cpsText = "CPS: " + leftCPS + " / " + rightCPS;
        if (!this.minecraft.options.hideGui) {
            String debugString = this.minecraft.fpsString;
            int fps = 0;
            try {
                String fpsPart = debugString.split(" ")[0];
                fps = Integer.parseInt(fpsPart);
            }
            catch (Exception e) {
                fps = 0;
            }
            ChatFormatting fpsColor = fps >= 60 ? ChatFormatting.GREEN : (fps >= 30 ? ChatFormatting.YELLOW : ChatFormatting.RED);
            Minecraft mc = Minecraft.getInstance();
            String text = "DiamondClient";
            int x = 5;
            int y = 5;
            Color color1 = new Color(0, 141, 255);
            Color color2 = new Color(0, 203, 255);
            long time = System.currentTimeMillis();
            int startX1 = x;
            int i2 = 0;
            while (i2 < text.length()) {
                float localAnim = (float)((Math.sin((double)time / 500.0 + (double)i2 * 0.3) + 1.0) / 2.0);
                int r = (int)((float)color1.getRed() * (1.0f - localAnim) + (float)color2.getRed() * localAnim);
                int g = (int)((float)color1.getGreen() * (1.0f - localAnim) + (float)color2.getGreen() * localAnim);
                int b = (int)((float)color1.getBlue() * (1.0f - localAnim) + (float)color2.getBlue() * localAnim);
                int color = 0xFF000000 | r << 16 | g << 8 | b;
                String s = String.valueOf(text.charAt(i2));
                this.getFont().draw(pPoseStack, s, (float)startX1, (float)y, color);
                startX1 += mc.font.width(s);
                ++i2;
            }
            MutableComponent lineText = new TextComponent(" | ").withStyle(ChatFormatting.WHITE);
            MutableComponent fpsText = new TextComponent(String.valueOf(fps) + " FPS").withStyle(fpsColor);
            MutableComponent cpsText1 = new TextComponent("CPS: " + leftCPS + " / " + rightCPS).withStyle(ChatFormatting.GRAY);
            MutableComponent pingText = new TextComponent(String.valueOf(ping) + "ms").withStyle(pingColor);
            MutableComponent combinedText = new TextComponent("").append(lineText).append(fpsText).append(lineText).append(cpsText1);
            this.getFont().drawShadow(pPoseStack, combinedText, (float)startX1, (float)y, 0xFFFFFF);
        }
        Minecraft mc = Minecraft.getInstance();
        int x = mc.getWindow().getGuiScaledWidth() - 30;
        int y = 5;
        MutableComponent pingText = new TextComponent(String.valueOf(ping) + "ms").withStyle(pingColor);
        int tps = Math.min(20, (int)(1000.0 / (double)mc.getFrameTime()));
        this.getFont().drawShadow(pPoseStack, pingText, (float)x, (float)y, 0xFFFFFF);
        Font font = this.getFont();
        RenderSystem.enableBlend();
        if (Config.isVignetteEnabled()) {
            this.renderVignette(this.minecraft.getCameraEntity());
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
        }
        float f = this.minecraft.getDeltaFrameTime();
        this.scopeScale = Mth.lerp(0.5f * f, this.scopeScale, 1.125f);
        if (this.minecraft.options.getCameraType().isFirstPerson()) {
            if (this.minecraft.player.isScoping()) {
                this.renderSpyglassOverlay(this.scopeScale);
            } else {
                this.scopeScale = 0.5f;
                ItemStack itemstack = this.minecraft.player.getInventory().getArmor(3);
                if (itemstack.is(Blocks.CARVED_PUMPKIN.asItem())) {
                    this.renderTextureOverlay(PUMPKIN_BLUR_LOCATION, 1.0f);
                }
            }
        }
        if (this.minecraft.player.getTicksFrozen() > 0) {
            this.renderTextureOverlay(POWDER_SNOW_OUTLINE_LOCATION, this.minecraft.player.getPercentFrozen());
        }
        if ((f2 = Mth.lerp(pPartialTick, this.minecraft.player.oPortalTime, this.minecraft.player.portalTime)) > 0.0f && !this.minecraft.player.hasEffect(MobEffects.CONFUSION)) {
            this.renderPortalOverlay(f2);
        }
        if (this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            this.spectatorGui.renderHotbar(pPoseStack);
        } else if (!this.minecraft.options.hideGui) {
            this.renderHotbar(pPartialTick, pPoseStack);
        }
        if (!this.minecraft.options.hideGui) {
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, GUI_ICONS_LOCATION);
            RenderSystem.enableBlend();
            this.renderCrosshair(pPoseStack);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            GlStateManager.enableAlphaTest();
            RenderSystem.defaultBlendFunc();
            this.minecraft.getProfiler().push("bossHealth");
            this.bossOverlay.render(pPoseStack);
            this.minecraft.getProfiler().pop();
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShaderTexture(0, GUI_ICONS_LOCATION);
            if (this.minecraft.gameMode.canHurtPlayer()) {
                this.renderPlayerHealth(pPoseStack);
            }
            this.renderVehicleHealth(pPoseStack);
            RenderSystem.disableBlend();
            int i3 = this.screenWidth / 2 - 91;
            if (this.minecraft.player.isRidingJumpable()) {
                this.renderJumpMeter(pPoseStack, i3);
            } else if (this.minecraft.gameMode.hasExperience()) {
                this.renderExperienceBar(pPoseStack, i3);
            }
            if (this.minecraft.options.heldItemTooltips && this.minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR) {
                this.renderSelectedItemName(pPoseStack);
            } else if (this.minecraft.player.isSpectator()) {
                this.spectatorGui.renderTooltip(pPoseStack);
            }
        }
        if (this.minecraft.player.getSleepTimer() > 0) {
            this.minecraft.getProfiler().push("sleep");
            RenderSystem.disableDepthTest();
            float f3 = this.minecraft.player.getSleepTimer();
            float f1 = f3 / 100.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f - (f3 - 100.0f) / 10.0f;
            }
            int j = (int)(220.0f * f1) << 24 | 0x101020;
            Gui.fill(pPoseStack, 0, 0, this.screenWidth, this.screenHeight, j);
            RenderSystem.enableDepthTest();
            this.minecraft.getProfiler().pop();
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.minecraft.isDemo()) {
            this.renderDemoOverlay(pPoseStack);
        }
        this.renderEffects(pPoseStack);
        if (this.minecraft.options.renderDebug) {
            this.debugScreen.render(pPoseStack);
        }
        if (!this.minecraft.options.hideGui) {
            Objective objective1;
            int j2;
            if (this.overlayMessageString != null && this.overlayMessageTime > 0) {
                this.minecraft.getProfiler().push("overlayMessage");
                float f4 = (float)this.overlayMessageTime - pPartialTick;
                int i1 = (int)(f4 * 255.0f / 20.0f);
                if (i1 > 255) {
                    i1 = 255;
                }
                if (i1 > 8) {
                    pPoseStack.pushPose();
                    pPoseStack.translate(this.screenWidth / 2, this.screenHeight - 68, 0.0);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    int k1 = 0xFFFFFF;
                    if (this.animateOverlayMessageColor) {
                        k1 = Mth.hsvToRgb(f4 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                    }
                    int k = i1 << 24 & 0xFF000000;
                    int l = font.width(this.overlayMessageString);
                    this.drawBackdrop(pPoseStack, font, -4, l, 0xFFFFFF | k);
                    font.draw(pPoseStack, this.overlayMessageString, (float)(-l / 2), -4.0f, k1 | k);
                    RenderSystem.disableBlend();
                    pPoseStack.popPose();
                }
                this.minecraft.getProfiler().pop();
            }
            if (this.title != null && this.titleTime > 0) {
                this.minecraft.getProfiler().push("titleAndSubtitle");
                float f5 = (float)this.titleTime - pPartialTick;
                int j1 = 255;
                if (this.titleTime > this.titleFadeOutTime + this.titleStayTime) {
                    float f6 = (float)(this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime) - f5;
                    j1 = (int)(f6 * 255.0f / (float)this.titleFadeInTime);
                }
                if (this.titleTime <= this.titleFadeOutTime) {
                    j1 = (int)(f5 * 255.0f / (float)this.titleFadeOutTime);
                }
                if ((j1 = Mth.clamp(j1, 0, 255)) > 8) {
                    pPoseStack.pushPose();
                    pPoseStack.translate(this.screenWidth / 2, this.screenHeight / 2, 0.0);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    pPoseStack.pushPose();
                    pPoseStack.scale(4.0f, 4.0f, 4.0f);
                    int l1 = j1 << 24 & 0xFF000000;
                    int i2 = font.width(this.title);
                    this.drawBackdrop(pPoseStack, font, -10, i2, 0xFFFFFF | l1);
                    font.drawShadow(pPoseStack, this.title, (float)(-i2 / 2), -10.0f, 0xFFFFFF | l1);
                    pPoseStack.popPose();
                    if (this.subtitle != null) {
                        pPoseStack.pushPose();
                        pPoseStack.scale(2.0f, 2.0f, 2.0f);
                        int k2 = font.width(this.subtitle);
                        this.drawBackdrop(pPoseStack, font, 5, k2, 0xFFFFFF | l1);
                        font.drawShadow(pPoseStack, this.subtitle, (float)(-k2 / 2), 5.0f, 0xFFFFFF | l1);
                        pPoseStack.popPose();
                    }
                    RenderSystem.disableBlend();
                    pPoseStack.popPose();
                }
                this.minecraft.getProfiler().pop();
            }
            this.subtitleOverlay.render(pPoseStack);
            Scoreboard scoreboard = this.minecraft.level.getScoreboard();
            Objective objective = null;
            PlayerTeam playerteam = scoreboard.getPlayersTeam(this.minecraft.player.getScoreboardName());
            if (playerteam != null && (j2 = playerteam.getColor().getId()) >= 0) {
                objective = scoreboard.getDisplayObjective(3 + j2);
            }
            Objective objective2 = objective1 = objective != null ? objective : scoreboard.getDisplayObjective(1);
            if (objective1 != null) {
                this.displayScoreboardSidebar(pPoseStack, objective1);
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, this.screenHeight - 48, 0.0);
            this.minecraft.getProfiler().push("chat");
            this.chat.render(pPoseStack, this.tickCount);
            this.minecraft.getProfiler().pop();
            pPoseStack.popPose();
            objective1 = scoreboard.getDisplayObjective(0);
            if (this.minecraft.options.keyPlayerList.isDown() && (!this.minecraft.isLocalServer() || this.minecraft.player.connection.getOnlinePlayers().size() > 1 || objective1 != null)) {
                this.tabList.setVisible(true);
                this.tabList.render(pPoseStack, this.screenWidth, scoreboard, objective1);
            } else {
                this.tabList.setVisible(false);
            }
            this.renderSavingIndicator(pPoseStack);
        }
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drawBackdrop(PoseStack p_93040_, Font p_93041_, int p_93042_, int p_93043_, int p_93044_) {
        int i = this.minecraft.options.getBackgroundColor(0.0f);
        if (i != 0) {
            int j = -p_93043_ / 2;
            Gui.fill(p_93040_, j - 2, p_93042_ - 2, j + p_93043_ + 2, p_93042_ + 9 + 2, FastColor.ARGB32.multiply(i, p_93044_));
        }
    }

    private void renderCrosshair(PoseStack pPoseStack) {
        Options options = this.minecraft.options;
        if (options.getCameraType().isFirstPerson() && (this.minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR || this.canRenderCrosshairForSpectator(this.minecraft.hitResult))) {
            if (options.renderDebug && !options.hideGui && !this.minecraft.player.isReducedDebugInfo() && !options.reducedDebugInfo) {
                Camera camera = this.minecraft.gameRenderer.getMainCamera();
                PoseStack posestack = RenderSystem.getModelViewStack();
                posestack.pushPose();
                posestack.translate(this.screenWidth / 2, this.screenHeight / 2, this.getBlitOffset());
                posestack.mulPose(Vector3f.XN.rotationDegrees(camera.getXRot()));
                posestack.mulPose(Vector3f.YP.rotationDegrees(camera.getYRot()));
                posestack.scale(-1.0f, -1.0f, -1.0f);
                RenderSystem.applyModelViewMatrix();
                RenderSystem.renderCrosshair(10);
                posestack.popPose();
                RenderSystem.applyModelViewMatrix();
            } else {
                RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                int i = 15;
                this.blit(pPoseStack, (this.screenWidth - 15) / 2, (this.screenHeight - 15) / 2, 0, 0, 15, 15);
                if (this.minecraft.options.attackIndicator == AttackIndicatorStatus.CROSSHAIR) {
                    float f = this.minecraft.player.getAttackStrengthScale(0.0f);
                    boolean flag = false;
                    if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && f >= 1.0f) {
                        flag = this.minecraft.player.getCurrentItemAttackStrengthDelay() > 5.0f;
                        flag &= this.minecraft.crosshairPickEntity.isAlive();
                    }
                    int j = this.screenHeight / 2 - 7 + 16;
                    int k = this.screenWidth / 2 - 8;
                    if (flag) {
                        this.blit(pPoseStack, k, j, 68, 94, 16, 16);
                    } else if (f < 1.0f) {
                        int l = (int)(f * 17.0f);
                        this.blit(pPoseStack, k, j, 36, 94, 16, 4);
                        this.blit(pPoseStack, k, j, 52, 94, l, 4);
                    }
                }
            }
        }
    }

    private boolean canRenderCrosshairForSpectator(HitResult pRayTrace) {
        if (pRayTrace == null) {
            return false;
        }
        if (pRayTrace.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)pRayTrace).getEntity() instanceof MenuProvider;
        }
        if (pRayTrace.getType() == HitResult.Type.BLOCK) {
            ClientLevel level = this.minecraft.level;
            BlockPos blockpos = ((BlockHitResult)pRayTrace).getBlockPos();
            return level.getBlockState(blockpos).getMenuProvider(level, blockpos) != null;
        }
        return false;
    }

    protected void renderEffects(PoseStack pPoseStack) {
        Collection<MobEffectInstance> collection = this.minecraft.player.getActiveEffects();
        if (!collection.isEmpty()) {
            EffectRenderingInventoryScreen effectrenderinginventoryscreen;
            Screen screen = this.minecraft.screen;
            if (screen instanceof EffectRenderingInventoryScreen && (effectrenderinginventoryscreen = (EffectRenderingInventoryScreen)screen).canSeeEffects()) {
                return;
            }
            RenderSystem.enableBlend();
            int k1 = 0;
            int i = 0;
            MobEffectTextureManager mobeffecttexturemanager = this.minecraft.getMobEffectTextures();
            ArrayList list = Lists.newArrayListWithExpectedSize((int)collection.size());
            RenderSystem.setShaderTexture(0, AbstractContainerScreen.INVENTORY_LOCATION);
            Iterator iterator = Ordering.natural().reverse().sortedCopy(collection).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    list.forEach(Runnable::run);
                    RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                MobEffectInstance mobeffectinstance = (MobEffectInstance)iterator.next();
                MobEffect mobeffect = mobeffectinstance.getEffect();
                EffectRenderer effectrenderer = null;
                if (Reflector.RenderProperties_getEffectRendererMEI.exists()) {
                    effectrenderer = (EffectRenderer)Reflector.RenderProperties_getEffectRendererMEI.call((Object)mobeffectinstance);
                    if (!effectrenderer.shouldRenderHUD(mobeffectinstance)) continue;
                    RenderSystem.setShaderTexture(0, AbstractContainerScreen.INVENTORY_LOCATION);
                }
                if (!mobeffectinstance.showIcon()) continue;
                int j = this.screenWidth;
                int k = 1;
                if (this.minecraft.isDemo()) {
                    k += 15;
                }
                if (mobeffect.isBeneficial()) {
                    j -= 25 * ++k1;
                } else {
                    j -= 25 * ++i;
                    k += 26;
                }
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                float f = 1.0f;
                if (mobeffectinstance.isAmbient()) {
                    this.blit(pPoseStack, j, k, 165, 166, 24, 24);
                } else {
                    this.blit(pPoseStack, j, k, 141, 166, 24, 24);
                    if (mobeffectinstance.getDuration() <= 200) {
                        int l = 10 - mobeffectinstance.getDuration() / 20;
                        f = Mth.clamp((float)mobeffectinstance.getDuration() / 10.0f / 5.0f * 0.5f, 0.0f, 0.5f) + Mth.cos((float)mobeffectinstance.getDuration() * (float)Math.PI / 5.0f) * Mth.clamp((float)l / 10.0f * 0.25f, 0.0f, 0.25f);
                    }
                }
                TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.get(mobeffect);
                int i1 = j;
                int j1 = k;
                float f1 = f;
                list.add(() -> {
                    RenderSystem.setShaderTexture(0, textureatlassprite.atlas().location());
                    RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, f1);
                    Gui.blit(pPoseStack, i1 + 3, j1 + 3, this.getBlitOffset(), 18, 18, textureatlassprite);
                });
                if (effectrenderer == null) continue;
                effectrenderer.renderHUDEffect(mobeffectinstance, this, pPoseStack, j, k, this.getBlitOffset(), f);
            }
        }
    }

    private void renderHotbar(float pPartialTick, PoseStack pPoseStack) {
        Player player = this.getCameraPlayer();
        if (player != null) {
            float f;
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, WIDGETS_LOCATION);
            ItemStack itemstack = player.getOffhandItem();
            HumanoidArm humanoidarm = player.getMainArm().getOpposite();
            int i = this.screenWidth / 2;
            int j = this.getBlitOffset();
            int k = 182;
            int l = 91;
            this.setBlitOffset(-90);
            this.blit(pPoseStack, i - 91, this.screenHeight - 22, 0, 0, 182, 22);
            this.blit(pPoseStack, i - 91 - 1 + player.getInventory().selected * 20, this.screenHeight - 22 - 1, 0, 22, 24, 22);
            if (!itemstack.isEmpty()) {
                if (humanoidarm == HumanoidArm.LEFT) {
                    this.blit(pPoseStack, i - 91 - 29, this.screenHeight - 23, 24, 22, 29, 24);
                } else {
                    this.blit(pPoseStack, i + 91, this.screenHeight - 23, 53, 22, 29, 24);
                }
            }
            this.setBlitOffset(j);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int i1 = 1;
            CustomItems.setRenderOffHand(false);
            int j1 = 0;
            while (j1 < 9) {
                int k1 = i - 90 + j1 * 20 + 2;
                int l1 = this.screenHeight - 16 - 3;
                this.renderSlot(k1, l1, pPartialTick, player, player.getInventory().items.get(j1), i1++);
                ++j1;
            }
            if (!itemstack.isEmpty()) {
                CustomItems.setRenderOffHand(true);
                int j2 = this.screenHeight - 16 - 3;
                if (humanoidarm == HumanoidArm.LEFT) {
                    this.renderSlot(i - 91 - 26, j2, pPartialTick, player, itemstack, i1++);
                } else {
                    this.renderSlot(i + 91 + 10, j2, pPartialTick, player, itemstack, i1++);
                }
                CustomItems.setRenderOffHand(false);
            }
            if (this.minecraft.options.attackIndicator == AttackIndicatorStatus.HOTBAR && (f = this.minecraft.player.getAttackStrengthScale(0.0f)) < 1.0f) {
                int k2 = this.screenHeight - 20;
                int l2 = i + 91 + 6;
                if (humanoidarm == HumanoidArm.RIGHT) {
                    l2 = i - 91 - 22;
                }
                RenderSystem.setShaderTexture(0, GuiComponent.GUI_ICONS_LOCATION);
                int i2 = (int)(f * 19.0f);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                this.blit(pPoseStack, l2, k2, 0, 94, 18, 18);
                this.blit(pPoseStack, l2, k2 + 18 - i2, 18, 112 - i2, 18, i2);
            }
            RenderSystem.disableBlend();
        }
    }

    public void renderJumpMeter(PoseStack pPoseStack, int pX) {
        this.minecraft.getProfiler().push("jumpBar");
        RenderSystem.setShaderTexture(0, GuiComponent.GUI_ICONS_LOCATION);
        float f = this.minecraft.player.getJumpRidingScale();
        int i = 182;
        int j = (int)(f * 183.0f);
        int k = this.screenHeight - 32 + 3;
        this.blit(pPoseStack, pX, k, 0, 84, 182, 5);
        if (j > 0) {
            this.blit(pPoseStack, pX, k, 0, 89, j, 5);
        }
        this.minecraft.getProfiler().pop();
    }

    public void renderExperienceBar(PoseStack pPoseStack, int pXPos) {
        this.minecraft.getProfiler().push("expBar");
        RenderSystem.setShaderTexture(0, GuiComponent.GUI_ICONS_LOCATION);
        int i = this.minecraft.player.getXpNeededForNextLevel();
        if (i > 0) {
            int j = 182;
            int k = (int)(this.minecraft.player.experienceProgress * 183.0f);
            int l = this.screenHeight - 32 + 3;
            this.blit(pPoseStack, pXPos, l, 0, 64, 182, 5);
            if (k > 0) {
                this.blit(pPoseStack, pXPos, l, 0, 69, k, 5);
            }
        }
        this.minecraft.getProfiler().pop();
        if (this.minecraft.player.experienceLevel > 0) {
            this.minecraft.getProfiler().push("expLevel");
            int j1 = 8453920;
            if (Config.isCustomColors()) {
                j1 = CustomColors.getExpBarTextColor(j1);
            }
            String s = "" + this.minecraft.player.experienceLevel;
            int k1 = (this.screenWidth - this.getFont().width(s)) / 2;
            int i1 = this.screenHeight - 31 - 4;
            this.getFont().draw(pPoseStack, s, (float)(k1 + 1), (float)i1, 0);
            this.getFont().draw(pPoseStack, s, (float)(k1 - 1), (float)i1, 0);
            this.getFont().draw(pPoseStack, s, (float)k1, (float)(i1 + 1), 0);
            this.getFont().draw(pPoseStack, s, (float)k1, (float)(i1 - 1), 0);
            this.getFont().draw(pPoseStack, s, (float)k1, (float)i1, j1);
            this.minecraft.getProfiler().pop();
        }
    }

    public void renderSelectedItemName(PoseStack pPoseStack) {
        this.minecraft.getProfiler().push("selectedItemName");
        if (this.toolHighlightTimer > 0 && !this.lastToolHighlight.isEmpty()) {
            int l;
            MutableComponent mutablecomponent = new TextComponent("").append(this.lastToolHighlight.getHoverName()).withStyle(this.lastToolHighlight.getRarity().color);
            if (this.lastToolHighlight.hasCustomHoverName()) {
                mutablecomponent.withStyle(ChatFormatting.ITALIC);
            }
            Component component = mutablecomponent;
            if (Reflector.IForgeItemStack_getHighlightTip.exists()) {
                component = (Component)Reflector.call(this.lastToolHighlight, Reflector.IForgeItemStack_getHighlightTip, mutablecomponent);
            }
            int i = this.getFont().width(component);
            int j = (this.screenWidth - i) / 2;
            int k = this.screenHeight - 59;
            if (!this.minecraft.gameMode.canHurtPlayer()) {
                k += 14;
            }
            if ((l = (int)((float)this.toolHighlightTimer * 256.0f / 10.0f)) > 255) {
                l = 255;
            }
            if (l > 0) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Gui.fill(pPoseStack, j - 2, k - 2, j + i + 2, k + 9 + 2, this.minecraft.options.getBackgroundColor(0));
                Font font = null;
                if (Reflector.RenderProperties_getIS.exists()) {
                    IItemRenderProperties iitemrenderproperties = (IItemRenderProperties)Reflector.RenderProperties_getIS.call((Object)this.lastToolHighlight);
                    font = iitemrenderproperties.getFont(this.lastToolHighlight);
                }
                if (font != null) {
                    i = (this.screenWidth - font.width(component)) / 2;
                    font.draw(pPoseStack, component.getVisualOrderText(), (float)j, (float)k, 0xFFFFFF + (l << 24));
                } else {
                    this.getFont().drawShadow(pPoseStack, component, (float)j, (float)k, 0xFFFFFF + (l << 24));
                }
                RenderSystem.disableBlend();
            }
        }
        this.minecraft.getProfiler().pop();
    }

    public void renderDemoOverlay(PoseStack pPoseStack) {
        this.minecraft.getProfiler().push("demo");
        Component component = this.minecraft.level.getGameTime() >= 120500L ? DEMO_EXPIRED_TEXT : new TranslatableComponent("demo.remainingTime", StringUtil.formatTickDuration((int)(120500L - this.minecraft.level.getGameTime())));
        int i = this.getFont().width(component);
        this.getFont().drawShadow(pPoseStack, component, (float)(this.screenWidth - i - 10), 5.0f, 0xFFFFFF);
        this.minecraft.getProfiler().pop();
    }

    private void displayScoreboardSidebar(PoseStack pPoseStack, Objective pObjective) {
        int i;
        Scoreboard scoreboard = pObjective.getScoreboard();
        List<Object> collection = scoreboard.getPlayerScores(pObjective);
        List list = collection.stream().filter(p_93026_0_ -> p_93026_0_.getOwner() != null && !p_93026_0_.getOwner().startsWith("#")).collect(Collectors.toList());
        collection = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(collection.size() - 15))) : list;
        ArrayList list1 = Lists.newArrayListWithCapacity((int)collection.size());
        Component component = pObjective.getDisplayName();
        int j = i = this.getFont().width(component);
        int k = this.getFont().width(SPACER);
        for (Score score : collection) {
            PlayerTeam playerteam = scoreboard.getPlayersTeam(score.getOwner());
            MutableComponent component1 = PlayerTeam.formatNameForTeam(playerteam, new TextComponent(score.getOwner()));
            list1.add(Pair.of((Object)score, (Object)component1));
            j = Math.max(j, this.getFont().width(component1) + k + this.getFont().width(Integer.toString(score.getScore())));
        }
        int i2 = collection.size() * 9;
        int j2 = this.screenHeight / 2 + i2 / 3;
        int k2 = 3;
        int l2 = this.screenWidth - j - 3;
        int l = 0;
        int i1 = this.minecraft.options.getBackgroundColor(0.3f);
        int j1 = this.minecraft.options.getBackgroundColor(0.4f);
        for (Pair pair : list1) {
            Score score1 = (Score)pair.getFirst();
            Component component2 = (Component)pair.getSecond();
            String s = "" + (Object)((Object)ChatFormatting.RED) + score1.getScore();
            int k1 = j2 - ++l * 9;
            int l1 = this.screenWidth - 3 + 2;
            Gui.fill(pPoseStack, l2 - 2, k1, l1, k1 + 9, i1);
            this.getFont().draw(pPoseStack, component2, (float)l2, (float)k1, -1);
            this.getFont().draw(pPoseStack, s, (float)(l1 - this.getFont().width(s)), (float)k1, -1);
            if (l != collection.size()) continue;
            Gui.fill(pPoseStack, l2 - 2, k1 - 9 - 1, l1, k1 - 1, j1);
            Gui.fill(pPoseStack, l2 - 2, k1 - 1, l1, k1, i1);
            this.getFont().draw(pPoseStack, component, (float)(l2 + j / 2 - i / 2), (float)(k1 - 9), -1);
        }
    }

    private Player getCameraPlayer() {
        return !(this.minecraft.getCameraEntity() instanceof Player) ? null : (Player)this.minecraft.getCameraEntity();
    }

    private LivingEntity getPlayerVehicleWithHealth() {
        Player player = this.getCameraPlayer();
        if (player != null) {
            Entity entity = player.getVehicle();
            if (entity == null) {
                return null;
            }
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    private int getVehicleMaxHearts(LivingEntity pMountEntity) {
        if (pMountEntity != null && pMountEntity.showVehicleHealth()) {
            float f = pMountEntity.getMaxHealth();
            int i = (int)(f + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }

    private int getVisibleVehicleHeartRows(int pMountHealth) {
        return (int)Math.ceil((double)pMountHealth / 10.0);
    }

    private void renderPlayerHealth(PoseStack pPoseStack) {
        Player player = this.getCameraPlayer();
        if (player != null) {
            int i = Mth.ceil(player.getHealth());
            boolean flag = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
            long j = Util.getMillis();
            if (i < this.lastHealth && player.invulnerableTime > 0) {
                this.lastHealthTime = j;
                this.healthBlinkTime = this.tickCount + 20;
            } else if (i > this.lastHealth && player.invulnerableTime > 0) {
                this.lastHealthTime = j;
                this.healthBlinkTime = this.tickCount + 10;
            }
            if (j - this.lastHealthTime > 1000L) {
                this.lastHealth = i;
                this.displayHealth = i;
                this.lastHealthTime = j;
            }
            this.lastHealth = i;
            int k = this.displayHealth;
            this.random.setSeed(this.tickCount * 312871);
            FoodData fooddata = player.getFoodData();
            int l = fooddata.getFoodLevel();
            int i1 = this.screenWidth / 2 - 91;
            int j1 = this.screenWidth / 2 + 91;
            int k1 = this.screenHeight - 39;
            float f = Math.max((float)player.getAttributeValue(Attributes.MAX_HEALTH), (float)Math.max(k, i));
            int l1 = Mth.ceil(player.getAbsorptionAmount());
            int i2 = Mth.ceil((f + (float)l1) / 2.0f / 10.0f);
            int j2 = Math.max(10 - (i2 - 2), 3);
            int k2 = k1 - (i2 - 1) * j2 - 10;
            int l2 = k1 - 10;
            int i3 = player.getArmorValue();
            int j3 = -1;
            if (player.hasEffect(MobEffects.REGENERATION)) {
                j3 = this.tickCount % Mth.ceil(f + 5.0f);
            }
            this.minecraft.getProfiler().push("armor");
            int k3 = 0;
            while (k3 < 10) {
                if (i3 > 0) {
                    int l3 = i1 + k3 * 8;
                    if (k3 * 2 + 1 < i3) {
                        this.blit(pPoseStack, l3, k2, 34, 9, 9, 9);
                    }
                    if (k3 * 2 + 1 == i3) {
                        this.blit(pPoseStack, l3, k2, 25, 9, 9, 9);
                    }
                    if (k3 * 2 + 1 > i3) {
                        this.blit(pPoseStack, l3, k2, 16, 9, 9, 9);
                    }
                }
                ++k3;
            }
            this.minecraft.getProfiler().popPush("health");
            this.renderHearts(pPoseStack, player, i1, k1, j2, j3, f, i, k, l1, flag);
            LivingEntity livingentity = this.getPlayerVehicleWithHealth();
            int k5 = this.getVehicleMaxHearts(livingentity);
            if (k5 == 0) {
                this.minecraft.getProfiler().popPush("food");
                int i4 = 0;
                while (i4 < 10) {
                    int j4 = k1;
                    int k4 = 16;
                    int l4 = 0;
                    if (player.hasEffect(MobEffects.HUNGER)) {
                        k4 += 36;
                        l4 = 13;
                    }
                    if (player.getFoodData().getSaturationLevel() <= 0.0f && this.tickCount % (l * 3 + 1) == 0) {
                        j4 = k1 + (this.random.nextInt(3) - 1);
                    }
                    int i5 = j1 - i4 * 8 - 9;
                    this.blit(pPoseStack, i5, j4, 16 + l4 * 9, 27, 9, 9);
                    if (i4 * 2 + 1 < l) {
                        this.blit(pPoseStack, i5, j4, k4 + 36, 27, 9, 9);
                    }
                    if (i4 * 2 + 1 == l) {
                        this.blit(pPoseStack, i5, j4, k4 + 45, 27, 9, 9);
                    }
                    ++i4;
                }
                l2 -= 10;
            }
            this.minecraft.getProfiler().popPush("air");
            int l5 = player.getMaxAirSupply();
            int i6 = Math.min(player.getAirSupply(), l5);
            if (player.isEyeInFluid(FluidTags.WATER) || i6 < l5) {
                int j6 = this.getVisibleVehicleHeartRows(k5) - 1;
                l2 -= j6 * 10;
                int k6 = Mth.ceil((double)(i6 - 2) * 10.0 / (double)l5);
                int l6 = Mth.ceil((double)i6 * 10.0 / (double)l5) - k6;
                int j5 = 0;
                while (j5 < k6 + l6) {
                    if (j5 < k6) {
                        this.blit(pPoseStack, j1 - j5 * 8 - 9, l2, 16, 18, 9, 9);
                    } else {
                        this.blit(pPoseStack, j1 - j5 * 8 - 9, l2, 25, 18, 9, 9);
                    }
                    ++j5;
                }
            }
            this.minecraft.getProfiler().pop();
        }
    }

    private void renderHearts(PoseStack p_168689_, Player p_168690_, int p_168691_, int p_168692_, int p_168693_, int p_168694_, float p_168695_, int p_168696_, int p_168697_, int p_168698_, boolean p_168699_) {
        HeartType gui$hearttype = HeartType.forPlayer(p_168690_);
        int i = 9 * (p_168690_.level.getLevelData().isHardcore() ? 5 : 0);
        int j = Mth.ceil((double)p_168695_ / 2.0);
        int k = Mth.ceil((double)p_168698_ / 2.0);
        int l = j * 2;
        int i1 = j + k - 1;
        while (i1 >= 0) {
            int k2;
            boolean flag;
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int l1 = p_168691_ + k1 * 8;
            int i2 = p_168692_ - j1 * p_168693_;
            if (p_168696_ + p_168698_ <= 4) {
                i2 += this.random.nextInt(2);
            }
            if (i1 < j && i1 == p_168694_) {
                i2 -= 2;
            }
            this.renderHeart(p_168689_, HeartType.CONTAINER, l1, i2, i, p_168699_, false);
            int j2 = i1 * 2;
            boolean bl = flag = i1 >= j;
            if (flag && (k2 = j2 - l) < p_168698_) {
                boolean flag1 = k2 + 1 == p_168698_;
                this.renderHeart(p_168689_, gui$hearttype == HeartType.WITHERED ? gui$hearttype : HeartType.ABSORBING, l1, i2, i, false, flag1);
            }
            if (p_168699_ && j2 < p_168697_) {
                boolean flag2 = j2 + 1 == p_168697_;
                this.renderHeart(p_168689_, gui$hearttype, l1, i2, i, true, flag2);
            }
            if (j2 < p_168696_) {
                boolean flag3 = j2 + 1 == p_168696_;
                this.renderHeart(p_168689_, gui$hearttype, l1, i2, i, false, flag3);
            }
            --i1;
        }
    }

    private void renderHeart(PoseStack p_168701_, HeartType p_168702_, int p_168703_, int p_168704_, int p_168705_, boolean p_168706_, boolean p_168707_) {
        this.blit(p_168701_, p_168703_, p_168704_, p_168702_.getX(p_168707_, p_168706_), p_168705_, 9, 9);
    }

    private void renderVehicleHealth(PoseStack pPoseStack) {
        int i;
        LivingEntity livingentity = this.getPlayerVehicleWithHealth();
        if (livingentity != null && (i = this.getVehicleMaxHearts(livingentity)) != 0) {
            int j = (int)Math.ceil(livingentity.getHealth());
            this.minecraft.getProfiler().popPush("mountHealth");
            int k = this.screenHeight - 39;
            int l = this.screenWidth / 2 + 91;
            int i1 = k;
            int j1 = 0;
            boolean flag = false;
            while (i > 0) {
                int k1 = Math.min(i, 10);
                i -= k1;
                int l1 = 0;
                while (l1 < k1) {
                    int i2 = 52;
                    int j2 = 0;
                    int k2 = l - l1 * 8 - 9;
                    this.blit(pPoseStack, k2, i1, 52 + j2 * 9, 9, 9, 9);
                    if (l1 * 2 + 1 + j1 < j) {
                        this.blit(pPoseStack, k2, i1, 88, 9, 9, 9);
                    }
                    if (l1 * 2 + 1 + j1 == j) {
                        this.blit(pPoseStack, k2, i1, 97, 9, 9, 9);
                    }
                    ++l1;
                }
                i1 -= 10;
                j1 += 20;
            }
        }
    }

    private void renderTextureOverlay(ResourceLocation pTextureLocation, float pAlpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, pAlpha);
        RenderSystem.setShaderTexture(0, pTextureLocation);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(0.0, this.screenHeight, -90.0).uv(0.0f, 1.0f).endVertex();
        bufferbuilder.vertex(this.screenWidth, this.screenHeight, -90.0).uv(1.0f, 1.0f).endVertex();
        bufferbuilder.vertex(this.screenWidth, 0.0, -90.0).uv(1.0f, 0.0f).endVertex();
        bufferbuilder.vertex(0.0, 0.0, -90.0).uv(0.0f, 0.0f).endVertex();
        tesselator.end();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderSpyglassOverlay(float p_168676_) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, SPYGLASS_SCOPE_LOCATION);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        float f = Math.min(this.screenWidth, this.screenHeight);
        float f1 = Math.min((float)this.screenWidth / f, (float)this.screenHeight / f) * p_168676_;
        float f2 = f * f1;
        float f3 = f * f1;
        float f4 = ((float)this.screenWidth - f2) / 2.0f;
        float f5 = ((float)this.screenHeight - f3) / 2.0f;
        float f6 = f4 + f2;
        float f7 = f5 + f3;
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(f4, f7, -90.0).uv(0.0f, 1.0f).endVertex();
        bufferbuilder.vertex(f6, f7, -90.0).uv(1.0f, 1.0f).endVertex();
        bufferbuilder.vertex(f6, f5, -90.0).uv(1.0f, 0.0f).endVertex();
        bufferbuilder.vertex(f4, f5, -90.0).uv(0.0f, 0.0f).endVertex();
        tesselator.end();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.disableTexture();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.vertex(0.0, this.screenHeight, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(this.screenWidth, this.screenHeight, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(this.screenWidth, f7, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(0.0, f7, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(0.0, f5, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(this.screenWidth, f5, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(this.screenWidth, 0.0, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(0.0, 0.0, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(0.0, f7, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(f4, f7, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(f4, f5, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(0.0, f5, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(f6, f7, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(this.screenWidth, f7, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(this.screenWidth, f5, -90.0).color(0, 0, 0, 255).endVertex();
        bufferbuilder.vertex(f6, f5, -90.0).color(0, 0, 0, 255).endVertex();
        tesselator.end();
        RenderSystem.enableTexture();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void updateVignetteBrightness(Entity pEntity) {
        if (pEntity != null) {
            float f = Mth.clamp(1.0f - pEntity.getBrightness(), 0.0f, 1.0f);
            this.vignetteBrightness += (f - this.vignetteBrightness) * 0.01f;
        }
    }

    private void renderVignette(Entity pEntity) {
        if (!Config.isVignetteEnabled()) {
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        } else {
            WorldBorder worldborder = this.minecraft.level.getWorldBorder();
            float f = (float)worldborder.getDistanceToBorder(pEntity);
            double d0 = Math.min(worldborder.getLerpSpeed() * (double)worldborder.getWarningTime() * 1000.0, Math.abs(worldborder.getLerpTarget() - worldborder.getSize()));
            double d1 = Math.max((double)worldborder.getWarningBlocks(), d0);
            f = (double)f < d1 ? 1.0f - (float)((double)f / d1) : 0.0f;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask(false);
            RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            if (f > 0.0f) {
                f = Mth.clamp(f, 0.0f, 1.0f);
                RenderSystem.setShaderColor(0.0f, f, f, 1.0f);
            } else {
                float f1 = this.vignetteBrightness;
                f1 = Mth.clamp(f1, 0.0f, 1.0f);
                RenderSystem.setShaderColor(f1, f1, f1, 1.0f);
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, VIGNETTE_LOCATION);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.getBuilder();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.vertex(0.0, this.screenHeight, -90.0).uv(0.0f, 1.0f).endVertex();
            bufferbuilder.vertex(this.screenWidth, this.screenHeight, -90.0).uv(1.0f, 1.0f).endVertex();
            bufferbuilder.vertex(this.screenWidth, 0.0, -90.0).uv(1.0f, 0.0f).endVertex();
            bufferbuilder.vertex(0.0, 0.0, -90.0).uv(0.0f, 0.0f).endVertex();
            tesselator.end();
            RenderSystem.depthMask(true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
        }
    }

    private void renderPortalOverlay(float pTimeInPortal) {
        if (pTimeInPortal < 1.0f) {
            pTimeInPortal *= pTimeInPortal;
            pTimeInPortal *= pTimeInPortal;
            pTimeInPortal = pTimeInPortal * 0.8f + 0.2f;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, pTimeInPortal);
        RenderSystem.setShaderTexture(0, TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        TextureAtlasSprite textureatlassprite = this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.NETHER_PORTAL.defaultBlockState());
        float f = textureatlassprite.getU0();
        float f1 = textureatlassprite.getV0();
        float f2 = textureatlassprite.getU1();
        float f3 = textureatlassprite.getV1();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(0.0, this.screenHeight, -90.0).uv(f, f3).endVertex();
        bufferbuilder.vertex(this.screenWidth, this.screenHeight, -90.0).uv(f2, f3).endVertex();
        bufferbuilder.vertex(this.screenWidth, 0.0, -90.0).uv(f2, f1).endVertex();
        bufferbuilder.vertex(0.0, 0.0, -90.0).uv(f, f1).endVertex();
        tesselator.end();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderSlot(int p_168678_, int p_168679_, float p_168680_, Player p_168681_, ItemStack p_168682_, int p_168683_) {
        if (!p_168682_.isEmpty()) {
            PoseStack posestack = RenderSystem.getModelViewStack();
            float f = (float)p_168682_.getPopTime() - p_168680_;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                posestack.pushPose();
                posestack.translate(p_168678_ + 8, p_168679_ + 12, 0.0);
                posestack.scale(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                posestack.translate(-(p_168678_ + 8), -(p_168679_ + 12), 0.0);
                RenderSystem.applyModelViewMatrix();
            }
            this.itemRenderer.renderAndDecorateItem(p_168681_, p_168682_, p_168678_, p_168679_, p_168683_);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            if (f > 0.0f) {
                posestack.popPose();
                RenderSystem.applyModelViewMatrix();
            }
            this.itemRenderer.renderGuiItemDecorations(this.minecraft.font, p_168682_, p_168678_, p_168679_);
        }
    }

    public void tick(boolean p_193833_) {
        this.tickAutosaveIndicator();
        if (!p_193833_) {
            this.tick();
        }
    }

    private void tick() {
        if (this.minecraft.level == null) {
            TextureAnimations.updateAnimations();
        }
        if (this.overlayMessageTime > 0) {
            --this.overlayMessageTime;
        }
        if (this.titleTime > 0) {
            --this.titleTime;
            if (this.titleTime <= 0) {
                this.title = null;
                this.subtitle = null;
            }
        }
        ++this.tickCount;
        Entity entity = this.minecraft.getCameraEntity();
        if (entity != null) {
            this.updateVignetteBrightness(entity);
        }
        if (this.minecraft.player != null) {
            ItemStack itemstack = this.minecraft.player.getInventory().getSelected();
            boolean flag = true;
            if (Reflector.IForgeItemStack_getHighlightTip.exists()) {
                Component component = (Component)Reflector.call(itemstack, Reflector.IForgeItemStack_getHighlightTip, itemstack.getHoverName());
                Component component1 = (Component)Reflector.call(this.lastToolHighlight, Reflector.IForgeItemStack_getHighlightTip, this.lastToolHighlight.getHoverName());
                flag = Config.equals(component, component1);
            }
            if (itemstack.isEmpty()) {
                this.toolHighlightTimer = 0;
            } else if (!this.lastToolHighlight.isEmpty() && itemstack.is(this.lastToolHighlight.getItem()) && itemstack.getHoverName().equals(this.lastToolHighlight.getHoverName()) && flag) {
                if (this.toolHighlightTimer > 0) {
                    --this.toolHighlightTimer;
                }
            } else {
                this.toolHighlightTimer = 40;
            }
            this.lastToolHighlight = itemstack;
        }
    }

    private void tickAutosaveIndicator() {
        IntegratedServer minecraftserver = this.minecraft.getSingleplayerServer();
        boolean flag = minecraftserver != null && minecraftserver.isCurrentlySaving();
        this.lastAutosaveIndicatorValue = this.autosaveIndicatorValue;
        this.autosaveIndicatorValue = Mth.lerp(0.2f, this.autosaveIndicatorValue, flag ? 1.0f : 0.0f);
    }

    public void setNowPlaying(Component p_93056_) {
        this.setOverlayMessage(new TranslatableComponent("record.nowPlaying", p_93056_), true);
    }

    public void setOverlayMessage(Component pComponent, boolean pAnimateColor) {
        this.overlayMessageString = pComponent;
        this.overlayMessageTime = 60;
        this.animateOverlayMessageColor = pAnimateColor;
    }

    public void setTimes(int pTitleFadeInTime, int pTitleStayTime, int pTitleFadeOutTime) {
        if (pTitleFadeInTime >= 0) {
            this.titleFadeInTime = pTitleFadeInTime;
        }
        if (pTitleStayTime >= 0) {
            this.titleStayTime = pTitleStayTime;
        }
        if (pTitleFadeOutTime >= 0) {
            this.titleFadeOutTime = pTitleFadeOutTime;
        }
        if (this.titleTime > 0) {
            this.titleTime = this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime;
        }
    }

    public void setSubtitle(Component pSubtitle) {
        this.subtitle = pSubtitle;
    }

    public void setTitle(Component pTitle) {
        this.title = pTitle;
        this.titleTime = this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime;
    }

    public void clear() {
        this.title = null;
        this.subtitle = null;
        this.titleTime = 0;
    }

    public UUID guessChatUUID(Component pComponent) {
        String s = StringDecomposer.getPlainText(pComponent);
        String s1 = StringUtils.substringBetween((String)s, (String)"<", (String)">");
        return s1 == null ? Util.NIL_UUID : this.minecraft.getPlayerSocialManager().getDiscoveredUUID(s1);
    }

    public void handleChat(ChatType pChatType, Component pComponent, UUID pSenderId) {
        if (!(this.minecraft.isBlocked(pSenderId) || this.minecraft.options.hideMatchedNames && this.minecraft.isBlocked(this.guessChatUUID(pComponent)))) {
            for (ChatListener chatlistener : this.chatListeners.get((Object)pChatType)) {
                chatlistener.handle(pChatType, pComponent, pSenderId);
            }
        }
    }

    public ChatComponent getChat() {
        return this.chat;
    }

    public int getGuiTicks() {
        return this.tickCount;
    }

    public Font getFont() {
        return this.minecraft.font;
    }

    public SpectatorGui getSpectatorGui() {
        return this.spectatorGui;
    }

    public PlayerTabOverlay getTabList() {
        return this.tabList;
    }

    public void onDisconnected() {
        this.tabList.reset();
        this.bossOverlay.reset();
        this.minecraft.getToasts().clear();
        this.minecraft.options.renderDebug = false;
        this.chat.clearMessages(true);
    }

    public BossHealthOverlay getBossOverlay() {
        return this.bossOverlay;
    }

    public void clearCache() {
        this.debugScreen.clearChunkCache();
    }

    private void renderSavingIndicator(PoseStack p_193835_) {
        int i;
        if (this.minecraft.options.showAutosaveIndicator && (this.autosaveIndicatorValue > 0.0f || this.lastAutosaveIndicatorValue > 0.0f) && (i = Mth.floor(255.0f * Mth.clamp(Mth.lerp(this.minecraft.getFrameTime(), this.lastAutosaveIndicatorValue, this.autosaveIndicatorValue), 0.0f, 1.0f))) > 8) {
            Font font = this.getFont();
            int j = font.width(SAVING_TEXT);
            int k = 0xFFFFFF | i << 24 & 0xFF000000;
            font.drawShadow(p_193835_, SAVING_TEXT, (float)(this.screenWidth - j - 10), (float)(this.screenHeight - 15), k);
        }
    }

    static enum HeartType {
        CONTAINER(0, false),
        NORMAL(2, true),
        POISIONED(4, true),
        WITHERED(6, true),
        ABSORBING(8, false),
        FROZEN(9, false);

        private final int index;
        private final boolean canBlink;

        private HeartType(int p_168729_, boolean p_168730_) {
            this.index = p_168729_;
            this.canBlink = p_168730_;
        }

        public int getX(boolean p_168735_, boolean p_168736_) {
            int i;
            if (this == CONTAINER) {
                i = p_168736_ ? 1 : 0;
            } else {
                int j = p_168735_ ? 1 : 0;
                int k = this.canBlink && p_168736_ ? 2 : 0;
                i = j + k;
            }
            return 16 + (this.index * 2 + i) * 9;
        }

        static HeartType forPlayer(Player pPlayer) {
            HeartType gui$hearttype = pPlayer.hasEffect(MobEffects.POISON) ? POISIONED : (pPlayer.hasEffect(MobEffects.WITHER) ? WITHERED : (pPlayer.isFullyFrozen() ? FROZEN : NORMAL));
            return gui$hearttype;
        }
    }
}

