/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class GuiComponent {
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("textures/gui/options_background.png");
    public static final ResourceLocation STATS_ICON_LOCATION = new ResourceLocation("textures/gui/container/stats_icons.png");
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private int blitOffset;

    protected void hLine(PoseStack pPoseStack, int pMinX, int pMaxX, int pY, int pColor) {
        if (pMaxX < pMinX) {
            int i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        GuiComponent.fill(pPoseStack, pMinX, pY, pMaxX + 1, pY + 1, pColor);
    }

    protected void vLine(PoseStack pPoseStack, int pX, int pMinY, int pMaxY, int pColor) {
        if (pMaxY < pMinY) {
            int i = pMinY;
            pMinY = pMaxY;
            pMaxY = i;
        }
        GuiComponent.fill(pPoseStack, pX, pMinY + 1, pX + 1, pMaxY, pColor);
    }

    public static void fill(PoseStack pPoseStack, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor) {
        GuiComponent.innerFill(pPoseStack.last().pose(), pMinX, pMinY, pMaxX, pMaxY, pColor);
    }

    private static void innerFill(Matrix4f pMatrix, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor) {
        if (pMinX < pMaxX) {
            int i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            int j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        float f3 = (float)(pColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(pColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(pColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(pColor & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.vertex(pMatrix, pMinX, pMaxY, 0.0f).color(f, f1, f2, f3).endVertex();
        bufferbuilder.vertex(pMatrix, pMaxX, pMaxY, 0.0f).color(f, f1, f2, f3).endVertex();
        bufferbuilder.vertex(pMatrix, pMaxX, pMinY, 0.0f).color(f, f1, f2, f3).endVertex();
        bufferbuilder.vertex(pMatrix, pMinX, pMinY, 0.0f).color(f, f1, f2, f3).endVertex();
        bufferbuilder.end();
        BufferUploader.end(bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void fillGradient(PoseStack pPoseStack, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo) {
        GuiComponent.fillGradient(pPoseStack, pX1, pY1, pX2, pY2, pColorFrom, pColorTo, this.blitOffset);
    }

    protected static void fillGradient(PoseStack pPoseStack, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        GuiComponent.fillGradient(pPoseStack.last().pose(), bufferbuilder, pX1, pY1, pX2, pY2, pBlitOffset, pColorFrom, pColorTo);
        tesselator.end();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    protected static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.vertex(pMatrix, pX2, pY1, pBlitOffset).color(f1, f2, f3, f).endVertex();
        pBuilder.vertex(pMatrix, pX1, pY1, pBlitOffset).color(f1, f2, f3, f).endVertex();
        pBuilder.vertex(pMatrix, pX1, pY2, pBlitOffset).color(f5, f6, f7, f4).endVertex();
        pBuilder.vertex(pMatrix, pX2, pY2, pBlitOffset).color(f5, f6, f7, f4).endVertex();
    }

    public static void drawCenteredString(PoseStack pPoseStack, Font pFont, String pText, int pX, int pY, int pColor) {
        pFont.drawShadow(pPoseStack, pText, (float)(pX - pFont.width(pText) / 2), (float)pY, pColor);
    }

    public static void drawCenteredString(PoseStack pPoseStack, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.getVisualOrderText();
        pFont.drawShadow(pPoseStack, formattedcharsequence, (float)(pX - pFont.width(formattedcharsequence) / 2), (float)pY, pColor);
    }

    public static void drawCenteredString(PoseStack pPoseStack, Font pFont, FormattedCharSequence pText, int pX, int pY, int pColor) {
        pFont.drawShadow(pPoseStack, pText, (float)(pX - pFont.width(pText) / 2), (float)pY, pColor);
    }

    public static void drawString(PoseStack pPoseStack, Font pFont, String pText, int pX, int pY, int pColor) {
        pFont.drawShadow(pPoseStack, pText, (float)pX, (float)pY, pColor);
    }

    public static void drawString(PoseStack pPoseStack, Font pFont, FormattedCharSequence pText, int pX, int pY, int pColor) {
        pFont.drawShadow(pPoseStack, pText, (float)pX, (float)pY, pColor);
    }

    public static void drawString(PoseStack pPoseStack, Font pFont, Component pText, int pX, int pY, int pColor) {
        pFont.drawShadow(pPoseStack, pText, (float)pX, (float)pY, pColor);
    }

    public void blitOutlineBlack(int pWidth, int pHeight, BiConsumer<Integer, Integer> pBoxXYConsumer) {
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pBoxXYConsumer.accept(pWidth + 1, pHeight);
        pBoxXYConsumer.accept(pWidth - 1, pHeight);
        pBoxXYConsumer.accept(pWidth, pHeight + 1);
        pBoxXYConsumer.accept(pWidth, pHeight - 1);
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pBoxXYConsumer.accept(pWidth, pHeight);
    }

    public static void blit(PoseStack p_93201_, int pPoseStack, int pX, int pY, int pUOffset, int pVOffset, TextureAtlasSprite pUWidth) {
        GuiComponent.innerBlit(p_93201_.last().pose(), pPoseStack, pPoseStack + pUOffset, pX, pX + pVOffset, pY, pUWidth.getU0(), pUWidth.getU1(), pUWidth.getV0(), pUWidth.getV1());
    }

    public void blit(PoseStack pPoseStack, int pX, int pY, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        GuiComponent.blit(pPoseStack, pX, pY, this.blitOffset, pUOffset, pVOffset, pUWidth, pVHeight, 256, 256);
    }

    public static void blit(PoseStack pPoseStack, int pX, int pY, int pBlitOffset, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureHeight, int pTextureWidth) {
        GuiComponent.innerBlit(pPoseStack, pX, pX + pUWidth, pY, pY + pVHeight, pBlitOffset, pUWidth, pVHeight, pUOffset, pVOffset, pTextureHeight, pTextureWidth);
    }

    public static void blit(PoseStack pPoseStack, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        GuiComponent.innerBlit(pPoseStack, pX, pX + pWidth, pY, pY + pHeight, 0, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight);
    }

    public static void blit(PoseStack pPoseStack, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        GuiComponent.blit(pPoseStack, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
    }

    private static void innerBlit(PoseStack pPoseStack, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, int pUWidth, int pVHeight, float pUOffset, float pVOffset, int pTextureWidth, int pTextureHeight) {
        GuiComponent.innerBlit(pPoseStack.last().pose(), pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / (float)pTextureWidth, (pUOffset + (float)pUWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight, (pVOffset + (float)pVHeight) / (float)pTextureHeight);
    }

    private static void innerBlit(Matrix4f pMatrix, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(pMatrix, pX1, pY2, pBlitOffset).uv(pMinU, pMaxV).endVertex();
        bufferbuilder.vertex(pMatrix, pX2, pY2, pBlitOffset).uv(pMaxU, pMaxV).endVertex();
        bufferbuilder.vertex(pMatrix, pX2, pY1, pBlitOffset).uv(pMaxU, pMinV).endVertex();
        bufferbuilder.vertex(pMatrix, pX1, pY1, pBlitOffset).uv(pMinU, pMinV).endVertex();
        bufferbuilder.end();
        BufferUploader.end(bufferbuilder);
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public void setBlitOffset(int pBlitOffset) {
        this.blitOffset = pBlitOffset;
    }
}

