/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapRenderer
implements AutoCloseable {
    private static final ResourceLocation MAP_ICONS_LOCATION = new ResourceLocation("textures/map/map_icons.png");
    static final RenderType MAP_ICONS = RenderType.text(MAP_ICONS_LOCATION);
    private static final int WIDTH = 128;
    private static final int HEIGHT = 128;
    final TextureManager textureManager;
    private final Int2ObjectMap<MapInstance> maps = new Int2ObjectOpenHashMap();

    public MapRenderer(TextureManager pTextureManager) {
        this.textureManager = pTextureManager;
    }

    public void update(int p_168766_, MapItemSavedData p_168767_) {
        this.getOrCreateMapInstance(p_168766_, p_168767_).forceUpload();
    }

    public void render(PoseStack p_168772_, MultiBufferSource p_168773_, int p_168774_, MapItemSavedData p_168775_, boolean p_168776_, int p_168777_) {
        this.getOrCreateMapInstance(p_168774_, p_168775_).draw(p_168772_, p_168773_, p_168776_, p_168777_);
    }

    private MapInstance getOrCreateMapInstance(int p_168779_, MapItemSavedData p_168780_) {
        return (MapInstance)this.maps.compute(p_168779_, (p_182563_, p_182564_) -> {
            if (p_182564_ == null) {
                return new MapInstance((int)p_182563_, p_168780_);
            }
            p_182564_.replaceMapData(p_168780_);
            return p_182564_;
        });
    }

    public void resetData() {
        for (MapInstance maprenderer$mapinstance : this.maps.values()) {
            maprenderer$mapinstance.close();
        }
        this.maps.clear();
    }

    @Override
    public void close() {
        this.resetData();
    }

    class MapInstance
    implements AutoCloseable {
        private MapItemSavedData data;
        private final DynamicTexture texture;
        private final RenderType renderType;
        private boolean requiresUpload = true;

        MapInstance(int p_168783_, MapItemSavedData p_168784_) {
            this.data = p_168784_;
            this.texture = new DynamicTexture(128, 128, true);
            ResourceLocation resourcelocation = MapRenderer.this.textureManager.register("map/" + p_168783_, this.texture);
            this.renderType = RenderType.text(resourcelocation);
        }

        void replaceMapData(MapItemSavedData pData) {
            boolean flag = this.data != pData;
            this.data = pData;
            this.requiresUpload |= flag;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        private void updateTexture() {
            int i = 0;
            while (i < 128) {
                int j = 0;
                while (j < 128) {
                    int k = j + i * 128;
                    this.texture.getPixels().setPixelRGBA(j, i, MaterialColor.getColorFromPackedId(this.data.colors[k]));
                    ++j;
                }
                ++i;
            }
            this.texture.upload();
        }

        void draw(PoseStack pPoseStack, MultiBufferSource pBufferSource, boolean pActive, int pPackedLight) {
            if (this.requiresUpload) {
                this.updateTexture();
                this.requiresUpload = false;
            }
            boolean i = false;
            boolean j = false;
            float f = 0.0f;
            Matrix4f matrix4f = pPoseStack.last().pose();
            VertexConsumer vertexconsumer = pBufferSource.getBuffer(this.renderType);
            vertexconsumer.vertex(matrix4f, 0.0f, 128.0f, -0.01f).color(255, 255, 255, 255).uv(0.0f, 1.0f).uv2(pPackedLight).endVertex();
            vertexconsumer.vertex(matrix4f, 128.0f, 128.0f, -0.01f).color(255, 255, 255, 255).uv(1.0f, 1.0f).uv2(pPackedLight).endVertex();
            vertexconsumer.vertex(matrix4f, 128.0f, 0.0f, -0.01f).color(255, 255, 255, 255).uv(1.0f, 0.0f).uv2(pPackedLight).endVertex();
            vertexconsumer.vertex(matrix4f, 0.0f, 0.0f, -0.01f).color(255, 255, 255, 255).uv(0.0f, 0.0f).uv2(pPackedLight).endVertex();
            int k = 0;
            for (MapDecoration mapdecoration : this.data.getDecorations()) {
                if (pActive && !mapdecoration.renderOnFrame()) continue;
                pPoseStack.pushPose();
                pPoseStack.translate(0.0f + (float)mapdecoration.getX() / 2.0f + 64.0f, 0.0f + (float)mapdecoration.getY() / 2.0f + 64.0f, -0.02f);
                pPoseStack.mulPose(Vector3f.ZP.rotationDegrees((float)(mapdecoration.getRot() * 360) / 16.0f));
                pPoseStack.scale(4.0f, 4.0f, 3.0f);
                pPoseStack.translate(-0.125, 0.125, 0.0);
                byte b0 = mapdecoration.getImage();
                float f1 = (float)(b0 % 16 + 0) / 16.0f;
                float f2 = (float)(b0 / 16 + 0) / 16.0f;
                float f3 = (float)(b0 % 16 + 1) / 16.0f;
                float f4 = (float)(b0 / 16 + 1) / 16.0f;
                Matrix4f matrix4f1 = pPoseStack.last().pose();
                float f5 = -0.001f;
                VertexConsumer vertexconsumer1 = pBufferSource.getBuffer(MAP_ICONS);
                vertexconsumer1.vertex(matrix4f1, -1.0f, 1.0f, (float)k * -0.001f).color(255, 255, 255, 255).uv(f1, f2).uv2(pPackedLight).endVertex();
                vertexconsumer1.vertex(matrix4f1, 1.0f, 1.0f, (float)k * -0.001f).color(255, 255, 255, 255).uv(f3, f2).uv2(pPackedLight).endVertex();
                vertexconsumer1.vertex(matrix4f1, 1.0f, -1.0f, (float)k * -0.001f).color(255, 255, 255, 255).uv(f3, f4).uv2(pPackedLight).endVertex();
                vertexconsumer1.vertex(matrix4f1, -1.0f, -1.0f, (float)k * -0.001f).color(255, 255, 255, 255).uv(f1, f4).uv2(pPackedLight).endVertex();
                pPoseStack.popPose();
                if (mapdecoration.getName() != null) {
                    Font font = Minecraft.getInstance().font;
                    Component component = mapdecoration.getName();
                    float f6 = font.width(component);
                    float f7 = Mth.clamp(25.0f / f6, 0.0f, 0.6666667f);
                    pPoseStack.pushPose();
                    pPoseStack.translate(0.0f + (float)mapdecoration.getX() / 2.0f + 64.0f - f6 * f7 / 2.0f, 0.0f + (float)mapdecoration.getY() / 2.0f + 64.0f + 4.0f, -0.025f);
                    pPoseStack.scale(f7, f7, 1.0f);
                    pPoseStack.translate(0.0, 0.0, -0.1f);
                    font.drawInBatch(component, 0.0f, 0.0f, -1, false, pPoseStack.last().pose(), pBufferSource, false, Integer.MIN_VALUE, pPackedLight);
                    pPoseStack.popPose();
                }
                ++k;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

