/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public abstract class AbstractSelectionList<E extends Entry<E>>
extends AbstractContainerEventHandler
implements Widget,
NarratableEntry {
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected boolean centerListVertically = true;
    private double scrollAmount;
    private boolean renderSelection = true;
    private boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;
    @Nullable
    private E selected;
    private boolean renderBackground = true;
    private boolean renderTopAndBottom = true;
    @Nullable
    private E hovered;

    public AbstractSelectionList(Minecraft pMinecraft, int pWidth, int pHeight, int pY0, int pY1, int pItemHeight) {
        this.minecraft = pMinecraft;
        this.width = pWidth;
        this.height = pHeight;
        this.y0 = pY0;
        this.y1 = pY1;
        this.itemHeight = pItemHeight;
        this.x0 = 0;
        this.x1 = pWidth;
    }

    public void setRenderSelection(boolean pRenderSelection) {
        this.renderSelection = pRenderSelection;
    }

    protected void setRenderHeader(boolean pRenderHeader, int pHeaderHeight) {
        this.renderHeader = pRenderHeader;
        this.headerHeight = pHeaderHeight;
        if (!pRenderHeader) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E pSelected) {
        this.selected = pSelected;
    }

    public void setRenderBackground(boolean pRenderBackground) {
        this.renderBackground = pRenderBackground;
    }

    public void setRenderTopAndBottom(boolean pRenderTopAndButton) {
        this.renderTopAndBottom = pRenderTopAndButton;
    }

    @Nullable
    public E getFocused() {
        return (E)((Entry)super.getFocused());
    }

    public final List<E> children() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> pEntries) {
        this.children.clear();
        this.children.addAll(pEntries);
    }

    protected E getEntry(int pIndex) {
        return (E)((Entry)this.children().get(pIndex));
    }

    protected int addEntry(E pEntry) {
        this.children.add(pEntry);
        return this.children.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int pIndex) {
        return Objects.equals(this.getSelected(), this.children().get(pIndex));
    }

    @Nullable
    protected final E getEntryAtPosition(double pMouseX, double p_93414_) {
        int i = this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2;
        int k = j - i;
        int l = j + i;
        int i1 = Mth.floor(p_93414_ - (double)this.y0) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(pMouseX < (double)this.getScrollbarPosition() && pMouseX >= (double)k && pMouseX <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)this.children().get(j1) : null);
    }

    public void updateSize(int pWidth, int pHeight, int pY0, int pY1) {
        this.width = pWidth;
        this.height = pHeight;
        this.y0 = pY0;
        this.y1 = pY1;
        this.x0 = 0;
        this.x1 = pWidth;
    }

    public void setLeftPos(int pX0) {
        this.x0 = pX0;
        this.x1 = pX0 + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int pMouseX, int pMouseY) {
    }

    protected void renderHeader(PoseStack pPoseStack, int pX, int pY, Tesselator pTessellator) {
    }

    protected void renderBackground(PoseStack pPoseStack) {
    }

    protected void renderDecorations(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int k1;
        this.renderBackground(pPoseStack);
        int i = this.getScrollbarPosition();
        int j = i + 6;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        this.hovered = this.isMouseOver(pMouseX, pMouseY) ? this.getEntryAtPosition(pMouseX, pMouseY) : null;
        Object v0 = this.hovered;
        if (this.renderBackground) {
            RenderSystem.setShaderTexture(0, GuiComponent.BACKGROUND_LOCATION);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            float f = 32.0f;
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.vertex(this.x0, this.y1, 0.0).uv((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).color(32, 32, 32, 255).endVertex();
            bufferbuilder.vertex(this.x1, this.y1, 0.0).uv((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).color(32, 32, 32, 255).endVertex();
            bufferbuilder.vertex(this.x1, this.y0, 0.0).uv((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).color(32, 32, 32, 255).endVertex();
            bufferbuilder.vertex(this.x0, this.y0, 0.0).uv((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).color(32, 32, 32, 255).endVertex();
            tesselator.end();
        }
        int j1 = this.getRowLeft();
        int k = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(pPoseStack, j1, k, tesselator);
        }
        this.renderList(pPoseStack, j1, k, pMouseX, pMouseY, pPartialTick);
        if (this.renderTopAndBottom) {
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderTexture(0, GuiComponent.BACKGROUND_LOCATION);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc(519);
            float f1 = 32.0f;
            int l = -100;
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.vertex(this.x0, this.y0, -100.0).uv(0.0f, (float)this.y0 / 32.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0 + this.width, this.y0, -100.0).uv((float)this.width / 32.0f, (float)this.y0 / 32.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0 + this.width, 0.0, -100.0).uv((float)this.width / 32.0f, 0.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0, 0.0, -100.0).uv(0.0f, 0.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0, this.height, -100.0).uv(0.0f, (float)this.height / 32.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0 + this.width, this.height, -100.0).uv((float)this.width / 32.0f, (float)this.height / 32.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0 + this.width, this.y1, -100.0).uv((float)this.width / 32.0f, (float)this.y1 / 32.0f).color(64, 64, 64, 255).endVertex();
            bufferbuilder.vertex(this.x0, this.y1, -100.0).uv(0.0f, (float)this.y1 / 32.0f).color(64, 64, 64, 255).endVertex();
            tesselator.end();
            RenderSystem.depthFunc(515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            RenderSystem.disableTexture();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            int i1 = 4;
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.vertex(this.x0, this.y0 + 4, 0.0).color(0, 0, 0, 0).endVertex();
            bufferbuilder.vertex(this.x1, this.y0 + 4, 0.0).color(0, 0, 0, 0).endVertex();
            bufferbuilder.vertex(this.x1, this.y0, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(this.x0, this.y0, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(this.x0, this.y1, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(this.x1, this.y1, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(this.x1, this.y1 - 4, 0.0).color(0, 0, 0, 0).endVertex();
            bufferbuilder.vertex(this.x0, this.y1 - 4, 0.0).color(0, 0, 0, 0).endVertex();
            tesselator.end();
        }
        if ((k1 = this.getMaxScroll()) > 0) {
            RenderSystem.disableTexture();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            int l1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            l1 = Mth.clamp(l1, 32, this.y1 - this.y0 - 8);
            int i2 = (int)this.getScrollAmount() * (this.y1 - this.y0 - l1) / k1 + this.y0;
            if (i2 < this.y0) {
                i2 = this.y0;
            }
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.vertex(i, this.y1, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(j, this.y1, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(j, this.y0, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(i, this.y0, 0.0).color(0, 0, 0, 255).endVertex();
            bufferbuilder.vertex(i, i2 + l1, 0.0).color(128, 128, 128, 255).endVertex();
            bufferbuilder.vertex(j, i2 + l1, 0.0).color(128, 128, 128, 255).endVertex();
            bufferbuilder.vertex(j, i2, 0.0).color(128, 128, 128, 255).endVertex();
            bufferbuilder.vertex(i, i2, 0.0).color(128, 128, 128, 255).endVertex();
            bufferbuilder.vertex(i, i2 + l1 - 1, 0.0).color(192, 192, 192, 255).endVertex();
            bufferbuilder.vertex(j - 1, i2 + l1 - 1, 0.0).color(192, 192, 192, 255).endVertex();
            bufferbuilder.vertex(j - 1, i2, 0.0).color(192, 192, 192, 255).endVertex();
            bufferbuilder.vertex(i, i2, 0.0).color(192, 192, 192, 255).endVertex();
            tesselator.end();
        }
        this.renderDecorations(pPoseStack, pMouseX, pMouseY);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void centerScrollOn(E pEntry) {
        this.setScrollAmount(this.children().indexOf(pEntry) * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2);
    }

    protected void ensureVisible(E pEntry) {
        int k;
        int i = this.getRowTop(this.children().indexOf(pEntry));
        int j = i - this.y0 - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.y1 - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int pScroll) {
        this.setScrollAmount(this.getScrollAmount() + (double)pScroll);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double pScroll) {
        this.scrollAmount = Mth.clamp(pScroll, 0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double pMouseX, double p_93483_, int pMouseY) {
        this.scrolling = pMouseY == 0 && pMouseX >= (double)this.getScrollbarPosition() && pMouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_93421_, int pMouseY) {
        this.updateScrollingState(pMouseX, p_93421_, pMouseY);
        if (!this.isMouseOver(pMouseX, p_93421_)) {
            return false;
        }
        E e = this.getEntryAtPosition(pMouseX, p_93421_);
        if (e != null) {
            if (e.mouseClicked(pMouseX, p_93421_, pMouseY)) {
                this.setFocused((GuiEventListener)e);
                this.setDragging(true);
                return true;
            }
        } else if (pMouseY == 0) {
            this.clickedHeader((int)(pMouseX - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_93421_ - (double)this.y0) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double pMouseX, double p_93492_, int pMouseY) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(pMouseX, p_93492_, pMouseY);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double p_93425_, int pMouseY, double p_93427_, double pButton) {
        if (super.mouseDragged(pMouseX, p_93425_, pMouseY, p_93427_, pButton)) {
            return true;
        }
        if (pMouseY == 0 && this.scrolling) {
            if (p_93425_ < (double)this.y0) {
                this.setScrollAmount(0.0);
            } else if (p_93425_ > (double)this.y1) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = this.y1 - this.y0;
                int j = Mth.clamp((int)((float)(i * i) / (float)this.getMaxPosition()), 32, i - 8);
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + pButton * d1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double p_93417_, double pMouseY) {
        this.setScrollAmount(this.getScrollAmount() - pMouseY * (double)this.itemHeight / 2.0);
        return true;
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 264) {
            this.moveSelection(SelectionDirection.DOWN);
            return true;
        }
        if (pKeyCode == 265) {
            this.moveSelection(SelectionDirection.UP);
            return true;
        }
        return false;
    }

    protected void moveSelection(SelectionDirection pOrdering) {
        this.moveSelection(pOrdering, p_93510_ -> true);
    }

    protected void refreshSelection() {
        E e = this.getSelected();
        if (e != null) {
            this.setSelected(e);
            this.ensureVisible(e);
        }
    }

    protected void moveSelection(SelectionDirection pOrdering, Predicate<E> pFilter) {
        int i;
        int n = i = pOrdering == SelectionDirection.UP ? -1 : 1;
        if (!this.children().isEmpty()) {
            int k;
            int j = this.children().indexOf(this.getSelected());
            while (j != (k = Mth.clamp(j + i, 0, this.getItemCount() - 1))) {
                Entry e = (Entry)this.children().get(k);
                if (pFilter.test(e)) {
                    this.setSelected(e);
                    this.ensureVisible(e);
                    break;
                }
                j = k;
            }
        }
    }

    @Override
    public boolean isMouseOver(double pMouseX, double p_93480_) {
        return p_93480_ >= (double)this.y0 && p_93480_ <= (double)this.y1 && pMouseX >= (double)this.x0 && pMouseX <= (double)this.x1;
    }

    protected void renderList(PoseStack pPoseStack, int pX, int pY, int pMouseX, int pMouseY, float pPartialTick) {
        int i = this.getItemCount();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        int j = 0;
        while (j < i) {
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l >= this.y0 && k <= this.y1) {
                int i1 = pY + j * this.itemHeight + this.headerHeight;
                int j1 = this.itemHeight - 4;
                E e = this.getEntry(j);
                int k1 = this.getRowWidth();
                if (this.renderSelection && this.isSelectedItem(j)) {
                    int l1 = this.x0 + this.width / 2 - k1 / 2;
                    int i2 = this.x0 + this.width / 2 + k1 / 2;
                    RenderSystem.disableTexture();
                    RenderSystem.setShader(GameRenderer::getPositionShader);
                    float f = this.isFocused() ? 1.0f : 0.5f;
                    RenderSystem.setShaderColor(f, f, f, 1.0f);
                    bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                    bufferbuilder.vertex(l1, i1 + j1 + 2, 0.0).endVertex();
                    bufferbuilder.vertex(i2, i1 + j1 + 2, 0.0).endVertex();
                    bufferbuilder.vertex(i2, i1 - 2, 0.0).endVertex();
                    bufferbuilder.vertex(l1, i1 - 2, 0.0).endVertex();
                    tesselator.end();
                    RenderSystem.setShaderColor(0.0f, 0.0f, 0.0f, 1.0f);
                    bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                    bufferbuilder.vertex(l1 + 1, i1 + j1 + 1, 0.0).endVertex();
                    bufferbuilder.vertex(i2 - 1, i1 + j1 + 1, 0.0).endVertex();
                    bufferbuilder.vertex(i2 - 1, i1 - 1, 0.0).endVertex();
                    bufferbuilder.vertex(l1 + 1, i1 - 1, 0.0).endVertex();
                    tesselator.end();
                    RenderSystem.enableTexture();
                }
                int j2 = this.getRowLeft();
                ((Entry)e).render(pPoseStack, j, k, j2, k1, j1, pMouseX, pMouseY, Objects.equals(this.hovered, e), pPartialTick);
            }
            ++j;
        }
    }

    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int pIndex) {
        return this.y0 + 4 - (int)this.getScrollAmount() + pIndex * this.itemHeight + this.headerHeight;
    }

    private int getRowBottom(int pIndex) {
        return this.getRowTop(pIndex) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    @Nullable
    protected E remove(int pIndex) {
        Entry e = (Entry)this.children.get(pIndex);
        return (E)(this.removeEntry((Entry)this.children.get(pIndex)) ? e : null);
    }

    protected boolean removeEntry(E pEntry) {
        boolean flag = this.children.remove(pEntry);
        if (flag && pEntry == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> pEntry) {
        pEntry.list = this;
    }

    protected void narrateListElementPosition(NarrationElementOutput p_168791_, E p_168792_) {
        int i;
        List<E> list = this.children();
        if (list.size() > 1 && (i = list.indexOf(p_168792_)) != -1) {
            p_168791_.add(NarratedElementType.POSITION, new TranslatableComponent("narrator.position.list", i + 1, list.size()));
        }
    }

    public static abstract class Entry<E extends Entry<E>>
    implements GuiEventListener {
        @Deprecated
        AbstractSelectionList<E> list;

        public abstract void render(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        @Override
        public boolean isMouseOver(double pMouseX, double p_93538_) {
            return Objects.equals(this.list.getEntryAtPosition(pMouseX, p_93538_), this);
        }
    }

    protected static enum SelectionDirection {
        UP,
        DOWN;

    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int p_93557_) {
            return (Entry)this.delegate.get(p_93557_);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int p_93559_, E p_93560_) {
            Entry e = (Entry)this.delegate.set(p_93559_, p_93560_);
            AbstractSelectionList.this.bindEntryToSelf(p_93560_);
            return e;
        }

        @Override
        public void add(int p_93567_, E p_93568_) {
            this.delegate.add(p_93567_, p_93568_);
            AbstractSelectionList.this.bindEntryToSelf(p_93568_);
        }

        @Override
        public E remove(int p_93565_) {
            return (Entry)this.delegate.remove(p_93565_);
        }
    }
}

