/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class Button
extends AbstractButton {
    public static final OnTooltip NO_TOOLTIP = (p_93740_, p_93741_, p_93742_, p_93743_) -> {};
    protected final OnPress onPress;
    protected final OnTooltip onTooltip;

    public Button(int pX, int pY, int pWidth, int pHeight, Component pMessage, OnPress pOnPress) {
        this(pX, pY, pWidth, pHeight, pMessage, pOnPress, NO_TOOLTIP);
    }

    public Button(int pX, int pY, int pWidth, int pHeight, Component pMessage, OnPress pOnPress, OnTooltip pOnTooltip) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.onPress = pOnPress;
        this.onTooltip = pOnTooltip;
    }

    @Override
    public void onPress() {
        this.onPress.onPress(this);
    }

    @Override
    public void renderButton(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderButton(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.isHoveredOrFocused()) {
            this.renderToolTip(pPoseStack, pMouseX, pMouseY);
        }
    }

    @Override
    public void renderToolTip(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.onTooltip.onTooltip(this, pPoseStack, pMouseX, pMouseY);
    }

    @Override
    public void updateNarration(NarrationElementOutput pNarrationElementOutput) {
        this.defaultButtonNarrationText(pNarrationElementOutput);
        this.onTooltip.narrateTooltip(p_168841_ -> pNarrationElementOutput.add(NarratedElementType.HINT, (Component)p_168841_));
    }

    public static interface OnPress {
        public void onPress(Button var1);
    }

    public static interface OnTooltip {
        public void onTooltip(Button var1, PoseStack var2, int var3, int var4);

        default public void narrateTooltip(Consumer<Component> p_168842_) {
        }
    }
}

