/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Option;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.optifine.gui.IOptionControl;

public class CycleButton<T>
extends AbstractButton
implements TooltipAccessor,
IOptionControl {
    static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::hasAltDown;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<CycleButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final TooltipSupplier<T> tooltipSupplier;
    private final boolean displayOnlyValue;
    private Option option;

    @Override
    public Option getControlOption() {
        return this.option;
    }

    CycleButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Component pName, int pIndex, T pValue, ValueListSupplier<T> pValues, Function<T, Component> pValueStringifier, Function<CycleButton<T>, MutableComponent> pNarrationProvider, OnValueChange<T> pOnValueChange, TooltipSupplier<T> pTooltipSupplier, boolean pDisplayOnlyValue) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.name = pName;
        this.index = pIndex;
        this.value = pValue;
        this.values = pValues;
        this.valueStringifier = pValueStringifier;
        this.narrationProvider = pNarrationProvider;
        this.onValueChange = pOnValueChange;
        this.tooltipSupplier = pTooltipSupplier;
        this.displayOnlyValue = pDisplayOnlyValue;
        if (this.name instanceof TranslatableComponent) {
            TranslatableComponent translatablecomponent = (TranslatableComponent)this.name;
            this.option = Option.OPTIONS_BY_KEY.get(translatablecomponent.getKey());
        }
    }

    @Override
    public void onPress() {
        if (Screen.hasShiftDown()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int pDelta) {
        List<T> list = this.values.getSelectedList();
        this.index = Mth.positiveModulo(this.index + pDelta, list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int pDelta) {
        List<T> list = this.values.getSelectedList();
        return list.get(Mth.positiveModulo(this.index + pDelta, list.size()));
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double p_168886_, double pMouseY) {
        if (pMouseY > 0.0) {
            this.cycleValue(-1);
        } else if (pMouseY < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T pValue) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(pValue);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(pValue);
    }

    private void updateValue(T pValue) {
        Component component = this.createLabelForValue(pValue);
        this.setMessage(component);
        this.value = pValue;
    }

    private Component createLabelForValue(T pValue) {
        return this.displayOnlyValue ? this.valueStringifier.apply(pValue) : this.createFullName(pValue);
    }

    private MutableComponent createFullName(T pValue) {
        return CommonComponents.optionNameValue(this.name, this.valueStringifier.apply(pValue));
    }

    public T getValue() {
        return this.value;
    }

    @Override
    protected MutableComponent createNarrationMessage() {
        return this.narrationProvider.apply(this);
    }

    @Override
    public void updateNarration(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.add(NarratedElementType.TITLE, this.createNarrationMessage());
        if (this.active) {
            T t = this.getCycledValue(1);
            Component component = this.createLabelForValue(t);
            if (this.isFocused()) {
                pNarrationElementOutput.add(NarratedElementType.USAGE, new TranslatableComponent("narration.cycle_button.usage.focused", component));
            } else {
                pNarrationElementOutput.add(NarratedElementType.USAGE, new TranslatableComponent("narration.cycle_button.usage.hovered", component));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return CycleButton.wrapDefaultNarrationMessage(this.displayOnlyValue ? this.createFullName(this.value) : this.getMessage());
    }

    @Override
    public List<FormattedCharSequence> getTooltip() {
        return (List)this.tooltipSupplier.apply(this.value);
    }

    public static <T> Builder<T> builder(Function<T, Component> pValueStringifier) {
        return new Builder<T>(pValueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(Component pComponentOn, Component pComponentOff) {
        return new Builder<Boolean>(p_168899_2_ -> p_168899_2_ != false ? pComponentOn : pComponentOff).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(p_168890_0_ -> p_168890_0_ != false ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean pInitialValue) {
        return CycleButton.onOffBuilder().withInitialValue(pInitialValue);
    }

    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private TooltipSupplier<T> tooltipSupplier = p_168963_0_ -> ImmutableList.of();
        private Function<CycleButton<T>, MutableComponent> narrationProvider = CycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, Component> pValueStringifier) {
            this.valueStringifier = pValueStringifier;
        }

        public Builder<T> withValues(List<T> pValues) {
            this.values = ValueListSupplier.create(pValues);
            return this;
        }

        @SafeVarargs
        public final Builder<T> a(T ... p_168962_) {
            return this.withValues((List<T>)ImmutableList.copyOf((Object[])p_168962_));
        }

        public Builder<T> withValues(List<T> p_168953_, List<T> p_168954_) {
            this.values = ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, p_168953_, p_168954_);
            return this;
        }

        public Builder<T> withValues(BooleanSupplier p_168956_, List<T> p_168957_, List<T> p_168958_) {
            this.values = ValueListSupplier.create(p_168956_, p_168957_, p_168958_);
            return this;
        }

        public Builder<T> withTooltip(TooltipSupplier<T> pTooltipSupplier) {
            this.tooltipSupplier = pTooltipSupplier;
            return this;
        }

        public Builder<T> withInitialValue(T pInitialValue) {
            this.initialValue = pInitialValue;
            int i = this.values.getDefaultList().indexOf(pInitialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<CycleButton<T>, MutableComponent> pNarrationProvider) {
            this.narrationProvider = pNarrationProvider;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CycleButton<T> create(int pX, int pY, int pWidth, int pHeight, Component pName) {
            return this.create(pX, pY, pWidth, pHeight, pName, (p_168945_0_, p_168945_1_) -> {});
        }

        public CycleButton<T> create(int pX, int pY, int pWidth, int pHeight, Component pName, OnValueChange<T> pOnValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            Component component = this.valueStringifier.apply(t);
            Component component1 = this.displayOnlyValue ? component : CommonComponents.optionNameValue(pName, component);
            return new CycleButton<T>(pX, pY, pWidth, pHeight, component1, pName, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, pOnValueChange, this.tooltipSupplier, this.displayOnlyValue);
        }
    }

    public static interface OnValueChange<T> {
        public void onValueChange(CycleButton var1, T var2);
    }

    @FunctionalInterface
    public static interface TooltipSupplier<T>
    extends Function<T, List<FormattedCharSequence>> {
    }

    static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(List<T> pValues) {
            ImmutableList list = ImmutableList.copyOf(pValues);
            return new ValueListSupplier<T>((List)list){
                private final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier p_168971_, List<T> p_168972_, List<T> p_168973_) {
            ImmutableList list = ImmutableList.copyOf(p_168972_);
            ImmutableList list1 = ImmutableList.copyOf(p_168973_);
            return new ValueListSupplier<T>((List)list1, (List)list){
                private final /* synthetic */ List val$list1;
                private final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return p_168971_.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }
}

