/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.TextureAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.util.GuiPoint;
import net.optifine.util.GuiRect;
import net.optifine.util.GuiUtils;
import net.optifine.util.MemoryMonitor;
import net.optifine.util.NativeMemory;

public class DebugScreenOverlay
extends GuiComponent {
    private static final int COLOR_GREY = 0xE0E0E0;
    private static final int MARGIN_RIGHT = 2;
    private static final int MARGIN_LEFT = 2;
    private static final int MARGIN_TOP = 2;
    private static final Map<Heightmap.Types, String> HEIGHTMAP_NAMES = Util.make(new EnumMap(Heightmap.Types.class), p_94069_0_ -> {
        p_94069_0_.put(Heightmap.Types.WORLD_SURFACE_WG, "SW");
        p_94069_0_.put(Heightmap.Types.WORLD_SURFACE, "S");
        p_94069_0_.put(Heightmap.Types.OCEAN_FLOOR_WG, "OW");
        p_94069_0_.put(Heightmap.Types.OCEAN_FLOOR, "O");
        p_94069_0_.put(Heightmap.Types.MOTION_BLOCKING, "M");
        p_94069_0_.put(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft minecraft;
    private final Font font;
    private HitResult block;
    private HitResult liquid;
    @Nullable
    private ChunkPos lastPos;
    @Nullable
    private LevelChunk clientChunk;
    @Nullable
    private CompletableFuture<LevelChunk> serverChunk;
    private static final int RED = -65536;
    private static final int YELLOW = -256;
    private static final int GREEN = -16711936;
    private String debugOF = null;
    private List<String> debugInfoLeft = null;
    private List<String> debugInfoRight = null;
    private long updateInfoLeftTimeMs = 0L;
    private long updateInfoRightTimeMs = 0L;

    public DebugScreenOverlay(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
        this.font = pMinecraft.font;
    }

    public void clearChunkCache() {
        this.serverChunk = null;
        this.clientChunk = null;
    }

    public void render(PoseStack pPoseStack) {
        this.minecraft.getProfiler().push("debug");
        Entity entity = this.minecraft.getCameraEntity();
        this.block = entity.pick(20.0, 0.0f, false);
        this.liquid = entity.pick(20.0, 0.0f, true);
        this.drawGameInformation(pPoseStack);
        this.drawSystemInformation(pPoseStack);
        if (this.minecraft.options.renderFpsChart) {
            int i = this.minecraft.getWindow().getGuiScaledWidth();
            this.drawChart(pPoseStack, this.minecraft.getFrameTimer(), 0, i / 2, true);
            IntegratedServer integratedserver = this.minecraft.getSingleplayerServer();
            if (integratedserver != null) {
                this.drawChart(pPoseStack, integratedserver.getFrameTimer(), i - Math.min(i / 2, 240), i / 2, false);
            }
        }
        this.minecraft.getProfiler().pop();
    }

    protected void drawGameInformation(PoseStack pPoseStack) {
        List<String> list = this.debugInfoLeft;
        if (list == null || System.currentTimeMillis() > this.updateInfoLeftTimeMs) {
            list = this.getGameInformation();
            list.add("");
            boolean flag = this.minecraft.getSingleplayerServer() != null;
            list.add("Debug: Pie [shift]: " + (this.minecraft.options.renderDebugCharts ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.minecraft.options.renderFpsChart ? "visible" : "hidden"));
            list.add("For help: press F3 + Q");
            this.debugInfoLeft = list;
            this.updateInfoLeftTimeMs = System.currentTimeMillis() + 100L;
        }
        GuiPoint[] aguipoint = new GuiPoint[list.size()];
        GuiRect[] aguirect = new GuiRect[list.size()];
        int i = 0;
        while (i < list.size()) {
            String s = list.get(i);
            if (!Strings.isNullOrEmpty((String)s)) {
                int j = 9;
                int k = this.font.width(s);
                int l = 2;
                int i1 = 2 + j * i;
                aguirect[i] = new GuiRect(1, i1 - 1, 2 + k + 1, i1 + j - 1);
                aguipoint[i] = new GuiPoint(2, i1);
            }
            ++i;
        }
        GuiUtils.fill(pPoseStack.last().pose(), aguirect, -1873784752);
        this.font.renderStrings(list, aguipoint, 0xE0E0E0, pPoseStack.last().pose(), false, this.font.isBidirectional());
    }

    protected void drawSystemInformation(PoseStack pPoseStack) {
        List<String> list = this.debugInfoRight;
        if (list == null || System.currentTimeMillis() > this.updateInfoRightTimeMs) {
            this.debugInfoRight = list = this.getSystemInformation();
            this.updateInfoRightTimeMs = System.currentTimeMillis() + 100L;
        }
        GuiPoint[] aguipoint = new GuiPoint[list.size()];
        GuiRect[] aguirect = new GuiRect[list.size()];
        int i = 0;
        while (i < list.size()) {
            String s = list.get(i);
            if (!Strings.isNullOrEmpty((String)s)) {
                int j = 9;
                int k = this.font.width(s);
                int l = this.minecraft.getWindow().getGuiScaledWidth() - 2 - k;
                int i1 = 2 + j * i;
                aguirect[i] = new GuiRect(l - 1, i1 - 1, l + k + 1, i1 + j - 1);
                aguipoint[i] = new GuiPoint(l, i1);
            }
            ++i;
        }
        GuiUtils.fill(pPoseStack.last().pose(), aguirect, -1873784752);
        this.font.renderStrings(list, aguipoint, 0xE0E0E0, pPoseStack.last().pose(), false, this.font.isBidirectional());
    }

    protected List<String> getGameInformation() {
        if (this.minecraft.fpsString != this.debugOF) {
            StringBuffer stringbuffer = new StringBuffer(this.minecraft.fpsString);
            int i = Config.getChunkUpdates();
            int j = this.minecraft.fpsString.indexOf("T: ");
            if (j >= 0) {
                stringbuffer.insert(j, "(" + i + " updates) ");
            }
            int k = Config.getFpsMin();
            int l = this.minecraft.fpsString.indexOf(" fps ");
            if (l >= 0) {
                stringbuffer.replace(0, l + 4, Config.getFpsString());
            }
            if (Config.isSmoothFps()) {
                stringbuffer.append(" sf");
            }
            if (Config.isFastRender()) {
                stringbuffer.append(" fr");
            }
            if (Config.isAnisotropicFiltering()) {
                stringbuffer.append(" af");
            }
            if (Config.isAntialiasing()) {
                stringbuffer.append(" aa");
            }
            if (Config.isRenderRegions()) {
                stringbuffer.append(" rr");
            }
            if (Config.isShaders()) {
                stringbuffer.append(" sh");
            }
            this.debugOF = this.minecraft.fpsString = stringbuffer.toString();
        }
        List<String> list = this.getInfoLeft();
        StringBuilder stringbuilder = new StringBuilder();
        TextureAtlas textureatlas = Config.getTextureMap();
        stringbuilder.append(", A: ");
        if (SmartAnimations.isActive()) {
            stringbuilder.append(textureatlas.getCountAnimationsActive() + TextureAnimations.getCountAnimationsActive());
            stringbuilder.append("/");
        }
        stringbuilder.append(textureatlas.getCountAnimations() + TextureAnimations.getCountAnimations());
        String s = stringbuilder.toString();
        String s1 = null;
        if (Config.isShadersShadows()) {
            int i1 = this.minecraft.levelRenderer.getRenderedChunksShadow();
            int j1 = this.minecraft.levelRenderer.getCountEntitiesRenderedShadow();
            int k1 = this.minecraft.levelRenderer.getCountTileEntitiesRenderedShadow();
            s1 = "Shadow C: " + i1 + ", E: " + j1 + "+" + k1;
        }
        int l1 = 0;
        while (l1 < list.size()) {
            String s2 = list.get(l1);
            if (s2 != null && s2.startsWith("P: ")) {
                s2 = String.valueOf(s2) + s;
                list.set(l1, s2);
                if (s1 == null) break;
                list.add(l1 + 1, s1);
                break;
            }
            ++l1;
        }
        return list;
    }

    protected List<String> getInfoLeft() {
        PostChain postchain;
        Level level;
        IntegratedServer integratedserver = this.minecraft.getSingleplayerServer();
        Connection connection = this.minecraft.getConnection().getConnection();
        float f = connection.getAverageSentPackets();
        float f1 = connection.getAverageReceivedPackets();
        String s = integratedserver != null ? String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedserver.getAverageTickTime()), Float.valueOf(f), Float.valueOf(f1)) : String.format("\"%s\" server, %.0f tx, %.0f rx", this.minecraft.player.getServerBrand(), Float.valueOf(f), Float.valueOf(f1));
        BlockPos blockpos = this.minecraft.getCameraEntity().blockPosition();
        if (this.minecraft.showOnlyReducedInfo()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.getCurrentVersion().getName() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + ")", this.minecraft.fpsString, s, this.minecraft.levelRenderer.getChunkStatistics(), this.minecraft.levelRenderer.getEntityStatistics(), "P: " + this.minecraft.particleEngine.countParticles() + ". T: " + this.minecraft.level.getEntityCount(), this.minecraft.level.gatherChunkSourceStats(), "", String.format("Chunk-relative: %d %d %d", blockpos.getX() & 0xF, blockpos.getY() & 0xF, blockpos.getZ() & 0xF)});
        }
        Entity entity = this.minecraft.getCameraEntity();
        Direction direction = entity.getDirection();
        String s1 = switch (direction) {
            case Direction.NORTH -> "Towards negative Z";
            case Direction.SOUTH -> "Towards positive Z";
            case Direction.WEST -> "Towards negative X";
            case Direction.EAST -> "Towards positive X";
            default -> "Invalid";
        };
        ChunkPos chunkpos = new ChunkPos(blockpos);
        if (!Objects.equals(this.lastPos, chunkpos)) {
            this.lastPos = chunkpos;
            this.clearChunkCache();
        }
        LongSets.EmptySet longset = (level = this.getLevel()) instanceof ServerLevel ? ((ServerLevel)level).getForcedChunks() : LongSets.EMPTY_SET;
        ArrayList list = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.getCurrentVersion().getName() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType()) + ")", this.minecraft.fpsString, s, this.minecraft.levelRenderer.getChunkStatistics(), this.minecraft.levelRenderer.getEntityStatistics(), "P: " + this.minecraft.particleEngine.countParticles() + ". T: " + this.minecraft.level.getEntityCount(), this.minecraft.level.gatherChunkSourceStats()});
        String s2 = this.getServerChunkStats();
        if (s2 != null) {
            list.add(s2);
        }
        list.add(this.minecraft.level.dimension().location() + " FC: " + longset.size());
        list.add("");
        list.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.minecraft.getCameraEntity().getX(), this.minecraft.getCameraEntity().getY(), this.minecraft.getCameraEntity().getZ()));
        list.add(String.format("Block: %d %d %d [%d %d %d]", blockpos.getX(), blockpos.getY(), blockpos.getZ(), blockpos.getX() & 0xF, blockpos.getY() & 0xF, blockpos.getZ() & 0xF));
        list.add(String.format("Chunk: %d %d %d [%d %d in r.%d.%d.mca]", chunkpos.x, SectionPos.blockToSectionCoord(blockpos.getY()), chunkpos.z, chunkpos.getRegionLocalX(), chunkpos.getRegionLocalZ(), chunkpos.getRegionX(), chunkpos.getRegionZ()));
        list.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", direction, s1, Float.valueOf(Mth.wrapDegrees(entity.getYRot())), Float.valueOf(Mth.wrapDegrees(entity.getXRot()))));
        LevelChunk levelchunk = this.getClientChunk();
        if (levelchunk.isEmpty()) {
            list.add("Waiting for chunk...");
        } else {
            int i = this.minecraft.level.getChunkSource().getLightEngine().getRawBrightness(blockpos, 0);
            int j = this.minecraft.level.getBrightness(LightLayer.SKY, blockpos);
            int k = this.minecraft.level.getBrightness(LightLayer.BLOCK, blockpos);
            list.add("Client Light: " + i + " (" + j + " sky, " + k + " block)");
            LevelChunk levelchunk1 = this.getServerChunk();
            StringBuilder stringbuilder = new StringBuilder("CH");
            Heightmap.Types[] typesArray = Heightmap.Types.values();
            int n = typesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Heightmap.Types heightmap$types = typesArray[n2];
                if (heightmap$types.sendToClient()) {
                    stringbuilder.append(" ").append(HEIGHTMAP_NAMES.get(heightmap$types)).append(": ").append(levelchunk.getHeight(heightmap$types, blockpos.getX(), blockpos.getZ()));
                }
                ++n2;
            }
            list.add(stringbuilder.toString());
            stringbuilder.setLength(0);
            stringbuilder.append("SH");
            typesArray = Heightmap.Types.values();
            n = typesArray.length;
            n2 = 0;
            while (n2 < n) {
                Heightmap.Types heightmap$types1 = typesArray[n2];
                if (heightmap$types1.keepAfterWorldgen()) {
                    stringbuilder.append(" ").append(HEIGHTMAP_NAMES.get(heightmap$types1)).append(": ");
                    if (levelchunk1 != null) {
                        stringbuilder.append(levelchunk1.getHeight(heightmap$types1, blockpos.getX(), blockpos.getZ()));
                    } else {
                        stringbuilder.append("??");
                    }
                }
                ++n2;
            }
            list.add(stringbuilder.toString());
            if (blockpos.getY() >= this.minecraft.level.getMinBuildHeight() && blockpos.getY() < this.minecraft.level.getMaxBuildHeight()) {
                list.add("Biome: " + DebugScreenOverlay.printBiome(this.minecraft.level.getBiome(blockpos)));
                long l = 0L;
                float f2 = 0.0f;
                if (levelchunk1 != null) {
                    f2 = level.getMoonBrightness();
                    l = levelchunk1.getInhabitedTime();
                }
                DifficultyInstance difficultyinstance = new DifficultyInstance(level.getDifficulty(), level.getDayTime(), l, f2);
                list.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyinstance.getEffectiveDifficulty()), Float.valueOf(difficultyinstance.getSpecialMultiplier()), this.minecraft.level.getDayTime() / 24000L));
            }
        }
        ServerLevel serverlevel = this.getServerLevel();
        if (serverlevel != null) {
            ServerChunkCache serverchunkcache = serverlevel.getChunkSource();
            ChunkGenerator chunkgenerator = serverchunkcache.getGenerator();
            chunkgenerator.addDebugScreenInfo(list, blockpos);
            Climate.Sampler climate$sampler = chunkgenerator.climateSampler();
            BiomeSource biomesource = chunkgenerator.getBiomeSource();
            biomesource.addDebugInfo(list, blockpos, climate$sampler);
            NaturalSpawner.SpawnState naturalspawner$spawnstate = serverchunkcache.getLastSpawnState();
            if (naturalspawner$spawnstate != null) {
                Object2IntMap<MobCategory> object2intmap = naturalspawner$spawnstate.getMobCategoryCounts();
                int i1 = naturalspawner$spawnstate.getSpawnableChunkCount();
                list.add("SC: " + i1 + ", " + Stream.of(MobCategory.values()).map(p_94066_1_ -> String.valueOf(Character.toUpperCase(p_94066_1_.getName().charAt(0))) + ": " + object2intmap.getInt(p_94066_1_)).collect(Collectors.joining(", ")));
            } else {
                list.add("SC: N/A");
            }
        }
        if ((postchain = this.minecraft.gameRenderer.currentEffect()) != null) {
            list.add("Shader: " + postchain.getName());
        }
        list.add(String.valueOf(this.minecraft.getSoundManager().getDebugString()) + String.format(" (Mood %d%%)", Math.round(this.minecraft.player.getCurrentMood() * 100.0f)));
        return list;
    }

    private static String printBiome(Holder<Biome> p_205375_) {
        return (String)p_205375_.unwrap().map(p_205376_0_ -> p_205376_0_.location().toString(), p_205366_0_ -> "[unregistered " + p_205366_0_ + "]");
    }

    @Nullable
    private ServerLevel getServerLevel() {
        IntegratedServer integratedserver = this.minecraft.getSingleplayerServer();
        return integratedserver != null ? integratedserver.getLevel(this.minecraft.level.dimension()) : null;
    }

    @Nullable
    private String getServerChunkStats() {
        ServerLevel serverlevel = this.getServerLevel();
        return serverlevel != null ? serverlevel.gatherChunkSourceStats() : null;
    }

    private Level getLevel() {
        return (Level)DataFixUtils.orElse(Optional.ofNullable(this.minecraft.getSingleplayerServer()).flatMap(p_205372_1_ -> Optional.ofNullable(p_205372_1_.getLevel(this.minecraft.level.dimension()))), (Object)this.minecraft.level);
    }

    @Nullable
    private LevelChunk getServerChunk() {
        if (this.serverChunk == null) {
            ServerLevel serverlevel = this.getServerLevel();
            if (serverlevel != null) {
                this.serverChunk = serverlevel.getChunkSource().getChunkFuture(this.lastPos.x, this.lastPos.z, ChunkStatus.FULL, false).thenApply(p_205368_0_ -> (LevelChunk)p_205368_0_.map(p_205370_0_ -> (LevelChunk)p_205370_0_, p_205362_0_ -> null));
            }
            if (this.serverChunk == null) {
                this.serverChunk = CompletableFuture.completedFuture(this.getClientChunk());
            }
        }
        return this.serverChunk.getNow(null);
    }

    private LevelChunk getClientChunk() {
        if (this.clientChunk == null) {
            this.clientChunk = this.minecraft.level.getChunk(this.lastPos.x, this.lastPos.z);
        }
        return this.clientChunk;
    }

    protected List<String> getSystemInformation() {
        Entity entity;
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;
        ArrayList list = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.minecraft.is64Bit() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, DebugScreenOverlay.bytesToMegabytes(l), DebugScreenOverlay.bytesToMegabytes(i)), String.format("Allocated: % 2d%% %03dMB", j * 100L / i, DebugScreenOverlay.bytesToMegabytes(j)), "", String.format("CPU: %s", GlUtil.getCpuInfo()), "", String.format("Display: %dx%d (%s)", Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight(), GlUtil.getVendor()), GlUtil.getRenderer(), GlUtil.getOpenGLVersion()});
        long i1 = NativeMemory.getBufferAllocated();
        long j1 = NativeMemory.getBufferMaximum();
        long k1 = NativeMemory.getImageAllocated();
        String s = "Native: " + DebugScreenOverlay.bytesToMegabytes(i1) + "/" + DebugScreenOverlay.bytesToMegabytes(j1) + "+" + DebugScreenOverlay.bytesToMegabytes(k1) + "MB";
        list.add(3, s);
        list.set(4, "Allocation: " + MemoryMonitor.getAllocationRateAvgMb() + "MB/s");
        if (Reflector.BrandingControl_getBrandings.exists()) {
            list.add("");
            for (String s1 : (Collection)Reflector.call(Reflector.BrandingControl_getBrandings, true, false)) {
                if (s1.startsWith("Minecraft ")) continue;
                list.add(s1);
            }
        }
        if (this.minecraft.showOnlyReducedInfo()) {
            return list;
        }
        if (this.block.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)this.block).getBlockPos();
            BlockState blockstate = this.minecraft.level.getBlockState(blockpos);
            list.add("");
            list.add((Object)((Object)ChatFormatting.UNDERLINE) + "Targeted Block: " + blockpos.getX() + ", " + blockpos.getY() + ", " + blockpos.getZ());
            list.add(String.valueOf(Registry.BLOCK.getKey(blockstate.getBlock())));
            for (Map.Entry entry : blockstate.getValues().entrySet()) {
                list.add(this.getPropertyValueString(entry));
            }
            blockstate.getTags().map(p_205378_0_ -> "#" + p_205378_0_.location()).forEach(list::add);
        }
        if (this.liquid.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos1 = ((BlockHitResult)this.liquid).getBlockPos();
            FluidState fluidstate = this.minecraft.level.getFluidState(blockpos1);
            list.add("");
            list.add((Object)((Object)ChatFormatting.UNDERLINE) + "Targeted Fluid: " + blockpos1.getX() + ", " + blockpos1.getY() + ", " + blockpos1.getZ());
            list.add(String.valueOf(Registry.FLUID.getKey(fluidstate.getType())));
            for (Map.Entry entry1 : fluidstate.getValues().entrySet()) {
                list.add(this.getPropertyValueString(entry1));
            }
            fluidstate.getTags().map(p_205364_0_ -> "#" + p_205364_0_.location()).forEach(list::add);
        }
        if ((entity = this.minecraft.crosshairPickEntity) != null) {
            list.add("");
            list.add((Object)((Object)ChatFormatting.UNDERLINE) + "Targeted Entity");
            list.add(String.valueOf(Registry.ENTITY_TYPE.getKey(entity.getType())));
            entity.getType().builtInRegistryHolder().tags().forEach(t -> list.add("#" + t.location()));
        }
        return list;
    }

    private String getPropertyValueString(Map.Entry<Property<?>, Comparable<?>> pEntry) {
        Property<?> property = pEntry.getKey();
        Comparable<?> comparable = pEntry.getValue();
        String s = Util.getPropertyName(property, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = (Object)((Object)ChatFormatting.GREEN) + s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = (Object)((Object)ChatFormatting.RED) + s;
        }
        return String.valueOf(property.getName()) + ": " + s;
    }

    private void drawChart(PoseStack p_94059_, FrameTimer p_94060_, int p_94061_, int p_94062_, boolean p_94063_) {
        if (!p_94063_) {
            int i = (int)(512.0 / this.minecraft.getWindow().getGuiScale());
            p_94061_ = Math.max(p_94061_, i);
            p_94062_ = this.minecraft.getWindow().getGuiScaledWidth() - p_94061_;
            RenderSystem.disableDepthTest();
            int j = p_94060_.getLogStart();
            int k = p_94060_.getLogEnd();
            long[] along = p_94060_.getLog();
            int l = p_94061_;
            int i1 = Math.max(0, along.length - p_94062_);
            int j1 = along.length - i1;
            int k1 = p_94060_.wrapIndex(j + i1);
            long l1 = 0L;
            int i2 = Integer.MAX_VALUE;
            int j2 = Integer.MIN_VALUE;
            int k2 = 0;
            while (k2 < j1) {
                int l2 = (int)(along[p_94060_.wrapIndex(k1 + k2)] / 1000000L);
                i2 = Math.min(i2, l2);
                j2 = Math.max(j2, l2);
                l1 += (long)l2;
                ++k2;
            }
            int l4 = this.minecraft.getWindow().getGuiScaledHeight();
            DebugScreenOverlay.fill(p_94059_, p_94061_, l4 - 60, p_94061_ + j1, l4, -1873784752);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
            RenderSystem.enableBlend();
            RenderSystem.disableTexture();
            RenderSystem.defaultBlendFunc();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f matrix4f = Transformation.identity().getMatrix();
            while (k1 != k) {
                int i3 = p_94060_.scaleSampleTo(along[k1], p_94063_ ? 30 : 60, p_94063_ ? 60 : 20);
                int j3 = p_94063_ ? 100 : 60;
                int k3 = this.getSampleColor(Mth.clamp(i3, 0, j3), 0, j3 / 2, j3);
                int l3 = k3 >> 24 & 0xFF;
                int i4 = k3 >> 16 & 0xFF;
                int j4 = k3 >> 8 & 0xFF;
                int k4 = k3 & 0xFF;
                bufferbuilder.vertex(matrix4f, l + 1, l4, 0.0f).color(i4, j4, k4, l3).endVertex();
                bufferbuilder.vertex(matrix4f, l + 1, l4 - i3 + 1, 0.0f).color(i4, j4, k4, l3).endVertex();
                bufferbuilder.vertex(matrix4f, l, l4 - i3 + 1, 0.0f).color(i4, j4, k4, l3).endVertex();
                bufferbuilder.vertex(matrix4f, l, l4, 0.0f).color(i4, j4, k4, l3).endVertex();
                ++l;
                k1 = p_94060_.wrapIndex(k1 + 1);
            }
            bufferbuilder.end();
            BufferUploader.end(bufferbuilder);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
            if (p_94063_) {
                DebugScreenOverlay.fill(p_94059_, p_94061_ + 1, l4 - 30 + 1, p_94061_ + 14, l4 - 30 + 10, -1873784752);
                this.font.draw(p_94059_, "60 FPS", (float)(p_94061_ + 2), (float)(l4 - 30 + 2), 0xE0E0E0);
                this.hLine(p_94059_, p_94061_, p_94061_ + j1 - 1, l4 - 30, -1);
                DebugScreenOverlay.fill(p_94059_, p_94061_ + 1, l4 - 60 + 1, p_94061_ + 14, l4 - 60 + 10, -1873784752);
                this.font.draw(p_94059_, "30 FPS", (float)(p_94061_ + 2), (float)(l4 - 60 + 2), 0xE0E0E0);
                this.hLine(p_94059_, p_94061_, p_94061_ + j1 - 1, l4 - 60, -1);
            } else {
                DebugScreenOverlay.fill(p_94059_, p_94061_ + 1, l4 - 60 + 1, p_94061_ + 14, l4 - 60 + 10, -1873784752);
                this.font.draw(p_94059_, "20 TPS", (float)(p_94061_ + 2), (float)(l4 - 60 + 2), 0xE0E0E0);
                this.hLine(p_94059_, p_94061_, p_94061_ + j1 - 1, l4 - 60, -1);
            }
            this.hLine(p_94059_, p_94061_, p_94061_ + j1 - 1, l4 - 1, -1);
            this.vLine(p_94059_, p_94061_, l4 - 60, l4, -1);
            this.vLine(p_94059_, p_94061_ + j1 - 1, l4 - 60, l4, -1);
            if (p_94063_ && this.minecraft.options.framerateLimit > 0 && this.minecraft.options.framerateLimit <= 250) {
                this.hLine(p_94059_, p_94061_, p_94061_ + j1 - 1, l4 - 1 - (int)(1800.0 / (double)this.minecraft.options.framerateLimit), -16711681);
            }
            String s = String.valueOf(i2) + " ms min";
            String s1 = String.valueOf(l1 / (long)j1) + " ms avg";
            String s2 = String.valueOf(j2) + " ms max";
            this.font.drawShadow(p_94059_, s, (float)(p_94061_ + 2), (float)(l4 - 60 - 9), 0xE0E0E0);
            this.font.drawShadow(p_94059_, s1, (float)(p_94061_ + j1 / 2 - this.font.width(s1) / 2), (float)(l4 - 60 - 9), 0xE0E0E0);
            this.font.drawShadow(p_94059_, s2, (float)(p_94061_ + j1 - this.font.width(s2)), (float)(l4 - 60 - 9), 0xE0E0E0);
            RenderSystem.enableDepthTest();
        }
    }

    private int getSampleColor(int pHeight, int pHeightMin, int pHeightMid, int pHeightMax) {
        return pHeight < pHeightMid ? this.colorLerp(-16711936, -256, (float)pHeight / (float)pHeightMid) : this.colorLerp(-256, -65536, (float)(pHeight - pHeightMid) / (float)(pHeightMax - pHeightMid));
    }

    private int colorLerp(int pCol1, int pCol2, float pFactor) {
        int i = pCol1 >> 24 & 0xFF;
        int j = pCol1 >> 16 & 0xFF;
        int k = pCol1 >> 8 & 0xFF;
        int l = pCol1 & 0xFF;
        int i1 = pCol2 >> 24 & 0xFF;
        int j1 = pCol2 >> 16 & 0xFF;
        int k1 = pCol2 >> 8 & 0xFF;
        int l1 = pCol2 & 0xFF;
        int i2 = Mth.clamp((int)Mth.lerp(pFactor, i, i1), 0, 255);
        int j2 = Mth.clamp((int)Mth.lerp(pFactor, j, j1), 0, 255);
        int k2 = Mth.clamp((int)Mth.lerp(pFactor, k, k1), 0, 255);
        int l2 = Mth.clamp((int)Mth.lerp(pFactor, l, l1), 0, 255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l2;
    }

    private static long bytesToMegabytes(long pBytes) {
        return pBytes / 1024L / 1024L;
    }
}

