/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    public OptionsList(Minecraft p_94465_, int p_94466_, int p_94467_, int p_94468_, int p_94469_, int p_94470_) {
        super(p_94465_, p_94466_, p_94467_, p_94468_, p_94469_, p_94470_);
        this.centerListVertically = false;
    }

    public int addBig(Option pOption) {
        return this.addEntry(Entry.big(this.minecraft.options, this.width, pOption));
    }

    public void addSmall(Option pLeftOption, @Nullable Option pRightOption) {
        this.addEntry(Entry.small(this.minecraft.options, this.width, pLeftOption, pRightOption));
    }

    public void a(Option[] p_94477_) {
        int i = 0;
        while (i < p_94477_.length) {
            this.addSmall(p_94477_[i], i < p_94477_.length - 1 ? p_94477_[i + 1] : null);
            i += 2;
        }
    }

    @Override
    public int getRowWidth() {
        return 400;
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    @Nullable
    public AbstractWidget findOption(Option pOption) {
        for (Entry optionslist$entry : this.children()) {
            AbstractWidget abstractwidget = optionslist$entry.options.get(pOption);
            if (abstractwidget == null) continue;
            return abstractwidget;
        }
        return null;
    }

    public Optional<AbstractWidget> getMouseOver(double pMouseX, double p_94482_) {
        for (Entry optionslist$entry : this.children()) {
            for (AbstractWidget abstractwidget : optionslist$entry.children) {
                if (!abstractwidget.isMouseOver(pMouseX, p_94482_)) continue;
                return Optional.of(abstractwidget);
            }
        }
        return Optional.empty();
    }

    protected static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        final Map<Option, AbstractWidget> options;
        final List<AbstractWidget> children;

        private Entry(Map<Option, AbstractWidget> pOptions) {
            this.options = pOptions;
            this.children = ImmutableList.copyOf(pOptions.values());
        }

        public static Entry big(Options pSettings, int pGuiWidth, Option pOption) {
            return new Entry((Map<Option, AbstractWidget>)ImmutableMap.of((Object)pOption, (Object)pOption.createButton(pSettings, pGuiWidth / 2 - 155, 0, 310)));
        }

        public static Entry small(Options pSettings, int pGuiWidth, Option pLeftOption, @Nullable Option pRightOption) {
            AbstractWidget abstractwidget = pLeftOption.createButton(pSettings, pGuiWidth / 2 - 155, 0, 150);
            return pRightOption == null ? new Entry((Map<Option, AbstractWidget>)ImmutableMap.of((Object)pLeftOption, (Object)abstractwidget)) : new Entry((Map<Option, AbstractWidget>)ImmutableMap.of((Object)pLeftOption, (Object)abstractwidget, (Object)pRightOption, (Object)pRightOption.createButton(pSettings, pGuiWidth / 2 - 155 + 160, 0, 150)));
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.children.forEach(p_94494_ -> {
                p_94494_.y = pTop;
                p_94494_.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            });
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }
}

