/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.events;

import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.events.GuiEventListener;

public interface ContainerEventHandler
extends GuiEventListener {
    public List<? extends GuiEventListener> children();

    default public Optional<GuiEventListener> getChildAt(double pMouseX, double p_94731_) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.isMouseOver(pMouseX, p_94731_)) continue;
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    @Override
    default public boolean mouseClicked(double pMouseX, double p_94696_, int pMouseY) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(pMouseX, p_94696_, pMouseY)) continue;
            this.setFocused(guiEventListener);
            if (pMouseY == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseReleased(double pMouseX, double p_94723_, int pMouseY) {
        this.setDragging(false);
        return this.getChildAt(pMouseX, p_94723_).filter(p_94708_ -> p_94708_.mouseReleased(pMouseX, p_94723_, pMouseY)).isPresent();
    }

    @Override
    default public boolean mouseDragged(double pMouseX, double p_94700_, int pMouseY, double p_94702_, double pButton) {
        return this.getFocused() != null && this.isDragging() && pMouseY == 0 ? this.getFocused().mouseDragged(pMouseX, p_94700_, pMouseY, p_94702_, pButton) : false;
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Override
    default public boolean mouseScrolled(double pMouseX, double p_94687_, double pMouseY) {
        return this.getChildAt(pMouseX, p_94687_).filter(p_94693_ -> p_94693_.mouseScrolled(pMouseX, p_94687_, pMouseY)).isPresent();
    }

    @Override
    default public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        return this.getFocused() != null && this.getFocused().keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    default public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        return this.getFocused() != null && this.getFocused().keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    default public boolean charTyped(char pCodePoint, int pModifiers) {
        return this.getFocused() != null && this.getFocused().charTyped(pCodePoint, pModifiers);
    }

    @Nullable
    public GuiEventListener getFocused();

    public void setFocused(@Nullable GuiEventListener var1);

    default public void setInitialFocus(@Nullable GuiEventListener pEventListener) {
        this.setFocused(pEventListener);
        pEventListener.changeFocus(true);
    }

    default public void magicalSpecialHackyFocus(@Nullable GuiEventListener pEventListener) {
        this.setFocused(pEventListener);
    }

    @Override
    default public boolean changeFocus(boolean pFocus) {
        BooleanSupplier booleansupplier;
        boolean flag;
        GuiEventListener guieventlistener = this.getFocused();
        boolean bl = flag = guieventlistener != null;
        if (flag && guieventlistener.changeFocus(pFocus)) {
            return true;
        }
        List<? extends GuiEventListener> list = this.children();
        int j = list.indexOf(guieventlistener);
        int i = flag && j >= 0 ? j + (pFocus ? 1 : 0) : (pFocus ? 0 : list.size());
        ListIterator<? extends GuiEventListener> listiterator = list.listIterator(i);
        BooleanSupplier booleanSupplier = pFocus ? listiterator::hasNext : (booleansupplier = listiterator::hasPrevious);
        Supplier<GuiEventListener> supplier = pFocus ? listiterator::next : listiterator::previous;
        while (booleansupplier.getAsBoolean()) {
            GuiEventListener guieventlistener1 = supplier.get();
            if (!guieventlistener1.changeFocus(pFocus)) continue;
            this.setFocused(guieventlistener1);
            return true;
        }
        this.setFocused(null);
        return false;
    }
}

