/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class AdvancementToast
implements Toast {
    private final Advancement advancement;
    private boolean playedSound;

    public AdvancementToast(Advancement pAdvancement) {
        this.advancement = pAdvancement;
    }

    @Override
    public Toast.Visibility render(PoseStack pPoseStack, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, TEXTURE);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        DisplayInfo displayinfo = this.advancement.getDisplay();
        pToastComponent.blit(pPoseStack, 0, 0, 0, 0, this.width(), this.height());
        if (displayinfo != null) {
            int i;
            List<FormattedCharSequence> list = pToastComponent.getMinecraft().font.split(displayinfo.getTitle(), 125);
            int n = i = displayinfo.getFrame() == FrameType.CHALLENGE ? 0xFF88FF : 0xFFFF00;
            if (list.size() == 1) {
                pToastComponent.getMinecraft().font.draw(pPoseStack, displayinfo.getFrame().getDisplayName(), 30.0f, 7.0f, i | 0xFF000000);
                pToastComponent.getMinecraft().font.draw(pPoseStack, list.get(0), 30.0f, 18.0f, -1);
            } else {
                int j = 1500;
                float f = 300.0f;
                if (pTimeSinceLastVisible < 1500L) {
                    int k = Mth.floor(Mth.clamp((float)(1500L - pTimeSinceLastVisible) / 300.0f, 0.0f, 1.0f) * 255.0f) << 24 | 0x4000000;
                    pToastComponent.getMinecraft().font.draw(pPoseStack, displayinfo.getFrame().getDisplayName(), 30.0f, 11.0f, i | k);
                } else {
                    int i1 = Mth.floor(Mth.clamp((float)(pTimeSinceLastVisible - 1500L) / 300.0f, 0.0f, 1.0f) * 252.0f) << 24 | 0x4000000;
                    int l = this.height() / 2 - list.size() * 9 / 2;
                    for (FormattedCharSequence formattedcharsequence : list) {
                        pToastComponent.getMinecraft().font.draw(pPoseStack, formattedcharsequence, 30.0f, (float)l, 0xFFFFFF | i1);
                        l += 9;
                    }
                }
            }
            if (!this.playedSound && pTimeSinceLastVisible > 0L) {
                this.playedSound = true;
                if (displayinfo.getFrame() == FrameType.CHALLENGE) {
                    pToastComponent.getMinecraft().getSoundManager().play(SimpleSoundInstance.forUI(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f));
                }
            }
            pToastComponent.getMinecraft().getItemRenderer().renderAndDecorateFakeItem(displayinfo.getIcon(), 8, 8);
            return pTimeSinceLastVisible >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

