/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.util.Mth;

public class ToastComponent
extends GuiComponent {
    private static final int VISIBLE_TOASTS = 5;
    final Minecraft minecraft;
    private final ToastInstance<?>[] visible = new ToastInstance[5];
    private final Deque<Toast> queued = Queues.newArrayDeque();

    public ToastComponent(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    public void render(PoseStack pPoseStack) {
        if (!this.minecraft.options.hideGui) {
            int i = 0;
            while (i < this.visible.length) {
                ToastInstance<?> toastinstance = this.visible[i];
                if (toastinstance != null && toastinstance.render(this.minecraft.getWindow().getGuiScaledWidth(), i, pPoseStack)) {
                    this.visible[i] = null;
                }
                if (this.visible[i] == null && !this.queued.isEmpty()) {
                    this.visible[i] = new ToastInstance(this, this.queued.removeFirst());
                }
                ++i;
            }
        }
    }

    @Nullable
    public <T extends Toast> T getToast(Class<? extends T> p_94927_, Object p_94928_) {
        ToastInstance<?>[] toastInstanceArray = this.visible;
        int n = this.visible.length;
        int n2 = 0;
        while (n2 < n) {
            ToastInstance<?> toastinstance = toastInstanceArray[n2];
            if (toastinstance != null && p_94927_.isAssignableFrom(toastinstance.getToast().getClass()) && ((Toast)toastinstance.getToast()).getToken().equals(p_94928_)) {
                return (T)toastinstance.getToast();
            }
            ++n2;
        }
        for (Toast toast : this.queued) {
            if (!p_94927_.isAssignableFrom(toast.getClass()) || !toast.getToken().equals(p_94928_)) continue;
            return (T)toast;
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.visible, null);
        this.queued.clear();
    }

    public void addToast(Toast pToast) {
        this.queued.add(pToast);
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    static class ToastInstance<T extends Toast> {
        private static final long ANIMATION_TIME = 600L;
        private final T toast;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private Toast.Visibility visibility = Toast.Visibility.SHOW;
        final /* synthetic */ ToastComponent this$0;

        ToastInstance(T p_94937_) {
            this.this$0 = var1_1;
            this.toast = p_94937_;
        }

        public T getToast() {
            return this.toast;
        }

        private float getVisibility(long p_94948_) {
            float f = Mth.clamp((float)(p_94948_ - this.animationTime) / 600.0f, 0.0f, 1.0f);
            f *= f;
            return this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
        }

        public boolean render(int p_94944_, int p_94945_, PoseStack p_94946_) {
            long i = Util.getMillis();
            if (this.animationTime == -1L) {
                this.animationTime = i;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            if (this.visibility == Toast.Visibility.SHOW && i - this.animationTime <= 600L) {
                this.visibleTime = i;
            }
            PoseStack posestack = RenderSystem.getModelViewStack();
            posestack.pushPose();
            posestack.translate((float)p_94944_ - (float)this.toast.width() * this.getVisibility(i), p_94945_ * this.toast.height(), 800 + p_94945_);
            RenderSystem.applyModelViewMatrix();
            Toast.Visibility toast$visibility = this.toast.render(p_94946_, this.this$0, i - this.visibleTime);
            posestack.popPose();
            RenderSystem.applyModelViewMatrix();
            if (toast$visibility != this.visibility) {
                this.animationTime = i - (long)((int)((1.0f - this.getVisibility(i)) * 600.0f));
                this.visibility = toast$visibility;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            return this.visibility == Toast.Visibility.HIDE && i - this.animationTime > 600L;
        }
    }
}

