/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TutorialToast
implements Toast {
    public static final int PROGRESS_BAR_WIDTH = 154;
    public static final int PROGRESS_BAR_HEIGHT = 1;
    public static final int PROGRESS_BAR_X = 3;
    public static final int PROGRESS_BAR_Y = 28;
    private final Icons icon;
    private final Component title;
    @Nullable
    private final Component message;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private long lastProgressTime;
    private float lastProgress;
    private float progress;
    private final boolean progressable;

    public TutorialToast(Icons pIcon, Component pTitle, @Nullable Component pMessage, boolean pProgressable) {
        this.icon = pIcon;
        this.title = pTitle;
        this.message = pMessage;
        this.progressable = pProgressable;
    }

    @Override
    public Toast.Visibility render(PoseStack pPoseStack, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        RenderSystem.setShaderTexture(0, TEXTURE);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        pToastComponent.blit(pPoseStack, 0, 0, 0, 96, this.width(), this.height());
        this.icon.render(pPoseStack, pToastComponent, 6, 6);
        if (this.message == null) {
            pToastComponent.getMinecraft().font.draw(pPoseStack, this.title, 30.0f, 12.0f, -11534256);
        } else {
            pToastComponent.getMinecraft().font.draw(pPoseStack, this.title, 30.0f, 7.0f, -11534256);
            pToastComponent.getMinecraft().font.draw(pPoseStack, this.message, 30.0f, 18.0f, -16777216);
        }
        if (this.progressable) {
            GuiComponent.fill(pPoseStack, 3, 28, 157, 29, -1);
            float f = Mth.clampedLerp(this.lastProgress, this.progress, (float)(pTimeSinceLastVisible - this.lastProgressTime) / 100.0f);
            int i = this.progress >= this.lastProgress ? -16755456 : -11206656;
            GuiComponent.fill(pPoseStack, 3, 28, (int)(3.0f + 154.0f * f), 29, i);
            this.lastProgress = f;
            this.lastProgressTime = pTimeSinceLastVisible;
        }
        return this.visibility;
    }

    public void hide() {
        this.visibility = Toast.Visibility.HIDE;
    }

    public void updateProgress(float pProgress) {
        this.progress = pProgress;
    }

    public static enum Icons {
        MOVEMENT_KEYS(0, 0),
        MOUSE(1, 0),
        TREE(2, 0),
        RECIPE_BOOK(0, 1),
        WOODEN_PLANKS(1, 1),
        SOCIAL_INTERACTIONS(2, 1),
        RIGHT_CLICK(3, 1);

        private final int x;
        private final int y;

        private Icons(int p_94982_, int p_94983_) {
            this.x = p_94982_;
            this.y = p_94983_;
        }

        public void render(PoseStack pPoseStack, GuiComponent pGuiComponent, int pX, int pY) {
            RenderSystem.enableBlend();
            pGuiComponent.blit(pPoseStack, pX, pY, 176 + this.x * 20, this.y * 20, 20, 20);
            RenderSystem.enableBlend();
        }
    }
}

