/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.AllMissingGlyphProvider;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class FontManager
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String FONTS_PATH = "fonts.json";
    public static final ResourceLocation MISSING_FONT = new ResourceLocation("minecraft", "missing");
    private final FontSet missingFontSet;
    final Map<ResourceLocation, FontSet> fontSets = Maps.newHashMap();
    final TextureManager textureManager;
    private Map<ResourceLocation, ResourceLocation> renames = ImmutableMap.of();
    private final PreparableReloadListener reloadListener = new SimplePreparableReloadListener<Map<ResourceLocation, List<GlyphProvider>>>(){

        @Override
        protected Map<ResourceLocation, List<GlyphProvider>> prepare(ResourceManager p_95024_, ProfilerFiller p_95025_) {
            p_95025_.startTick();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            HashMap map = Maps.newHashMap();
            for (ResourceLocation resourcelocation : p_95024_.listResources("font", p_95031_ -> p_95031_.endsWith(".json"))) {
                String s = resourcelocation.getPath();
                ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.getNamespace(), s.substring("font/".length(), s.length() - ".json".length()));
                List list = map.computeIfAbsent(resourcelocation1, p_95040_ -> Lists.newArrayList((Object[])new GlyphProvider[]{new AllMissingGlyphProvider()}));
                p_95025_.push(resourcelocation1::toString);
                try {
                    for (Resource resource : p_95024_.getResources(resourcelocation)) {
                        p_95025_.push(resource::getSourceName);
                        try (InputStream inputstream = resource.getInputStream();
                             BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            p_95025_.push("reading");
                            JsonArray jsonarray = GsonHelper.getAsJsonArray(GsonHelper.fromJson(gson, (Reader)reader, JsonObject.class), "providers");
                            p_95025_.popPush("parsing");
                            int i = jsonarray.size() - 1;
                            while (i >= 0) {
                                JsonObject jsonobject = GsonHelper.convertToJsonObject(jsonarray.get(i), "providers[" + i + "]");
                                try {
                                    String s1 = GsonHelper.getAsString(jsonobject, "type");
                                    GlyphProviderBuilderType glyphproviderbuildertype = GlyphProviderBuilderType.byName(s1);
                                    p_95025_.push(s1);
                                    GlyphProvider glyphprovider = glyphproviderbuildertype.create(jsonobject).create(p_95024_);
                                    if (glyphprovider != null) {
                                        list.add(glyphprovider);
                                    }
                                    p_95025_.pop();
                                }
                                catch (RuntimeException runtimeexception) {
                                    LOGGER.warn("Unable to read definition '{}' in {} in resourcepack: '{}': {}", new Object[]{resourcelocation1, FontManager.FONTS_PATH, resource.getSourceName(), runtimeexception.getMessage()});
                                }
                                --i;
                            }
                            p_95025_.pop();
                        }
                        catch (RuntimeException runtimeexception1) {
                            LOGGER.warn("Unable to load font '{}' in {} in resourcepack: '{}': {}", new Object[]{resourcelocation1, FontManager.FONTS_PATH, resource.getSourceName(), runtimeexception1.getMessage()});
                        }
                        p_95025_.pop();
                    }
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Unable to load font '{}' in {}: {}", new Object[]{resourcelocation1, FontManager.FONTS_PATH, ioexception.getMessage()});
                }
                p_95025_.push("caching");
                IntOpenHashSet intset = new IntOpenHashSet();
                for (GlyphProvider glyphprovider1 : list) {
                    intset.addAll((IntCollection)glyphprovider1.getSupportedGlyphs());
                }
                intset.forEach(p_95034_ -> {
                    if (p_95034_ != 32) {
                        for (GlyphProvider glyphprovider2 : Lists.reverse((List)list)) {
                            if (glyphprovider2.getGlyph(p_95034_) != null) break;
                        }
                    }
                });
                p_95025_.pop();
                p_95025_.pop();
            }
            p_95025_.endTick();
            return map;
        }

        @Override
        protected void apply(Map<ResourceLocation, List<GlyphProvider>> p_95036_, ResourceManager p_95037_, ProfilerFiller p_95038_) {
            p_95038_.startTick();
            p_95038_.push("closing");
            FontManager.this.fontSets.values().forEach(FontSet::close);
            FontManager.this.fontSets.clear();
            p_95038_.popPush("reloading");
            p_95036_.forEach((p_95042_, p_95043_) -> {
                FontSet fontset = new FontSet(FontManager.this.textureManager, (ResourceLocation)p_95042_);
                fontset.reload(Lists.reverse((List)p_95043_));
                FontManager.this.fontSets.put((ResourceLocation)p_95042_, fontset);
            });
            p_95038_.pop();
            p_95038_.endTick();
        }

        @Override
        public String getName() {
            return "FontManager";
        }
    };

    public FontManager(TextureManager pTextureManager) {
        this.textureManager = pTextureManager;
        this.missingFontSet = Util.make(new FontSet(pTextureManager, MISSING_FONT), p_95010_ -> p_95010_.reload(Lists.newArrayList((Object[])new GlyphProvider[]{new AllMissingGlyphProvider()})));
    }

    public void setRenames(Map<ResourceLocation, ResourceLocation> pUnicodeForcedMap) {
        this.renames = pUnicodeForcedMap;
    }

    public Font createFont() {
        return new Font(p_95014_ -> this.fontSets.getOrDefault(this.renames.getOrDefault(p_95014_, (ResourceLocation)p_95014_), this.missingFontSet));
    }

    public PreparableReloadListener getReloadListener() {
        return this.reloadListener;
    }

    @Override
    public void close() {
        this.fontSets.values().forEach(FontSet::close);
        this.missingFontSet.close();
    }
}

