/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.FontTexture;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.gui.font.glyphs.MissingGlyph;
import net.minecraft.client.gui.font.glyphs.WhiteGlyph;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class FontSet
implements AutoCloseable {
    private static final EmptyGlyph SPACE_GLYPH = new EmptyGlyph();
    private static final GlyphInfo SPACE_INFO = () -> 4.0f;
    private static final GlyphInfo ZERO_WIDTH_NO_JOIN_INFO = () -> 0.0f;
    private static final int ZERO_WIDTH_NO_JOIN_CODEPOINT = 8204;
    private static final Random RANDOM = new Random();
    private final TextureManager textureManager;
    private final ResourceLocation name;
    private BakedGlyph missingGlyph;
    private BakedGlyph whiteGlyph;
    private final List<GlyphProvider> providers = Lists.newArrayList();
    private final Int2ObjectMap<BakedGlyph> glyphs = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<GlyphInfo> glyphInfos = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<IntList> glyphsByWidth = new Int2ObjectOpenHashMap();
    private final List<FontTexture> textures = Lists.newArrayList();

    public FontSet(TextureManager pTextureManager, ResourceLocation pName) {
        this.textureManager = pTextureManager;
        this.name = pName;
    }

    public void reload(List<GlyphProvider> pGlyphProviders) {
        this.closeProviders();
        this.closeTextures();
        this.glyphs.clear();
        this.glyphInfos.clear();
        this.glyphsByWidth.clear();
        this.missingGlyph = this.stitch(MissingGlyph.INSTANCE);
        this.whiteGlyph = this.stitch(WhiteGlyph.INSTANCE);
        IntOpenHashSet intset = new IntOpenHashSet();
        for (GlyphProvider glyphprovider : pGlyphProviders) {
            intset.addAll((IntCollection)glyphprovider.getSupportedGlyphs());
        }
        HashSet set = Sets.newHashSet();
        intset.forEach(p_202357_3_ -> {
            for (GlyphProvider glyphprovider1 : pGlyphProviders) {
                GlyphInfo glyphinfo = this.getGlyphInfoForSpace(p_202357_3_);
                if (glyphinfo == null) {
                    glyphinfo = glyphprovider1.getGlyph(p_202357_3_);
                }
                if (glyphinfo == null) continue;
                set.add(glyphprovider1);
                if (glyphinfo == MissingGlyph.INSTANCE) break;
                ((IntList)this.glyphsByWidth.computeIfAbsent(Mth.ceil(glyphinfo.getAdvance(false)), p_202368_0_ -> new IntArrayList())).add(p_202357_3_);
                break;
            }
        });
        pGlyphProviders.stream().filter(set::contains).forEach(this.providers::add);
    }

    @Override
    public void close() {
        this.closeProviders();
        this.closeTextures();
    }

    private void closeProviders() {
        for (GlyphProvider glyphprovider : this.providers) {
            glyphprovider.close();
        }
        this.providers.clear();
    }

    private void closeTextures() {
        for (FontTexture fonttexture : this.textures) {
            fonttexture.close();
        }
        this.textures.clear();
    }

    @Nullable
    private GlyphInfo getGlyphInfoForSpace(int p_202362_) {
        return switch (p_202362_) {
            case 32 -> SPACE_INFO;
            case 8204 -> ZERO_WIDTH_NO_JOIN_INFO;
            default -> null;
        };
    }

    public GlyphInfo getGlyphInfo(int p_95066_) {
        GlyphInfo glyphinfo = (GlyphInfo)this.glyphInfos.get(p_95066_);
        if (glyphinfo == null) {
            glyphinfo = p_95066_ == 32 ? SPACE_INFO : this.getRaw(p_95066_);
            this.glyphInfos.put(p_95066_, (Object)glyphinfo);
        }
        return glyphinfo;
    }

    private RawGlyph getRaw(int p_95082_) {
        for (GlyphProvider glyphprovider : this.providers) {
            RawGlyph rawglyph = glyphprovider.getGlyph(p_95082_);
            if (rawglyph == null) continue;
            return rawglyph;
        }
        return MissingGlyph.INSTANCE;
    }

    public BakedGlyph getGlyph(int p_95079_) {
        BakedGlyph bakedglyph = (BakedGlyph)this.glyphs.get(p_95079_);
        if (bakedglyph == null) {
            bakedglyph = p_95079_ != 32 && p_95079_ != 8204 ? this.stitch(this.getRaw(p_95079_)) : SPACE_GLYPH;
            this.glyphs.put(p_95079_, (Object)bakedglyph);
        }
        return bakedglyph;
    }

    private BakedGlyph stitch(RawGlyph pGlyphInfo) {
        for (FontTexture fonttexture : this.textures) {
            BakedGlyph bakedglyph = fonttexture.add(pGlyphInfo);
            if (bakedglyph == null) continue;
            return bakedglyph;
        }
        FontTexture fonttexture1 = new FontTexture(new ResourceLocation(this.name.getNamespace(), String.valueOf(this.name.getPath()) + "/" + this.textures.size()), pGlyphInfo.isColored());
        this.textures.add(fonttexture1);
        this.textureManager.register(fonttexture1.getName(), fonttexture1);
        BakedGlyph bakedglyph1 = fonttexture1.add(pGlyphInfo);
        return bakedglyph1 == null ? this.missingGlyph : bakedglyph1;
    }

    public BakedGlyph getRandomGlyph(GlyphInfo pGlyph) {
        IntList intlist = (IntList)this.glyphsByWidth.get(Mth.ceil(pGlyph.getAdvance(false)));
        return intlist != null && !intlist.isEmpty() ? this.getGlyph(intlist.getInt(RANDOM.nextInt(intlist.size()))) : this.missingGlyph;
    }

    public BakedGlyph whiteGlyph() {
        return this.whiteGlyph;
    }
}

